package software.amazon.awscdk.services.cur;

/**
 * Properties for defining a <code>CfnReportDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cur.*;
 * CfnReportDefinitionProps cfnReportDefinitionProps = CfnReportDefinitionProps.builder()
 *         .compression("compression")
 *         .format("format")
 *         .refreshClosedReports(false)
 *         .reportName("reportName")
 *         .reportVersioning("reportVersioning")
 *         .s3Bucket("s3Bucket")
 *         .s3Prefix("s3Prefix")
 *         .s3Region("s3Region")
 *         .timeUnit("timeUnit")
 *         // the properties below are optional
 *         .additionalArtifacts(List.of("additionalArtifacts"))
 *         .additionalSchemaElements(List.of("additionalSchemaElements"))
 *         .billingViewArn("billingViewArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:14.245Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cur.CfnReportDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnReportDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnReportDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The compression format that Amazon Web Services uses for the report.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-compression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-compression</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCompression();

    /**
     * The format that Amazon Web Services saves the report in.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-format">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-format</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getFormat();

    /**
     * Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months.
     * <p>
     * These charges can include refunds, credits, or support fees.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-refreshclosedreports">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-refreshclosedreports</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getRefreshClosedReports();

    /**
     * The name of the report that you want to create.
     * <p>
     * The name must be unique, is case sensitive, and can't include spaces.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReportName();

    /**
     * Whether you want AWS to overwrite the previous version of each report or to deliver the report in addition to the previous versions.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportversioning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-reportversioning</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getReportVersioning();

    /**
     * The S3 bucket where Amazon Web Services delivers the report.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3bucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3Bucket();

    /**
     * The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report.
     * <p>
     * Your prefix can't include spaces.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3prefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3prefix</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3Prefix();

    /**
     * The Region of the S3 bucket that Amazon Web Services delivers the report into.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3region">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-s3region</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getS3Region();

    /**
     * The granularity of the line items in the report.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-timeunit">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-timeunit</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTimeUnit();

    /**
     * A list of manifests that you want AWS to create for this report.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalartifacts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalartifacts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalArtifacts() {
        return null;
    }

    /**
     * A list of strings that indicate additional content that AWS includes in the report, such as individual resource IDs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalschemaelements">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-additionalschemaelements</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdditionalSchemaElements() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the billing view.
     * <p>
     * You can get this value by using the billing view service public APIs.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-billingviewarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cur-reportdefinition.html#cfn-cur-reportdefinition-billingviewarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBillingViewArn() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnReportDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnReportDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnReportDefinitionProps> {
        java.lang.String compression;
        java.lang.String format;
        java.lang.Object refreshClosedReports;
        java.lang.String reportName;
        java.lang.String reportVersioning;
        java.lang.String s3Bucket;
        java.lang.String s3Prefix;
        java.lang.String s3Region;
        java.lang.String timeUnit;
        java.util.List<java.lang.String> additionalArtifacts;
        java.util.List<java.lang.String> additionalSchemaElements;
        java.lang.String billingViewArn;

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getCompression}
         * @param compression The compression format that Amazon Web Services uses for the report. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compression(java.lang.String compression) {
            this.compression = compression;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getFormat}
         * @param format The format that Amazon Web Services saves the report in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder format(java.lang.String format) {
            this.format = format;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getRefreshClosedReports}
         * @param refreshClosedReports Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months. This parameter is required.
         *                             These charges can include refunds, credits, or support fees.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshClosedReports(java.lang.Boolean refreshClosedReports) {
            this.refreshClosedReports = refreshClosedReports;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getRefreshClosedReports}
         * @param refreshClosedReports Whether you want AWS to update your reports after they have been finalized if AWS detects charges related to previous months. This parameter is required.
         *                             These charges can include refunds, credits, or support fees.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder refreshClosedReports(software.amazon.awscdk.IResolvable refreshClosedReports) {
            this.refreshClosedReports = refreshClosedReports;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getReportName}
         * @param reportName The name of the report that you want to create. This parameter is required.
         *                   The name must be unique, is case sensitive, and can't include spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportName(java.lang.String reportName) {
            this.reportName = reportName;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getReportVersioning}
         * @param reportVersioning Whether you want AWS to overwrite the previous version of each report or to deliver the report in addition to the previous versions. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportVersioning(java.lang.String reportVersioning) {
            this.reportVersioning = reportVersioning;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getS3Bucket}
         * @param s3Bucket The S3 bucket where Amazon Web Services delivers the report. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Bucket(java.lang.String s3Bucket) {
            this.s3Bucket = s3Bucket;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getS3Prefix}
         * @param s3Prefix The prefix that Amazon Web Services adds to the report name when Amazon Web Services delivers the report. This parameter is required.
         *                 Your prefix can't include spaces.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Prefix(java.lang.String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getS3Region}
         * @param s3Region The Region of the S3 bucket that Amazon Web Services delivers the report into. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3Region(java.lang.String s3Region) {
            this.s3Region = s3Region;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getTimeUnit}
         * @param timeUnit The granularity of the line items in the report. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeUnit(java.lang.String timeUnit) {
            this.timeUnit = timeUnit;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getAdditionalArtifacts}
         * @param additionalArtifacts A list of manifests that you want AWS to create for this report.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalArtifacts(java.util.List<java.lang.String> additionalArtifacts) {
            this.additionalArtifacts = additionalArtifacts;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getAdditionalSchemaElements}
         * @param additionalSchemaElements A list of strings that indicate additional content that AWS includes in the report, such as individual resource IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder additionalSchemaElements(java.util.List<java.lang.String> additionalSchemaElements) {
            this.additionalSchemaElements = additionalSchemaElements;
            return this;
        }

        /**
         * Sets the value of {@link CfnReportDefinitionProps#getBillingViewArn}
         * @param billingViewArn The Amazon Resource Name (ARN) of the billing view.
         *                       You can get this value by using the billing view service public APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder billingViewArn(java.lang.String billingViewArn) {
            this.billingViewArn = billingViewArn;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnReportDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnReportDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnReportDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnReportDefinitionProps {
        private final java.lang.String compression;
        private final java.lang.String format;
        private final java.lang.Object refreshClosedReports;
        private final java.lang.String reportName;
        private final java.lang.String reportVersioning;
        private final java.lang.String s3Bucket;
        private final java.lang.String s3Prefix;
        private final java.lang.String s3Region;
        private final java.lang.String timeUnit;
        private final java.util.List<java.lang.String> additionalArtifacts;
        private final java.util.List<java.lang.String> additionalSchemaElements;
        private final java.lang.String billingViewArn;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.compression = software.amazon.jsii.Kernel.get(this, "compression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.format = software.amazon.jsii.Kernel.get(this, "format", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.refreshClosedReports = software.amazon.jsii.Kernel.get(this, "refreshClosedReports", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.reportName = software.amazon.jsii.Kernel.get(this, "reportName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.reportVersioning = software.amazon.jsii.Kernel.get(this, "reportVersioning", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Bucket = software.amazon.jsii.Kernel.get(this, "s3Bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Prefix = software.amazon.jsii.Kernel.get(this, "s3Prefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.s3Region = software.amazon.jsii.Kernel.get(this, "s3Region", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.timeUnit = software.amazon.jsii.Kernel.get(this, "timeUnit", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.additionalArtifacts = software.amazon.jsii.Kernel.get(this, "additionalArtifacts", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.additionalSchemaElements = software.amazon.jsii.Kernel.get(this, "additionalSchemaElements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.billingViewArn = software.amazon.jsii.Kernel.get(this, "billingViewArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.compression = java.util.Objects.requireNonNull(builder.compression, "compression is required");
            this.format = java.util.Objects.requireNonNull(builder.format, "format is required");
            this.refreshClosedReports = java.util.Objects.requireNonNull(builder.refreshClosedReports, "refreshClosedReports is required");
            this.reportName = java.util.Objects.requireNonNull(builder.reportName, "reportName is required");
            this.reportVersioning = java.util.Objects.requireNonNull(builder.reportVersioning, "reportVersioning is required");
            this.s3Bucket = java.util.Objects.requireNonNull(builder.s3Bucket, "s3Bucket is required");
            this.s3Prefix = java.util.Objects.requireNonNull(builder.s3Prefix, "s3Prefix is required");
            this.s3Region = java.util.Objects.requireNonNull(builder.s3Region, "s3Region is required");
            this.timeUnit = java.util.Objects.requireNonNull(builder.timeUnit, "timeUnit is required");
            this.additionalArtifacts = builder.additionalArtifacts;
            this.additionalSchemaElements = builder.additionalSchemaElements;
            this.billingViewArn = builder.billingViewArn;
        }

        @Override
        public final java.lang.String getCompression() {
            return this.compression;
        }

        @Override
        public final java.lang.String getFormat() {
            return this.format;
        }

        @Override
        public final java.lang.Object getRefreshClosedReports() {
            return this.refreshClosedReports;
        }

        @Override
        public final java.lang.String getReportName() {
            return this.reportName;
        }

        @Override
        public final java.lang.String getReportVersioning() {
            return this.reportVersioning;
        }

        @Override
        public final java.lang.String getS3Bucket() {
            return this.s3Bucket;
        }

        @Override
        public final java.lang.String getS3Prefix() {
            return this.s3Prefix;
        }

        @Override
        public final java.lang.String getS3Region() {
            return this.s3Region;
        }

        @Override
        public final java.lang.String getTimeUnit() {
            return this.timeUnit;
        }

        @Override
        public final java.util.List<java.lang.String> getAdditionalArtifacts() {
            return this.additionalArtifacts;
        }

        @Override
        public final java.util.List<java.lang.String> getAdditionalSchemaElements() {
            return this.additionalSchemaElements;
        }

        @Override
        public final java.lang.String getBillingViewArn() {
            return this.billingViewArn;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("compression", om.valueToTree(this.getCompression()));
            data.set("format", om.valueToTree(this.getFormat()));
            data.set("refreshClosedReports", om.valueToTree(this.getRefreshClosedReports()));
            data.set("reportName", om.valueToTree(this.getReportName()));
            data.set("reportVersioning", om.valueToTree(this.getReportVersioning()));
            data.set("s3Bucket", om.valueToTree(this.getS3Bucket()));
            data.set("s3Prefix", om.valueToTree(this.getS3Prefix()));
            data.set("s3Region", om.valueToTree(this.getS3Region()));
            data.set("timeUnit", om.valueToTree(this.getTimeUnit()));
            if (this.getAdditionalArtifacts() != null) {
                data.set("additionalArtifacts", om.valueToTree(this.getAdditionalArtifacts()));
            }
            if (this.getAdditionalSchemaElements() != null) {
                data.set("additionalSchemaElements", om.valueToTree(this.getAdditionalSchemaElements()));
            }
            if (this.getBillingViewArn() != null) {
                data.set("billingViewArn", om.valueToTree(this.getBillingViewArn()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cur.CfnReportDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnReportDefinitionProps.Jsii$Proxy that = (CfnReportDefinitionProps.Jsii$Proxy) o;

            if (!compression.equals(that.compression)) return false;
            if (!format.equals(that.format)) return false;
            if (!refreshClosedReports.equals(that.refreshClosedReports)) return false;
            if (!reportName.equals(that.reportName)) return false;
            if (!reportVersioning.equals(that.reportVersioning)) return false;
            if (!s3Bucket.equals(that.s3Bucket)) return false;
            if (!s3Prefix.equals(that.s3Prefix)) return false;
            if (!s3Region.equals(that.s3Region)) return false;
            if (!timeUnit.equals(that.timeUnit)) return false;
            if (this.additionalArtifacts != null ? !this.additionalArtifacts.equals(that.additionalArtifacts) : that.additionalArtifacts != null) return false;
            if (this.additionalSchemaElements != null ? !this.additionalSchemaElements.equals(that.additionalSchemaElements) : that.additionalSchemaElements != null) return false;
            return this.billingViewArn != null ? this.billingViewArn.equals(that.billingViewArn) : that.billingViewArn == null;
        }

        @Override
        public final int hashCode() {
            int result = this.compression.hashCode();
            result = 31 * result + (this.format.hashCode());
            result = 31 * result + (this.refreshClosedReports.hashCode());
            result = 31 * result + (this.reportName.hashCode());
            result = 31 * result + (this.reportVersioning.hashCode());
            result = 31 * result + (this.s3Bucket.hashCode());
            result = 31 * result + (this.s3Prefix.hashCode());
            result = 31 * result + (this.s3Region.hashCode());
            result = 31 * result + (this.timeUnit.hashCode());
            result = 31 * result + (this.additionalArtifacts != null ? this.additionalArtifacts.hashCode() : 0);
            result = 31 * result + (this.additionalSchemaElements != null ? this.additionalSchemaElements.hashCode() : 0);
            result = 31 * result + (this.billingViewArn != null ? this.billingViewArn.hashCode() : 0);
            return result;
        }
    }
}
