package software.amazon.awscdk.services.ec2;

/**
 * Request for subnet IPv6 CIDRs to be allocated for a VPC.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * AllocateIpv6CidrRequest allocateIpv6CidrRequest = AllocateIpv6CidrRequest.builder()
 *         .allocatedSubnets(List.of(AllocatedSubnet.builder()
 *                 .cidr("cidr")
 *                 // the properties below are optional
 *                 .ipv6Cidr("ipv6Cidr")
 *                 .build()))
 *         .ipv6Cidrs(List.of("ipv6Cidrs"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.028Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AllocateIpv6CidrRequest")
@software.amazon.jsii.Jsii.Proxy(AllocateIpv6CidrRequest.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AllocateIpv6CidrRequest extends software.amazon.jsii.JsiiSerializable {

    /**
     * List of subnets allocated with IPv4 CIDRs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> getAllocatedSubnets();

    /**
     * The IPv6 CIDRs to be allocated to the subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getIpv6Cidrs();

    /**
     * @return a {@link Builder} of {@link AllocateIpv6CidrRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AllocateIpv6CidrRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AllocateIpv6CidrRequest> {
        java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> allocatedSubnets;
        java.util.List<java.lang.String> ipv6Cidrs;

        /**
         * Sets the value of {@link AllocateIpv6CidrRequest#getAllocatedSubnets}
         * @param allocatedSubnets List of subnets allocated with IPv4 CIDRs. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allocatedSubnets(java.util.List<? extends software.amazon.awscdk.services.ec2.AllocatedSubnet> allocatedSubnets) {
            this.allocatedSubnets = (java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet>)allocatedSubnets;
            return this;
        }

        /**
         * Sets the value of {@link AllocateIpv6CidrRequest#getIpv6Cidrs}
         * @param ipv6Cidrs The IPv6 CIDRs to be allocated to the subnets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6Cidrs(java.util.List<java.lang.String> ipv6Cidrs) {
            this.ipv6Cidrs = ipv6Cidrs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AllocateIpv6CidrRequest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AllocateIpv6CidrRequest build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AllocateIpv6CidrRequest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AllocateIpv6CidrRequest {
        private final java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> allocatedSubnets;
        private final java.util.List<java.lang.String> ipv6Cidrs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allocatedSubnets = software.amazon.jsii.Kernel.get(this, "allocatedSubnets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AllocatedSubnet.class)));
            this.ipv6Cidrs = software.amazon.jsii.Kernel.get(this, "ipv6Cidrs", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allocatedSubnets = (java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet>)java.util.Objects.requireNonNull(builder.allocatedSubnets, "allocatedSubnets is required");
            this.ipv6Cidrs = java.util.Objects.requireNonNull(builder.ipv6Cidrs, "ipv6Cidrs is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.AllocatedSubnet> getAllocatedSubnets() {
            return this.allocatedSubnets;
        }

        @Override
        public final java.util.List<java.lang.String> getIpv6Cidrs() {
            return this.ipv6Cidrs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("allocatedSubnets", om.valueToTree(this.getAllocatedSubnets()));
            data.set("ipv6Cidrs", om.valueToTree(this.getIpv6Cidrs()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.AllocateIpv6CidrRequest"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AllocateIpv6CidrRequest.Jsii$Proxy that = (AllocateIpv6CidrRequest.Jsii$Proxy) o;

            if (!allocatedSubnets.equals(that.allocatedSubnets)) return false;
            return this.ipv6Cidrs.equals(that.ipv6Cidrs);
        }

        @Override
        public final int hashCode() {
            int result = this.allocatedSubnets.hashCode();
            result = 31 * result + (this.ipv6Cidrs.hashCode());
            return result;
        }
    }
}
