package software.amazon.awscdk.services.ec2;

/**
 * Amazon Linux 2023 kernel versions.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Instance.Builder.create(this, "LatestAl2023")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.C7G, InstanceSize.LARGE))
 *         // context cache is turned on by default
 *         .machineImage(AmazonLinux2023ImageSsmParameter.Builder.create()
 *                 .kernel(AmazonLinux2023Kernel.KERNEL_6_1)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.032Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.AmazonLinux2023Kernel")
public class AmazonLinux2023Kernel extends software.amazon.jsii.JsiiObject {

    protected AmazonLinux2023Kernel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AmazonLinux2023Kernel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CDK_LATEST = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel.class, "CDK_LATEST", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel.class));
        DEFAULT = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel.class, "DEFAULT", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel.class));
        KERNEL_6_1 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel.class, "KERNEL_6_1", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel.class));
    }

    /**
     * @param version This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public AmazonLinux2023Kernel(final @org.jetbrains.annotations.NotNull java.lang.String version) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(version, "version is required") });
    }

    /**
     * Generate a string representation of the kernel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String toString() {
        return software.amazon.jsii.Kernel.call(this, "toString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The latest kernel version currently available in a published AMI.
     * <p>
     * When a new kernel version is available for an al2023 AMI this will be
     * updated to contain the latest kernel version and will cause your instances
     * to be replaced. Do not store stateful information on the instance if you are
     * using this version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel CDK_LATEST;

    /**
     * The default kernel version for Amazon Linux 2023 is 6.1 and the SSM parameter does not include it in the name (i.e. /aws/service/ami-amazon-linux-latest/amzn2023-ami-kernel-default-x86_64).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel DEFAULT;

    /**
     * Kernel version 6.1.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.ec2.AmazonLinux2023Kernel KERNEL_6_1;
}
