package software.amazon.awscdk.services.ec2;

/**
 * Specifies a VPN connection between a virtual private gateway and a VPN customer gateway or a transit gateway and a VPN customer gateway.
 * <p>
 * To specify a VPN connection between a transit gateway and customer gateway, use the <code>TransitGatewayId</code> and <code>CustomerGatewayId</code> properties.
 * <p>
 * To specify a VPN connection between a virtual private gateway and customer gateway, use the <code>VpnGatewayId</code> and <code>CustomerGatewayId</code> properties.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html">AWS Site-to-Site VPN</a> in the <em>AWS Site-to-Site VPN User Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * CfnVPNConnection cfnVPNConnection = CfnVPNConnection.Builder.create(this, "MyCfnVPNConnection")
 *         .customerGatewayId("customerGatewayId")
 *         .type("type")
 *         // the properties below are optional
 *         .enableAcceleration(false)
 *         .localIpv4NetworkCidr("localIpv4NetworkCidr")
 *         .localIpv6NetworkCidr("localIpv6NetworkCidr")
 *         .outsideIpAddressType("outsideIpAddressType")
 *         .remoteIpv4NetworkCidr("remoteIpv4NetworkCidr")
 *         .remoteIpv6NetworkCidr("remoteIpv6NetworkCidr")
 *         .staticRoutesOnly(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .transitGatewayId("transitGatewayId")
 *         .transportTransitGatewayAttachmentId("transportTransitGatewayAttachmentId")
 *         .tunnelInsideIpVersion("tunnelInsideIpVersion")
 *         .vpnGatewayId("vpnGatewayId")
 *         .vpnTunnelOptionsSpecifications(List.of(VpnTunnelOptionsSpecificationProperty.builder()
 *                 .dpdTimeoutAction("dpdTimeoutAction")
 *                 .dpdTimeoutSeconds(123)
 *                 .enableTunnelLifecycleControl(false)
 *                 .ikeVersions(List.of(Map.of(
 *                         "value", "value")))
 *                 .logOptions(VpnTunnelLogOptionsSpecificationProperty.builder()
 *                         .cloudwatchLogOptions(CloudwatchLogOptionsSpecificationProperty.builder()
 *                                 .logEnabled(false)
 *                                 .logGroupArn("logGroupArn")
 *                                 .logOutputFormat("logOutputFormat")
 *                                 .build())
 *                         .build())
 *                 .phase1DhGroupNumbers(List.of(Phase1DHGroupNumbersRequestListValueProperty.builder()
 *                         .value(123)
 *                         .build()))
 *                 .phase1EncryptionAlgorithms(List.of(Phase1EncryptionAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase1IntegrityAlgorithms(List.of(Phase1IntegrityAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase1LifetimeSeconds(123)
 *                 .phase2DhGroupNumbers(List.of(Phase2DHGroupNumbersRequestListValueProperty.builder()
 *                         .value(123)
 *                         .build()))
 *                 .phase2EncryptionAlgorithms(List.of(Phase2EncryptionAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase2IntegrityAlgorithms(List.of(Phase2IntegrityAlgorithmsRequestListValueProperty.builder()
 *                         .value("value")
 *                         .build()))
 *                 .phase2LifetimeSeconds(123)
 *                 .preSharedKey("preSharedKey")
 *                 .rekeyFuzzPercentage(123)
 *                 .rekeyMarginTimeSeconds(123)
 *                 .replayWindowSize(123)
 *                 .startupAction("startupAction")
 *                 .tunnelInsideCidr("tunnelInsideCidr")
 *                 .tunnelInsideIpv6Cidr("tunnelInsideIpv6Cidr")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.496Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection")
public class CfnVPNConnection extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnVPNConnection(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnVPNConnection(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.ec2.CfnVPNConnection.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnVPNConnection(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.CfnVPNConnectionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ID of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVpnConnectionId() {
        return software.amazon.jsii.Kernel.get(this, "attrVpnConnectionId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The ID of the customer gateway at your end of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCustomerGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "customerGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the customer gateway at your end of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerGatewayId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customerGatewayId", java.util.Objects.requireNonNull(value, "customerGatewayId is required"));
    }

    /**
     * The type of VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * Indicate whether to enable acceleration for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableAcceleration() {
        return software.amazon.jsii.Kernel.get(this, "enableAcceleration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicate whether to enable acceleration for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableAcceleration(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableAcceleration", value);
    }

    /**
     * Indicate whether to enable acceleration for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableAcceleration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableAcceleration", value);
    }

    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLocalIpv4NetworkCidr() {
        return software.amazon.jsii.Kernel.get(this, "localIpv4NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalIpv4NetworkCidr(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "localIpv4NetworkCidr", value);
    }

    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getLocalIpv6NetworkCidr() {
        return software.amazon.jsii.Kernel.get(this, "localIpv6NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLocalIpv6NetworkCidr(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "localIpv6NetworkCidr", value);
    }

    /**
     * The type of IPv4 address assigned to the outside interface of the customer gateway device.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOutsideIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "outsideIpAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of IPv4 address assigned to the outside interface of the customer gateway device.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOutsideIpAddressType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "outsideIpAddressType", value);
    }

    /**
     * The IPv4 CIDR on the AWS side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRemoteIpv4NetworkCidr() {
        return software.amazon.jsii.Kernel.get(this, "remoteIpv4NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv4 CIDR on the AWS side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoteIpv4NetworkCidr(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "remoteIpv4NetworkCidr", value);
    }

    /**
     * The IPv6 CIDR on the AWS side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRemoteIpv6NetworkCidr() {
        return software.amazon.jsii.Kernel.get(this, "remoteIpv6NetworkCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IPv6 CIDR on the AWS side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRemoteIpv6NetworkCidr(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "remoteIpv6NetworkCidr", value);
    }

    /**
     * Indicates whether the VPN connection uses static routes only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStaticRoutesOnly() {
        return software.amazon.jsii.Kernel.get(this, "staticRoutesOnly", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether the VPN connection uses static routes only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStaticRoutesOnly(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "staticRoutesOnly", value);
    }

    /**
     * Indicates whether the VPN connection uses static routes only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStaticRoutesOnly(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "staticRoutesOnly", value);
    }

    /**
     * Any tags assigned to the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Any tags assigned to the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The ID of the transit gateway associated with the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransitGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "transitGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the transit gateway associated with the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransitGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transitGatewayId", value);
    }

    /**
     * The transit gateway attachment ID to use for the VPN tunnel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTransportTransitGatewayAttachmentId() {
        return software.amazon.jsii.Kernel.get(this, "transportTransitGatewayAttachmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The transit gateway attachment ID to use for the VPN tunnel.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTransportTransitGatewayAttachmentId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "transportTransitGatewayAttachmentId", value);
    }

    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTunnelInsideIpVersion() {
        return software.amazon.jsii.Kernel.get(this, "tunnelInsideIpVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTunnelInsideIpVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "tunnelInsideIpVersion", value);
    }

    /**
     * The ID of the virtual private gateway at the AWS side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getVpnGatewayId() {
        return software.amazon.jsii.Kernel.get(this, "vpnGatewayId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the virtual private gateway at the AWS side of the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpnGatewayId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "vpnGatewayId", value);
    }

    /**
     * The tunnel options for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpnTunnelOptionsSpecifications() {
        return software.amazon.jsii.Kernel.get(this, "vpnTunnelOptionsSpecifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The tunnel options for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpnTunnelOptionsSpecifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpnTunnelOptionsSpecifications", value);
    }

    /**
     * The tunnel options for the VPN connection.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpnTunnelOptionsSpecifications(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "vpnTunnelOptionsSpecifications", value);
    }
    /**
     * Options for sending VPN tunnel logs to CloudWatch.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * CloudwatchLogOptionsSpecificationProperty cloudwatchLogOptionsSpecificationProperty = CloudwatchLogOptionsSpecificationProperty.builder()
     *         .logEnabled(false)
     *         .logGroupArn("logGroupArn")
     *         .logOutputFormat("logOutputFormat")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.CloudwatchLogOptionsSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudwatchLogOptionsSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudwatchLogOptionsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Enable or disable VPN tunnel logging feature. Default value is <code>False</code> .
         * <p>
         * Valid values: <code>True</code> | <code>False</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html#cfn-ec2-vpnconnection-cloudwatchlogoptionsspecification-logenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html#cfn-ec2-vpnconnection-cloudwatchlogoptionsspecification-logenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogEnabled() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html#cfn-ec2-vpnconnection-cloudwatchlogoptionsspecification-loggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html#cfn-ec2-vpnconnection-cloudwatchlogoptionsspecification-loggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupArn() {
            return null;
        }

        /**
         * Set log format. Default format is <code>json</code> .
         * <p>
         * Valid values: <code>json</code> | <code>text</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html#cfn-ec2-vpnconnection-cloudwatchlogoptionsspecification-logoutputformat">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-cloudwatchlogoptionsspecification.html#cfn-ec2-vpnconnection-cloudwatchlogoptionsspecification-logoutputformat</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogOutputFormat() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudwatchLogOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudwatchLogOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudwatchLogOptionsSpecificationProperty> {
            java.lang.Object logEnabled;
            java.lang.String logGroupArn;
            java.lang.String logOutputFormat;

            /**
             * Sets the value of {@link CloudwatchLogOptionsSpecificationProperty#getLogEnabled}
             * @param logEnabled Enable or disable VPN tunnel logging feature. Default value is <code>False</code> .
             *                   Valid values: <code>True</code> | <code>False</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logEnabled(java.lang.Boolean logEnabled) {
                this.logEnabled = logEnabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchLogOptionsSpecificationProperty#getLogEnabled}
             * @param logEnabled Enable or disable VPN tunnel logging feature. Default value is <code>False</code> .
             *                   Valid values: <code>True</code> | <code>False</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logEnabled(software.amazon.awscdk.IResolvable logEnabled) {
                this.logEnabled = logEnabled;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchLogOptionsSpecificationProperty#getLogGroupArn}
             * @param logGroupArn The Amazon Resource Name (ARN) of the CloudWatch log group to send logs to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link CloudwatchLogOptionsSpecificationProperty#getLogOutputFormat}
             * @param logOutputFormat Set log format. Default format is <code>json</code> .
             *                        Valid values: <code>json</code> | <code>text</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logOutputFormat(java.lang.String logOutputFormat) {
                this.logOutputFormat = logOutputFormat;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudwatchLogOptionsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudwatchLogOptionsSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudwatchLogOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudwatchLogOptionsSpecificationProperty {
            private final java.lang.Object logEnabled;
            private final java.lang.String logGroupArn;
            private final java.lang.String logOutputFormat;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logEnabled = software.amazon.jsii.Kernel.get(this, "logEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.logOutputFormat = software.amazon.jsii.Kernel.get(this, "logOutputFormat", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logEnabled = builder.logEnabled;
                this.logGroupArn = builder.logGroupArn;
                this.logOutputFormat = builder.logOutputFormat;
            }

            @Override
            public final java.lang.Object getLogEnabled() {
                return this.logEnabled;
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            public final java.lang.String getLogOutputFormat() {
                return this.logOutputFormat;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogEnabled() != null) {
                    data.set("logEnabled", om.valueToTree(this.getLogEnabled()));
                }
                if (this.getLogGroupArn() != null) {
                    data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));
                }
                if (this.getLogOutputFormat() != null) {
                    data.set("logOutputFormat", om.valueToTree(this.getLogOutputFormat()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.CloudwatchLogOptionsSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudwatchLogOptionsSpecificationProperty.Jsii$Proxy that = (CloudwatchLogOptionsSpecificationProperty.Jsii$Proxy) o;

                if (this.logEnabled != null ? !this.logEnabled.equals(that.logEnabled) : that.logEnabled != null) return false;
                if (this.logGroupArn != null ? !this.logGroupArn.equals(that.logGroupArn) : that.logGroupArn != null) return false;
                return this.logOutputFormat != null ? this.logOutputFormat.equals(that.logOutputFormat) : that.logOutputFormat == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logEnabled != null ? this.logEnabled.hashCode() : 0;
                result = 31 * result + (this.logGroupArn != null ? this.logGroupArn.hashCode() : 0);
                result = 31 * result + (this.logOutputFormat != null ? this.logOutputFormat.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The IKE version that is permitted for the VPN tunnel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * IKEVersionsRequestListValueProperty iKEVersionsRequestListValueProperty = Map.of(
     *         "value", "value");
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-ikeversionsrequestlistvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-ikeversionsrequestlistvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.IKEVersionsRequestListValueProperty")
    @software.amazon.jsii.Jsii.Proxy(IKEVersionsRequestListValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IKEVersionsRequestListValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The IKE version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-ikeversionsrequestlistvalue.html#cfn-ec2-vpnconnection-ikeversionsrequestlistvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-ikeversionsrequestlistvalue.html#cfn-ec2-vpnconnection-ikeversionsrequestlistvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IKEVersionsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IKEVersionsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IKEVersionsRequestListValueProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link IKEVersionsRequestListValueProperty#getValue}
             * @param value The IKE version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IKEVersionsRequestListValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IKEVersionsRequestListValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IKEVersionsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IKEVersionsRequestListValueProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.IKEVersionsRequestListValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IKEVersionsRequestListValueProperty.Jsii$Proxy that = (IKEVersionsRequestListValueProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a Diffie-Hellman group number for the VPN tunnel for phase 1 IKE negotiations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Phase1DHGroupNumbersRequestListValueProperty phase1DHGroupNumbersRequestListValueProperty = Phase1DHGroupNumbersRequestListValueProperty.builder()
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1dhgroupnumbersrequestlistvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1dhgroupnumbersrequestlistvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase1DHGroupNumbersRequestListValueProperty")
    @software.amazon.jsii.Jsii.Proxy(Phase1DHGroupNumbersRequestListValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Phase1DHGroupNumbersRequestListValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Diffie-Hellmann group number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1dhgroupnumbersrequestlistvalue.html#cfn-ec2-vpnconnection-phase1dhgroupnumbersrequestlistvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1dhgroupnumbersrequestlistvalue.html#cfn-ec2-vpnconnection-phase1dhgroupnumbersrequestlistvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Phase1DHGroupNumbersRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Phase1DHGroupNumbersRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Phase1DHGroupNumbersRequestListValueProperty> {
            java.lang.Number value;

            /**
             * Sets the value of {@link Phase1DHGroupNumbersRequestListValueProperty#getValue}
             * @param value The Diffie-Hellmann group number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Phase1DHGroupNumbersRequestListValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Phase1DHGroupNumbersRequestListValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Phase1DHGroupNumbersRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Phase1DHGroupNumbersRequestListValueProperty {
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase1DHGroupNumbersRequestListValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Phase1DHGroupNumbersRequestListValueProperty.Jsii$Proxy that = (Phase1DHGroupNumbersRequestListValueProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the encryption algorithm for the VPN tunnel for phase 1 IKE negotiations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Phase1EncryptionAlgorithmsRequestListValueProperty phase1EncryptionAlgorithmsRequestListValueProperty = Phase1EncryptionAlgorithmsRequestListValueProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1encryptionalgorithmsrequestlistvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1encryptionalgorithmsrequestlistvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase1EncryptionAlgorithmsRequestListValueProperty")
    @software.amazon.jsii.Jsii.Proxy(Phase1EncryptionAlgorithmsRequestListValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Phase1EncryptionAlgorithmsRequestListValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value for the encryption algorithm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1encryptionalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase1encryptionalgorithmsrequestlistvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1encryptionalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase1encryptionalgorithmsrequestlistvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Phase1EncryptionAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Phase1EncryptionAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Phase1EncryptionAlgorithmsRequestListValueProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link Phase1EncryptionAlgorithmsRequestListValueProperty#getValue}
             * @param value The value for the encryption algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Phase1EncryptionAlgorithmsRequestListValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Phase1EncryptionAlgorithmsRequestListValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Phase1EncryptionAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Phase1EncryptionAlgorithmsRequestListValueProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase1EncryptionAlgorithmsRequestListValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Phase1EncryptionAlgorithmsRequestListValueProperty.Jsii$Proxy that = (Phase1EncryptionAlgorithmsRequestListValueProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the integrity algorithm for the VPN tunnel for phase 1 IKE negotiations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Phase1IntegrityAlgorithmsRequestListValueProperty phase1IntegrityAlgorithmsRequestListValueProperty = Phase1IntegrityAlgorithmsRequestListValueProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1integrityalgorithmsrequestlistvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1integrityalgorithmsrequestlistvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase1IntegrityAlgorithmsRequestListValueProperty")
    @software.amazon.jsii.Jsii.Proxy(Phase1IntegrityAlgorithmsRequestListValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Phase1IntegrityAlgorithmsRequestListValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The value for the integrity algorithm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1integrityalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase1integrityalgorithmsrequestlistvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase1integrityalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase1integrityalgorithmsrequestlistvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Phase1IntegrityAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Phase1IntegrityAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Phase1IntegrityAlgorithmsRequestListValueProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link Phase1IntegrityAlgorithmsRequestListValueProperty#getValue}
             * @param value The value for the integrity algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Phase1IntegrityAlgorithmsRequestListValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Phase1IntegrityAlgorithmsRequestListValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Phase1IntegrityAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Phase1IntegrityAlgorithmsRequestListValueProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase1IntegrityAlgorithmsRequestListValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Phase1IntegrityAlgorithmsRequestListValueProperty.Jsii$Proxy that = (Phase1IntegrityAlgorithmsRequestListValueProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies a Diffie-Hellman group number for the VPN tunnel for phase 2 IKE negotiations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Phase2DHGroupNumbersRequestListValueProperty phase2DHGroupNumbersRequestListValueProperty = Phase2DHGroupNumbersRequestListValueProperty.builder()
     *         .value(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2dhgroupnumbersrequestlistvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2dhgroupnumbersrequestlistvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase2DHGroupNumbersRequestListValueProperty")
    @software.amazon.jsii.Jsii.Proxy(Phase2DHGroupNumbersRequestListValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Phase2DHGroupNumbersRequestListValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Diffie-Hellmann group number.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2dhgroupnumbersrequestlistvalue.html#cfn-ec2-vpnconnection-phase2dhgroupnumbersrequestlistvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2dhgroupnumbersrequestlistvalue.html#cfn-ec2-vpnconnection-phase2dhgroupnumbersrequestlistvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Phase2DHGroupNumbersRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Phase2DHGroupNumbersRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Phase2DHGroupNumbersRequestListValueProperty> {
            java.lang.Number value;

            /**
             * Sets the value of {@link Phase2DHGroupNumbersRequestListValueProperty#getValue}
             * @param value The Diffie-Hellmann group number.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.Number value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Phase2DHGroupNumbersRequestListValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Phase2DHGroupNumbersRequestListValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Phase2DHGroupNumbersRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Phase2DHGroupNumbersRequestListValueProperty {
            private final java.lang.Number value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.Number getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase2DHGroupNumbersRequestListValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Phase2DHGroupNumbersRequestListValueProperty.Jsii$Proxy that = (Phase2DHGroupNumbersRequestListValueProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the encryption algorithm for the VPN tunnel for phase 2 IKE negotiations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Phase2EncryptionAlgorithmsRequestListValueProperty phase2EncryptionAlgorithmsRequestListValueProperty = Phase2EncryptionAlgorithmsRequestListValueProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2encryptionalgorithmsrequestlistvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2encryptionalgorithmsrequestlistvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase2EncryptionAlgorithmsRequestListValueProperty")
    @software.amazon.jsii.Jsii.Proxy(Phase2EncryptionAlgorithmsRequestListValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Phase2EncryptionAlgorithmsRequestListValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The encryption algorithm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2encryptionalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase2encryptionalgorithmsrequestlistvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2encryptionalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase2encryptionalgorithmsrequestlistvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Phase2EncryptionAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Phase2EncryptionAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Phase2EncryptionAlgorithmsRequestListValueProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link Phase2EncryptionAlgorithmsRequestListValueProperty#getValue}
             * @param value The encryption algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Phase2EncryptionAlgorithmsRequestListValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Phase2EncryptionAlgorithmsRequestListValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Phase2EncryptionAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Phase2EncryptionAlgorithmsRequestListValueProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase2EncryptionAlgorithmsRequestListValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Phase2EncryptionAlgorithmsRequestListValueProperty.Jsii$Proxy that = (Phase2EncryptionAlgorithmsRequestListValueProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies the integrity algorithm for the VPN tunnel for phase 2 IKE negotiations.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * Phase2IntegrityAlgorithmsRequestListValueProperty phase2IntegrityAlgorithmsRequestListValueProperty = Phase2IntegrityAlgorithmsRequestListValueProperty.builder()
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2integrityalgorithmsrequestlistvalue.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2integrityalgorithmsrequestlistvalue.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase2IntegrityAlgorithmsRequestListValueProperty")
    @software.amazon.jsii.Jsii.Proxy(Phase2IntegrityAlgorithmsRequestListValueProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface Phase2IntegrityAlgorithmsRequestListValueProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The integrity algorithm.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2integrityalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase2integrityalgorithmsrequestlistvalue-value">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-phase2integrityalgorithmsrequestlistvalue.html#cfn-ec2-vpnconnection-phase2integrityalgorithmsrequestlistvalue-value</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link Phase2IntegrityAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link Phase2IntegrityAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<Phase2IntegrityAlgorithmsRequestListValueProperty> {
            java.lang.String value;

            /**
             * Sets the value of {@link Phase2IntegrityAlgorithmsRequestListValueProperty#getValue}
             * @param value The integrity algorithm.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link Phase2IntegrityAlgorithmsRequestListValueProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public Phase2IntegrityAlgorithmsRequestListValueProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link Phase2IntegrityAlgorithmsRequestListValueProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements Phase2IntegrityAlgorithmsRequestListValueProperty {
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.value = builder.value;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getValue() != null) {
                    data.set("value", om.valueToTree(this.getValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.Phase2IntegrityAlgorithmsRequestListValueProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                Phase2IntegrityAlgorithmsRequestListValueProperty.Jsii$Proxy that = (Phase2IntegrityAlgorithmsRequestListValueProperty.Jsii$Proxy) o;

                return this.value != null ? this.value.equals(that.value) : that.value == null;
            }

            @Override
            public final int hashCode() {
                int result = this.value != null ? this.value.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Options for logging VPN tunnel activity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VpnTunnelLogOptionsSpecificationProperty vpnTunnelLogOptionsSpecificationProperty = VpnTunnelLogOptionsSpecificationProperty.builder()
     *         .cloudwatchLogOptions(CloudwatchLogOptionsSpecificationProperty.builder()
     *                 .logEnabled(false)
     *                 .logGroupArn("logGroupArn")
     *                 .logOutputFormat("logOutputFormat")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunnellogoptionsspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunnellogoptionsspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.VpnTunnelLogOptionsSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpnTunnelLogOptionsSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpnTunnelLogOptionsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Options for sending VPN tunnel logs to CloudWatch.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunnellogoptionsspecification.html#cfn-ec2-vpnconnection-vpntunnellogoptionsspecification-cloudwatchlogoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunnellogoptionsspecification.html#cfn-ec2-vpnconnection-vpntunnellogoptionsspecification-cloudwatchlogoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudwatchLogOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpnTunnelLogOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpnTunnelLogOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpnTunnelLogOptionsSpecificationProperty> {
            java.lang.Object cloudwatchLogOptions;

            /**
             * Sets the value of {@link VpnTunnelLogOptionsSpecificationProperty#getCloudwatchLogOptions}
             * @param cloudwatchLogOptions Options for sending VPN tunnel logs to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogOptions(software.amazon.awscdk.IResolvable cloudwatchLogOptions) {
                this.cloudwatchLogOptions = cloudwatchLogOptions;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelLogOptionsSpecificationProperty#getCloudwatchLogOptions}
             * @param cloudwatchLogOptions Options for sending VPN tunnel logs to CloudWatch.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudwatchLogOptions(software.amazon.awscdk.services.ec2.CfnVPNConnection.CloudwatchLogOptionsSpecificationProperty cloudwatchLogOptions) {
                this.cloudwatchLogOptions = cloudwatchLogOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpnTunnelLogOptionsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpnTunnelLogOptionsSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpnTunnelLogOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnTunnelLogOptionsSpecificationProperty {
            private final java.lang.Object cloudwatchLogOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudwatchLogOptions = software.amazon.jsii.Kernel.get(this, "cloudwatchLogOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudwatchLogOptions = builder.cloudwatchLogOptions;
            }

            @Override
            public final java.lang.Object getCloudwatchLogOptions() {
                return this.cloudwatchLogOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudwatchLogOptions() != null) {
                    data.set("cloudwatchLogOptions", om.valueToTree(this.getCloudwatchLogOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.VpnTunnelLogOptionsSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpnTunnelLogOptionsSpecificationProperty.Jsii$Proxy that = (VpnTunnelLogOptionsSpecificationProperty.Jsii$Proxy) o;

                return this.cloudwatchLogOptions != null ? this.cloudwatchLogOptions.equals(that.cloudwatchLogOptions) : that.cloudwatchLogOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudwatchLogOptions != null ? this.cloudwatchLogOptions.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The tunnel options for a single VPN tunnel.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.ec2.*;
     * VpnTunnelOptionsSpecificationProperty vpnTunnelOptionsSpecificationProperty = VpnTunnelOptionsSpecificationProperty.builder()
     *         .dpdTimeoutAction("dpdTimeoutAction")
     *         .dpdTimeoutSeconds(123)
     *         .enableTunnelLifecycleControl(false)
     *         .ikeVersions(List.of(Map.of(
     *                 "value", "value")))
     *         .logOptions(VpnTunnelLogOptionsSpecificationProperty.builder()
     *                 .cloudwatchLogOptions(CloudwatchLogOptionsSpecificationProperty.builder()
     *                         .logEnabled(false)
     *                         .logGroupArn("logGroupArn")
     *                         .logOutputFormat("logOutputFormat")
     *                         .build())
     *                 .build())
     *         .phase1DhGroupNumbers(List.of(Phase1DHGroupNumbersRequestListValueProperty.builder()
     *                 .value(123)
     *                 .build()))
     *         .phase1EncryptionAlgorithms(List.of(Phase1EncryptionAlgorithmsRequestListValueProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .phase1IntegrityAlgorithms(List.of(Phase1IntegrityAlgorithmsRequestListValueProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .phase1LifetimeSeconds(123)
     *         .phase2DhGroupNumbers(List.of(Phase2DHGroupNumbersRequestListValueProperty.builder()
     *                 .value(123)
     *                 .build()))
     *         .phase2EncryptionAlgorithms(List.of(Phase2EncryptionAlgorithmsRequestListValueProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .phase2IntegrityAlgorithms(List.of(Phase2IntegrityAlgorithmsRequestListValueProperty.builder()
     *                 .value("value")
     *                 .build()))
     *         .phase2LifetimeSeconds(123)
     *         .preSharedKey("preSharedKey")
     *         .rekeyFuzzPercentage(123)
     *         .rekeyMarginTimeSeconds(123)
     *         .replayWindowSize(123)
     *         .startupAction("startupAction")
     *         .tunnelInsideCidr("tunnelInsideCidr")
     *         .tunnelInsideIpv6Cidr("tunnelInsideIpv6Cidr")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpnTunnelOptionsSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpnTunnelOptionsSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The action to take after DPD timeout occurs.
         * <p>
         * Specify <code>restart</code> to restart the IKE initiation. Specify <code>clear</code> to end the IKE session.
         * <p>
         * Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
         * <p>
         * Default: <code>clear</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-dpdtimeoutaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-dpdtimeoutaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDpdTimeoutAction() {
            return null;
        }

        /**
         * The number of seconds after which a DPD timeout occurs.
         * <p>
         * Constraints: A value greater than or equal to 30.
         * <p>
         * Default: <code>30</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-dpdtimeoutseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-dpdtimeoutseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDpdTimeoutSeconds() {
            return null;
        }

        /**
         * Turn on or off tunnel endpoint lifecycle control feature.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-enabletunnellifecyclecontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-enabletunnellifecyclecontrol</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnableTunnelLifecycleControl() {
            return null;
        }

        /**
         * The IKE versions that are permitted for the VPN tunnel.
         * <p>
         * Valid values: <code>ikev1</code> | <code>ikev2</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-ikeversions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-ikeversions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIkeVersions() {
            return null;
        }

        /**
         * Options for logging VPN tunnel activity.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-logoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-logoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogOptions() {
            return null;
        }

        /**
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * <p>
         * Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1dhgroupnumbers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1dhgroupnumbers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhase1DhGroupNumbers() {
            return null;
        }

        /**
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1encryptionalgorithms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1encryptionalgorithms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhase1EncryptionAlgorithms() {
            return null;
        }

        /**
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1integrityalgorithms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1integrityalgorithms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhase1IntegrityAlgorithms() {
            return null;
        }

        /**
         * The lifetime for phase 1 of the IKE negotiation, in seconds.
         * <p>
         * Constraints: A value between 900 and 28,800.
         * <p>
         * Default: <code>28800</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1lifetimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase1lifetimeseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPhase1LifetimeSeconds() {
            return null;
        }

        /**
         * One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * <p>
         * Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2dhgroupnumbers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2dhgroupnumbers</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhase2DhGroupNumbers() {
            return null;
        }

        /**
         * One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * <p>
         * Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2encryptionalgorithms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2encryptionalgorithms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhase2EncryptionAlgorithms() {
            return null;
        }

        /**
         * One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
         * <p>
         * Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2integrityalgorithms">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2integrityalgorithms</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPhase2IntegrityAlgorithms() {
            return null;
        }

        /**
         * The lifetime for phase 2 of the IKE negotiation, in seconds.
         * <p>
         * Constraints: A value between 900 and 3,600. The value must be less than the value for <code>Phase1LifetimeSeconds</code> .
         * <p>
         * Default: <code>3600</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2lifetimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-phase2lifetimeseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPhase2LifetimeSeconds() {
            return null;
        }

        /**
         * The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
         * <p>
         * Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be between 8 and 64 characters in length and cannot start with zero (0).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-presharedkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPreSharedKey() {
            return null;
        }

        /**
         * The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code> ) during which the rekey time is randomly selected.
         * <p>
         * Constraints: A value between 0 and 100.
         * <p>
         * Default: <code>100</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-rekeyfuzzpercentage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-rekeyfuzzpercentage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRekeyFuzzPercentage() {
            return null;
        }

        /**
         * The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN connection performs an IKE rekey.
         * <p>
         * The exact time of the rekey is randomly selected based on the value for <code>RekeyFuzzPercentage</code> .
         * <p>
         * Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code> .
         * <p>
         * Default: <code>270</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-rekeymargintimeseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-rekeymargintimeseconds</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRekeyMarginTimeSeconds() {
            return null;
        }

        /**
         * The number of packets in an IKE replay window.
         * <p>
         * Constraints: A value between 64 and 2048.
         * <p>
         * Default: <code>1024</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-replaywindowsize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-replaywindowsize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getReplayWindowSize() {
            return null;
        }

        /**
         * The action to take when the establishing the tunnel for the VPN connection.
         * <p>
         * By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify <code>start</code> for AWS to initiate the IKE negotiation.
         * <p>
         * Valid Values: <code>add</code> | <code>start</code>
         * <p>
         * Default: <code>add</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-startupaction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-startupaction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStartupAction() {
            return null;
        }

        /**
         * The range of inside IP addresses for the tunnel.
         * <p>
         * Any specified CIDR blocks must be unique across all VPN connections that use the same virtual private gateway.
         * <p>
         * Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are reserved and cannot be used:
         * <p>
         * <ul>
         * <li><code>169.254.0.0/30</code></li>
         * <li><code>169.254.1.0/30</code></li>
         * <li><code>169.254.2.0/30</code></li>
         * <li><code>169.254.3.0/30</code></li>
         * <li><code>169.254.4.0/30</code></li>
         * <li><code>169.254.5.0/30</code></li>
         * <li><code>169.254.169.252/30</code></li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsidecidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTunnelInsideCidr() {
            return null;
        }

        /**
         * The range of inside IPv6 addresses for the tunnel.
         * <p>
         * Any specified CIDR blocks must be unique across all VPN connections that use the same transit gateway.
         * <p>
         * Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsideipv6cidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-vpnconnection-vpntunneloptionsspecification.html#cfn-ec2-vpnconnection-vpntunneloptionsspecification-tunnelinsideipv6cidr</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTunnelInsideIpv6Cidr() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpnTunnelOptionsSpecificationProperty> {
            java.lang.String dpdTimeoutAction;
            java.lang.Number dpdTimeoutSeconds;
            java.lang.Object enableTunnelLifecycleControl;
            java.lang.Object ikeVersions;
            java.lang.Object logOptions;
            java.lang.Object phase1DhGroupNumbers;
            java.lang.Object phase1EncryptionAlgorithms;
            java.lang.Object phase1IntegrityAlgorithms;
            java.lang.Number phase1LifetimeSeconds;
            java.lang.Object phase2DhGroupNumbers;
            java.lang.Object phase2EncryptionAlgorithms;
            java.lang.Object phase2IntegrityAlgorithms;
            java.lang.Number phase2LifetimeSeconds;
            java.lang.String preSharedKey;
            java.lang.Number rekeyFuzzPercentage;
            java.lang.Number rekeyMarginTimeSeconds;
            java.lang.Number replayWindowSize;
            java.lang.String startupAction;
            java.lang.String tunnelInsideCidr;
            java.lang.String tunnelInsideIpv6Cidr;

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getDpdTimeoutAction}
             * @param dpdTimeoutAction The action to take after DPD timeout occurs.
             *                         Specify <code>restart</code> to restart the IKE initiation. Specify <code>clear</code> to end the IKE session.
             *                         <p>
             *                         Valid Values: <code>clear</code> | <code>none</code> | <code>restart</code>
             *                         <p>
             *                         Default: <code>clear</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dpdTimeoutAction(java.lang.String dpdTimeoutAction) {
                this.dpdTimeoutAction = dpdTimeoutAction;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getDpdTimeoutSeconds}
             * @param dpdTimeoutSeconds The number of seconds after which a DPD timeout occurs.
             *                          Constraints: A value greater than or equal to 30.
             *                          <p>
             *                          Default: <code>30</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dpdTimeoutSeconds(java.lang.Number dpdTimeoutSeconds) {
                this.dpdTimeoutSeconds = dpdTimeoutSeconds;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getEnableTunnelLifecycleControl}
             * @param enableTunnelLifecycleControl Turn on or off tunnel endpoint lifecycle control feature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableTunnelLifecycleControl(java.lang.Boolean enableTunnelLifecycleControl) {
                this.enableTunnelLifecycleControl = enableTunnelLifecycleControl;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getEnableTunnelLifecycleControl}
             * @param enableTunnelLifecycleControl Turn on or off tunnel endpoint lifecycle control feature.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enableTunnelLifecycleControl(software.amazon.awscdk.IResolvable enableTunnelLifecycleControl) {
                this.enableTunnelLifecycleControl = enableTunnelLifecycleControl;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getIkeVersions}
             * @param ikeVersions The IKE versions that are permitted for the VPN tunnel.
             *                    Valid values: <code>ikev1</code> | <code>ikev2</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ikeVersions(software.amazon.awscdk.IResolvable ikeVersions) {
                this.ikeVersions = ikeVersions;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getIkeVersions}
             * @param ikeVersions The IKE versions that are permitted for the VPN tunnel.
             *                    Valid values: <code>ikev1</code> | <code>ikev2</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ikeVersions(java.util.List<? extends java.lang.Object> ikeVersions) {
                this.ikeVersions = ikeVersions;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getLogOptions}
             * @param logOptions Options for logging VPN tunnel activity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logOptions(software.amazon.awscdk.IResolvable logOptions) {
                this.logOptions = logOptions;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getLogOptions}
             * @param logOptions Options for logging VPN tunnel activity.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logOptions(software.amazon.awscdk.services.ec2.CfnVPNConnection.VpnTunnelLogOptionsSpecificationProperty logOptions) {
                this.logOptions = logOptions;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase1DhGroupNumbers}
             * @param phase1DhGroupNumbers One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.
             *                             Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase1DhGroupNumbers(software.amazon.awscdk.IResolvable phase1DhGroupNumbers) {
                this.phase1DhGroupNumbers = phase1DhGroupNumbers;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase1DhGroupNumbers}
             * @param phase1DhGroupNumbers One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 1 IKE negotiations.
             *                             Valid values: <code>2</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase1DhGroupNumbers(java.util.List<? extends java.lang.Object> phase1DhGroupNumbers) {
                this.phase1DhGroupNumbers = phase1DhGroupNumbers;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase1EncryptionAlgorithms}
             * @param phase1EncryptionAlgorithms One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
             *                                   Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase1EncryptionAlgorithms(software.amazon.awscdk.IResolvable phase1EncryptionAlgorithms) {
                this.phase1EncryptionAlgorithms = phase1EncryptionAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase1EncryptionAlgorithms}
             * @param phase1EncryptionAlgorithms One or more encryption algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
             *                                   Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase1EncryptionAlgorithms(java.util.List<? extends java.lang.Object> phase1EncryptionAlgorithms) {
                this.phase1EncryptionAlgorithms = phase1EncryptionAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase1IntegrityAlgorithms}
             * @param phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
             *                                  Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase1IntegrityAlgorithms(software.amazon.awscdk.IResolvable phase1IntegrityAlgorithms) {
                this.phase1IntegrityAlgorithms = phase1IntegrityAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase1IntegrityAlgorithms}
             * @param phase1IntegrityAlgorithms One or more integrity algorithms that are permitted for the VPN tunnel for phase 1 IKE negotiations.
             *                                  Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase1IntegrityAlgorithms(java.util.List<? extends java.lang.Object> phase1IntegrityAlgorithms) {
                this.phase1IntegrityAlgorithms = phase1IntegrityAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase1LifetimeSeconds}
             * @param phase1LifetimeSeconds The lifetime for phase 1 of the IKE negotiation, in seconds.
             *                              Constraints: A value between 900 and 28,800.
             *                              <p>
             *                              Default: <code>28800</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase1LifetimeSeconds(java.lang.Number phase1LifetimeSeconds) {
                this.phase1LifetimeSeconds = phase1LifetimeSeconds;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase2DhGroupNumbers}
             * @param phase2DhGroupNumbers One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.
             *                             Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase2DhGroupNumbers(software.amazon.awscdk.IResolvable phase2DhGroupNumbers) {
                this.phase2DhGroupNumbers = phase2DhGroupNumbers;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase2DhGroupNumbers}
             * @param phase2DhGroupNumbers One or more Diffie-Hellman group numbers that are permitted for the VPN tunnel for phase 2 IKE negotiations.
             *                             Valid values: <code>2</code> | <code>5</code> | <code>14</code> | <code>15</code> | <code>16</code> | <code>17</code> | <code>18</code> | <code>19</code> | <code>20</code> | <code>21</code> | <code>22</code> | <code>23</code> | <code>24</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase2DhGroupNumbers(java.util.List<? extends java.lang.Object> phase2DhGroupNumbers) {
                this.phase2DhGroupNumbers = phase2DhGroupNumbers;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase2EncryptionAlgorithms}
             * @param phase2EncryptionAlgorithms One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
             *                                   Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase2EncryptionAlgorithms(software.amazon.awscdk.IResolvable phase2EncryptionAlgorithms) {
                this.phase2EncryptionAlgorithms = phase2EncryptionAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase2EncryptionAlgorithms}
             * @param phase2EncryptionAlgorithms One or more encryption algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
             *                                   Valid values: <code>AES128</code> | <code>AES256</code> | <code>AES128-GCM-16</code> | <code>AES256-GCM-16</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase2EncryptionAlgorithms(java.util.List<? extends java.lang.Object> phase2EncryptionAlgorithms) {
                this.phase2EncryptionAlgorithms = phase2EncryptionAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase2IntegrityAlgorithms}
             * @param phase2IntegrityAlgorithms One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
             *                                  Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase2IntegrityAlgorithms(software.amazon.awscdk.IResolvable phase2IntegrityAlgorithms) {
                this.phase2IntegrityAlgorithms = phase2IntegrityAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase2IntegrityAlgorithms}
             * @param phase2IntegrityAlgorithms One or more integrity algorithms that are permitted for the VPN tunnel for phase 2 IKE negotiations.
             *                                  Valid values: <code>SHA1</code> | <code>SHA2-256</code> | <code>SHA2-384</code> | <code>SHA2-512</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase2IntegrityAlgorithms(java.util.List<? extends java.lang.Object> phase2IntegrityAlgorithms) {
                this.phase2IntegrityAlgorithms = phase2IntegrityAlgorithms;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPhase2LifetimeSeconds}
             * @param phase2LifetimeSeconds The lifetime for phase 2 of the IKE negotiation, in seconds.
             *                              Constraints: A value between 900 and 3,600. The value must be less than the value for <code>Phase1LifetimeSeconds</code> .
             *                              <p>
             *                              Default: <code>3600</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder phase2LifetimeSeconds(java.lang.Number phase2LifetimeSeconds) {
                this.phase2LifetimeSeconds = phase2LifetimeSeconds;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getPreSharedKey}
             * @param preSharedKey The pre-shared key (PSK) to establish initial authentication between the virtual private gateway and customer gateway.
             *                     Constraints: Allowed characters are alphanumeric characters, periods (.), and underscores (_). Must be between 8 and 64 characters in length and cannot start with zero (0).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preSharedKey(java.lang.String preSharedKey) {
                this.preSharedKey = preSharedKey;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getRekeyFuzzPercentage}
             * @param rekeyFuzzPercentage The percentage of the rekey window (determined by <code>RekeyMarginTimeSeconds</code> ) during which the rekey time is randomly selected.
             *                            Constraints: A value between 0 and 100.
             *                            <p>
             *                            Default: <code>100</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekeyFuzzPercentage(java.lang.Number rekeyFuzzPercentage) {
                this.rekeyFuzzPercentage = rekeyFuzzPercentage;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getRekeyMarginTimeSeconds}
             * @param rekeyMarginTimeSeconds The margin time, in seconds, before the phase 2 lifetime expires, during which the AWS side of the VPN connection performs an IKE rekey.
             *                               The exact time of the rekey is randomly selected based on the value for <code>RekeyFuzzPercentage</code> .
             *                               <p>
             *                               Constraints: A value between 60 and half of <code>Phase2LifetimeSeconds</code> .
             *                               <p>
             *                               Default: <code>270</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rekeyMarginTimeSeconds(java.lang.Number rekeyMarginTimeSeconds) {
                this.rekeyMarginTimeSeconds = rekeyMarginTimeSeconds;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getReplayWindowSize}
             * @param replayWindowSize The number of packets in an IKE replay window.
             *                         Constraints: A value between 64 and 2048.
             *                         <p>
             *                         Default: <code>1024</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder replayWindowSize(java.lang.Number replayWindowSize) {
                this.replayWindowSize = replayWindowSize;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getStartupAction}
             * @param startupAction The action to take when the establishing the tunnel for the VPN connection.
             *                      By default, your customer gateway device must initiate the IKE negotiation and bring up the tunnel. Specify <code>start</code> for AWS to initiate the IKE negotiation.
             *                      <p>
             *                      Valid Values: <code>add</code> | <code>start</code>
             *                      <p>
             *                      Default: <code>add</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startupAction(java.lang.String startupAction) {
                this.startupAction = startupAction;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getTunnelInsideCidr}
             * @param tunnelInsideCidr The range of inside IP addresses for the tunnel.
             *                         Any specified CIDR blocks must be unique across all VPN connections that use the same virtual private gateway.
             *                         <p>
             *                         Constraints: A size /30 CIDR block from the <code>169.254.0.0/16</code> range. The following CIDR blocks are reserved and cannot be used:
             *                         <p>
             *                         <ul>
             *                         <li><code>169.254.0.0/30</code></li>
             *                         <li><code>169.254.1.0/30</code></li>
             *                         <li><code>169.254.2.0/30</code></li>
             *                         <li><code>169.254.3.0/30</code></li>
             *                         <li><code>169.254.4.0/30</code></li>
             *                         <li><code>169.254.5.0/30</code></li>
             *                         <li><code>169.254.169.252/30</code></li>
             *                         </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tunnelInsideCidr(java.lang.String tunnelInsideCidr) {
                this.tunnelInsideCidr = tunnelInsideCidr;
                return this;
            }

            /**
             * Sets the value of {@link VpnTunnelOptionsSpecificationProperty#getTunnelInsideIpv6Cidr}
             * @param tunnelInsideIpv6Cidr The range of inside IPv6 addresses for the tunnel.
             *                             Any specified CIDR blocks must be unique across all VPN connections that use the same transit gateway.
             *                             <p>
             *                             Constraints: A size /126 CIDR block from the local <code>fd00::/8</code> range.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tunnelInsideIpv6Cidr(java.lang.String tunnelInsideIpv6Cidr) {
                this.tunnelInsideIpv6Cidr = tunnelInsideIpv6Cidr;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpnTunnelOptionsSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpnTunnelOptionsSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpnTunnelOptionsSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpnTunnelOptionsSpecificationProperty {
            private final java.lang.String dpdTimeoutAction;
            private final java.lang.Number dpdTimeoutSeconds;
            private final java.lang.Object enableTunnelLifecycleControl;
            private final java.lang.Object ikeVersions;
            private final java.lang.Object logOptions;
            private final java.lang.Object phase1DhGroupNumbers;
            private final java.lang.Object phase1EncryptionAlgorithms;
            private final java.lang.Object phase1IntegrityAlgorithms;
            private final java.lang.Number phase1LifetimeSeconds;
            private final java.lang.Object phase2DhGroupNumbers;
            private final java.lang.Object phase2EncryptionAlgorithms;
            private final java.lang.Object phase2IntegrityAlgorithms;
            private final java.lang.Number phase2LifetimeSeconds;
            private final java.lang.String preSharedKey;
            private final java.lang.Number rekeyFuzzPercentage;
            private final java.lang.Number rekeyMarginTimeSeconds;
            private final java.lang.Number replayWindowSize;
            private final java.lang.String startupAction;
            private final java.lang.String tunnelInsideCidr;
            private final java.lang.String tunnelInsideIpv6Cidr;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dpdTimeoutAction = software.amazon.jsii.Kernel.get(this, "dpdTimeoutAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.dpdTimeoutSeconds = software.amazon.jsii.Kernel.get(this, "dpdTimeoutSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enableTunnelLifecycleControl = software.amazon.jsii.Kernel.get(this, "enableTunnelLifecycleControl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.ikeVersions = software.amazon.jsii.Kernel.get(this, "ikeVersions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logOptions = software.amazon.jsii.Kernel.get(this, "logOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phase1DhGroupNumbers = software.amazon.jsii.Kernel.get(this, "phase1DhGroupNumbers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phase1EncryptionAlgorithms = software.amazon.jsii.Kernel.get(this, "phase1EncryptionAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phase1IntegrityAlgorithms = software.amazon.jsii.Kernel.get(this, "phase1IntegrityAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phase1LifetimeSeconds = software.amazon.jsii.Kernel.get(this, "phase1LifetimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.phase2DhGroupNumbers = software.amazon.jsii.Kernel.get(this, "phase2DhGroupNumbers", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phase2EncryptionAlgorithms = software.amazon.jsii.Kernel.get(this, "phase2EncryptionAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phase2IntegrityAlgorithms = software.amazon.jsii.Kernel.get(this, "phase2IntegrityAlgorithms", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.phase2LifetimeSeconds = software.amazon.jsii.Kernel.get(this, "phase2LifetimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.preSharedKey = software.amazon.jsii.Kernel.get(this, "preSharedKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rekeyFuzzPercentage = software.amazon.jsii.Kernel.get(this, "rekeyFuzzPercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.rekeyMarginTimeSeconds = software.amazon.jsii.Kernel.get(this, "rekeyMarginTimeSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.replayWindowSize = software.amazon.jsii.Kernel.get(this, "replayWindowSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.startupAction = software.amazon.jsii.Kernel.get(this, "startupAction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tunnelInsideCidr = software.amazon.jsii.Kernel.get(this, "tunnelInsideCidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tunnelInsideIpv6Cidr = software.amazon.jsii.Kernel.get(this, "tunnelInsideIpv6Cidr", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dpdTimeoutAction = builder.dpdTimeoutAction;
                this.dpdTimeoutSeconds = builder.dpdTimeoutSeconds;
                this.enableTunnelLifecycleControl = builder.enableTunnelLifecycleControl;
                this.ikeVersions = builder.ikeVersions;
                this.logOptions = builder.logOptions;
                this.phase1DhGroupNumbers = builder.phase1DhGroupNumbers;
                this.phase1EncryptionAlgorithms = builder.phase1EncryptionAlgorithms;
                this.phase1IntegrityAlgorithms = builder.phase1IntegrityAlgorithms;
                this.phase1LifetimeSeconds = builder.phase1LifetimeSeconds;
                this.phase2DhGroupNumbers = builder.phase2DhGroupNumbers;
                this.phase2EncryptionAlgorithms = builder.phase2EncryptionAlgorithms;
                this.phase2IntegrityAlgorithms = builder.phase2IntegrityAlgorithms;
                this.phase2LifetimeSeconds = builder.phase2LifetimeSeconds;
                this.preSharedKey = builder.preSharedKey;
                this.rekeyFuzzPercentage = builder.rekeyFuzzPercentage;
                this.rekeyMarginTimeSeconds = builder.rekeyMarginTimeSeconds;
                this.replayWindowSize = builder.replayWindowSize;
                this.startupAction = builder.startupAction;
                this.tunnelInsideCidr = builder.tunnelInsideCidr;
                this.tunnelInsideIpv6Cidr = builder.tunnelInsideIpv6Cidr;
            }

            @Override
            public final java.lang.String getDpdTimeoutAction() {
                return this.dpdTimeoutAction;
            }

            @Override
            public final java.lang.Number getDpdTimeoutSeconds() {
                return this.dpdTimeoutSeconds;
            }

            @Override
            public final java.lang.Object getEnableTunnelLifecycleControl() {
                return this.enableTunnelLifecycleControl;
            }

            @Override
            public final java.lang.Object getIkeVersions() {
                return this.ikeVersions;
            }

            @Override
            public final java.lang.Object getLogOptions() {
                return this.logOptions;
            }

            @Override
            public final java.lang.Object getPhase1DhGroupNumbers() {
                return this.phase1DhGroupNumbers;
            }

            @Override
            public final java.lang.Object getPhase1EncryptionAlgorithms() {
                return this.phase1EncryptionAlgorithms;
            }

            @Override
            public final java.lang.Object getPhase1IntegrityAlgorithms() {
                return this.phase1IntegrityAlgorithms;
            }

            @Override
            public final java.lang.Number getPhase1LifetimeSeconds() {
                return this.phase1LifetimeSeconds;
            }

            @Override
            public final java.lang.Object getPhase2DhGroupNumbers() {
                return this.phase2DhGroupNumbers;
            }

            @Override
            public final java.lang.Object getPhase2EncryptionAlgorithms() {
                return this.phase2EncryptionAlgorithms;
            }

            @Override
            public final java.lang.Object getPhase2IntegrityAlgorithms() {
                return this.phase2IntegrityAlgorithms;
            }

            @Override
            public final java.lang.Number getPhase2LifetimeSeconds() {
                return this.phase2LifetimeSeconds;
            }

            @Override
            public final java.lang.String getPreSharedKey() {
                return this.preSharedKey;
            }

            @Override
            public final java.lang.Number getRekeyFuzzPercentage() {
                return this.rekeyFuzzPercentage;
            }

            @Override
            public final java.lang.Number getRekeyMarginTimeSeconds() {
                return this.rekeyMarginTimeSeconds;
            }

            @Override
            public final java.lang.Number getReplayWindowSize() {
                return this.replayWindowSize;
            }

            @Override
            public final java.lang.String getStartupAction() {
                return this.startupAction;
            }

            @Override
            public final java.lang.String getTunnelInsideCidr() {
                return this.tunnelInsideCidr;
            }

            @Override
            public final java.lang.String getTunnelInsideIpv6Cidr() {
                return this.tunnelInsideIpv6Cidr;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDpdTimeoutAction() != null) {
                    data.set("dpdTimeoutAction", om.valueToTree(this.getDpdTimeoutAction()));
                }
                if (this.getDpdTimeoutSeconds() != null) {
                    data.set("dpdTimeoutSeconds", om.valueToTree(this.getDpdTimeoutSeconds()));
                }
                if (this.getEnableTunnelLifecycleControl() != null) {
                    data.set("enableTunnelLifecycleControl", om.valueToTree(this.getEnableTunnelLifecycleControl()));
                }
                if (this.getIkeVersions() != null) {
                    data.set("ikeVersions", om.valueToTree(this.getIkeVersions()));
                }
                if (this.getLogOptions() != null) {
                    data.set("logOptions", om.valueToTree(this.getLogOptions()));
                }
                if (this.getPhase1DhGroupNumbers() != null) {
                    data.set("phase1DhGroupNumbers", om.valueToTree(this.getPhase1DhGroupNumbers()));
                }
                if (this.getPhase1EncryptionAlgorithms() != null) {
                    data.set("phase1EncryptionAlgorithms", om.valueToTree(this.getPhase1EncryptionAlgorithms()));
                }
                if (this.getPhase1IntegrityAlgorithms() != null) {
                    data.set("phase1IntegrityAlgorithms", om.valueToTree(this.getPhase1IntegrityAlgorithms()));
                }
                if (this.getPhase1LifetimeSeconds() != null) {
                    data.set("phase1LifetimeSeconds", om.valueToTree(this.getPhase1LifetimeSeconds()));
                }
                if (this.getPhase2DhGroupNumbers() != null) {
                    data.set("phase2DhGroupNumbers", om.valueToTree(this.getPhase2DhGroupNumbers()));
                }
                if (this.getPhase2EncryptionAlgorithms() != null) {
                    data.set("phase2EncryptionAlgorithms", om.valueToTree(this.getPhase2EncryptionAlgorithms()));
                }
                if (this.getPhase2IntegrityAlgorithms() != null) {
                    data.set("phase2IntegrityAlgorithms", om.valueToTree(this.getPhase2IntegrityAlgorithms()));
                }
                if (this.getPhase2LifetimeSeconds() != null) {
                    data.set("phase2LifetimeSeconds", om.valueToTree(this.getPhase2LifetimeSeconds()));
                }
                if (this.getPreSharedKey() != null) {
                    data.set("preSharedKey", om.valueToTree(this.getPreSharedKey()));
                }
                if (this.getRekeyFuzzPercentage() != null) {
                    data.set("rekeyFuzzPercentage", om.valueToTree(this.getRekeyFuzzPercentage()));
                }
                if (this.getRekeyMarginTimeSeconds() != null) {
                    data.set("rekeyMarginTimeSeconds", om.valueToTree(this.getRekeyMarginTimeSeconds()));
                }
                if (this.getReplayWindowSize() != null) {
                    data.set("replayWindowSize", om.valueToTree(this.getReplayWindowSize()));
                }
                if (this.getStartupAction() != null) {
                    data.set("startupAction", om.valueToTree(this.getStartupAction()));
                }
                if (this.getTunnelInsideCidr() != null) {
                    data.set("tunnelInsideCidr", om.valueToTree(this.getTunnelInsideCidr()));
                }
                if (this.getTunnelInsideIpv6Cidr() != null) {
                    data.set("tunnelInsideIpv6Cidr", om.valueToTree(this.getTunnelInsideIpv6Cidr()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.CfnVPNConnection.VpnTunnelOptionsSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpnTunnelOptionsSpecificationProperty.Jsii$Proxy that = (VpnTunnelOptionsSpecificationProperty.Jsii$Proxy) o;

                if (this.dpdTimeoutAction != null ? !this.dpdTimeoutAction.equals(that.dpdTimeoutAction) : that.dpdTimeoutAction != null) return false;
                if (this.dpdTimeoutSeconds != null ? !this.dpdTimeoutSeconds.equals(that.dpdTimeoutSeconds) : that.dpdTimeoutSeconds != null) return false;
                if (this.enableTunnelLifecycleControl != null ? !this.enableTunnelLifecycleControl.equals(that.enableTunnelLifecycleControl) : that.enableTunnelLifecycleControl != null) return false;
                if (this.ikeVersions != null ? !this.ikeVersions.equals(that.ikeVersions) : that.ikeVersions != null) return false;
                if (this.logOptions != null ? !this.logOptions.equals(that.logOptions) : that.logOptions != null) return false;
                if (this.phase1DhGroupNumbers != null ? !this.phase1DhGroupNumbers.equals(that.phase1DhGroupNumbers) : that.phase1DhGroupNumbers != null) return false;
                if (this.phase1EncryptionAlgorithms != null ? !this.phase1EncryptionAlgorithms.equals(that.phase1EncryptionAlgorithms) : that.phase1EncryptionAlgorithms != null) return false;
                if (this.phase1IntegrityAlgorithms != null ? !this.phase1IntegrityAlgorithms.equals(that.phase1IntegrityAlgorithms) : that.phase1IntegrityAlgorithms != null) return false;
                if (this.phase1LifetimeSeconds != null ? !this.phase1LifetimeSeconds.equals(that.phase1LifetimeSeconds) : that.phase1LifetimeSeconds != null) return false;
                if (this.phase2DhGroupNumbers != null ? !this.phase2DhGroupNumbers.equals(that.phase2DhGroupNumbers) : that.phase2DhGroupNumbers != null) return false;
                if (this.phase2EncryptionAlgorithms != null ? !this.phase2EncryptionAlgorithms.equals(that.phase2EncryptionAlgorithms) : that.phase2EncryptionAlgorithms != null) return false;
                if (this.phase2IntegrityAlgorithms != null ? !this.phase2IntegrityAlgorithms.equals(that.phase2IntegrityAlgorithms) : that.phase2IntegrityAlgorithms != null) return false;
                if (this.phase2LifetimeSeconds != null ? !this.phase2LifetimeSeconds.equals(that.phase2LifetimeSeconds) : that.phase2LifetimeSeconds != null) return false;
                if (this.preSharedKey != null ? !this.preSharedKey.equals(that.preSharedKey) : that.preSharedKey != null) return false;
                if (this.rekeyFuzzPercentage != null ? !this.rekeyFuzzPercentage.equals(that.rekeyFuzzPercentage) : that.rekeyFuzzPercentage != null) return false;
                if (this.rekeyMarginTimeSeconds != null ? !this.rekeyMarginTimeSeconds.equals(that.rekeyMarginTimeSeconds) : that.rekeyMarginTimeSeconds != null) return false;
                if (this.replayWindowSize != null ? !this.replayWindowSize.equals(that.replayWindowSize) : that.replayWindowSize != null) return false;
                if (this.startupAction != null ? !this.startupAction.equals(that.startupAction) : that.startupAction != null) return false;
                if (this.tunnelInsideCidr != null ? !this.tunnelInsideCidr.equals(that.tunnelInsideCidr) : that.tunnelInsideCidr != null) return false;
                return this.tunnelInsideIpv6Cidr != null ? this.tunnelInsideIpv6Cidr.equals(that.tunnelInsideIpv6Cidr) : that.tunnelInsideIpv6Cidr == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dpdTimeoutAction != null ? this.dpdTimeoutAction.hashCode() : 0;
                result = 31 * result + (this.dpdTimeoutSeconds != null ? this.dpdTimeoutSeconds.hashCode() : 0);
                result = 31 * result + (this.enableTunnelLifecycleControl != null ? this.enableTunnelLifecycleControl.hashCode() : 0);
                result = 31 * result + (this.ikeVersions != null ? this.ikeVersions.hashCode() : 0);
                result = 31 * result + (this.logOptions != null ? this.logOptions.hashCode() : 0);
                result = 31 * result + (this.phase1DhGroupNumbers != null ? this.phase1DhGroupNumbers.hashCode() : 0);
                result = 31 * result + (this.phase1EncryptionAlgorithms != null ? this.phase1EncryptionAlgorithms.hashCode() : 0);
                result = 31 * result + (this.phase1IntegrityAlgorithms != null ? this.phase1IntegrityAlgorithms.hashCode() : 0);
                result = 31 * result + (this.phase1LifetimeSeconds != null ? this.phase1LifetimeSeconds.hashCode() : 0);
                result = 31 * result + (this.phase2DhGroupNumbers != null ? this.phase2DhGroupNumbers.hashCode() : 0);
                result = 31 * result + (this.phase2EncryptionAlgorithms != null ? this.phase2EncryptionAlgorithms.hashCode() : 0);
                result = 31 * result + (this.phase2IntegrityAlgorithms != null ? this.phase2IntegrityAlgorithms.hashCode() : 0);
                result = 31 * result + (this.phase2LifetimeSeconds != null ? this.phase2LifetimeSeconds.hashCode() : 0);
                result = 31 * result + (this.preSharedKey != null ? this.preSharedKey.hashCode() : 0);
                result = 31 * result + (this.rekeyFuzzPercentage != null ? this.rekeyFuzzPercentage.hashCode() : 0);
                result = 31 * result + (this.rekeyMarginTimeSeconds != null ? this.rekeyMarginTimeSeconds.hashCode() : 0);
                result = 31 * result + (this.replayWindowSize != null ? this.replayWindowSize.hashCode() : 0);
                result = 31 * result + (this.startupAction != null ? this.startupAction.hashCode() : 0);
                result = 31 * result + (this.tunnelInsideCidr != null ? this.tunnelInsideCidr.hashCode() : 0);
                result = 31 * result + (this.tunnelInsideIpv6Cidr != null ? this.tunnelInsideIpv6Cidr.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ec2.CfnVPNConnection}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ec2.CfnVPNConnection> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.ec2.CfnVPNConnectionProps.Builder();
        }

        /**
         * The ID of the customer gateway at your end of the VPN connection.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-customergatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-customergatewayid</a>
         * @param customerGatewayId The ID of the customer gateway at your end of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerGatewayId(final java.lang.String customerGatewayId) {
            this.props.customerGatewayId(customerGatewayId);
            return this;
        }

        /**
         * The type of VPN connection.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-type</a>
         * @param type The type of VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * Indicate whether to enable acceleration for the VPN connection.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-enableacceleration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-enableacceleration</a>
         * @param enableAcceleration Indicate whether to enable acceleration for the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAcceleration(final java.lang.Boolean enableAcceleration) {
            this.props.enableAcceleration(enableAcceleration);
            return this;
        }
        /**
         * Indicate whether to enable acceleration for the VPN connection.
         * <p>
         * Default: <code>false</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-enableacceleration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-enableacceleration</a>
         * @param enableAcceleration Indicate whether to enable acceleration for the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAcceleration(final software.amazon.awscdk.IResolvable enableAcceleration) {
            this.props.enableAcceleration(enableAcceleration);
            return this;
        }

        /**
         * The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * <p>
         * Default: <code>0.0.0.0/0</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv4networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv4networkcidr</a>
         * @param localIpv4NetworkCidr The IPv4 CIDR on the customer gateway (on-premises) side of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localIpv4NetworkCidr(final java.lang.String localIpv4NetworkCidr) {
            this.props.localIpv4NetworkCidr(localIpv4NetworkCidr);
            return this;
        }

        /**
         * The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection.
         * <p>
         * Default: <code>::/0</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv6networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-localipv6networkcidr</a>
         * @param localIpv6NetworkCidr The IPv6 CIDR on the customer gateway (on-premises) side of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder localIpv6NetworkCidr(final java.lang.String localIpv6NetworkCidr) {
            this.props.localIpv6NetworkCidr(localIpv6NetworkCidr);
            return this;
        }

        /**
         * The type of IPv4 address assigned to the outside interface of the customer gateway device.
         * <p>
         * Valid values: <code>PrivateIpv4</code> | <code>PublicIpv4</code>
         * <p>
         * Default: <code>PublicIpv4</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-outsideipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-outsideipaddresstype</a>
         * @param outsideIpAddressType The type of IPv4 address assigned to the outside interface of the customer gateway device. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outsideIpAddressType(final java.lang.String outsideIpAddressType) {
            this.props.outsideIpAddressType(outsideIpAddressType);
            return this;
        }

        /**
         * The IPv4 CIDR on the AWS side of the VPN connection.
         * <p>
         * Default: <code>0.0.0.0/0</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv4networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv4networkcidr</a>
         * @param remoteIpv4NetworkCidr The IPv4 CIDR on the AWS side of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteIpv4NetworkCidr(final java.lang.String remoteIpv4NetworkCidr) {
            this.props.remoteIpv4NetworkCidr(remoteIpv4NetworkCidr);
            return this;
        }

        /**
         * The IPv6 CIDR on the AWS side of the VPN connection.
         * <p>
         * Default: <code>::/0</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv6networkcidr">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-remoteipv6networkcidr</a>
         * @param remoteIpv6NetworkCidr The IPv6 CIDR on the AWS side of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder remoteIpv6NetworkCidr(final java.lang.String remoteIpv6NetworkCidr) {
            this.props.remoteIpv6NetworkCidr(remoteIpv6NetworkCidr);
            return this;
        }

        /**
         * Indicates whether the VPN connection uses static routes only.
         * <p>
         * Static routes must be used for devices that don't support BGP.
         * <p>
         * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-staticroutesonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-staticroutesonly</a>
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(final java.lang.Boolean staticRoutesOnly) {
            this.props.staticRoutesOnly(staticRoutesOnly);
            return this;
        }
        /**
         * Indicates whether the VPN connection uses static routes only.
         * <p>
         * Static routes must be used for devices that don't support BGP.
         * <p>
         * If you are creating a VPN connection for a device that does not support Border Gateway Protocol (BGP), you must specify <code>true</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-staticroutesonly">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-staticroutesonly</a>
         * @param staticRoutesOnly Indicates whether the VPN connection uses static routes only. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staticRoutesOnly(final software.amazon.awscdk.IResolvable staticRoutesOnly) {
            this.props.staticRoutesOnly(staticRoutesOnly);
            return this;
        }

        /**
         * Any tags assigned to the VPN connection.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tags</a>
         * @param tags Any tags assigned to the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The ID of the transit gateway associated with the VPN connection.
         * <p>
         * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transitgatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transitgatewayid</a>
         * @param transitGatewayId The ID of the transit gateway associated with the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transitGatewayId(final java.lang.String transitGatewayId) {
            this.props.transitGatewayId(transitGatewayId);
            return this;
        }

        /**
         * The transit gateway attachment ID to use for the VPN tunnel.
         * <p>
         * Required if <code>OutsideIpAddressType</code> is set to <code>PrivateIpv4</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transporttransitgatewayattachmentid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-transporttransitgatewayattachmentid</a>
         * @param transportTransitGatewayAttachmentId The transit gateway attachment ID to use for the VPN tunnel. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder transportTransitGatewayAttachmentId(final java.lang.String transportTransitGatewayAttachmentId) {
            this.props.transportTransitGatewayAttachmentId(transportTransitGatewayAttachmentId);
            return this;
        }

        /**
         * Indicate whether the VPN tunnels process IPv4 or IPv6 traffic.
         * <p>
         * Default: <code>ipv4</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tunnelinsideipversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-tunnelinsideipversion</a>
         * @param tunnelInsideIpVersion Indicate whether the VPN tunnels process IPv4 or IPv6 traffic. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tunnelInsideIpVersion(final java.lang.String tunnelInsideIpVersion) {
            this.props.tunnelInsideIpVersion(tunnelInsideIpVersion);
            return this;
        }

        /**
         * The ID of the virtual private gateway at the AWS side of the VPN connection.
         * <p>
         * You must specify either <code>TransitGatewayId</code> or <code>VpnGatewayId</code> , but not both.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpngatewayid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpngatewayid</a>
         * @param vpnGatewayId The ID of the virtual private gateway at the AWS side of the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnGatewayId(final java.lang.String vpnGatewayId) {
            this.props.vpnGatewayId(vpnGatewayId);
            return this;
        }

        /**
         * The tunnel options for the VPN connection.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications</a>
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(final software.amazon.awscdk.IResolvable vpnTunnelOptionsSpecifications) {
            this.props.vpnTunnelOptionsSpecifications(vpnTunnelOptionsSpecifications);
            return this;
        }
        /**
         * The tunnel options for the VPN connection.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-vpnconnection.html#cfn-ec2-vpnconnection-vpntunneloptionsspecifications</a>
         * @param vpnTunnelOptionsSpecifications The tunnel options for the VPN connection. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpnTunnelOptionsSpecifications(final java.util.List<? extends java.lang.Object> vpnTunnelOptionsSpecifications) {
            this.props.vpnTunnelOptionsSpecifications(vpnTunnelOptionsSpecifications);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ec2.CfnVPNConnection}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ec2.CfnVPNConnection build() {
            return new software.amazon.awscdk.services.ec2.CfnVPNConnection(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
