package software.amazon.awscdk.services.ec2;

/**
 * What class and generation of instance to use.
 * <p>
 * We have both symbolic and concrete enums for every type.
 * <p>
 * The first are for people that want to specify by purpose,
 * the second one are for people who already know exactly what
 * 'R4' means.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a distribution from an EC2 instance
 * Vpc vpc;
 * // Create an EC2 instance in a VPC. 'subnetType' can be private.
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_EGRESS).build())
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(VpcOrigin.withEc2Instance(instance)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.652Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InstanceClass")
public enum InstanceClass {
    /**
     * Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD3,
    /**
     * Standard instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M3,
    /**
     * Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD4,
    /**
     * Standard instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M4,
    /**
     * Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5,
    /**
     * Standard instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5,
    /**
     * Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_NVME_DRIVE,
    /**
     * Standard instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5D,
    /**
     * Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD,
    /**
     * Standard instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5A,
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_AMD_NVME_DRIVE,
    /**
     * Standard instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5AD,
    /**
     * Standard instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_HIGH_PERFORMANCE,
    /**
     * Standard instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5N,
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Standard instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5DN,
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD5_HIGH_COMPUTE,
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Cascade Lake) processors, 5nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M5ZN,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY3,
    /**
     * Memory optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R3,
    /**
     * Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY4,
    /**
     * Memory optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R4,
    /**
     * Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5,
    /**
     * Memory optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5,
    /**
     * Memory optimized instances based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_AMD,
    /**
     * Memory optimized instances based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6A,
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_INTEL,
    /**
     * Memory optimized instances, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6I,
    /**
     * Memory optimized instances with local NVME drive, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_INTEL_NVME_DRIVE,
    /**
     * Memory optimized instances with local NVME drive, 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6ID,
    /**
     * Memory optimized instances for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_INTEL_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6IN,
    /**
     * Memory optimized instances with local NVME drive for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_INTEL_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances with local NVME drive for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6IDN,
    /**
     * Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5N,
    /**
     * Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE,
    /**
     * Memory optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5D,
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Memory optimized instances with local NVME drive for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5DN,
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_AMD,
    /**
     * Memory optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5A,
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_AMD_NVME_DRIVE,
    /**
     * Memory optimized instances based on AMD EPYC with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5AD,
    /**
     * High memory instances (3TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_3TB_1,
    /**
     * High memory instances (3TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_3TB1,
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_6TB_1,
    /**
     * High memory instances (6TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_6TB1,
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_9TB_1,
    /**
     * High memory instances (9TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_9TB1,
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_12TB_1,
    /**
     * High memory instances (12TB) based on Intel Xeon Platinum 8176M (Skylake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_12TB1,
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_18TB_1,
    /**
     * High memory instances (18TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_18TB1,
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_24TB_1,
    /**
     * High memory instances (24TB) based on Intel Xeon Scalable (Cascade Lake) processors, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U_24TB1,
    /**
     * High memory instances (6TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_6TB_7,
    /**
     * High memory instances (6TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U7I_6TB,
    /**
     * High memory instances (8TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_8TB_7,
    /**
     * High memory instances (8TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U7I_8TB,
    /**
     * High memory instances (12TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_12TB_7,
    /**
     * High memory instances (12TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U7I_12TB,
    /**
     * High memory, network-intensive instances (16TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_HIGH_NETWORK_16TB_7,
    /**
     * High memory, network-intensive instances (16TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U7IN_16TB,
    /**
     * High memory, network-intensive instances (24TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_HIGH_NETWORK_24TB_7,
    /**
     * High memory, network-intensive instances (24TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U7IN_24TB,
    /**
     * High memory, network-intensive instances (32TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_HIGH_NETWORK_32TB_7,
    /**
     * High memory, network-intensive instances (32TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U7IN_32TB,
    /**
     * High memory, network-intensive instances (32TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation U7inh instances use Hewlett Packard Enterprise (HPE) Compute Scale Up Server 3200.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_MEMORY_HIGH_NETWORK_HPE_32TB_7,
    /**
     * High memory, network-intensive instances (32TB) based on 4th Generation Intel Xeon Scalable processors (Sapphire Rapids), 7th generation U7inh instances use Hewlett Packard Enterprise (HPE) Compute Scale Up Server 3200.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    U7INH_32TB,
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY5_EBS_OPTIMIZED,
    /**
     * Memory optimized instances that are also EBS-optimized, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R5B,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_GRAVITON,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6G,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY6_GRAVITON2_NVME_DRIVE,
    /**
     * Memory optimized instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R6GD,
    /**
     * Memory optimized instances, 7th generation with Graviton3 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY7_GRAVITON,
    /**
     * Memory optimized instances, 7th generation with Graviton3 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R7G,
    /**
     * Memory optimized instances, 7th generation with Graviton3 processors and local NVME drive.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY7_GRAVITON3_NVME_DRIVE,
    /**
     * Memory optimized instances, 7th generation with Graviton3 processors and local NVME drive.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R7GD,
    /**
     * Memory optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation w/  3.2GHz turbo frequency.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY7_INTEL_BASE,
    /**
     * Memory optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation w/  3.2GHz turbo frequency.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R7I,
    /**
     * Memory optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation, with sustained 3.9GHz turbo frequency.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY7_INTEL,
    /**
     * Memory optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation, with sustained 3.9GHz turbo frequency.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R7IZ,
    /**
     * Memory optimized instances based on 4th generation AMD EPYC (codename Genoa), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY7_AMD,
    /**
     * Memory optimized instances based on 4th generation AMD EPYC (codename Genoa), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R7A,
    /**
     * Memory optimized instances with Graviton4 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY8_GRAVITON,
    /**
     * Memory optimized instances with Graviton4 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R8G,
    /**
     * Memory optimized instances, 8th generation with Graviton4 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY8_GRAVITON4_NVME_DRIVE,
    /**
     * Memory optimized instances, 8th generation with Graviton4 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    R8GD,
    /**
     * Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE3,
    /**
     * Compute optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C3,
    /**
     * Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE4,
    /**
     * Compute optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C4,
    /**
     * Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5,
    /**
     * Compute optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5,
    /**
     * Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_NVME_DRIVE,
    /**
     * Compute optimized instances with local NVME drive, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5D,
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_AMD,
    /**
     * Compute optimized instances based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5A,
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_AMD_NVME_DRIVE,
    /**
     * Compute optimized instances with local NVME drive based on AMD EPYC, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5AD,
    /**
     * Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE5_HIGH_PERFORMANCE,
    /**
     * Compute optimized instances for high performance computing, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C5N,
    /**
     * Compute optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_INTEL,
    /**
     * Compute optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6I,
    /**
     * Compute optimized instances with local NVME drive, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_INTEL_NVME_DRIVE,
    /**
     * Compute optimized instances with local NVME drive, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6ID,
    /**
     * Compute optimized instances for high performance computing, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_INTEL_HIGH_PERFORMANCE,
    /**
     * Compute optimized instances for high performance computing, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6IN,
    /**
     * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_AMD,
    /**
     * Compute optimized instances based on AMD EPYC (codename Milan), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6A,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6G,
    /**
     * Compute optimized instances for high performance computing, 7th generation with Graviton3 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE7_GRAVITON3,
    /**
     * Compute optimized instances for high performance computing, 7th generation with Graviton3 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C7G,
    /**
     * Compute optimized instances for high performance computing, 8th generation with Graviton4 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Frankfurt).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE8_GRAVITON4,
    /**
     * Compute optimized instances for high performance computing, 8th generation with Graviton4 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Frankfurt).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C8G,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2_NVME_DRIVE,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6GD,
    /**
     * Compute optimized instances for high performance computing, 7th generation with Graviton3 processors and local NVME drive.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE7_GRAVITON3_NVME_DRIVE,
    /**
     * Compute optimized instances for high performance computing, 7th generation with Graviton3 processors and local NVME drive.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C7GD,
    /**
     * Compute optimized instances for high performance computing, 8th generation with Graviton4 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE8_GRAVITON4_NVME_DRIVE,
    /**
     * Compute optimized instances for high performance computing, 8th generation with Graviton4 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C8GD,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE6_GRAVITON2_HIGH_NETWORK_BANDWIDTH,
    /**
     * Compute optimized instances for high performance computing, 6th generation with Graviton2 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C6GN,
    /**
     * Compute optimized instances for high performance computing, 7th generation with Graviton3 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE7_GRAVITON3_HIGH_NETWORK_BANDWIDTH,
    /**
     * Compute optimized instances for high performance computing, 7th generation with Graviton3 processors and high network bandwidth capabilities.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C7GN,
    /**
     * Compute optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE7_INTEL,
    /**
     * Compute optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C7I,
    /**
     * Compute optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation C7i-flex instances efficiently use compute resources to deliver a baseline level of performance with the ability to scale up to the full compute performance a majority of the time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE7_INTEL_FLEX,
    /**
     * Compute optimized instances based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation C7i-flex instances efficiently use compute resources to deliver a baseline level of performance with the ability to scale up to the full compute performance a majority of the time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C7I_FLEX,
    /**
     * Compute optimized instances based on 4th generation AMD EPYC (codename Genoa), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPUTE7_AMD,
    /**
     * Compute optimized instances based on 4th generation AMD EPYC (codename Genoa), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    C7A,
    /**
     * Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE2,
    /**
     * Storage-optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    D2,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE3,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    D3,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE3_ENHANCED_NETWORK,
    /**
     * Storage-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    D3EN,
    /**
     * Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE_COMPUTE_1,
    /**
     * Storage/compute balanced instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    H1,
    /**
     * High performance computing powered by AWS Trainium.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRAINING_ACCELERATOR1,
    /**
     * High performance computing powered by AWS Trainium.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRN1,
    /**
     * Network-optimized high performance computing powered by AWS Trainium.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRAINING_ACCELERATOR1_ENHANCED_NETWORK,
    /**
     * Network-optimized high performance computing powered by AWS Trainium.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRN1N,
    /**
     * High performance computing powered by AWS Trainium2, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRAINING_ACCELERATOR2,
    /**
     * High performance computing powered by AWS Trainium2, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRN2,
    /**
     * High performance computing powered by AWS Trainium2 and EC2 Ultra Servers, 2nd generation UltraServers connect multiple EC2 instances using a dedicated, high-bandwidth, low-latency accelerator interconnect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRAINING_ACCELERATOR2_ULTRASERVER,
    /**
     * High performance computing powered by AWS Trainium2 and EC2 Ultra Servers, 2nd generation UltraServers connect multiple EC2 instances using a dedicated, high-bandwidth, low-latency accelerator interconnect.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRN2U,
    /**
     * I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3,
    /**
     * I/O-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I3,
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO3_DENSE_NVME_DRIVE,
    /**
     * I/O-optimized instances with local NVME drive, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I3EN,
    /**
     * I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO4_INTEL,
    /**
     * I/O-optimized instances with local NVME drive powered by Intel Xeon Scalable processors (code named Ice Lake), 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I4I,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE4_GRAVITON,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I4G,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE4_GRAVITON_NETWORK_OPTIMIZED,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IM4GN,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE4_GRAVITON_NETWORK_STORAGE_OPTIMIZED,
    /**
     * Storage optimized instances powered by Graviton2 processor, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IS4GEN,
    /**
     * Storage optimized instances powered by 5th generation Intel Xeon Scalable processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE7_INTEL_STORAGE_OPTIMIZED,
    /**
     * Storage optimized instances powered by 5th generation Intel Xeon Scalable processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I7IE,
    /**
     * I/O-optimized instances with local NVME drive powered by 5th generation Intel Xeon Scalable processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    IO7_INTEL,
    /**
     * I/O-optimized instances with local NVME drive powered by 5th generation Intel Xeon Scalable processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I7I,
    /**
     * Storage optimized instances powered by Graviton4 processor, 8th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STORAGE8_GRAVITON,
    /**
     * Storage optimized instances powered by Graviton4 processor, 8th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    I8G,
    /**
     * Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE2,
    /**
     * Burstable instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T2,
    /**
     * Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3,
    /**
     * Burstable instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T3,
    /**
     * Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE3_AMD,
    /**
     * Burstable instances based on AMD EPYC, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T3A,
    /**
     * Burstable instances, 4th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BURSTABLE4_GRAVITON,
    /**
     * Burstable instances, 4th generation with Graviton2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    T4G,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1,
    /**
     * Memory-intensive instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X1,
    /**
     * Memory-intensive instances, extended, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_1_EXTENDED,
    /**
     * Memory-intensive instances, extended, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X1E,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors.
     * <p>
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_GRAVITON2,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors.
     * <p>
     * This instance type can be used only in RDS. It is not supported in EC2.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2G,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_GRAVITON2_NVME_DRIVE,
    /**
     * Memory-intensive instances, 2nd generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2GD,
    /**
     * Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory.
     * <p>
     * Intel Xeon Scalable (Ice Lake) processors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_XT_INTEL,
    /**
     * Memory-intensive instances with higher network bandwith, local NVME drive, and extended memory.
     * <p>
     * Intel Xeon Scalable (Ice Lake) processors
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2IEDN,
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_INTEL,
    /**
     * Memory-intensive instances with higher network bandwith and local NVME drive, Intel Xeon Scalable (Ice Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2IDN,
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_2_XTZ_INTEL,
    /**
     * Memory-intensive instances with higher network bandwith and single-threaded performance, Intel Xeon Scalable (Cascade Lake) processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X2IEZN,
    /**
     * Memory-intensive instances powered by Graviton4 processors, 8th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MEMORY_INTENSIVE_8_GRAVITON,
    /**
     * Memory-intensive instances powered by Graviton4 processors, 8th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    X8G,
    /**
     * Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FPGA1,
    /**
     * Instances with customizable hardware acceleration, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    F1,
    /**
     * Instances with customizable hardware acceleration, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    FPGA2,
    /**
     * Instances with customizable hardware acceleration, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    F2,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS3_SMALL,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G3S,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS3,
    /**
     * Graphics-optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G3,
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS4_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Graphics-optimized instances with NVME drive for high performance computing, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G4DN,
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS4_AMD_NVME_DRIVE,
    /**
     * Graphics-optimized instances based on AMD EPYC And Radeon Pro GPU (NAVI) with local NVME drive, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G4AD,
    /**
     * Graphics-optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS5,
    /**
     * Graphics-optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G5,
    /**
     * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS5_GRAVITON2,
    /**
     * Graphics-optimized instances powered by AWS Graviton2 Processors and NVIDIA T4G Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G5G,
    /**
     * Graphics-optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS6,
    /**
     * Graphics-optimized instances, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G6,
    /**
     * Cost-efficient GPU-based instances for AI inference and spatial computing workloads, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS6_EFFICIENT,
    /**
     * Cost-efficient GPU-based instances for AI inference and spatial computing workloads, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    G6E,
    /**
     * Graphics-optimized instances, 6th generation Gr6 instances offer a 1:8 vCPU to RAM ratio, making them better suited for graphics workloads with higher memory requirements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GRAPHICS_RAM_6,
    /**
     * Graphics-optimized instances, 6th generation Gr6 instances offer a 1:8 vCPU to RAM ratio, making them better suited for graphics workloads with higher memory requirements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    GR6,
    /**
     * Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL2,
    /**
     * Parallel-processing optimized instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P2,
    /**
     * Parallel-processing optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL3,
    /**
     * Parallel-processing optimized instances, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P3,
    /**
     * Parallel-processing optimized instances with local NVME drive for high performance computing, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL3_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Parallel-processing optimized instances with local NVME drive for high performance computing, 3rd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P3DN,
    /**
     * Parallel-processing optimized instances with local NVME drive, extended, 4th generation (in developer preview).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL4_NVME_DRIVE_EXTENDED,
    /**
     * Parallel-processing optimized instances with local NVME drive, extended, 4th generation (in developer preview).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P4DE,
    /**
     * Parallel-processing optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL4,
    /**
     * Parallel-processing optimized instances, 4th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P4D,
    /**
     * Parallel-processing optimized instances powered by NVIDIA H100 Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL5,
    /**
     * Parallel-processing optimized instances powered by NVIDIA H100 Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P5,
    /**
     * Parallel-processing optimized instances powered by NVIDIA H200 Tensor Core GPUs, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL5_EXTENDED,
    /**
     * Parallel-processing optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P5E,
    /**
     * Parallel-processing, network-optimized instances powered by NVIDIA H200 Tensor Core GPUs, 5th generation P5en instances pair NVIDIA H200 Tensor Core GPUs with Intel Sapphire Rapids CPU, enabling Gen5 PCIe between CPU and GPU.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    PARALLEL5_EXTENDED_NETWORK,
    /**
     * Parallel-processing optimized instances, 5th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    P5EN,
    /**
     * Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ARM1,
    /**
     * Arm processor based instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    A1,
    /**
     * Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_GRAVITON,
    /**
     * Arm processor based instances, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6G,
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_INTEL,
    /**
     * Standard instances based on Intel (Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6I,
    /**
     * Standard instances based on Intel (Ice Lake) with local NVME drive, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_INTEL_NVME_DRIVE,
    /**
     * Standard instances based on Intel (Ice Lake) with local NVME drive, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6ID,
    /**
     * Standard instances for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_INTEL_HIGH_PERFORMANCE,
    /**
     * Standard instances for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6IN,
    /**
     * Standard instances with local NVME drive for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_INTEL_NVME_DRIVE_HIGH_PERFORMANCE,
    /**
     * Standard instances with local NVME drive for high performance computing powered by Intel Xeon Scalable processors (code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6IDN,
    /**
     * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_AMD,
    /**
     * Standard instances based on 3rd Gen AMD EPYC processors, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6A,
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD6_GRAVITON2_NVME_DRIVE,
    /**
     * Standard instances, 6th generation with Graviton2 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M6GD,
    /**
     * Standard instances, 7th generation with Graviton3 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD7_GRAVITON,
    /**
     * Standard instances, 7th generation with Graviton3 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M7G,
    /**
     * Standard instances, 8th generation with Graviton4 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Frankfurt).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD8_GRAVITON,
    /**
     * Standard instances, 8th generation with Graviton4 processors.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Frankfurt).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M8G,
    /**
     * Standard instances, 7th generation with Graviton3 processors and local NVME drive.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD7_GRAVITON3_NVME_DRIVE,
    /**
     * Standard instances, 7th generation with Graviton3 processors and local NVME drive.
     * <p>
     * This instance class is currently only available in US East (Ohio), US East (N. Virginia), US West (Oregon), and Europe (Ireland).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M7GD,
    /**
     * Standard instances, 8th generation with Graviton4 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD8_GRAVITON4_NVME_DRIVE,
    /**
     * Standard instances, 8th generation with Graviton4 processors and local NVME drive.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M8GD,
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD7_INTEL,
    /**
     * Standard instances with high memory and compute capacity based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M7I,
    /**
     * Flexible instances with high memory and compute capacity based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation The M7i-Flex instances deliver a baseline of 40% CPU performance, and can scale up to full CPU performance 95% of the time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD7_INTEL_FLEX,
    /**
     * Flexible instances with high memory and compute capacity based on Intel Xeon Scalable (Sapphire Rapids) processors, 7th generation The M7i-Flex instances deliver a baseline of 40% CPU performance, and can scale up to full CPU performance 95% of the time.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M7I_FLEX,
    /**
     * Standard instances based on 4th generation AMD EPYC (codename Genoa), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STANDARD7_AMD,
    /**
     * Standard instances based on 4th generation AMD EPYC (codename Genoa), 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    M7A,
    /**
     * High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_COMPUTE_MEMORY1,
    /**
     * High memory and compute capacity instances, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    Z1D,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFERENCE1,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INF1,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFERENCE2,
    /**
     * Inferentia Chips based instances for machine learning inference applications, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INF2,
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MACINTOSH1_INTEL,
    /**
     * Macintosh instances built on Apple Mac mini computers, 1st generation with Intel procesors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC1,
    /**
     * Macintosh instances built on Apple Mac mini 2020 computers, 2nd generation with Apple silicon M1 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MACINTOSH2_M1,
    /**
     * Macintosh instances built on Apple Mac mini 2020 computers, 2nd generation with Apple silicon M1 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC2,
    /**
     * Macintosh instances built on Apple Mac mini 2023 computers, 2nd generation with Apple silicon M2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MACINTOSH2_M2,
    /**
     * Macintosh instances built on Apple Mac mini 2023 computers, 2nd generation with Apple silicon M2 processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC2_M2,
    /**
     * Macintosh instances built on Apple Mac mini 2023 computers, 2nd generation with Apple silicon M2 Pro processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MACINTOSH2_M2_PRO,
    /**
     * Macintosh instances built on Apple Mac mini 2023 computers, 2nd generation with Apple silicon M2 Pro processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC2_M2PRO,
    /**
     * Macintosh instances built on 2022 Mac Studio hardware powered by Apple silicon M1 Ultra processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MACINTOSH2_M1_ULTRA,
    /**
     * Macintosh instances built on 2022 Mac Studio hardware powered by Apple silicon M1 Ultra processors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    MAC2_M1ULTRA,
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VIDEO_TRANSCODING1,
    /**
     * Multi-stream video transcoding instances for resolutions up to 4K UHD, 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VT1,
    /**
     * High performance computing based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_PERFORMANCE_COMPUTING6_AMD,
    /**
     * High performance computing based on AMD EPYC, 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HPC6A,
    /**
     * High performance computing with local NVME drive based on 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_PERFORMANCE_COMPUTING6_INTEL_NVME_DRIVE,
    /**
     * High performance computing with local NVME drive based on 6th generation with Intel Xeon Scalable processors (3rd generation processors code named Ice Lake), 6th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HPC6ID,
    /**
     * High performance computing based on AMD EPYC, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_PERFORMANCE_COMPUTING7_AMD,
    /**
     * High performance computing based on AMD EPYC, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HPC7A,
    /**
     * High performance computing based on Graviton, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HIGH_PERFORMANCE_COMPUTING7_GRAVITON,
    /**
     * High performance computing based on Graviton, 7th generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    HPC7G,
    /**
     * Deep learning instances powered by Gaudi accelerators from Habana Labs (an Intel company), 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEEP_LEARNING1,
    /**
     * Deep learning instances powered by Gaudi accelerators from Habana Labs (an Intel company), 1st generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DL1,
    /**
     * Deep learning instances powered by Qualcomm AI 100 Standard accelerators, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEEP_LEARNING2_QUALCOMM,
    /**
     * Deep learning instances powered by Qualcomm AI 100 Standard accelerators, 2nd generation.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DL2Q,
}
