package software.amazon.awscdk.services.ec2;

/**
 * Provides the options for specifying the instance initiated shutdown behavior.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.T3, InstanceSize.NANO))
 *         .machineImage(AmazonLinuxImage.Builder.create().generation(AmazonLinuxGeneration.AMAZON_LINUX_2).build())
 *         .instanceInitiatedShutdownBehavior(InstanceInitiatedShutdownBehavior.TERMINATE)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.654Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InstanceInitiatedShutdownBehavior")
public enum InstanceInitiatedShutdownBehavior {
    /**
     * The instance will stop when it initiates a shutdown.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    STOP,
    /**
     * The instance will be terminated when it initiates a shutdown.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TERMINATE,
}
