package software.amazon.awscdk.services.ec2;

/**
 * The type of the key pair.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * InstanceType instanceType;
 * KeyPair keyPair = KeyPair.Builder.create(this, "KeyPair")
 *         .type(KeyPairType.ED25519)
 *         .format(KeyPairFormat.PEM)
 *         .build();
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(instanceType)
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         // Use the custom key pair
 *         .keyPair(keyPair)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.681Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.KeyPairType")
public enum KeyPairType {
    /**
     * An RSA key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RSA,
    /**
     * An ED25519 key.
     * <p>
     * Note that ED25519 keys are not supported for Windows instances.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ED25519,
}
