package software.amazon.awscdk.services.ec2;

/**
 * CIDR Allocated Vpc.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * VpcIpamOptions vpcIpamOptions = VpcIpamOptions.builder()
 *         .cidrBlock("cidrBlock")
 *         .ipv4IpamPoolId("ipv4IpamPoolId")
 *         .ipv4NetmaskLength(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.775Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.VpcIpamOptions")
@software.amazon.jsii.Jsii.Proxy(VpcIpamOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VpcIpamOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * CIDR Block for Vpc.
     * <p>
     * Default: - Only required when Ipam has concrete allocation available for static Vpc
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCidrBlock() {
        return null;
    }

    /**
     * ipv4 IPAM Pool Id.
     * <p>
     * Default: - Only required when using AWS Ipam
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpv4IpamPoolId() {
        return null;
    }

    /**
     * CIDR Mask for Vpc.
     * <p>
     * Default: - Only required when using AWS Ipam
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv4NetmaskLength() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link VpcIpamOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VpcIpamOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VpcIpamOptions> {
        java.lang.String cidrBlock;
        java.lang.String ipv4IpamPoolId;
        java.lang.Number ipv4NetmaskLength;

        /**
         * Sets the value of {@link VpcIpamOptions#getCidrBlock}
         * @param cidrBlock CIDR Block for Vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cidrBlock(java.lang.String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        /**
         * Sets the value of {@link VpcIpamOptions#getIpv4IpamPoolId}
         * @param ipv4IpamPoolId ipv4 IPAM Pool Id.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4IpamPoolId(java.lang.String ipv4IpamPoolId) {
            this.ipv4IpamPoolId = ipv4IpamPoolId;
            return this;
        }

        /**
         * Sets the value of {@link VpcIpamOptions#getIpv4NetmaskLength}
         * @param ipv4NetmaskLength CIDR Mask for Vpc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv4NetmaskLength(java.lang.Number ipv4NetmaskLength) {
            this.ipv4NetmaskLength = ipv4NetmaskLength;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VpcIpamOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VpcIpamOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VpcIpamOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcIpamOptions {
        private final java.lang.String cidrBlock;
        private final java.lang.String ipv4IpamPoolId;
        private final java.lang.Number ipv4NetmaskLength;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cidrBlock = software.amazon.jsii.Kernel.get(this, "cidrBlock", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv4IpamPoolId = software.amazon.jsii.Kernel.get(this, "ipv4IpamPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipv4NetmaskLength = software.amazon.jsii.Kernel.get(this, "ipv4NetmaskLength", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cidrBlock = builder.cidrBlock;
            this.ipv4IpamPoolId = builder.ipv4IpamPoolId;
            this.ipv4NetmaskLength = builder.ipv4NetmaskLength;
        }

        @Override
        public final java.lang.String getCidrBlock() {
            return this.cidrBlock;
        }

        @Override
        public final java.lang.String getIpv4IpamPoolId() {
            return this.ipv4IpamPoolId;
        }

        @Override
        public final java.lang.Number getIpv4NetmaskLength() {
            return this.ipv4NetmaskLength;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCidrBlock() != null) {
                data.set("cidrBlock", om.valueToTree(this.getCidrBlock()));
            }
            if (this.getIpv4IpamPoolId() != null) {
                data.set("ipv4IpamPoolId", om.valueToTree(this.getIpv4IpamPoolId()));
            }
            if (this.getIpv4NetmaskLength() != null) {
                data.set("ipv4NetmaskLength", om.valueToTree(this.getIpv4NetmaskLength()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.VpcIpamOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VpcIpamOptions.Jsii$Proxy that = (VpcIpamOptions.Jsii$Proxy) o;

            if (this.cidrBlock != null ? !this.cidrBlock.equals(that.cidrBlock) : that.cidrBlock != null) return false;
            if (this.ipv4IpamPoolId != null ? !this.ipv4IpamPoolId.equals(that.ipv4IpamPoolId) : that.ipv4IpamPoolId != null) return false;
            return this.ipv4NetmaskLength != null ? this.ipv4NetmaskLength.equals(that.ipv4NetmaskLength) : that.ipv4NetmaskLength == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cidrBlock != null ? this.cidrBlock.hashCode() : 0;
            result = 31 * result + (this.ipv4IpamPoolId != null ? this.ipv4IpamPoolId.hashCode() : 0);
            result = 31 * result + (this.ipv4NetmaskLength != null ? this.ipv4NetmaskLength.hashCode() : 0);
            return result;
        }
    }
}
