package software.amazon.awscdk.services.ecr.assets;

/**
 * Options for TarballImageAsset.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ecr.assets.TarballImageAsset;
 * TarballImageAsset asset = TarballImageAsset.Builder.create(this, "MyBuildImage")
 *         .tarballFile("local-image.tar")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:15.853Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecr_assets.TarballImageAssetProps")
@software.amazon.jsii.Jsii.Proxy(TarballImageAssetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface TarballImageAssetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Absolute path to the tarball.
     * <p>
     * It is recommended to to use the script running directory (e.g. <code>__dirname</code>
     * in Node.js projects or dirname of <code>__file__</code> in Python) if your tarball
     * is located as a resource inside your project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTarballFile();

    /**
     * A display name for this asset.
     * <p>
     * If supplied, the display name will be used in locations where the asset
     * identifier is printed, like in the CLI progress information. If the same
     * asset is added multiple times, the display name of the first occurrence is
     * used.
     * <p>
     * The default is the construct path of the <code>TarballImageAsset</code> construct,
     * with respect to the enclosing stack. If the asset is produced by a
     * construct helper function (such as <code>lambda.Code.fromAssetImage()</code>), this
     * will look like <code>MyFunction/AssetImage</code>.
     * <p>
     * We use the stack-relative construct path so that in the common case where
     * you have multiple stacks with the same asset, we won't show something like
     * <code>/MyBetaStack/MyFunction/Code</code> when you are actually deploying to
     * production.
     * <p>
     * Default: - Stack-relative construct path
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDisplayName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link TarballImageAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link TarballImageAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<TarballImageAssetProps> {
        java.lang.String tarballFile;
        java.lang.String displayName;

        /**
         * Sets the value of {@link TarballImageAssetProps#getTarballFile}
         * @param tarballFile Absolute path to the tarball. This parameter is required.
         *                    It is recommended to to use the script running directory (e.g. <code>__dirname</code>
         *                    in Node.js projects or dirname of <code>__file__</code> in Python) if your tarball
         *                    is located as a resource inside your project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tarballFile(java.lang.String tarballFile) {
            this.tarballFile = tarballFile;
            return this;
        }

        /**
         * Sets the value of {@link TarballImageAssetProps#getDisplayName}
         * @param displayName A display name for this asset.
         *                    If supplied, the display name will be used in locations where the asset
         *                    identifier is printed, like in the CLI progress information. If the same
         *                    asset is added multiple times, the display name of the first occurrence is
         *                    used.
         *                    <p>
         *                    The default is the construct path of the <code>TarballImageAsset</code> construct,
         *                    with respect to the enclosing stack. If the asset is produced by a
         *                    construct helper function (such as <code>lambda.Code.fromAssetImage()</code>), this
         *                    will look like <code>MyFunction/AssetImage</code>.
         *                    <p>
         *                    We use the stack-relative construct path so that in the common case where
         *                    you have multiple stacks with the same asset, we won't show something like
         *                    <code>/MyBetaStack/MyFunction/Code</code> when you are actually deploying to
         *                    production.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(java.lang.String displayName) {
            this.displayName = displayName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link TarballImageAssetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public TarballImageAssetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link TarballImageAssetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TarballImageAssetProps {
        private final java.lang.String tarballFile;
        private final java.lang.String displayName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.tarballFile = software.amazon.jsii.Kernel.get(this, "tarballFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.tarballFile = java.util.Objects.requireNonNull(builder.tarballFile, "tarballFile is required");
            this.displayName = builder.displayName;
        }

        @Override
        public final java.lang.String getTarballFile() {
            return this.tarballFile;
        }

        @Override
        public final java.lang.String getDisplayName() {
            return this.displayName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("tarballFile", om.valueToTree(this.getTarballFile()));
            if (this.getDisplayName() != null) {
                data.set("displayName", om.valueToTree(this.getDisplayName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecr_assets.TarballImageAssetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            TarballImageAssetProps.Jsii$Proxy that = (TarballImageAssetProps.Jsii$Proxy) o;

            if (!tarballFile.equals(that.tarballFile)) return false;
            return this.displayName != null ? this.displayName.equals(that.displayName) : that.displayName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.tarballFile.hashCode();
            result = 31 * result + (this.displayName != null ? this.displayName.hashCode() : 0);
            return result;
        }
    }
}
