package software.amazon.awscdk.services.ecs;

/**
 * Properties for defining a <code>CfnTaskDefinition</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnTaskDefinitionProps cfnTaskDefinitionProps = CfnTaskDefinitionProps.builder()
 *         .containerDefinitions(List.of(ContainerDefinitionProperty.builder()
 *                 .image("image")
 *                 .name("name")
 *                 // the properties below are optional
 *                 .command(List.of("command"))
 *                 .cpu(123)
 *                 .credentialSpecs(List.of("credentialSpecs"))
 *                 .dependsOn(List.of(ContainerDependencyProperty.builder()
 *                         .condition("condition")
 *                         .containerName("containerName")
 *                         .build()))
 *                 .disableNetworking(false)
 *                 .dnsSearchDomains(List.of("dnsSearchDomains"))
 *                 .dnsServers(List.of("dnsServers"))
 *                 .dockerLabels(Map.of(
 *                         "dockerLabelsKey", "dockerLabels"))
 *                 .dockerSecurityOptions(List.of("dockerSecurityOptions"))
 *                 .entryPoint(List.of("entryPoint"))
 *                 .environment(List.of(KeyValuePairProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .environmentFiles(List.of(EnvironmentFileProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build()))
 *                 .essential(false)
 *                 .extraHosts(List.of(HostEntryProperty.builder()
 *                         .hostname("hostname")
 *                         .ipAddress("ipAddress")
 *                         .build()))
 *                 .firelensConfiguration(FirelensConfigurationProperty.builder()
 *                         .options(Map.of(
 *                                 "optionsKey", "options"))
 *                         .type("type")
 *                         .build())
 *                 .healthCheck(HealthCheckProperty.builder()
 *                         .command(List.of("command"))
 *                         .interval(123)
 *                         .retries(123)
 *                         .startPeriod(123)
 *                         .timeout(123)
 *                         .build())
 *                 .hostname("hostname")
 *                 .interactive(false)
 *                 .links(List.of("links"))
 *                 .linuxParameters(LinuxParametersProperty.builder()
 *                         .capabilities(KernelCapabilitiesProperty.builder()
 *                                 .add(List.of("add"))
 *                                 .drop(List.of("drop"))
 *                                 .build())
 *                         .devices(List.of(DeviceProperty.builder()
 *                                 .containerPath("containerPath")
 *                                 .hostPath("hostPath")
 *                                 .permissions(List.of("permissions"))
 *                                 .build()))
 *                         .initProcessEnabled(false)
 *                         .maxSwap(123)
 *                         .sharedMemorySize(123)
 *                         .swappiness(123)
 *                         .tmpfs(List.of(TmpfsProperty.builder()
 *                                 .size(123)
 *                                 // the properties below are optional
 *                                 .containerPath("containerPath")
 *                                 .mountOptions(List.of("mountOptions"))
 *                                 .build()))
 *                         .build())
 *                 .logConfiguration(LogConfigurationProperty.builder()
 *                         .logDriver("logDriver")
 *                         // the properties below are optional
 *                         .options(Map.of(
 *                                 "optionsKey", "options"))
 *                         .secretOptions(List.of(SecretProperty.builder()
 *                                 .name("name")
 *                                 .valueFrom("valueFrom")
 *                                 .build()))
 *                         .build())
 *                 .memory(123)
 *                 .memoryReservation(123)
 *                 .mountPoints(List.of(MountPointProperty.builder()
 *                         .containerPath("containerPath")
 *                         .readOnly(false)
 *                         .sourceVolume("sourceVolume")
 *                         .build()))
 *                 .portMappings(List.of(PortMappingProperty.builder()
 *                         .appProtocol("appProtocol")
 *                         .containerPort(123)
 *                         .containerPortRange("containerPortRange")
 *                         .hostPort(123)
 *                         .name("name")
 *                         .protocol("protocol")
 *                         .build()))
 *                 .privileged(false)
 *                 .pseudoTerminal(false)
 *                 .readonlyRootFilesystem(false)
 *                 .repositoryCredentials(RepositoryCredentialsProperty.builder()
 *                         .credentialsParameter("credentialsParameter")
 *                         .build())
 *                 .resourceRequirements(List.of(ResourceRequirementProperty.builder()
 *                         .type("type")
 *                         .value("value")
 *                         .build()))
 *                 .restartPolicy(RestartPolicyProperty.builder()
 *                         .enabled(false)
 *                         .ignoredExitCodes(List.of(123))
 *                         .restartAttemptPeriod(123)
 *                         .build())
 *                 .secrets(List.of(SecretProperty.builder()
 *                         .name("name")
 *                         .valueFrom("valueFrom")
 *                         .build()))
 *                 .startTimeout(123)
 *                 .stopTimeout(123)
 *                 .systemControls(List.of(SystemControlProperty.builder()
 *                         .namespace("namespace")
 *                         .value("value")
 *                         .build()))
 *                 .ulimits(List.of(UlimitProperty.builder()
 *                         .hardLimit(123)
 *                         .name("name")
 *                         .softLimit(123)
 *                         .build()))
 *                 .user("user")
 *                 .versionConsistency("versionConsistency")
 *                 .volumesFrom(List.of(VolumeFromProperty.builder()
 *                         .readOnly(false)
 *                         .sourceContainer("sourceContainer")
 *                         .build()))
 *                 .workingDirectory("workingDirectory")
 *                 .build()))
 *         .cpu("cpu")
 *         .enableFaultInjection(false)
 *         .ephemeralStorage(EphemeralStorageProperty.builder()
 *                 .sizeInGiB(123)
 *                 .build())
 *         .executionRoleArn("executionRoleArn")
 *         .family("family")
 *         .inferenceAccelerators(List.of(InferenceAcceleratorProperty.builder()
 *                 .deviceName("deviceName")
 *                 .deviceType("deviceType")
 *                 .build()))
 *         .ipcMode("ipcMode")
 *         .memory("memory")
 *         .networkMode("networkMode")
 *         .pidMode("pidMode")
 *         .placementConstraints(List.of(TaskDefinitionPlacementConstraintProperty.builder()
 *                 .type("type")
 *                 // the properties below are optional
 *                 .expression("expression")
 *                 .build()))
 *         .proxyConfiguration(ProxyConfigurationProperty.builder()
 *                 .containerName("containerName")
 *                 // the properties below are optional
 *                 .proxyConfigurationProperties(List.of(KeyValuePairProperty.builder()
 *                         .name("name")
 *                         .value("value")
 *                         .build()))
 *                 .type("type")
 *                 .build())
 *         .requiresCompatibilities(List.of("requiresCompatibilities"))
 *         .runtimePlatform(RuntimePlatformProperty.builder()
 *                 .cpuArchitecture("cpuArchitecture")
 *                 .operatingSystemFamily("operatingSystemFamily")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .taskRoleArn("taskRoleArn")
 *         .volumes(List.of(VolumeProperty.builder()
 *                 .configuredAtLaunch(false)
 *                 .dockerVolumeConfiguration(DockerVolumeConfigurationProperty.builder()
 *                         .autoprovision(false)
 *                         .driver("driver")
 *                         .driverOpts(Map.of(
 *                                 "driverOptsKey", "driverOpts"))
 *                         .labels(Map.of(
 *                                 "labelsKey", "labels"))
 *                         .scope("scope")
 *                         .build())
 *                 .efsVolumeConfiguration(EFSVolumeConfigurationProperty.builder()
 *                         .filesystemId("filesystemId")
 *                         // the properties below are optional
 *                         .authorizationConfig(AuthorizationConfigProperty.builder()
 *                                 .accessPointId("accessPointId")
 *                                 .iam("iam")
 *                                 .build())
 *                         .rootDirectory("rootDirectory")
 *                         .transitEncryption("transitEncryption")
 *                         .transitEncryptionPort(123)
 *                         .build())
 *                 .fSxWindowsFileServerVolumeConfiguration(FSxWindowsFileServerVolumeConfigurationProperty.builder()
 *                         .fileSystemId("fileSystemId")
 *                         .rootDirectory("rootDirectory")
 *                         // the properties below are optional
 *                         .authorizationConfig(FSxAuthorizationConfigProperty.builder()
 *                                 .credentialsParameter("credentialsParameter")
 *                                 .domain("domain")
 *                                 .build())
 *                         .build())
 *                 .host(HostVolumePropertiesProperty.builder()
 *                         .sourcePath("sourcePath")
 *                         .build())
 *                 .name("name")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:16.031Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnTaskDefinitionProps")
@software.amazon.jsii.Jsii.Proxy(CfnTaskDefinitionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTaskDefinitionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of container definitions in JSON format that describe the different containers that make up your task.
     * <p>
     * For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-containerdefinitions</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getContainerDefinitions() {
        return null;
    }

    /**
     * The number of <code>cpu</code> units used by the task.
     * <p>
     * If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the <code>memory</code> parameter.
     * <p>
     * If you're using the EC2 launch type or the external launch type, this field is optional. Supported values are between <code>128</code> CPU units ( <code>0.125</code> vCPUs) and <code>196608</code> CPU units ( <code>192</code> vCPUs).
     * <p>
     * This field is required for Fargate. For information about the valid values, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size">Task size</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-cpu">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-cpu</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCpu() {
        return null;
    }

    /**
     * Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
     * <p>
     * The default value is <code>false</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-enablefaultinjection">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-enablefaultinjection</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableFaultInjection() {
        return null;
    }

    /**
     * The ephemeral storage settings to use for tasks run with the task definition.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ephemeralstorage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ephemeralstorage</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEphemeralStorage() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf.
     * <p>
     * For informationabout the required IAM roles for Amazon ECS, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security-ecs-iam-role-overview.html">IAM roles for Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-executionrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return null;
    }

    /**
     * The name of a family that this task definition is registered to.
     * <p>
     * Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
     * <p>
     * A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
     * <p>
     * <blockquote>
     * <p>
     * To use revision numbers when you update a task definition, specify this property. If you don't specify a value, AWS CloudFormation generates a new task definition each time that you update it.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-family">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-family</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFamily() {
        return null;
    }

    /**
     * The Elastic Inference accelerators to use for the containers in the task.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-inferenceaccelerators</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceAccelerators() {
        return null;
    }

    /**
     * The IPC resource namespace to use for the containers in the task.
     * <p>
     * The valid values are <code>host</code> , <code>task</code> , or <code>none</code> . If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance.
     * <p>
     * If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose.
     * <p>
     * If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <ul>
     * <li>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</li>
     * <li>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * This parameter is not supported for Windows containers or tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ipcmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-ipcmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIpcMode() {
        return null;
    }

    /**
     * The amount (in MiB) of memory used by the task.
     * <p>
     * If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a> .
     * <p>
     * If your tasks runs on AWS Fargate , this field is required. You must use one of the following values. The value you choose determines your range of valid values for the <code>cpu</code> parameter.
     * <p>
     * <ul>
     * <li>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</li>
     * <li>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</li>
     * <li>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</li>
     * <li>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</li>
     * <li>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</li>
     * <li>Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)</li>
     * </ul>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * <p>
     * <ul>
     * <li>Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)</li>
     * </ul>
     * <p>
     * This option requires Linux platform <code>1.4.0</code> or later.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-memory">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-memory</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getMemory() {
        return null;
    }

    /**
     * The Docker networking mode to use for the containers in the task.
     * <p>
     * The valid values are <code>none</code> , <code>bridge</code> , <code>awsvpc</code> , and <code>host</code> . If no network mode is specified, the default is <code>bridge</code> .
     * <p>
     * For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, <code>&lt;default&gt;</code> or <code>awsvpc</code> can be used. If the network mode is set to <code>none</code> , you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.
     * <p>
     * With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings.
     * <p>
     * <blockquote>
     * <p>
     * When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
     * <p>
     * </blockquote>
     * <p>
     * If the network mode is <code>awsvpc</code> , the task is allocated an elastic network interface, and you must specify a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html">NetworkConfiguration</a> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * If the network mode is <code>host</code> , you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-networkmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-networkmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getNetworkMode() {
        return null;
    }

    /**
     * The process namespace to use for the containers in the task.
     * <p>
     * The valid values are <code>host</code> or <code>task</code> . On Fargate for Linux containers, the only valid value is <code>task</code> . For example, monitoring sidecars might need <code>pidMode</code> to access information about other containers running in the same task.
     * <p>
     * If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
     * <p>
     * If <code>task</code> is specified, all containers within the specified task share the same process namespace.
     * <p>
     * If no value is specified, the default is a private namespace for each container.
     * <p>
     * If the <code>host</code> PID mode is used, there's a heightened risk of undesired process namespace exposure.
     * <p>
     * <blockquote>
     * <p>
     * This parameter is not supported for Windows containers. &gt; This parameter is only supported for tasks that are hosted on AWS Fargate if the tasks are using platform version <code>1.4.0</code> or later (Linux). This isn't supported for Windows containers on Fargate.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-pidmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-pidmode</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPidMode() {
        return null;
    }

    /**
     * An array of placement constraint objects to use for tasks.
     * <p>
     * <blockquote>
     * <p>
     * This parameter isn't supported for tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-placementconstraints</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPlacementConstraints() {
        return null;
    }

    /**
     * The configuration details for the App Mesh proxy.
     * <p>
     * Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version <code>20190301</code> or later, they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-proxyconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getProxyConfiguration() {
        return null;
    }

    /**
     * The task launch types the task definition was validated against.
     * <p>
     * The valid values are <code>EC2</code> , <code>FARGATE</code> , and <code>EXTERNAL</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-requirescompatibilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-requirescompatibilities</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getRequiresCompatibilities() {
        return null;
    }

    /**
     * The operating system that your tasks definitions run on.
     * <p>
     * A platform family is specified only for tasks using the Fargate launch type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-runtimeplatform">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-runtimeplatform</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimePlatform() {
        return null;
    }

    /**
     * The metadata that you apply to the task definition to help you categorize and organize them.
     * <p>
     * Each tag consists of a key and an optional value. You define both of them.
     * <p>
     * The following basic restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per resource - 50</li>
     * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
     * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
     * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS Task Role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * String validation is done on the ECS side. If an invalid string value is given for <code>TaskRoleArn</code> , it may cause the Cloudformation job to hang.
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-taskrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-taskrolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getTaskRoleArn() {
        return null;
    }

    /**
     * The list of data volume definitions for the task.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * <blockquote>
     * <p>
     * The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
     * <p>
     * </blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-taskdefinition.html#cfn-ecs-taskdefinition-volumes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getVolumes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTaskDefinitionProps> {
        java.lang.Object containerDefinitions;
        java.lang.String cpu;
        java.lang.Object enableFaultInjection;
        java.lang.Object ephemeralStorage;
        java.lang.String executionRoleArn;
        java.lang.String family;
        java.lang.Object inferenceAccelerators;
        java.lang.String ipcMode;
        java.lang.String memory;
        java.lang.String networkMode;
        java.lang.String pidMode;
        java.lang.Object placementConstraints;
        java.lang.Object proxyConfiguration;
        java.util.List<java.lang.String> requiresCompatibilities;
        java.lang.Object runtimePlatform;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String taskRoleArn;
        java.lang.Object volumes;

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getContainerDefinitions}
         * @param containerDefinitions A list of container definitions in JSON format that describe the different containers that make up your task.
         *                             For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(software.amazon.awscdk.IResolvable containerDefinitions) {
            this.containerDefinitions = containerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getContainerDefinitions}
         * @param containerDefinitions A list of container definitions in JSON format that describe the different containers that make up your task.
         *                             For more information about container definition parameters and defaults, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_defintions.html">Amazon ECS Task Definitions</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerDefinitions(java.util.List<? extends java.lang.Object> containerDefinitions) {
            this.containerDefinitions = containerDefinitions;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getCpu}
         * @param cpu The number of <code>cpu</code> units used by the task.
         *            If you use the EC2 launch type, this field is optional. Any value can be used. If you use the Fargate launch type, this field is required. You must use one of the following values. The value that you choose determines your range of valid values for the <code>memory</code> parameter.
         *            <p>
         *            If you're using the EC2 launch type or the external launch type, this field is optional. Supported values are between <code>128</code> CPU units ( <code>0.125</code> vCPUs) and <code>196608</code> CPU units ( <code>192</code> vCPUs).
         *            <p>
         *            This field is required for Fargate. For information about the valid values, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html#task_size">Task size</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(java.lang.String cpu) {
            this.cpu = cpu;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getEnableFaultInjection}
         * @param enableFaultInjection Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
         *                             The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableFaultInjection(java.lang.Boolean enableFaultInjection) {
            this.enableFaultInjection = enableFaultInjection;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getEnableFaultInjection}
         * @param enableFaultInjection Enables fault injection and allows for fault injection requests to be accepted from the task's containers.
         *                             The default value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableFaultInjection(software.amazon.awscdk.IResolvable enableFaultInjection) {
            this.enableFaultInjection = enableFaultInjection;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getEphemeralStorage}
         * @param ephemeralStorage The ephemeral storage settings to use for tasks run with the task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(software.amazon.awscdk.IResolvable ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getEphemeralStorage}
         * @param ephemeralStorage The ephemeral storage settings to use for tasks run with the task definition.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorage(software.amazon.awscdk.services.ecs.CfnTaskDefinition.EphemeralStorageProperty ephemeralStorage) {
            this.ephemeralStorage = ephemeralStorage;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getExecutionRoleArn}
         * @param executionRoleArn The Amazon Resource Name (ARN) of the task execution role that grants the Amazon ECS container agent permission to make AWS API calls on your behalf.
         *                         For informationabout the required IAM roles for Amazon ECS, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/security-ecs-iam-role-overview.html">IAM roles for Amazon ECS</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(java.lang.String executionRoleArn) {
            this.executionRoleArn = executionRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getFamily}
         * @param family The name of a family that this task definition is registered to.
         *               Up to 255 letters (uppercase and lowercase), numbers, hyphens, and underscores are allowed.
         *               <p>
         *               A family groups multiple versions of a task definition. Amazon ECS gives the first task definition that you registered to a family a revision number of 1. Amazon ECS gives sequential revision numbers to each task definition that you add.
         *               <p>
         *               <blockquote>
         *               <p>
         *               To use revision numbers when you update a task definition, specify this property. If you don't specify a value, AWS CloudFormation generates a new task definition each time that you update it.
         *               <p>
         *               </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(java.lang.String family) {
            this.family = family;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getInferenceAccelerators}
         * @param inferenceAccelerators The Elastic Inference accelerators to use for the containers in the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(software.amazon.awscdk.IResolvable inferenceAccelerators) {
            this.inferenceAccelerators = inferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getInferenceAccelerators}
         * @param inferenceAccelerators The Elastic Inference accelerators to use for the containers in the task.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceAccelerators(java.util.List<? extends java.lang.Object> inferenceAccelerators) {
            this.inferenceAccelerators = inferenceAccelerators;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getIpcMode}
         * @param ipcMode The IPC resource namespace to use for the containers in the task.
         *                The valid values are <code>host</code> , <code>task</code> , or <code>none</code> . If <code>host</code> is specified, then all containers within the tasks that specified the <code>host</code> IPC mode on the same container instance share the same IPC resources with the host Amazon EC2 instance. If <code>task</code> is specified, all containers within the specified task share the same IPC resources. If <code>none</code> is specified, then IPC resources within the containers of a task are private and not shared with other containers in a task or on the container instance. If no value is specified, then the IPC resource namespace sharing depends on the Docker daemon setting on the container instance.
         *                <p>
         *                If the <code>host</code> IPC mode is used, be aware that there is a heightened risk of undesired IPC namespace expose.
         *                <p>
         *                If you are setting namespaced kernel parameters using <code>systemControls</code> for the containers in the task, the following will apply to your IPC resource namespace. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task_definition_parameters.html">System Controls</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                <p>
         *                <ul>
         *                <li>For tasks that use the <code>host</code> IPC mode, IPC namespace related <code>systemControls</code> are not supported.</li>
         *                <li>For tasks that use the <code>task</code> IPC mode, IPC namespace related <code>systemControls</code> will apply to all containers within a task.</li>
         *                </ul>
         *                <p>
         *                <blockquote>
         *                <p>
         *                This parameter is not supported for Windows containers or tasks run on AWS Fargate .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipcMode(java.lang.String ipcMode) {
            this.ipcMode = ipcMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getMemory}
         * @param memory The amount (in MiB) of memory used by the task.
         *               If your tasks runs on Amazon EC2 instances, you must specify either a task-level memory value or a container-level memory value. This field is optional and any value can be used. If a task-level memory value is specified, the container-level memory value is optional. For more information regarding container-level memory and memory reservation, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_ContainerDefinition.html">ContainerDefinition</a> .
         *               <p>
         *               If your tasks runs on AWS Fargate , this field is required. You must use one of the following values. The value you choose determines your range of valid values for the <code>cpu</code> parameter.
         *               <p>
         *               <ul>
         *               <li>512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available <code>cpu</code> values: 256 (.25 vCPU)</li>
         *               <li>1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available <code>cpu</code> values: 512 (.5 vCPU)</li>
         *               <li>2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available <code>cpu</code> values: 1024 (1 vCPU)</li>
         *               <li>Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 2048 (2 vCPU)</li>
         *               <li>Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available <code>cpu</code> values: 4096 (4 vCPU)</li>
         *               <li>Between 16 GB and 60 GB in 4 GB increments - Available <code>cpu</code> values: 8192 (8 vCPU)</li>
         *               </ul>
         *               <p>
         *               This option requires Linux platform <code>1.4.0</code> or later.
         *               <p>
         *               <ul>
         *               <li>Between 32GB and 120 GB in 8 GB increments - Available <code>cpu</code> values: 16384 (16 vCPU)</li>
         *               </ul>
         *               <p>
         *               This option requires Linux platform <code>1.4.0</code> or later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memory(java.lang.String memory) {
            this.memory = memory;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getNetworkMode}
         * @param networkMode The Docker networking mode to use for the containers in the task.
         *                    The valid values are <code>none</code> , <code>bridge</code> , <code>awsvpc</code> , and <code>host</code> . If no network mode is specified, the default is <code>bridge</code> .
         *                    <p>
         *                    For Amazon ECS tasks on Fargate, the <code>awsvpc</code> network mode is required. For Amazon ECS tasks on Amazon EC2 Linux instances, any network mode can be used. For Amazon ECS tasks on Amazon EC2 Windows instances, <code>&lt;default&gt;</code> or <code>awsvpc</code> can be used. If the network mode is set to <code>none</code> , you cannot specify port mappings in your container definitions, and the tasks containers do not have external connectivity. The <code>host</code> and <code>awsvpc</code> network modes offer the highest networking performance for containers because they use the EC2 network stack instead of the virtualized network stack provided by the <code>bridge</code> mode.
         *                    <p>
         *                    With the <code>host</code> and <code>awsvpc</code> network modes, exposed container ports are mapped directly to the corresponding host port (for the <code>host</code> network mode) or the attached elastic network interface port (for the <code>awsvpc</code> network mode), so you cannot take advantage of dynamic host port mappings.
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    When using the <code>host</code> network mode, you should not run containers using the root user (UID 0). It is considered best practice to use a non-root user.
         *                    <p>
         *                    </blockquote>
         *                    <p>
         *                    If the network mode is <code>awsvpc</code> , the task is allocated an elastic network interface, and you must specify a <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_NetworkConfiguration.html">NetworkConfiguration</a> value when you create a service or run a task with the task definition. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html">Task Networking</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                    <p>
         *                    If the network mode is <code>host</code> , you cannot run multiple instantiations of the same task on a single container instance when port mappings are used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkMode(java.lang.String networkMode) {
            this.networkMode = networkMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getPidMode}
         * @param pidMode The process namespace to use for the containers in the task.
         *                The valid values are <code>host</code> or <code>task</code> . On Fargate for Linux containers, the only valid value is <code>task</code> . For example, monitoring sidecars might need <code>pidMode</code> to access information about other containers running in the same task.
         *                <p>
         *                If <code>host</code> is specified, all containers within the tasks that specified the <code>host</code> PID mode on the same container instance share the same process namespace with the host Amazon EC2 instance.
         *                <p>
         *                If <code>task</code> is specified, all containers within the specified task share the same process namespace.
         *                <p>
         *                If no value is specified, the default is a private namespace for each container.
         *                <p>
         *                If the <code>host</code> PID mode is used, there's a heightened risk of undesired process namespace exposure.
         *                <p>
         *                <blockquote>
         *                <p>
         *                This parameter is not supported for Windows containers. &gt; This parameter is only supported for tasks that are hosted on AWS Fargate if the tasks are using platform version <code>1.4.0</code> or later (Linux). This isn't supported for Windows containers on Fargate.
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pidMode(java.lang.String pidMode) {
            this.pidMode = pidMode;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getPlacementConstraints}
         * @param placementConstraints An array of placement constraint objects to use for tasks.
         *                             <blockquote>
         *                             <p>
         *                             This parameter isn't supported for tasks run on AWS Fargate .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(software.amazon.awscdk.IResolvable placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getPlacementConstraints}
         * @param placementConstraints An array of placement constraint objects to use for tasks.
         *                             <blockquote>
         *                             <p>
         *                             This parameter isn't supported for tasks run on AWS Fargate .
         *                             <p>
         *                             </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementConstraints(java.util.List<? extends java.lang.Object> placementConstraints) {
            this.placementConstraints = placementConstraints;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The configuration details for the App Mesh proxy.
         *                           Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version <code>20190301</code> or later, they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(software.amazon.awscdk.IResolvable proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getProxyConfiguration}
         * @param proxyConfiguration The configuration details for the App Mesh proxy.
         *                           Your Amazon ECS container instances require at least version 1.26.0 of the container agent and at least version 1.26.0-1 of the <code>ecs-init</code> package to use a proxy configuration. If your container instances are launched from the Amazon ECS optimized AMI version <code>20190301</code> or later, they contain the required versions of the container agent and <code>ecs-init</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-optimized_AMI.html">Amazon ECS-optimized Linux AMI</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxyConfiguration(software.amazon.awscdk.services.ecs.CfnTaskDefinition.ProxyConfigurationProperty proxyConfiguration) {
            this.proxyConfiguration = proxyConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getRequiresCompatibilities}
         * @param requiresCompatibilities The task launch types the task definition was validated against.
         *                                The valid values are <code>EC2</code> , <code>FARGATE</code> , and <code>EXTERNAL</code> . For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html">Amazon ECS launch types</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requiresCompatibilities(java.util.List<java.lang.String> requiresCompatibilities) {
            this.requiresCompatibilities = requiresCompatibilities;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getRuntimePlatform}
         * @param runtimePlatform The operating system that your tasks definitions run on.
         *                        A platform family is specified only for tasks using the Fargate launch type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(software.amazon.awscdk.IResolvable runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getRuntimePlatform}
         * @param runtimePlatform The operating system that your tasks definitions run on.
         *                        A platform family is specified only for tasks using the Fargate launch type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(software.amazon.awscdk.services.ecs.CfnTaskDefinition.RuntimePlatformProperty runtimePlatform) {
            this.runtimePlatform = runtimePlatform;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getTags}
         * @param tags The metadata that you apply to the task definition to help you categorize and organize them.
         *             Each tag consists of a key and an optional value. You define both of them.
         *             <p>
         *             The following basic restrictions apply to tags:
         *             <p>
         *             <ul>
         *             <li>Maximum number of tags per resource - 50</li>
         *             <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         *             <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         *             <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         *             <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getTaskRoleArn}
         * @param taskRoleArn The short name or full Amazon Resource Name (ARN) of the AWS Identity and Access Management role that grants containers in the task permission to call AWS APIs on your behalf.
         *                    For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-iam-roles.html">Amazon ECS Task Role</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                    <p>
         *                    IAM roles for tasks on Windows require that the <code>-EnableTaskIAMRole</code> option is set when you launch the Amazon ECS-optimized Windows AMI. Your containers must also run some configuration code to use the feature. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/windows_task_IAM_roles.html">Windows IAM roles for tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                    <p>
         *                    <blockquote>
         *                    <p>
         *                    String validation is done on the ECS side. If an invalid string value is given for <code>TaskRoleArn</code> , it may cause the Cloudformation job to hang.
         *                    <p>
         *                    </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskRoleArn(java.lang.String taskRoleArn) {
            this.taskRoleArn = taskRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getVolumes}
         * @param volumes The list of data volume definitions for the task.
         *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(software.amazon.awscdk.IResolvable volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Sets the value of {@link CfnTaskDefinitionProps#getVolumes}
         * @param volumes The list of data volume definitions for the task.
         *                For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_data_volumes.html">Using data volumes in tasks</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         *                <p>
         *                <blockquote>
         *                <p>
         *                The <code>host</code> and <code>sourcePath</code> parameters aren't supported for tasks run on AWS Fargate .
         *                <p>
         *                </blockquote>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumes(java.util.List<? extends java.lang.Object> volumes) {
            this.volumes = volumes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTaskDefinitionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTaskDefinitionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTaskDefinitionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTaskDefinitionProps {
        private final java.lang.Object containerDefinitions;
        private final java.lang.String cpu;
        private final java.lang.Object enableFaultInjection;
        private final java.lang.Object ephemeralStorage;
        private final java.lang.String executionRoleArn;
        private final java.lang.String family;
        private final java.lang.Object inferenceAccelerators;
        private final java.lang.String ipcMode;
        private final java.lang.String memory;
        private final java.lang.String networkMode;
        private final java.lang.String pidMode;
        private final java.lang.Object placementConstraints;
        private final java.lang.Object proxyConfiguration;
        private final java.util.List<java.lang.String> requiresCompatibilities;
        private final java.lang.Object runtimePlatform;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String taskRoleArn;
        private final java.lang.Object volumes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.containerDefinitions = software.amazon.jsii.Kernel.get(this, "containerDefinitions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.cpu = software.amazon.jsii.Kernel.get(this, "cpu", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.enableFaultInjection = software.amazon.jsii.Kernel.get(this, "enableFaultInjection", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ephemeralStorage = software.amazon.jsii.Kernel.get(this, "ephemeralStorage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.executionRoleArn = software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.family = software.amazon.jsii.Kernel.get(this, "family", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inferenceAccelerators = software.amazon.jsii.Kernel.get(this, "inferenceAccelerators", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.ipcMode = software.amazon.jsii.Kernel.get(this, "ipcMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.memory = software.amazon.jsii.Kernel.get(this, "memory", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.networkMode = software.amazon.jsii.Kernel.get(this, "networkMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pidMode = software.amazon.jsii.Kernel.get(this, "pidMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.placementConstraints = software.amazon.jsii.Kernel.get(this, "placementConstraints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.proxyConfiguration = software.amazon.jsii.Kernel.get(this, "proxyConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.requiresCompatibilities = software.amazon.jsii.Kernel.get(this, "requiresCompatibilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.runtimePlatform = software.amazon.jsii.Kernel.get(this, "runtimePlatform", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.taskRoleArn = software.amazon.jsii.Kernel.get(this, "taskRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.volumes = software.amazon.jsii.Kernel.get(this, "volumes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.containerDefinitions = builder.containerDefinitions;
            this.cpu = builder.cpu;
            this.enableFaultInjection = builder.enableFaultInjection;
            this.ephemeralStorage = builder.ephemeralStorage;
            this.executionRoleArn = builder.executionRoleArn;
            this.family = builder.family;
            this.inferenceAccelerators = builder.inferenceAccelerators;
            this.ipcMode = builder.ipcMode;
            this.memory = builder.memory;
            this.networkMode = builder.networkMode;
            this.pidMode = builder.pidMode;
            this.placementConstraints = builder.placementConstraints;
            this.proxyConfiguration = builder.proxyConfiguration;
            this.requiresCompatibilities = builder.requiresCompatibilities;
            this.runtimePlatform = builder.runtimePlatform;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.taskRoleArn = builder.taskRoleArn;
            this.volumes = builder.volumes;
        }

        @Override
        public final java.lang.Object getContainerDefinitions() {
            return this.containerDefinitions;
        }

        @Override
        public final java.lang.String getCpu() {
            return this.cpu;
        }

        @Override
        public final java.lang.Object getEnableFaultInjection() {
            return this.enableFaultInjection;
        }

        @Override
        public final java.lang.Object getEphemeralStorage() {
            return this.ephemeralStorage;
        }

        @Override
        public final java.lang.String getExecutionRoleArn() {
            return this.executionRoleArn;
        }

        @Override
        public final java.lang.String getFamily() {
            return this.family;
        }

        @Override
        public final java.lang.Object getInferenceAccelerators() {
            return this.inferenceAccelerators;
        }

        @Override
        public final java.lang.String getIpcMode() {
            return this.ipcMode;
        }

        @Override
        public final java.lang.String getMemory() {
            return this.memory;
        }

        @Override
        public final java.lang.String getNetworkMode() {
            return this.networkMode;
        }

        @Override
        public final java.lang.String getPidMode() {
            return this.pidMode;
        }

        @Override
        public final java.lang.Object getPlacementConstraints() {
            return this.placementConstraints;
        }

        @Override
        public final java.lang.Object getProxyConfiguration() {
            return this.proxyConfiguration;
        }

        @Override
        public final java.util.List<java.lang.String> getRequiresCompatibilities() {
            return this.requiresCompatibilities;
        }

        @Override
        public final java.lang.Object getRuntimePlatform() {
            return this.runtimePlatform;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getTaskRoleArn() {
            return this.taskRoleArn;
        }

        @Override
        public final java.lang.Object getVolumes() {
            return this.volumes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getContainerDefinitions() != null) {
                data.set("containerDefinitions", om.valueToTree(this.getContainerDefinitions()));
            }
            if (this.getCpu() != null) {
                data.set("cpu", om.valueToTree(this.getCpu()));
            }
            if (this.getEnableFaultInjection() != null) {
                data.set("enableFaultInjection", om.valueToTree(this.getEnableFaultInjection()));
            }
            if (this.getEphemeralStorage() != null) {
                data.set("ephemeralStorage", om.valueToTree(this.getEphemeralStorage()));
            }
            if (this.getExecutionRoleArn() != null) {
                data.set("executionRoleArn", om.valueToTree(this.getExecutionRoleArn()));
            }
            if (this.getFamily() != null) {
                data.set("family", om.valueToTree(this.getFamily()));
            }
            if (this.getInferenceAccelerators() != null) {
                data.set("inferenceAccelerators", om.valueToTree(this.getInferenceAccelerators()));
            }
            if (this.getIpcMode() != null) {
                data.set("ipcMode", om.valueToTree(this.getIpcMode()));
            }
            if (this.getMemory() != null) {
                data.set("memory", om.valueToTree(this.getMemory()));
            }
            if (this.getNetworkMode() != null) {
                data.set("networkMode", om.valueToTree(this.getNetworkMode()));
            }
            if (this.getPidMode() != null) {
                data.set("pidMode", om.valueToTree(this.getPidMode()));
            }
            if (this.getPlacementConstraints() != null) {
                data.set("placementConstraints", om.valueToTree(this.getPlacementConstraints()));
            }
            if (this.getProxyConfiguration() != null) {
                data.set("proxyConfiguration", om.valueToTree(this.getProxyConfiguration()));
            }
            if (this.getRequiresCompatibilities() != null) {
                data.set("requiresCompatibilities", om.valueToTree(this.getRequiresCompatibilities()));
            }
            if (this.getRuntimePlatform() != null) {
                data.set("runtimePlatform", om.valueToTree(this.getRuntimePlatform()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTaskRoleArn() != null) {
                data.set("taskRoleArn", om.valueToTree(this.getTaskRoleArn()));
            }
            if (this.getVolumes() != null) {
                data.set("volumes", om.valueToTree(this.getVolumes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnTaskDefinitionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTaskDefinitionProps.Jsii$Proxy that = (CfnTaskDefinitionProps.Jsii$Proxy) o;

            if (this.containerDefinitions != null ? !this.containerDefinitions.equals(that.containerDefinitions) : that.containerDefinitions != null) return false;
            if (this.cpu != null ? !this.cpu.equals(that.cpu) : that.cpu != null) return false;
            if (this.enableFaultInjection != null ? !this.enableFaultInjection.equals(that.enableFaultInjection) : that.enableFaultInjection != null) return false;
            if (this.ephemeralStorage != null ? !this.ephemeralStorage.equals(that.ephemeralStorage) : that.ephemeralStorage != null) return false;
            if (this.executionRoleArn != null ? !this.executionRoleArn.equals(that.executionRoleArn) : that.executionRoleArn != null) return false;
            if (this.family != null ? !this.family.equals(that.family) : that.family != null) return false;
            if (this.inferenceAccelerators != null ? !this.inferenceAccelerators.equals(that.inferenceAccelerators) : that.inferenceAccelerators != null) return false;
            if (this.ipcMode != null ? !this.ipcMode.equals(that.ipcMode) : that.ipcMode != null) return false;
            if (this.memory != null ? !this.memory.equals(that.memory) : that.memory != null) return false;
            if (this.networkMode != null ? !this.networkMode.equals(that.networkMode) : that.networkMode != null) return false;
            if (this.pidMode != null ? !this.pidMode.equals(that.pidMode) : that.pidMode != null) return false;
            if (this.placementConstraints != null ? !this.placementConstraints.equals(that.placementConstraints) : that.placementConstraints != null) return false;
            if (this.proxyConfiguration != null ? !this.proxyConfiguration.equals(that.proxyConfiguration) : that.proxyConfiguration != null) return false;
            if (this.requiresCompatibilities != null ? !this.requiresCompatibilities.equals(that.requiresCompatibilities) : that.requiresCompatibilities != null) return false;
            if (this.runtimePlatform != null ? !this.runtimePlatform.equals(that.runtimePlatform) : that.runtimePlatform != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.taskRoleArn != null ? !this.taskRoleArn.equals(that.taskRoleArn) : that.taskRoleArn != null) return false;
            return this.volumes != null ? this.volumes.equals(that.volumes) : that.volumes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.containerDefinitions != null ? this.containerDefinitions.hashCode() : 0;
            result = 31 * result + (this.cpu != null ? this.cpu.hashCode() : 0);
            result = 31 * result + (this.enableFaultInjection != null ? this.enableFaultInjection.hashCode() : 0);
            result = 31 * result + (this.ephemeralStorage != null ? this.ephemeralStorage.hashCode() : 0);
            result = 31 * result + (this.executionRoleArn != null ? this.executionRoleArn.hashCode() : 0);
            result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
            result = 31 * result + (this.inferenceAccelerators != null ? this.inferenceAccelerators.hashCode() : 0);
            result = 31 * result + (this.ipcMode != null ? this.ipcMode.hashCode() : 0);
            result = 31 * result + (this.memory != null ? this.memory.hashCode() : 0);
            result = 31 * result + (this.networkMode != null ? this.networkMode.hashCode() : 0);
            result = 31 * result + (this.pidMode != null ? this.pidMode.hashCode() : 0);
            result = 31 * result + (this.placementConstraints != null ? this.placementConstraints.hashCode() : 0);
            result = 31 * result + (this.proxyConfiguration != null ? this.proxyConfiguration.hashCode() : 0);
            result = 31 * result + (this.requiresCompatibilities != null ? this.requiresCompatibilities.hashCode() : 0);
            result = 31 * result + (this.runtimePlatform != null ? this.runtimePlatform.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.taskRoleArn != null ? this.taskRoleArn.hashCode() : 0);
            result = 31 * result + (this.volumes != null ? this.volumes.hashCode() : 0);
            return result;
        }
    }
}
