package software.amazon.awscdk.services.ecs;

/**
 * Construct a Linux or Windows machine image from the latest ECS Optimized AMI published in SSM.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .vpc(vpc)
 *         .build();
 * // Either add default capacity
 * cluster.addCapacity("DefaultAutoScalingGroupCapacity", AddCapacityOptions.builder()
 *         .instanceType(new InstanceType("t2.xlarge"))
 *         .desiredCapacity(3)
 *         .build());
 * // Or add customized capacity. Be sure to start the Amazon ECS-optimized AMI.
 * AutoScalingGroup autoScalingGroup = AutoScalingGroup.Builder.create(this, "ASG")
 *         .vpc(vpc)
 *         .instanceType(new InstanceType("t2.xlarge"))
 *         .machineImage(EcsOptimizedImage.amazonLinux())
 *         // Or use Amazon ECS-Optimized Amazon Linux 2 AMI
 *         // machineImage: EcsOptimizedImage.amazonLinux2(),
 *         .desiredCapacity(3)
 *         .build();
 * AsgCapacityProvider capacityProvider = AsgCapacityProvider.Builder.create(this, "AsgCapacityProvider")
 *         .autoScalingGroup(autoScalingGroup)
 *         .build();
 * cluster.addAsgCapacityProvider(capacityProvider);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:16.088Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.EcsOptimizedImage")
public class EcsOptimizedImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.ec2.IMachineImage {

    protected EcsOptimizedImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsOptimizedImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Construct an Amazon Linux AMI image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.EcsOptimizedImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { options });
    }

    /**
     * Construct an Amazon Linux AMI image from the latest ECS Optimized AMI published in SSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class));
    }

    /**
     * Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param hardwareType ECS-optimized AMI variant to use.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AmiHardwareType hardwareType, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.EcsOptimizedImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { hardwareType, options });
    }

    /**
     * Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param hardwareType ECS-optimized AMI variant to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AmiHardwareType hardwareType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { hardwareType });
    }

    /**
     * Construct an Amazon Linux 2 image from the latest ECS Optimized AMI published in SSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class));
    }

    /**
     * Construct an Amazon Linux 2023 image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param hardwareType ECS-optimized AMI variant to use.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2023(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AmiHardwareType hardwareType, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.EcsOptimizedImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2023", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { hardwareType, options });
    }

    /**
     * Construct an Amazon Linux 2023 image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param hardwareType ECS-optimized AMI variant to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2023(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.AmiHardwareType hardwareType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2023", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { hardwareType });
    }

    /**
     * Construct an Amazon Linux 2023 image from the latest ECS Optimized AMI published in SSM.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage amazonLinux2023() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "amazonLinux2023", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class));
    }

    /**
     * Construct a Windows image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param windowsVersion Windows Version to use. This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage windows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.WindowsOptimizedVersion windowsVersion, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.EcsOptimizedImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "windows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { java.util.Objects.requireNonNull(windowsVersion, "windowsVersion is required"), options });
    }

    /**
     * Construct a Windows image from the latest ECS Optimized AMI published in SSM.
     * <p>
     * @param windowsVersion Windows Version to use. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.EcsOptimizedImage windows(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.WindowsOptimizedVersion windowsVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class, "windows", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.EcsOptimizedImage.class), new Object[] { java.util.Objects.requireNonNull(windowsVersion, "windowsVersion is required") });
    }

    /**
     * Return the correct image.
     * <p>
     * @param scope This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.MachineImageConfig getImage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope) {
        return software.amazon.jsii.Kernel.call(this, "getImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.MachineImageConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required") });
    }
}
