package software.amazon.awscdk.services.ecs;

/**
 * A log driver that sends logs to the specified driver.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Create a Task Definition for the container to start
 * Ec2TaskDefinition taskDefinition = new Ec2TaskDefinition(this, "TaskDef");
 * taskDefinition.addContainer("TheContainer", ContainerDefinitionOptions.builder()
 *         .image(ContainerImage.fromRegistry("example-image"))
 *         .memoryLimitMiB(256)
 *         .logging(GenericLogDriver.Builder.create()
 *                 .logDriver("fluentd")
 *                 .options(Map.of(
 *                         "tag", "example-tag"))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:16.132Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.GenericLogDriver")
public class GenericLogDriver extends software.amazon.awscdk.services.ecs.LogDriver {

    protected GenericLogDriver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GenericLogDriver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the GenericLogDriver class.
     * <p>
     * @param props the generic log driver configuration options. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GenericLogDriver(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.GenericLogDriverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Called when the log driver is configured on a container.
     * <p>
     * @param _scope This parameter is required.
     * @param _containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriverConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition _containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_containerDefinition, "_containerDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.GenericLogDriver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.GenericLogDriver> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.ecs.GenericLogDriverProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.ecs.GenericLogDriverProps.Builder();
        }

        /**
         * The log driver to use for the container.
         * <p>
         * The valid values listed for this parameter are log drivers
         * that the Amazon ECS container agent can communicate with by default.
         * <p>
         * For tasks using the Fargate launch type, the supported log drivers are awslogs and splunk.
         * For tasks using the EC2 launch type, the supported log drivers are awslogs, syslog, gelf, fluentd, splunk, journald, and json-file.
         * <p>
         * For more information about using the awslogs log driver, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/using_awslogs.html">Using the awslogs Log Driver</a>
         * in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * @return {@code this}
         * @param logDriver The log driver to use for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(final java.lang.String logDriver) {
            this.props.logDriver(logDriver);
            return this;
        }

        /**
         * The configuration options to send to the log driver.
         * <p>
         * Default: - the log driver options.
         * <p>
         * @return {@code this}
         * @param options The configuration options to send to the log driver. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(final java.util.Map<java.lang.String, java.lang.String> options) {
            this.props.options(options);
            return this;
        }

        /**
         * The secrets to pass to the log configuration.
         * <p>
         * Default: - no secret options provided.
         * <p>
         * @return {@code this}
         * @param secretOptions The secrets to pass to the log configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretOptions(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secretOptions) {
            this.props.secretOptions(secretOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.GenericLogDriver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.GenericLogDriver build() {
            return new software.amazon.awscdk.services.ecs.GenericLogDriver(
                this.props.build()
            );
        }
    }
}
