package software.amazon.awscdk.services.eks;

/**
 * EKS cluster logging types.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.cdk.lambdalayer.kubectl.v33.KubectlV33Layer;
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         // ...
 *         .version(KubernetesVersion.V1_33)
 *         .clusterLogging(List.of(ClusterLoggingTypes.API, ClusterLoggingTypes.AUTHENTICATOR, ClusterLoggingTypes.SCHEDULER))
 *         .kubectlLayer(new KubectlV33Layer(this, "kubectl"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:16.484Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.ClusterLoggingTypes")
public enum ClusterLoggingTypes {
    /**
     * Logs pertaining to API requests to the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API,
    /**
     * Logs pertaining to cluster access via the Kubernetes API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUDIT,
    /**
     * Logs pertaining to authentication requests into the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AUTHENTICATOR,
    /**
     * Logs pertaining to state of cluster controllers.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CONTROLLER_MANAGER,
    /**
     * Logs pertaining to scheduling decisions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SCHEDULER,
}
