package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Define an ApplicationListener.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.autoscaling.AutoScalingGroup;
 * AutoScalingGroup asg;
 * Vpc vpc;
 * // Create the load balancer in a VPC. 'internetFacing' is 'false'
 * // by default, which creates an internal load balancer.
 * ApplicationLoadBalancer lb = ApplicationLoadBalancer.Builder.create(this, "LB")
 *         .vpc(vpc)
 *         .internetFacing(true)
 *         .build();
 * // Add a listener and open up the load balancer's security group
 * // to the world.
 * ApplicationListener listener = lb.addListener("Listener", BaseApplicationListenerProps.builder()
 *         .port(80)
 *         // 'open: true' is the default, you can leave it out if you want. Set it
 *         // to 'false' and use `listener.connections` if you want to be selective
 *         // about who can access the load balancer.
 *         .open(true)
 *         .build());
 * // Create an AutoScaling group and add it as a load balancing
 * // target to the listener.
 * listener.addTargets("ApplicationFleet", AddApplicationTargetsProps.builder()
 *         .port(8080)
 *         .targets(List.of(asg))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:16.674Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListener")
public class ApplicationListener extends software.amazon.awscdk.services.elasticloadbalancingv2.BaseListener implements software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener {

    protected ApplicationListener(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ApplicationListener(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ApplicationListener(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing listener.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener fromApplicationListenerAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class, "fromApplicationListenerAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Look up an ApplicationListener.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener fromLookup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerLookupOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener.class, "fromLookup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Perform the given default action on incoming requests.
     * <p>
     * This allows full control of the default action of the load balancer,
     * including Action chaining, fixed responses and redirect responses. See
     * the <code>ListenerAction</code> class for all options.
     * <p>
     * It's possible to add routing conditions to the Action added in this way.
     * At least one Action must be added without conditions (which becomes the
     * default Action).
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addAction(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationActionProps props) {
        software.amazon.jsii.Kernel.call(this, "addAction", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Add one or more certificates to this listener.
     * <p>
     * After the first certificate, this creates ApplicationListenerCertificates
     * resources since cloudformation requires the certificates array on the
     * listener resource to have a length of 1.
     * <p>
     * @param id This parameter is required.
     * @param certificates This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addCertificates(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
        software.amazon.jsii.Kernel.call(this, "addCertificates", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(certificates, "certificates is required") });
    }

    /**
     * Load balance incoming requests to the given target groups.
     * <p>
     * All target groups will be load balanced to with equal weight and without
     * stickiness. For a more complex configuration than that, use <code>addAction()</code>.
     * <p>
     * It's possible to add routing conditions to the TargetGroups added in this
     * way. At least one TargetGroup must be added without conditions (which will
     * become the default Action for this listener).
     * <p>
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addTargetGroups(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetGroupsProps props) {
        software.amazon.jsii.Kernel.call(this, "addTargetGroups", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Load balance incoming requests to the given load balancing targets.
     * <p>
     * This method implicitly creates an ApplicationTargetGroup for the targets
     * involved, and a 'forward' action to route traffic to the given TargetGroup.
     * <p>
     * If you want more control over the precise setup, create the TargetGroup
     * and use <code>addAction</code> yourself.
     * <p>
     * It's possible to add conditions to the targets added in this way. At least
     * one set of targets must be added without conditions.
     * <p>
     * @return The newly created target group
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup addTargets(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.AddApplicationTargetsProps props) {
        return software.amazon.jsii.Kernel.call(this, "addTargets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationTargetGroup.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Register that a connectable that has been added to this load balancer.
     * <p>
     * Don't call this directly. It is called by ApplicationTargetGroup.
     * <p>
     * @param connectable This parameter is required.
     * @param portRange This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void registerConnectable(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IConnectable connectable, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Port portRange) {
        software.amazon.jsii.Kernel.call(this, "registerConnectable", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(connectable, "connectable is required"), java.util.Objects.requireNonNull(portRange, "portRange is required") });
    }

    /**
     * Validate this listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateListener() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateListener", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Manage connections to this ApplicationListener.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.Connections getConnections() {
        return software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.Connections.class));
    }

    /**
     * Load balancer this listener is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer getLoadBalancer() {
        return software.amazon.jsii.Kernel.get(this, "loadBalancer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer.class));
    }

    /**
     * The port of the listener.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListenerProps.Builder();
        }

        /**
         * Certificate list of ACM cert ARNs.
         * <p>
         * You must provide exactly one certificate if the listener protocol is HTTPS or TLS.
         * <p>
         * Default: - No certificates.
         * <p>
         * @return {@code this}
         * @param certificates Certificate list of ACM cert ARNs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificates(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IListenerCertificate> certificates) {
            this.props.certificates(certificates);
            return this;
        }

        /**
         * Default action to take for requests to this listener.
         * <p>
         * This allows full control of the default action of the load balancer,
         * including Action chaining, fixed responses and redirect responses.
         * <p>
         * See the <code>ListenerAction</code> class for all options.
         * <p>
         * Cannot be specified together with <code>defaultTargetGroups</code>.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param defaultAction Default action to take for requests to this listener. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultAction(final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction defaultAction) {
            this.props.defaultAction(defaultAction);
            return this;
        }

        /**
         * Default target groups to load balance to.
         * <p>
         * All target groups will be load balanced to with equal weight and without
         * stickiness. For a more complex configuration than that, use
         * either <code>defaultAction</code> or <code>addAction()</code>.
         * <p>
         * Cannot be specified together with <code>defaultAction</code>.
         * <p>
         * Default: - None.
         * <p>
         * @return {@code this}
         * @param defaultTargetGroups Default target groups to load balance to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultTargetGroups(final java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> defaultTargetGroups) {
            this.props.defaultTargetGroups(defaultTargetGroups);
            return this;
        }

        /**
         * The mutual authentication configuration information.
         * <p>
         * Default: - No mutual authentication configuration
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/elasticloadbalancing/latest/application/mutual-authentication.html">https://docs.aws.amazon.com/elasticloadbalancing/latest/application/mutual-authentication.html</a>
         * @param mutualAuthentication The mutual authentication configuration information. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mutualAuthentication(final software.amazon.awscdk.services.elasticloadbalancingv2.MutualAuthentication mutualAuthentication) {
            this.props.mutualAuthentication(mutualAuthentication);
            return this;
        }

        /**
         * Allow anyone to connect to the load balancer on the listener port.
         * <p>
         * If this is specified, the load balancer will be opened up to anyone who can reach it.
         * For internal load balancers this is anyone in the same VPC. For public load
         * balancers, this is anyone on the internet.
         * <p>
         * If you want to be more selective about who can access this load
         * balancer, set this to <code>false</code> and use the listener's <code>connections</code>
         * object to selectively grant access to the load balancer on the listener port.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param open Allow anyone to connect to the load balancer on the listener port. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder open(final java.lang.Boolean open) {
            this.props.open(open);
            return this;
        }

        /**
         * The port on which the listener listens for requests.
         * <p>
         * Default: - Determined from protocol if known.
         * <p>
         * @return {@code this}
         * @param port The port on which the listener listens for requests. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * The protocol to use.
         * <p>
         * Default: - Determined from port if known.
         * <p>
         * @return {@code this}
         * @param protocol The protocol to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder protocol(final software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationProtocol protocol) {
            this.props.protocol(protocol);
            return this;
        }

        /**
         * The security policy that defines which ciphers and protocols are supported.
         * <p>
         * Default: - The current predefined security policy.
         * <p>
         * @return {@code this}
         * @param sslPolicy The security policy that defines which ciphers and protocols are supported. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sslPolicy(final software.amazon.awscdk.services.elasticloadbalancingv2.SslPolicy sslPolicy) {
            this.props.sslPolicy(sslPolicy);
            return this;
        }

        /**
         * The load balancer to attach this listener to.
         * <p>
         * @return {@code this}
         * @param loadBalancer The load balancer to attach this listener to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loadBalancer(final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationLoadBalancer loadBalancer) {
            this.props.loadBalancer(loadBalancer);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener build() {
            return new software.amazon.awscdk.services.elasticloadbalancingv2.ApplicationListener(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
