package software.amazon.awscdk.services.elasticloadbalancingv2;

/**
 * Properties for defining a listener rule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * ApplicationListener applicationListener;
 * ApplicationTargetGroup applicationTargetGroup;
 * ListenerAction listenerAction;
 * ListenerCondition listenerCondition;
 * ApplicationListenerRuleProps applicationListenerRuleProps = ApplicationListenerRuleProps.builder()
 *         .listener(applicationListener)
 *         .priority(123)
 *         // the properties below are optional
 *         .action(listenerAction)
 *         .conditions(List.of(listenerCondition))
 *         .targetGroups(List.of(applicationTargetGroup))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:16.679Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListenerRuleProps")
@software.amazon.jsii.Jsii.Proxy(ApplicationListenerRuleProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApplicationListenerRuleProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.elasticloadbalancingv2.BaseApplicationListenerRuleProps {

    /**
     * The listener to attach the rule to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener();

    /**
     * @return a {@link Builder} of {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApplicationListenerRuleProps> {
        software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        java.lang.Number priority;
        software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getListener}
         * @param listener The listener to attach the rule to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder listener(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener) {
            this.listener = listener;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getPriority}
         * @param priority Priority of the rule. This parameter is required.
         *                 The rule with the lowest priority will be used for every request.
         *                 <p>
         *                 Priorities must be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(java.lang.Number priority) {
            this.priority = priority;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getAction}
         * @param action Action to perform when requests are received.
         *               Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getConditions}
         * @param conditions Rule applies if matches the conditions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder conditions(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions) {
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)conditions;
            return this;
        }

        /**
         * Sets the value of {@link ApplicationListenerRuleProps#getTargetGroups}
         * @param targetGroups Target groups to forward requests to.
         *                     Only one of <code>action</code>, <code>fixedResponse</code>, <code>redirectResponse</code> or <code>targetGroups</code> can be specified.
         *                     <p>
         *                     Implies a <code>forward</code> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder targetGroups(java.util.List<? extends software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups) {
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)targetGroups;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApplicationListenerRuleProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApplicationListenerRuleProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApplicationListenerRuleProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApplicationListenerRuleProps {
        private final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener listener;
        private final java.lang.Number priority;
        private final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction action;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> conditions;
        private final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> targetGroups;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.listener = software.amazon.jsii.Kernel.get(this, "listener", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener.class));
            this.priority = software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.action = software.amazon.jsii.Kernel.get(this, "action", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction.class));
            this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition.class)));
            this.targetGroups = software.amazon.jsii.Kernel.get(this, "targetGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.listener = java.util.Objects.requireNonNull(builder.listener, "listener is required");
            this.priority = java.util.Objects.requireNonNull(builder.priority, "priority is required");
            this.action = builder.action;
            this.conditions = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition>)builder.conditions;
            this.targetGroups = (java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup>)builder.targetGroups;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationListener getListener() {
            return this.listener;
        }

        @Override
        public final java.lang.Number getPriority() {
            return this.priority;
        }

        @Override
        public final software.amazon.awscdk.services.elasticloadbalancingv2.ListenerAction getAction() {
            return this.action;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.ListenerCondition> getConditions() {
            return this.conditions;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.elasticloadbalancingv2.IApplicationTargetGroup> getTargetGroups() {
            return this.targetGroups;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("listener", om.valueToTree(this.getListener()));
            data.set("priority", om.valueToTree(this.getPriority()));
            if (this.getAction() != null) {
                data.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getConditions() != null) {
                data.set("conditions", om.valueToTree(this.getConditions()));
            }
            if (this.getTargetGroups() != null) {
                data.set("targetGroups", om.valueToTree(this.getTargetGroups()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationListenerRuleProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApplicationListenerRuleProps.Jsii$Proxy that = (ApplicationListenerRuleProps.Jsii$Proxy) o;

            if (!listener.equals(that.listener)) return false;
            if (!priority.equals(that.priority)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) return false;
            return this.targetGroups != null ? this.targetGroups.equals(that.targetGroups) : that.targetGroups == null;
        }

        @Override
        public final int hashCode() {
            int result = this.listener.hashCode();
            result = 31 * result + (this.priority.hashCode());
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.conditions != null ? this.conditions.hashCode() : 0);
            result = 31 * result + (this.targetGroups != null ? this.targetGroups.hashCode() : 0);
            return result;
        }
    }
}
