package software.amazon.awscdk.services.events.targets;

/**
 * Customize the CloudWatch LogGroup Event Target.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * LogGroup logGroup;
 * Rule rule;
 * rule.addTarget(CloudWatchLogGroup.Builder.create(logGroup)
 *         .logEvent(LogGroupTargetInput.fromObjectV2(LogGroupTargetInputOptions.builder()
 *                 .message(JSON.stringify(Map.of(
 *                         "CustomField", "CustomValue")))
 *                 .build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:17.158Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_events_targets.LogGroupProps")
@software.amazon.jsii.Jsii.Proxy(LogGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LogGroupProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.events.targets.TargetBaseProps {

    /**
     * (deprecated) The event to send to the CloudWatch LogGroup.
     * <p>
     * This will be the event logged into the CloudWatch LogGroup
     * <p>
     * Default: - the entire EventBridge event
     * <p>
     * @deprecated use logEvent instead
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
        return null;
    }

    /**
     * Whether the custom resource created wll default to install latest AWS SDK.
     * <p>
     * Default: - install latest AWS SDK
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInstallLatestAwsSdk() {
        return null;
    }

    /**
     * The event to send to the CloudWatch LogGroup.
     * <p>
     * This will be the event logged into the CloudWatch LogGroup
     * <p>
     * Default: - the entire EventBridge event
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.events.targets.LogGroupTargetInput getLogEvent() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LogGroupProps> {
        software.amazon.awscdk.services.events.RuleTargetInput event;
        java.lang.Boolean installLatestAwsSdk;
        software.amazon.awscdk.services.events.targets.LogGroupTargetInput logEvent;
        software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        software.amazon.awscdk.Duration maxEventAge;
        java.lang.Number retryAttempts;

        /**
         * Sets the value of {@link LogGroupProps#getEvent}
         * @param event The event to send to the CloudWatch LogGroup.
         *              This will be the event logged into the CloudWatch LogGroup
         * @return {@code this}
         * @deprecated use logEvent instead
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder event(software.amazon.awscdk.services.events.RuleTargetInput event) {
            this.event = event;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getInstallLatestAwsSdk}
         * @param installLatestAwsSdk Whether the custom resource created wll default to install latest AWS SDK.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installLatestAwsSdk(java.lang.Boolean installLatestAwsSdk) {
            this.installLatestAwsSdk = installLatestAwsSdk;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getLogEvent}
         * @param logEvent The event to send to the CloudWatch LogGroup.
         *                 This will be the event logged into the CloudWatch LogGroup
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logEvent(software.amazon.awscdk.services.events.targets.LogGroupTargetInput logEvent) {
            this.logEvent = logEvent;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getDeadLetterQueue}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. Check out the <a href="https://docs.aws.amazon.com/eventbridge/latest/userguide/rule-dlq.html#dlq-considerations">considerations for using a dead-letter queue</a>.
         *                        The events not successfully delivered are automatically retried for a specified period of time,
         *                        depending on the retry policy of the target.
         *                        If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.deadLetterQueue = deadLetterQueue;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getMaxEventAge}
         * @param maxEventAge The maximum age of a request that Lambda sends to a function for processing.
         *                    Minimum value of 60.
         *                    Maximum value of 86400.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(software.amazon.awscdk.Duration maxEventAge) {
            this.maxEventAge = maxEventAge;
            return this;
        }

        /**
         * Sets the value of {@link LogGroupProps#getRetryAttempts}
         * @param retryAttempts The maximum number of times to retry when the function returns an error.
         *                      Minimum value of 0.
         *                      Maximum value of 185.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(java.lang.Number retryAttempts) {
            this.retryAttempts = retryAttempts;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LogGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LogGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link LogGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogGroupProps {
        private final software.amazon.awscdk.services.events.RuleTargetInput event;
        private final java.lang.Boolean installLatestAwsSdk;
        private final software.amazon.awscdk.services.events.targets.LogGroupTargetInput logEvent;
        private final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue;
        private final software.amazon.awscdk.Duration maxEventAge;
        private final java.lang.Number retryAttempts;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.event = software.amazon.jsii.Kernel.get(this, "event", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.RuleTargetInput.class));
            this.installLatestAwsSdk = software.amazon.jsii.Kernel.get(this, "installLatestAwsSdk", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logEvent = software.amazon.jsii.Kernel.get(this, "logEvent", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.targets.LogGroupTargetInput.class));
            this.deadLetterQueue = software.amazon.jsii.Kernel.get(this, "deadLetterQueue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class));
            this.maxEventAge = software.amazon.jsii.Kernel.get(this, "maxEventAge", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.retryAttempts = software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.event = builder.event;
            this.installLatestAwsSdk = builder.installLatestAwsSdk;
            this.logEvent = builder.logEvent;
            this.deadLetterQueue = builder.deadLetterQueue;
            this.maxEventAge = builder.maxEventAge;
            this.retryAttempts = builder.retryAttempts;
        }

        @Override
        public final software.amazon.awscdk.services.events.RuleTargetInput getEvent() {
            return this.event;
        }

        @Override
        public final java.lang.Boolean getInstallLatestAwsSdk() {
            return this.installLatestAwsSdk;
        }

        @Override
        public final software.amazon.awscdk.services.events.targets.LogGroupTargetInput getLogEvent() {
            return this.logEvent;
        }

        @Override
        public final software.amazon.awscdk.services.sqs.IQueue getDeadLetterQueue() {
            return this.deadLetterQueue;
        }

        @Override
        public final software.amazon.awscdk.Duration getMaxEventAge() {
            return this.maxEventAge;
        }

        @Override
        public final java.lang.Number getRetryAttempts() {
            return this.retryAttempts;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getEvent() != null) {
                data.set("event", om.valueToTree(this.getEvent()));
            }
            if (this.getInstallLatestAwsSdk() != null) {
                data.set("installLatestAwsSdk", om.valueToTree(this.getInstallLatestAwsSdk()));
            }
            if (this.getLogEvent() != null) {
                data.set("logEvent", om.valueToTree(this.getLogEvent()));
            }
            if (this.getDeadLetterQueue() != null) {
                data.set("deadLetterQueue", om.valueToTree(this.getDeadLetterQueue()));
            }
            if (this.getMaxEventAge() != null) {
                data.set("maxEventAge", om.valueToTree(this.getMaxEventAge()));
            }
            if (this.getRetryAttempts() != null) {
                data.set("retryAttempts", om.valueToTree(this.getRetryAttempts()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_events_targets.LogGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LogGroupProps.Jsii$Proxy that = (LogGroupProps.Jsii$Proxy) o;

            if (this.event != null ? !this.event.equals(that.event) : that.event != null) return false;
            if (this.installLatestAwsSdk != null ? !this.installLatestAwsSdk.equals(that.installLatestAwsSdk) : that.installLatestAwsSdk != null) return false;
            if (this.logEvent != null ? !this.logEvent.equals(that.logEvent) : that.logEvent != null) return false;
            if (this.deadLetterQueue != null ? !this.deadLetterQueue.equals(that.deadLetterQueue) : that.deadLetterQueue != null) return false;
            if (this.maxEventAge != null ? !this.maxEventAge.equals(that.maxEventAge) : that.maxEventAge != null) return false;
            return this.retryAttempts != null ? this.retryAttempts.equals(that.retryAttempts) : that.retryAttempts == null;
        }

        @Override
        public final int hashCode() {
            int result = this.event != null ? this.event.hashCode() : 0;
            result = 31 * result + (this.installLatestAwsSdk != null ? this.installLatestAwsSdk.hashCode() : 0);
            result = 31 * result + (this.logEvent != null ? this.logEvent.hashCode() : 0);
            result = 31 * result + (this.deadLetterQueue != null ? this.deadLetterQueue.hashCode() : 0);
            result = 31 * result + (this.maxEventAge != null ? this.maxEventAge.hashCode() : 0);
            result = 31 * result + (this.retryAttempts != null ? this.retryAttempts.hashCode() : 0);
            return result;
        }
    }
}
