package software.amazon.awscdk.services.grafana;

/**
 * Specifies a <em>workspace</em> .
 * <p>
 * In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.grafana.*;
 * CfnWorkspace cfnWorkspace = CfnWorkspace.Builder.create(this, "MyCfnWorkspace")
 *         .accountAccessType("accountAccessType")
 *         .authenticationProviders(List.of("authenticationProviders"))
 *         .permissionType("permissionType")
 *         // the properties below are optional
 *         .clientToken("clientToken")
 *         .dataSources(List.of("dataSources"))
 *         .description("description")
 *         .grafanaVersion("grafanaVersion")
 *         .name("name")
 *         .networkAccessControl(NetworkAccessControlProperty.builder()
 *                 .prefixListIds(List.of("prefixListIds"))
 *                 .vpceIds(List.of("vpceIds"))
 *                 .build())
 *         .notificationDestinations(List.of("notificationDestinations"))
 *         .organizationalUnits(List.of("organizationalUnits"))
 *         .organizationRoleName("organizationRoleName")
 *         .pluginAdminEnabled(false)
 *         .roleArn("roleArn")
 *         .samlConfiguration(SamlConfigurationProperty.builder()
 *                 .idpMetadata(IdpMetadataProperty.builder()
 *                         .url("url")
 *                         .xml("xml")
 *                         .build())
 *                 // the properties below are optional
 *                 .allowedOrganizations(List.of("allowedOrganizations"))
 *                 .assertionAttributes(AssertionAttributesProperty.builder()
 *                         .email("email")
 *                         .groups("groups")
 *                         .login("login")
 *                         .name("name")
 *                         .org("org")
 *                         .role("role")
 *                         .build())
 *                 .loginValidityDuration(123)
 *                 .roleValues(RoleValuesProperty.builder()
 *                         .admin(List.of("admin"))
 *                         .editor(List.of("editor"))
 *                         .build())
 *                 .build())
 *         .stackSetName("stackSetName")
 *         .vpcConfiguration(VpcConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:17.643Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_grafana.CfnWorkspace")
public class CfnWorkspace extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnWorkspace(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkspace(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.grafana.CfnWorkspace.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkspace(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.grafana.CfnWorkspaceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The date that the workspace was created.
     * <p>
     * Type: Timestamp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreationTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrCreationTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL that users can use to access the Grafana console in the workspace.
     * <p>
     * Type: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the version of Grafana supported by this workspace.
     * <p>
     * Type: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrGrafanaVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrGrafanaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique ID of this workspace.
     * <p>
     * Type: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The most recent date that the workspace was modified.
     * <p>
     * Type: Timestamp
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrModificationTimestamp() {
        return software.amazon.jsii.Kernel.get(this, "attrModificationTimestamp", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the workspace's SAML configuration is complete.
     * <p>
     * Valid values: <code>CONFIGURED | NOT_CONFIGURED</code>
     * <p>
     * Type: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSamlConfigurationStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrSamlConfigurationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the IAM Identity Center-managed application that is created by Amazon Managed Grafana .
     * <p>
     * Type: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSsoClientId() {
        return software.amazon.jsii.Kernel.get(this, "attrSsoClientId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the workspace.
     * <p>
     * Valid values: <code>ACTIVE | CREATING | DELETING | FAILED | UPDATING | UPGRADING | DELETION_FAILED | CREATION_FAILED | UPDATE_FAILED | UPGRADE_FAILED | LICENSE_REMOVAL_FAILED</code>
     * <p>
     * Type: String
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAccountAccessType() {
        return software.amazon.jsii.Kernel.get(this, "accountAccessType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccountAccessType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "accountAccessType", java.util.Objects.requireNonNull(value, "accountAccessType is required"));
    }

    /**
     * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center , or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAuthenticationProviders() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "authenticationProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center , or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthenticationProviders(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "authenticationProviders", java.util.Objects.requireNonNull(value, "authenticationProviders is required"));
    }

    /**
     * If this is <code>SERVICE_MANAGED</code> , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPermissionType() {
        return software.amazon.jsii.Kernel.get(this, "permissionType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * If this is <code>SERVICE_MANAGED</code> , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPermissionType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "permissionType", java.util.Objects.requireNonNull(value, "permissionType is required"));
    }

    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getClientToken() {
        return software.amazon.jsii.Kernel.get(this, "clientToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClientToken(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "clientToken", value);
    }

    /**
     * Specifies the AWS data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getDataSources() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "dataSources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the AWS data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataSources(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "dataSources", value);
    }

    /**
     * The user-defined description of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The user-defined description of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Specifies the version of Grafana to support in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getGrafanaVersion() {
        return software.amazon.jsii.Kernel.get(this, "grafanaVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the version of Grafana to support in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setGrafanaVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "grafanaVersion", value);
    }

    /**
     * The name of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", value);
    }

    /**
     * The configuration settings for network access to your workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkAccessControl() {
        return software.amazon.jsii.Kernel.get(this, "networkAccessControl", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration settings for network access to your workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkAccessControl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkAccessControl", value);
    }

    /**
     * The configuration settings for network access to your workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkAccessControl(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.grafana.CfnWorkspace.NetworkAccessControlProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkAccessControl", value);
    }

    /**
     * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationDestinations() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "notificationDestinations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationDestinations(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "notificationDestinations", value);
    }

    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOrganizationalUnits() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "organizationalUnits", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationalUnits(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "organizationalUnits", value);
    }

    /**
     * The name of the IAM role that is used to access resources through Organizations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getOrganizationRoleName() {
        return software.amazon.jsii.Kernel.get(this, "organizationRoleName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the IAM role that is used to access resources through Organizations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOrganizationRoleName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "organizationRoleName", value);
    }

    /**
     * Whether plugin administration is enabled in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPluginAdminEnabled() {
        return software.amazon.jsii.Kernel.get(this, "pluginAdminEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether plugin administration is enabled in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPluginAdminEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "pluginAdminEnabled", value);
    }

    /**
     * Whether plugin administration is enabled in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPluginAdminEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pluginAdminEnabled", value);
    }

    /**
     * The IAM role that grants permissions to the AWS resources that the workspace will view data from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The IAM role that grants permissions to the AWS resources that the workspace will view data from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", value);
    }

    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSamlConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "samlConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamlConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "samlConfiguration", value);
    }

    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSamlConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.grafana.CfnWorkspace.SamlConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "samlConfiguration", value);
    }

    /**
     * The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for this workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStackSetName() {
        return software.amazon.jsii.Kernel.get(this, "stackSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for this workspace.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStackSetName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stackSetName", value);
    }

    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "vpcConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfiguration", value);
    }

    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.grafana.CfnWorkspace.VpcConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcConfiguration", value);
    }
    /**
     * A structure that defines which attributes in the IdP assertion are to be used to define information about the users authenticated by the IdP to use the workspace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.grafana.*;
     * AssertionAttributesProperty assertionAttributesProperty = AssertionAttributesProperty.builder()
     *         .email("email")
     *         .groups("groups")
     *         .login("login")
     *         .name("name")
     *         .org("org")
     *         .role("role")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_grafana.CfnWorkspace.AssertionAttributesProperty")
    @software.amazon.jsii.Jsii.Proxy(AssertionAttributesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AssertionAttributesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the attribute within the SAML assertion to use as the email names for SAML users.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-email">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-email</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEmail() {
            return null;
        }

        /**
         * The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-groups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-groups</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGroups() {
            return null;
        }

        /**
         * The name of the attribute within the SAML assertion to use as the login names for SAML users.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-login">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-login</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogin() {
            return null;
        }

        /**
         * The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users' organizations.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-org">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-org</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOrg() {
            return null;
        }

        /**
         * The name of the attribute within the SAML assertion to use as the user roles.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-role">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-assertionattributes.html#cfn-grafana-workspace-assertionattributes-role</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRole() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AssertionAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AssertionAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AssertionAttributesProperty> {
            java.lang.String email;
            java.lang.String groups;
            java.lang.String login;
            java.lang.String name;
            java.lang.String org;
            java.lang.String role;

            /**
             * Sets the value of {@link AssertionAttributesProperty#getEmail}
             * @param email The name of the attribute within the SAML assertion to use as the email names for SAML users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder email(java.lang.String email) {
                this.email = email;
                return this;
            }

            /**
             * Sets the value of {@link AssertionAttributesProperty#getGroups}
             * @param groups The name of the attribute within the SAML assertion to use as the user full "friendly" names for user groups.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder groups(java.lang.String groups) {
                this.groups = groups;
                return this;
            }

            /**
             * Sets the value of {@link AssertionAttributesProperty#getLogin}
             * @param login The name of the attribute within the SAML assertion to use as the login names for SAML users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder login(java.lang.String login) {
                this.login = login;
                return this;
            }

            /**
             * Sets the value of {@link AssertionAttributesProperty#getName}
             * @param name The name of the attribute within the SAML assertion to use as the user full "friendly" names for SAML users.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link AssertionAttributesProperty#getOrg}
             * @param org The name of the attribute within the SAML assertion to use as the user full "friendly" names for the users' organizations.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder org(java.lang.String org) {
                this.org = org;
                return this;
            }

            /**
             * Sets the value of {@link AssertionAttributesProperty#getRole}
             * @param role The name of the attribute within the SAML assertion to use as the user roles.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder role(java.lang.String role) {
                this.role = role;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AssertionAttributesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AssertionAttributesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AssertionAttributesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssertionAttributesProperty {
            private final java.lang.String email;
            private final java.lang.String groups;
            private final java.lang.String login;
            private final java.lang.String name;
            private final java.lang.String org;
            private final java.lang.String role;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.email = software.amazon.jsii.Kernel.get(this, "email", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.login = software.amazon.jsii.Kernel.get(this, "login", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.org = software.amazon.jsii.Kernel.get(this, "org", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.email = builder.email;
                this.groups = builder.groups;
                this.login = builder.login;
                this.name = builder.name;
                this.org = builder.org;
                this.role = builder.role;
            }

            @Override
            public final java.lang.String getEmail() {
                return this.email;
            }

            @Override
            public final java.lang.String getGroups() {
                return this.groups;
            }

            @Override
            public final java.lang.String getLogin() {
                return this.login;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getOrg() {
                return this.org;
            }

            @Override
            public final java.lang.String getRole() {
                return this.role;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEmail() != null) {
                    data.set("email", om.valueToTree(this.getEmail()));
                }
                if (this.getGroups() != null) {
                    data.set("groups", om.valueToTree(this.getGroups()));
                }
                if (this.getLogin() != null) {
                    data.set("login", om.valueToTree(this.getLogin()));
                }
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }
                if (this.getOrg() != null) {
                    data.set("org", om.valueToTree(this.getOrg()));
                }
                if (this.getRole() != null) {
                    data.set("role", om.valueToTree(this.getRole()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_grafana.CfnWorkspace.AssertionAttributesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AssertionAttributesProperty.Jsii$Proxy that = (AssertionAttributesProperty.Jsii$Proxy) o;

                if (this.email != null ? !this.email.equals(that.email) : that.email != null) return false;
                if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
                if (this.login != null ? !this.login.equals(that.login) : that.login != null) return false;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
                if (this.org != null ? !this.org.equals(that.org) : that.org != null) return false;
                return this.role != null ? this.role.equals(that.role) : that.role == null;
            }

            @Override
            public final int hashCode() {
                int result = this.email != null ? this.email.hashCode() : 0;
                result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
                result = 31 * result + (this.login != null ? this.login.hashCode() : 0);
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                result = 31 * result + (this.org != null ? this.org.hashCode() : 0);
                result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.
     * <p>
     * You can specify the metadata either by providing a URL to its location in the <code>url</code> parameter, or by specifying the full metadata in XML format in the <code>xml</code> parameter. Specifying both will cause an error.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.grafana.*;
     * IdpMetadataProperty idpMetadataProperty = IdpMetadataProperty.builder()
     *         .url("url")
     *         .xml("xml")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-idpmetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-idpmetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_grafana.CfnWorkspace.IdpMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(IdpMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdpMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The URL of the location containing the IdP metadata.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-idpmetadata.html#cfn-grafana-workspace-idpmetadata-url">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-idpmetadata.html#cfn-grafana-workspace-idpmetadata-url</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUrl() {
            return null;
        }

        /**
         * The full IdP metadata, in XML format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-idpmetadata.html#cfn-grafana-workspace-idpmetadata-xml">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-idpmetadata.html#cfn-grafana-workspace-idpmetadata-xml</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getXml() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdpMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdpMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdpMetadataProperty> {
            java.lang.String url;
            java.lang.String xml;

            /**
             * Sets the value of {@link IdpMetadataProperty#getUrl}
             * @param url The URL of the location containing the IdP metadata.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder url(java.lang.String url) {
                this.url = url;
                return this;
            }

            /**
             * Sets the value of {@link IdpMetadataProperty#getXml}
             * @param xml The full IdP metadata, in XML format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder xml(java.lang.String xml) {
                this.xml = xml;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdpMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdpMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdpMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdpMetadataProperty {
            private final java.lang.String url;
            private final java.lang.String xml;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.url = software.amazon.jsii.Kernel.get(this, "url", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.xml = software.amazon.jsii.Kernel.get(this, "xml", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.url = builder.url;
                this.xml = builder.xml;
            }

            @Override
            public final java.lang.String getUrl() {
                return this.url;
            }

            @Override
            public final java.lang.String getXml() {
                return this.xml;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getUrl() != null) {
                    data.set("url", om.valueToTree(this.getUrl()));
                }
                if (this.getXml() != null) {
                    data.set("xml", om.valueToTree(this.getXml()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_grafana.CfnWorkspace.IdpMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdpMetadataProperty.Jsii$Proxy that = (IdpMetadataProperty.Jsii$Proxy) o;

                if (this.url != null ? !this.url.equals(that.url) : that.url != null) return false;
                return this.xml != null ? this.xml.equals(that.xml) : that.xml == null;
            }

            @Override
            public final int hashCode() {
                int result = this.url != null ? this.url.hashCode() : 0;
                result = 31 * result + (this.xml != null ? this.xml.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for in-bound network access to your workspace.
     * <p>
     * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization are still required.
     * <p>
     * Access is granted to a caller that is in either the IP address list or the VPC endpoint list - they do not need to be in both.
     * <p>
     * If this is not configured, or is removed, then all IP addresses and VPC endpoints are allowed. Standard Grafana authentication and authorization are still required.
     * <p>
     * <blockquote>
     * <p>
     * While both <code>prefixListIds</code> and <code>vpceIds</code> are required, you can pass in an empty array of strings for either parameter if you do not want to allow any of that type.
     * <p>
     * If both are passed as empty arrays, no traffic is allowed to the workspace, because only <em>explicitly</em> allowed connections are accepted.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.grafana.*;
     * NetworkAccessControlProperty networkAccessControlProperty = NetworkAccessControlProperty.builder()
     *         .prefixListIds(List.of("prefixListIds"))
     *         .vpceIds(List.of("vpceIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-networkaccesscontrol.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-networkaccesscontrol.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_grafana.CfnWorkspace.NetworkAccessControlProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkAccessControlProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkAccessControlProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of prefix list IDs.
         * <p>
         * A prefix list is a list of CIDR ranges of IP addresses. The IP addresses specified are allowed to access your workspace. If the list is not included in the configuration (passed an empty array) then no IP addresses are allowed to access the workspace. You create a prefix list using the Amazon VPC console.
         * <p>
         * Prefix list IDs have the format <code>pl- *1a2b3c4d*</code> .
         * <p>
         * For more information about prefix lists, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html">Group CIDR blocks using managed prefix lists</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-networkaccesscontrol.html#cfn-grafana-workspace-networkaccesscontrol-prefixlistids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-networkaccesscontrol.html#cfn-grafana-workspace-networkaccesscontrol-prefixlistids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getPrefixListIds() {
            return null;
        }

        /**
         * An array of Amazon VPC endpoint IDs for the workspace.
         * <p>
         * You can create VPC endpoints to your Amazon Managed Grafana workspace for access from within a VPC. If a <code>NetworkAccessConfiguration</code> is specified then only VPC endpoints specified here are allowed to access the workspace. If you pass in an empty array of strings, then no VPCs are allowed to access the workspace.
         * <p>
         * VPC endpoint IDs have the format <code>vpce- *1a2b3c4d*</code> .
         * <p>
         * For more information about creating an interface VPC endpoint, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/VPC-endpoints">Interface VPC endpoints</a> in the <em>Amazon Managed Grafana User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the <code>com.amazonaws.[region].grafana-workspace</code> service endpoint). Other VPC endpoints are ignored.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-networkaccesscontrol.html#cfn-grafana-workspace-networkaccesscontrol-vpceids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-networkaccesscontrol.html#cfn-grafana-workspace-networkaccesscontrol-vpceids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getVpceIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkAccessControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkAccessControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkAccessControlProperty> {
            java.util.List<java.lang.String> prefixListIds;
            java.util.List<java.lang.String> vpceIds;

            /**
             * Sets the value of {@link NetworkAccessControlProperty#getPrefixListIds}
             * @param prefixListIds An array of prefix list IDs.
             *                      A prefix list is a list of CIDR ranges of IP addresses. The IP addresses specified are allowed to access your workspace. If the list is not included in the configuration (passed an empty array) then no IP addresses are allowed to access the workspace. You create a prefix list using the Amazon VPC console.
             *                      <p>
             *                      Prefix list IDs have the format <code>pl- *1a2b3c4d*</code> .
             *                      <p>
             *                      For more information about prefix lists, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/managed-prefix-lists.html">Group CIDR blocks using managed prefix lists</a> in the <em>Amazon Virtual Private Cloud User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefixListIds(java.util.List<java.lang.String> prefixListIds) {
                this.prefixListIds = prefixListIds;
                return this;
            }

            /**
             * Sets the value of {@link NetworkAccessControlProperty#getVpceIds}
             * @param vpceIds An array of Amazon VPC endpoint IDs for the workspace.
             *                You can create VPC endpoints to your Amazon Managed Grafana workspace for access from within a VPC. If a <code>NetworkAccessConfiguration</code> is specified then only VPC endpoints specified here are allowed to access the workspace. If you pass in an empty array of strings, then no VPCs are allowed to access the workspace.
             *                <p>
             *                VPC endpoint IDs have the format <code>vpce- *1a2b3c4d*</code> .
             *                <p>
             *                For more information about creating an interface VPC endpoint, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/VPC-endpoints">Interface VPC endpoints</a> in the <em>Amazon Managed Grafana User Guide</em> .
             *                <p>
             *                <blockquote>
             *                <p>
             *                The only VPC endpoints that can be specified here are interface VPC endpoints for Grafana workspaces (using the <code>com.amazonaws.[region].grafana-workspace</code> service endpoint). Other VPC endpoints are ignored.
             *                <p>
             *                </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpceIds(java.util.List<java.lang.String> vpceIds) {
                this.vpceIds = vpceIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkAccessControlProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkAccessControlProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkAccessControlProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkAccessControlProperty {
            private final java.util.List<java.lang.String> prefixListIds;
            private final java.util.List<java.lang.String> vpceIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.prefixListIds = software.amazon.jsii.Kernel.get(this, "prefixListIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.vpceIds = software.amazon.jsii.Kernel.get(this, "vpceIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.prefixListIds = builder.prefixListIds;
                this.vpceIds = builder.vpceIds;
            }

            @Override
            public final java.util.List<java.lang.String> getPrefixListIds() {
                return this.prefixListIds;
            }

            @Override
            public final java.util.List<java.lang.String> getVpceIds() {
                return this.vpceIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPrefixListIds() != null) {
                    data.set("prefixListIds", om.valueToTree(this.getPrefixListIds()));
                }
                if (this.getVpceIds() != null) {
                    data.set("vpceIds", om.valueToTree(this.getVpceIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_grafana.CfnWorkspace.NetworkAccessControlProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkAccessControlProperty.Jsii$Proxy that = (NetworkAccessControlProperty.Jsii$Proxy) o;

                if (this.prefixListIds != null ? !this.prefixListIds.equals(that.prefixListIds) : that.prefixListIds != null) return false;
                return this.vpceIds != null ? this.vpceIds.equals(that.vpceIds) : that.vpceIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.prefixListIds != null ? this.prefixListIds.hashCode() : 0;
                result = 31 * result + (this.vpceIds != null ? this.vpceIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure defines which groups defined in the SAML assertion attribute are to be mapped to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.
     * <p>
     * SAML authenticated users not part of <code>Admin</code> or <code>Editor</code> role groups have <code>Viewer</code> permission over the workspace.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.grafana.*;
     * RoleValuesProperty roleValuesProperty = RoleValuesProperty.builder()
     *         .admin(List.of("admin"))
     *         .editor(List.of("editor"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-rolevalues.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-rolevalues.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_grafana.CfnWorkspace.RoleValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(RoleValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RoleValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-rolevalues.html#cfn-grafana-workspace-rolevalues-admin">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-rolevalues.html#cfn-grafana-workspace-rolevalues-admin</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAdmin() {
            return null;
        }

        /**
         * A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-rolevalues.html#cfn-grafana-workspace-rolevalues-editor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-rolevalues.html#cfn-grafana-workspace-rolevalues-editor</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEditor() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RoleValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RoleValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RoleValuesProperty> {
            java.util.List<java.lang.String> admin;
            java.util.List<java.lang.String> editor;

            /**
             * Sets the value of {@link RoleValuesProperty#getAdmin}
             * @param admin A list of groups from the SAML assertion attribute to grant the Grafana <code>Admin</code> role to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder admin(java.util.List<java.lang.String> admin) {
                this.admin = admin;
                return this;
            }

            /**
             * Sets the value of {@link RoleValuesProperty#getEditor}
             * @param editor A list of groups from the SAML assertion attribute to grant the Grafana <code>Editor</code> role to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder editor(java.util.List<java.lang.String> editor) {
                this.editor = editor;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RoleValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RoleValuesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RoleValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RoleValuesProperty {
            private final java.util.List<java.lang.String> admin;
            private final java.util.List<java.lang.String> editor;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.admin = software.amazon.jsii.Kernel.get(this, "admin", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.editor = software.amazon.jsii.Kernel.get(this, "editor", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.admin = builder.admin;
                this.editor = builder.editor;
            }

            @Override
            public final java.util.List<java.lang.String> getAdmin() {
                return this.admin;
            }

            @Override
            public final java.util.List<java.lang.String> getEditor() {
                return this.editor;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAdmin() != null) {
                    data.set("admin", om.valueToTree(this.getAdmin()));
                }
                if (this.getEditor() != null) {
                    data.set("editor", om.valueToTree(this.getEditor()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_grafana.CfnWorkspace.RoleValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RoleValuesProperty.Jsii$Proxy that = (RoleValuesProperty.Jsii$Proxy) o;

                if (this.admin != null ? !this.admin.equals(that.admin) : that.admin != null) return false;
                return this.editor != null ? this.editor.equals(that.editor) : that.editor == null;
            }

            @Override
            public final int hashCode() {
                int result = this.admin != null ? this.admin.hashCode() : 0;
                result = 31 * result + (this.editor != null ? this.editor.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A structure containing information about how this workspace works with SAML.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.grafana.*;
     * SamlConfigurationProperty samlConfigurationProperty = SamlConfigurationProperty.builder()
     *         .idpMetadata(IdpMetadataProperty.builder()
     *                 .url("url")
     *                 .xml("xml")
     *                 .build())
     *         // the properties below are optional
     *         .allowedOrganizations(List.of("allowedOrganizations"))
     *         .assertionAttributes(AssertionAttributesProperty.builder()
     *                 .email("email")
     *                 .groups("groups")
     *                 .login("login")
     *                 .name("name")
     *                 .org("org")
     *                 .role("role")
     *                 .build())
     *         .loginValidityDuration(123)
     *         .roleValues(RoleValuesProperty.builder()
     *                 .admin(List.of("admin"))
     *                 .editor(List.of("editor"))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_grafana.CfnWorkspace.SamlConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(SamlConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SamlConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-idpmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-idpmetadata</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIdpMetadata();

        /**
         * Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace.
         * <p>
         * If this is empty, all organizations in the assertion attribute have access.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-allowedorganizations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-allowedorganizations</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedOrganizations() {
            return null;
        }

        /**
         * A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-assertionattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-assertionattributes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAssertionAttributes() {
            return null;
        }

        /**
         * How long a sign-on session by a SAML user is valid, before the user has to sign on again.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-loginvalidityduration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-loginvalidityduration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLoginValidityDuration() {
            return null;
        }

        /**
         * A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-rolevalues">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-samlconfiguration.html#cfn-grafana-workspace-samlconfiguration-rolevalues</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRoleValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SamlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SamlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SamlConfigurationProperty> {
            java.lang.Object idpMetadata;
            java.util.List<java.lang.String> allowedOrganizations;
            java.lang.Object assertionAttributes;
            java.lang.Number loginValidityDuration;
            java.lang.Object roleValues;

            /**
             * Sets the value of {@link SamlConfigurationProperty#getIdpMetadata}
             * @param idpMetadata A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idpMetadata(software.amazon.awscdk.IResolvable idpMetadata) {
                this.idpMetadata = idpMetadata;
                return this;
            }

            /**
             * Sets the value of {@link SamlConfigurationProperty#getIdpMetadata}
             * @param idpMetadata A structure containing the identity provider (IdP) metadata used to integrate the identity provider with this workspace. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idpMetadata(software.amazon.awscdk.services.grafana.CfnWorkspace.IdpMetadataProperty idpMetadata) {
                this.idpMetadata = idpMetadata;
                return this;
            }

            /**
             * Sets the value of {@link SamlConfigurationProperty#getAllowedOrganizations}
             * @param allowedOrganizations Lists which organizations defined in the SAML assertion are allowed to use the Amazon Managed Grafana workspace.
             *                             If this is empty, all organizations in the assertion attribute have access.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedOrganizations(java.util.List<java.lang.String> allowedOrganizations) {
                this.allowedOrganizations = allowedOrganizations;
                return this;
            }

            /**
             * Sets the value of {@link SamlConfigurationProperty#getAssertionAttributes}
             * @param assertionAttributes A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assertionAttributes(software.amazon.awscdk.IResolvable assertionAttributes) {
                this.assertionAttributes = assertionAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SamlConfigurationProperty#getAssertionAttributes}
             * @param assertionAttributes A structure that defines which attributes in the SAML assertion are to be used to define information about the users authenticated by that IdP to use the workspace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder assertionAttributes(software.amazon.awscdk.services.grafana.CfnWorkspace.AssertionAttributesProperty assertionAttributes) {
                this.assertionAttributes = assertionAttributes;
                return this;
            }

            /**
             * Sets the value of {@link SamlConfigurationProperty#getLoginValidityDuration}
             * @param loginValidityDuration How long a sign-on session by a SAML user is valid, before the user has to sign on again.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder loginValidityDuration(java.lang.Number loginValidityDuration) {
                this.loginValidityDuration = loginValidityDuration;
                return this;
            }

            /**
             * Sets the value of {@link SamlConfigurationProperty#getRoleValues}
             * @param roleValues A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleValues(software.amazon.awscdk.IResolvable roleValues) {
                this.roleValues = roleValues;
                return this;
            }

            /**
             * Sets the value of {@link SamlConfigurationProperty#getRoleValues}
             * @param roleValues A structure containing arrays that map group names in the SAML assertion to the Grafana <code>Admin</code> and <code>Editor</code> roles in the workspace.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleValues(software.amazon.awscdk.services.grafana.CfnWorkspace.RoleValuesProperty roleValues) {
                this.roleValues = roleValues;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SamlConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SamlConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SamlConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SamlConfigurationProperty {
            private final java.lang.Object idpMetadata;
            private final java.util.List<java.lang.String> allowedOrganizations;
            private final java.lang.Object assertionAttributes;
            private final java.lang.Number loginValidityDuration;
            private final java.lang.Object roleValues;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.idpMetadata = software.amazon.jsii.Kernel.get(this, "idpMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowedOrganizations = software.amazon.jsii.Kernel.get(this, "allowedOrganizations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.assertionAttributes = software.amazon.jsii.Kernel.get(this, "assertionAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.loginValidityDuration = software.amazon.jsii.Kernel.get(this, "loginValidityDuration", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.roleValues = software.amazon.jsii.Kernel.get(this, "roleValues", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.idpMetadata = java.util.Objects.requireNonNull(builder.idpMetadata, "idpMetadata is required");
                this.allowedOrganizations = builder.allowedOrganizations;
                this.assertionAttributes = builder.assertionAttributes;
                this.loginValidityDuration = builder.loginValidityDuration;
                this.roleValues = builder.roleValues;
            }

            @Override
            public final java.lang.Object getIdpMetadata() {
                return this.idpMetadata;
            }

            @Override
            public final java.util.List<java.lang.String> getAllowedOrganizations() {
                return this.allowedOrganizations;
            }

            @Override
            public final java.lang.Object getAssertionAttributes() {
                return this.assertionAttributes;
            }

            @Override
            public final java.lang.Number getLoginValidityDuration() {
                return this.loginValidityDuration;
            }

            @Override
            public final java.lang.Object getRoleValues() {
                return this.roleValues;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("idpMetadata", om.valueToTree(this.getIdpMetadata()));
                if (this.getAllowedOrganizations() != null) {
                    data.set("allowedOrganizations", om.valueToTree(this.getAllowedOrganizations()));
                }
                if (this.getAssertionAttributes() != null) {
                    data.set("assertionAttributes", om.valueToTree(this.getAssertionAttributes()));
                }
                if (this.getLoginValidityDuration() != null) {
                    data.set("loginValidityDuration", om.valueToTree(this.getLoginValidityDuration()));
                }
                if (this.getRoleValues() != null) {
                    data.set("roleValues", om.valueToTree(this.getRoleValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_grafana.CfnWorkspace.SamlConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SamlConfigurationProperty.Jsii$Proxy that = (SamlConfigurationProperty.Jsii$Proxy) o;

                if (!idpMetadata.equals(that.idpMetadata)) return false;
                if (this.allowedOrganizations != null ? !this.allowedOrganizations.equals(that.allowedOrganizations) : that.allowedOrganizations != null) return false;
                if (this.assertionAttributes != null ? !this.assertionAttributes.equals(that.assertionAttributes) : that.assertionAttributes != null) return false;
                if (this.loginValidityDuration != null ? !this.loginValidityDuration.equals(that.loginValidityDuration) : that.loginValidityDuration != null) return false;
                return this.roleValues != null ? this.roleValues.equals(that.roleValues) : that.roleValues == null;
            }

            @Override
            public final int hashCode() {
                int result = this.idpMetadata.hashCode();
                result = 31 * result + (this.allowedOrganizations != null ? this.allowedOrganizations.hashCode() : 0);
                result = 31 * result + (this.assertionAttributes != null ? this.assertionAttributes.hashCode() : 0);
                result = 31 * result + (this.loginValidityDuration != null ? this.loginValidityDuration.hashCode() : 0);
                result = 31 * result + (this.roleValues != null ? this.roleValues.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
     * <p>
     * <blockquote>
     * <p>
     * Provided <code>securityGroupIds</code> and <code>subnetIds</code> must be part of the same VPC.
     * <p>
     * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.grafana.*;
     * VpcConfigurationProperty vpcConfigurationProperty = VpcConfigurationProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-vpcconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-vpcconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_grafana.CfnWorkspace.VpcConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect.
         * <p>
         * Duplicates not allowed.
         * <p>
         * <em>Array Members</em> : Minimum number of 1 items. Maximum number of 5 items.
         * <p>
         * <em>Length</em> : Minimum length of 0. Maximum length of 255.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-vpcconfiguration.html#cfn-grafana-workspace-vpcconfiguration-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-vpcconfiguration.html#cfn-grafana-workspace-vpcconfiguration-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSecurityGroupIds();

        /**
         * The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect.
         * <p>
         * Duplicates not allowed.
         * <p>
         * <em>Array Members</em> : Minimum number of 2 items. Maximum number of 6 items.
         * <p>
         * <em>Length</em> : Minimum length of 0. Maximum length of 255.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-vpcconfiguration.html#cfn-grafana-workspace-vpcconfiguration-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-grafana-workspace-vpcconfiguration.html#cfn-grafana-workspace-vpcconfiguration-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getSubnetIds();

        /**
         * @return a {@link Builder} of {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect. This parameter is required.
             *                         Duplicates not allowed.
             *                         <p>
             *                         <em>Array Members</em> : Minimum number of 1 items. Maximum number of 5 items.
             *                         <p>
             *                         <em>Length</em> : Minimum length of 0. Maximum length of 255.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VpcConfigurationProperty#getSubnetIds}
             * @param subnetIds The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect. This parameter is required.
             *                  Duplicates not allowed.
             *                  <p>
             *                  <em>Array Members</em> : Minimum number of 2 items. Maximum number of 6 items.
             *                  <p>
             *                  <em>Length</em> : Minimum length of 0. Maximum length of 255.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = java.util.Objects.requireNonNull(builder.securityGroupIds, "securityGroupIds is required");
                this.subnetIds = java.util.Objects.requireNonNull(builder.subnetIds, "subnetIds is required");
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                data.set("subnetIds", om.valueToTree(this.getSubnetIds()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_grafana.CfnWorkspace.VpcConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcConfigurationProperty.Jsii$Proxy that = (VpcConfigurationProperty.Jsii$Proxy) o;

                if (!securityGroupIds.equals(that.securityGroupIds)) return false;
                return this.subnetIds.equals(that.subnetIds);
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds.hashCode();
                result = 31 * result + (this.subnetIds.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.grafana.CfnWorkspace}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.grafana.CfnWorkspace> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.grafana.CfnWorkspaceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.grafana.CfnWorkspaceProps.Builder();
        }

        /**
         * Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization.
         * <p>
         * If this is <code>ORGANIZATION</code> , the <code>OrganizationalUnits</code> parameter specifies which organizational units the workspace can access.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-accountaccesstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-accountaccesstype</a>
         * @param accountAccessType Specifies whether the workspace can access AWS resources in this AWS account only, or whether it can also access AWS resources in other accounts in the same organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountAccessType(final java.lang.String accountAccessType) {
            this.props.accountAccessType(accountAccessType);
            return this;
        }

        /**
         * Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center , or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a> .
         * <p>
         * <em>Allowed Values</em> : <code>AWS_SSO | SAML</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-authenticationproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-authenticationproviders</a>
         * @param authenticationProviders Specifies whether this workspace uses SAML 2.0, AWS IAM Identity Center , or both to authenticate users for using the Grafana console within a workspace. For more information, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html">User authentication in Amazon Managed Grafana</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authenticationProviders(final java.util.List<java.lang.String> authenticationProviders) {
            this.props.authenticationProviders(authenticationProviders);
            return this;
        }

        /**
         * If this is <code>SERVICE_MANAGED</code> , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels.
         * <p>
         * If this is <code>CUSTOMER_MANAGED</code> , you must manage those roles and permissions yourself.
         * <p>
         * If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other AWS accounts in the organization, this parameter must be set to <code>CUSTOMER_MANAGED</code> .
         * <p>
         * For more information about converting between customer and service managed, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html">Managing permissions for data sources and notification channels</a> . For more information about the roles and permissions that must be managed for customer managed workspaces, see <a href="https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html">Amazon Managed Grafana permissions and policies for AWS data sources and notification channels</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-permissiontype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-permissiontype</a>
         * @param permissionType If this is <code>SERVICE_MANAGED</code> , and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use AWS data sources and notification channels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder permissionType(final java.lang.String permissionType) {
            this.props.permissionType(permissionType);
            return this;
        }

        /**
         * A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-clienttoken">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-clienttoken</a>
         * @param clientToken A unique, case-sensitive, user-provided identifier to ensure the idempotency of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(final java.lang.String clientToken) {
            this.props.clientToken(clientToken);
            return this;
        }

        /**
         * Specifies the AWS data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.
         * <p>
         * This list is only used when the workspace was created through the AWS console, and the <code>permissionType</code> is <code>SERVICE_MANAGED</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-datasources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-datasources</a>
         * @param dataSources Specifies the AWS data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataSources(final java.util.List<java.lang.String> dataSources) {
            this.props.dataSources(dataSources);
            return this;
        }

        /**
         * The user-defined description of the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-description</a>
         * @param description The user-defined description of the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies the version of Grafana to support in the workspace.
         * <p>
         * Defaults to the latest version on create (for example, 9.4), or the current version of the workspace on update.
         * <p>
         * Can only be used to upgrade (for example, from 8.4 to 9.4), not downgrade (for example, from 9.4 to 8.4).
         * <p>
         * To know what versions are available to upgrade to for a specific workspace, see the <a href="https://docs.aws.amazon.com/grafana/latest/APIReference/API_ListVersions.html">ListVersions</a> operation.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-grafanaversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-grafanaversion</a>
         * @param grafanaVersion Specifies the version of Grafana to support in the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder grafanaVersion(final java.lang.String grafanaVersion) {
            this.props.grafanaVersion(grafanaVersion);
            return this;
        }

        /**
         * The name of the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-name</a>
         * @param name The name of the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The configuration settings for network access to your workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-networkaccesscontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-networkaccesscontrol</a>
         * @param networkAccessControl The configuration settings for network access to your workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkAccessControl(final software.amazon.awscdk.IResolvable networkAccessControl) {
            this.props.networkAccessControl(networkAccessControl);
            return this;
        }
        /**
         * The configuration settings for network access to your workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-networkaccesscontrol">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-networkaccesscontrol</a>
         * @param networkAccessControl The configuration settings for network access to your workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkAccessControl(final software.amazon.awscdk.services.grafana.CfnWorkspace.NetworkAccessControlProperty networkAccessControl) {
            this.props.networkAccessControl(networkAccessControl);
            return this;
        }

        /**
         * The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.
         * <p>
         * <em>AllowedValues</em> : <code>SNS</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-notificationdestinations">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-notificationdestinations</a>
         * @param notificationDestinations The AWS notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationDestinations(final java.util.List<java.lang.String> notificationDestinations) {
            this.props.notificationDestinations(notificationDestinations);
            return this;
        }

        /**
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-organizationalunits">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-organizationalunits</a>
         * @param organizationalUnits Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationalUnits(final java.util.List<java.lang.String> organizationalUnits) {
            this.props.organizationalUnits(organizationalUnits);
            return this;
        }

        /**
         * The name of the IAM role that is used to access resources through Organizations.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-organizationrolename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-organizationrolename</a>
         * @param organizationRoleName The name of the IAM role that is used to access resources through Organizations. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationRoleName(final java.lang.String organizationRoleName) {
            this.props.organizationRoleName(organizationRoleName);
            return this;
        }

        /**
         * Whether plugin administration is enabled in the workspace.
         * <p>
         * Setting to <code>true</code> allows workspace admins to install, uninstall, and update plugins from within the Grafana workspace.
         * <p>
         * <blockquote>
         * <p>
         * This option is only valid for workspaces that support Grafana version 9 or newer.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-pluginadminenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-pluginadminenabled</a>
         * @param pluginAdminEnabled Whether plugin administration is enabled in the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginAdminEnabled(final java.lang.Boolean pluginAdminEnabled) {
            this.props.pluginAdminEnabled(pluginAdminEnabled);
            return this;
        }
        /**
         * Whether plugin administration is enabled in the workspace.
         * <p>
         * Setting to <code>true</code> allows workspace admins to install, uninstall, and update plugins from within the Grafana workspace.
         * <p>
         * <blockquote>
         * <p>
         * This option is only valid for workspaces that support Grafana version 9 or newer.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-pluginadminenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-pluginadminenabled</a>
         * @param pluginAdminEnabled Whether plugin administration is enabled in the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginAdminEnabled(final software.amazon.awscdk.IResolvable pluginAdminEnabled) {
            this.props.pluginAdminEnabled(pluginAdminEnabled);
            return this;
        }

        /**
         * The IAM role that grants permissions to the AWS resources that the workspace will view data from.
         * <p>
         * This role must already exist.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-rolearn</a>
         * @param roleArn The IAM role that grants permissions to the AWS resources that the workspace will view data from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-samlconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-samlconfiguration</a>
         * @param samlConfiguration If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlConfiguration(final software.amazon.awscdk.IResolvable samlConfiguration) {
            this.props.samlConfiguration(samlConfiguration);
            return this;
        }
        /**
         * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-samlconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-samlconfiguration</a>
         * @param samlConfiguration If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the <code>Admin</code> and <code>Editor</code> roles in the workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder samlConfiguration(final software.amazon.awscdk.services.grafana.CfnWorkspace.SamlConfigurationProperty samlConfiguration) {
            this.props.samlConfiguration(samlConfiguration);
            return this;
        }

        /**
         * The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for this workspace.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-stacksetname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-stacksetname</a>
         * @param stackSetName The name of the AWS CloudFormation stack set that is used to generate IAM roles to be used for this workspace. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stackSetName(final java.lang.String stackSetName) {
            this.props.stackSetName(stackSetName);
            return this;
        }

        /**
         * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
         * <p>
         * <blockquote>
         * <p>
         * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-vpcconfiguration</a>
         * @param vpcConfiguration The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(final software.amazon.awscdk.IResolvable vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }
        /**
         * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
         * <p>
         * <blockquote>
         * <p>
         * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-vpcconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-grafana-workspace.html#cfn-grafana-workspace-vpcconfiguration</a>
         * @param vpcConfiguration The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfiguration(final software.amazon.awscdk.services.grafana.CfnWorkspace.VpcConfigurationProperty vpcConfiguration) {
            this.props.vpcConfiguration(vpcConfiguration);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.grafana.CfnWorkspace}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.grafana.CfnWorkspace build() {
            return new software.amazon.awscdk.services.grafana.CfnWorkspace(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
