package software.amazon.awscdk.services.iam;

/**
 * Properties for defining an IAM managed policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Map&lt;String, Object&gt; policyDocument = Map.of(
 *         "Version", "2012-10-17",
 *         "Statement", List.of(Map.of(
 *                 "Sid", "FirstStatement",
 *                 "Effect", "Allow",
 *                 "Action", List.of("iam:ChangePassword"),
 *                 "Resource", List.of("*")), Map.of(
 *                 "Sid", "SecondStatement",
 *                 "Effect", "Allow",
 *                 "Action", List.of("s3:ListAllMyBuckets"),
 *                 "Resource", List.of("*")), Map.of(
 *                 "Sid", "ThirdStatement",
 *                 "Effect", "Allow",
 *                 "Action", List.of("s3:List*", "s3:Get*"),
 *                 "Resource", List.of("arn:aws:s3:::confidential-data", "arn:aws:s3:::confidential-data/*"),
 *                 "Condition", Map.of("Bool", Map.of("aws:MultiFactorAuthPresent", "true")))));
 * PolicyDocument customPolicyDocument = PolicyDocument.fromJson(policyDocument);
 * // You can pass this document as an initial document to a ManagedPolicy
 * // or inline Policy.
 * ManagedPolicy newManagedPolicy = ManagedPolicy.Builder.create(this, "MyNewManagedPolicy")
 *         .document(customPolicyDocument)
 *         .build();
 * Policy newPolicy = Policy.Builder.create(this, "MyNewPolicy")
 *         .document(customPolicyDocument)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:17.950Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iam.ManagedPolicyProps")
@software.amazon.jsii.Jsii.Proxy(ManagedPolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ManagedPolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A description of the managed policy.
     * <p>
     * Typically used to store information about the
     * permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
     * The policy description is immutable. After a value is assigned, it cannot be changed.
     * <p>
     * Default: - empty
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * Initial PolicyDocument to use for this ManagedPolicy.
     * <p>
     * If omited, any
     * <code>PolicyStatement</code> provided in the <code>statements</code> property will be applied
     * against the empty default <code>PolicyDocument</code>.
     * <p>
     * Default: - An empty policy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
        return null;
    }

    /**
     * Groups to attach this policy to.
     * <p>
     * You can also use <code>attachToGroup(group)</code> to attach this policy to a group.
     * <p>
     * Default: - No groups.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
        return null;
    }

    /**
     * The name of the managed policy.
     * <p>
     * If you specify multiple policies for an entity,
     * specify unique names. For example, if you specify a list of policies for
     * an IAM role, each policy must have a unique name.
     * <p>
     * Default: - A name is automatically generated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getManagedPolicyName() {
        return null;
    }

    /**
     * The path for the policy.
     * <p>
     * This parameter allows (through its regex pattern) a string of characters
     * consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
     * In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
     * including most punctuation characters, digits, and upper and lowercased letters.
     * <p>
     * For more information about paths, see IAM Identifiers in the IAM User Guide.
     * <p>
     * Default: - "/"
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
        return null;
    }

    /**
     * Roles to attach this policy to.
     * <p>
     * You can also use <code>attachToRole(role)</code> to attach this policy to a role.
     * <p>
     * Default: - No roles.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
        return null;
    }

    /**
     * Initial set of permissions to add to this policy document.
     * <p>
     * You can also use <code>addPermission(statement)</code> to add permissions later.
     * <p>
     * Default: - No statements.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
        return null;
    }

    /**
     * Users to attach this policy to.
     * <p>
     * You can also use <code>attachToUser(user)</code> to attach this policy to a user.
     * <p>
     * Default: - No users.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ManagedPolicyProps> {
        java.lang.String description;
        software.amazon.awscdk.services.iam.PolicyDocument document;
        java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        java.lang.String managedPolicyName;
        java.lang.String path;
        java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Sets the value of {@link ManagedPolicyProps#getDescription}
         * @param description A description of the managed policy.
         *                    Typically used to store information about the
         *                    permissions defined in the policy. For example, "Grants access to production DynamoDB tables."
         *                    The policy description is immutable. After a value is assigned, it cannot be changed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ManagedPolicyProps#getDocument}
         * @param document Initial PolicyDocument to use for this ManagedPolicy.
         *                 If omited, any
         *                 <code>PolicyStatement</code> provided in the <code>statements</code> property will be applied
         *                 against the empty default <code>PolicyDocument</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder document(software.amazon.awscdk.services.iam.PolicyDocument document) {
            this.document = document;
            return this;
        }

        /**
         * Sets the value of {@link ManagedPolicyProps#getGroups}
         * @param groups Groups to attach this policy to.
         *               You can also use <code>attachToGroup(group)</code> to attach this policy to a group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder groups(java.util.List<? extends software.amazon.awscdk.services.iam.IGroup> groups) {
            this.groups = (java.util.List<software.amazon.awscdk.services.iam.IGroup>)groups;
            return this;
        }

        /**
         * Sets the value of {@link ManagedPolicyProps#getManagedPolicyName}
         * @param managedPolicyName The name of the managed policy.
         *                          If you specify multiple policies for an entity,
         *                          specify unique names. For example, if you specify a list of policies for
         *                          an IAM role, each policy must have a unique name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder managedPolicyName(java.lang.String managedPolicyName) {
            this.managedPolicyName = managedPolicyName;
            return this;
        }

        /**
         * Sets the value of {@link ManagedPolicyProps#getPath}
         * @param path The path for the policy.
         *             This parameter allows (through its regex pattern) a string of characters
         *             consisting of either a forward slash (/) by itself or a string that must begin and end with forward slashes.
         *             In addition, it can contain any ASCII character from the ! (\u0021) through the DEL character (\u007F),
         *             including most punctuation characters, digits, and upper and lowercased letters.
         *             <p>
         *             For more information about paths, see IAM Identifiers in the IAM User Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of {@link ManagedPolicyProps#getRoles}
         * @param roles Roles to attach this policy to.
         *              You can also use <code>attachToRole(role)</code> to attach this policy to a role.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder roles(java.util.List<? extends software.amazon.awscdk.services.iam.IRole> roles) {
            this.roles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)roles;
            return this;
        }

        /**
         * Sets the value of {@link ManagedPolicyProps#getStatements}
         * @param statements Initial set of permissions to add to this policy document.
         *                   You can also use <code>addPermission(statement)</code> to add permissions later.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder statements(java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> statements) {
            this.statements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)statements;
            return this;
        }

        /**
         * Sets the value of {@link ManagedPolicyProps#getUsers}
         * @param users Users to attach this policy to.
         *              You can also use <code>attachToUser(user)</code> to attach this policy to a user.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder users(java.util.List<? extends software.amazon.awscdk.services.iam.IUser> users) {
            this.users = (java.util.List<software.amazon.awscdk.services.iam.IUser>)users;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ManagedPolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ManagedPolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ManagedPolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ManagedPolicyProps {
        private final java.lang.String description;
        private final software.amazon.awscdk.services.iam.PolicyDocument document;
        private final java.util.List<software.amazon.awscdk.services.iam.IGroup> groups;
        private final java.lang.String managedPolicyName;
        private final java.lang.String path;
        private final java.util.List<software.amazon.awscdk.services.iam.IRole> roles;
        private final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> statements;
        private final java.util.List<software.amazon.awscdk.services.iam.IUser> users;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.document = software.amazon.jsii.Kernel.get(this, "document", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.groups = software.amazon.jsii.Kernel.get(this, "groups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IGroup.class)));
            this.managedPolicyName = software.amazon.jsii.Kernel.get(this, "managedPolicyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.path = software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roles = software.amazon.jsii.Kernel.get(this, "roles", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class)));
            this.statements = software.amazon.jsii.Kernel.get(this, "statements", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class)));
            this.users = software.amazon.jsii.Kernel.get(this, "users", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IUser.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.description = builder.description;
            this.document = builder.document;
            this.groups = (java.util.List<software.amazon.awscdk.services.iam.IGroup>)builder.groups;
            this.managedPolicyName = builder.managedPolicyName;
            this.path = builder.path;
            this.roles = (java.util.List<software.amazon.awscdk.services.iam.IRole>)builder.roles;
            this.statements = (java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)builder.statements;
            this.users = (java.util.List<software.amazon.awscdk.services.iam.IUser>)builder.users;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getDocument() {
            return this.document;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IGroup> getGroups() {
            return this.groups;
        }

        @Override
        public final java.lang.String getManagedPolicyName() {
            return this.managedPolicyName;
        }

        @Override
        public final java.lang.String getPath() {
            return this.path;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IRole> getRoles() {
            return this.roles;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getStatements() {
            return this.statements;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.iam.IUser> getUsers() {
            return this.users;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDocument() != null) {
                data.set("document", om.valueToTree(this.getDocument()));
            }
            if (this.getGroups() != null) {
                data.set("groups", om.valueToTree(this.getGroups()));
            }
            if (this.getManagedPolicyName() != null) {
                data.set("managedPolicyName", om.valueToTree(this.getManagedPolicyName()));
            }
            if (this.getPath() != null) {
                data.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getRoles() != null) {
                data.set("roles", om.valueToTree(this.getRoles()));
            }
            if (this.getStatements() != null) {
                data.set("statements", om.valueToTree(this.getStatements()));
            }
            if (this.getUsers() != null) {
                data.set("users", om.valueToTree(this.getUsers()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iam.ManagedPolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ManagedPolicyProps.Jsii$Proxy that = (ManagedPolicyProps.Jsii$Proxy) o;

            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.document != null ? !this.document.equals(that.document) : that.document != null) return false;
            if (this.groups != null ? !this.groups.equals(that.groups) : that.groups != null) return false;
            if (this.managedPolicyName != null ? !this.managedPolicyName.equals(that.managedPolicyName) : that.managedPolicyName != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.roles != null ? !this.roles.equals(that.roles) : that.roles != null) return false;
            if (this.statements != null ? !this.statements.equals(that.statements) : that.statements != null) return false;
            return this.users != null ? this.users.equals(that.users) : that.users == null;
        }

        @Override
        public final int hashCode() {
            int result = this.description != null ? this.description.hashCode() : 0;
            result = 31 * result + (this.document != null ? this.document.hashCode() : 0);
            result = 31 * result + (this.groups != null ? this.groups.hashCode() : 0);
            result = 31 * result + (this.managedPolicyName != null ? this.managedPolicyName.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.roles != null ? this.roles.hashCode() : 0);
            result = 31 * result + (this.statements != null ? this.statements.hashCode() : 0);
            result = 31 * result + (this.users != null ? this.users.hashCode() : 0);
            return result;
        }
    }
}
