package software.amazon.awscdk.services.inspectorv2;

/**
 * Properties for defining a <code>CfnCisScanConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.inspectorv2.*;
 * Object oneTime;
 * CfnCisScanConfigurationProps cfnCisScanConfigurationProps = CfnCisScanConfigurationProps.builder()
 *         .scanName("scanName")
 *         .schedule(ScheduleProperty.builder()
 *                 .daily(DailyScheduleProperty.builder()
 *                         .startTime(TimeProperty.builder()
 *                                 .timeOfDay("timeOfDay")
 *                                 .timeZone("timeZone")
 *                                 .build())
 *                         .build())
 *                 .monthly(MonthlyScheduleProperty.builder()
 *                         .day("day")
 *                         .startTime(TimeProperty.builder()
 *                                 .timeOfDay("timeOfDay")
 *                                 .timeZone("timeZone")
 *                                 .build())
 *                         .build())
 *                 .oneTime(oneTime)
 *                 .weekly(WeeklyScheduleProperty.builder()
 *                         .days(List.of("days"))
 *                         .startTime(TimeProperty.builder()
 *                                 .timeOfDay("timeOfDay")
 *                                 .timeZone("timeZone")
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .securityLevel("securityLevel")
 *         .targets(CisTargetsProperty.builder()
 *                 .accountIds(List.of("accountIds"))
 *                 .targetResourceTags(Map.of(
 *                         "targetResourceTagsKey", List.of("targetResourceTags")))
 *                 .build())
 *         // the properties below are optional
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:18.070Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_inspectorv2.CfnCisScanConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnCisScanConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnCisScanConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the CIS scan configuration.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-scanname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-scanname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getScanName();

    /**
     * The CIS scan configuration's schedule.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-schedule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-schedule</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSchedule();

    /**
     * The CIS scan configuration's CIS Benchmark level.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-securitylevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-securitylevel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getSecurityLevel();

    /**
     * The CIS scan configuration's targets.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-targets">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-targets</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getTargets();

    /**
     * The CIS scan configuration's tags.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-inspectorv2-cisscanconfiguration.html#cfn-inspectorv2-cisscanconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnCisScanConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnCisScanConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnCisScanConfigurationProps> {
        java.lang.String scanName;
        java.lang.Object schedule;
        java.lang.String securityLevel;
        java.lang.Object targets;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnCisScanConfigurationProps#getScanName}
         * @param scanName The name of the CIS scan configuration. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scanName(java.lang.String scanName) {
            this.scanName = scanName;
            return this;
        }

        /**
         * Sets the value of {@link CfnCisScanConfigurationProps#getSchedule}
         * @param schedule The CIS scan configuration's schedule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.IResolvable schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCisScanConfigurationProps#getSchedule}
         * @param schedule The CIS scan configuration's schedule. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.ScheduleProperty schedule) {
            this.schedule = schedule;
            return this;
        }

        /**
         * Sets the value of {@link CfnCisScanConfigurationProps#getSecurityLevel}
         * @param securityLevel The CIS scan configuration's CIS Benchmark level. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityLevel(java.lang.String securityLevel) {
            this.securityLevel = securityLevel;
            return this;
        }

        /**
         * Sets the value of {@link CfnCisScanConfigurationProps#getTargets}
         * @param targets The CIS scan configuration's targets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.IResolvable targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnCisScanConfigurationProps#getTargets}
         * @param targets The CIS scan configuration's targets. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder targets(software.amazon.awscdk.services.inspectorv2.CfnCisScanConfiguration.CisTargetsProperty targets) {
            this.targets = targets;
            return this;
        }

        /**
         * Sets the value of {@link CfnCisScanConfigurationProps#getTags}
         * @param tags The CIS scan configuration's tags.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnCisScanConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnCisScanConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnCisScanConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnCisScanConfigurationProps {
        private final java.lang.String scanName;
        private final java.lang.Object schedule;
        private final java.lang.String securityLevel;
        private final java.lang.Object targets;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.scanName = software.amazon.jsii.Kernel.get(this, "scanName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.schedule = software.amazon.jsii.Kernel.get(this, "schedule", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.securityLevel = software.amazon.jsii.Kernel.get(this, "securityLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.targets = software.amazon.jsii.Kernel.get(this, "targets", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.scanName = java.util.Objects.requireNonNull(builder.scanName, "scanName is required");
            this.schedule = java.util.Objects.requireNonNull(builder.schedule, "schedule is required");
            this.securityLevel = java.util.Objects.requireNonNull(builder.securityLevel, "securityLevel is required");
            this.targets = java.util.Objects.requireNonNull(builder.targets, "targets is required");
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getScanName() {
            return this.scanName;
        }

        @Override
        public final java.lang.Object getSchedule() {
            return this.schedule;
        }

        @Override
        public final java.lang.String getSecurityLevel() {
            return this.securityLevel;
        }

        @Override
        public final java.lang.Object getTargets() {
            return this.targets;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("scanName", om.valueToTree(this.getScanName()));
            data.set("schedule", om.valueToTree(this.getSchedule()));
            data.set("securityLevel", om.valueToTree(this.getSecurityLevel()));
            data.set("targets", om.valueToTree(this.getTargets()));
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_inspectorv2.CfnCisScanConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnCisScanConfigurationProps.Jsii$Proxy that = (CfnCisScanConfigurationProps.Jsii$Proxy) o;

            if (!scanName.equals(that.scanName)) return false;
            if (!schedule.equals(that.schedule)) return false;
            if (!securityLevel.equals(that.securityLevel)) return false;
            if (!targets.equals(that.targets)) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.scanName.hashCode();
            result = 31 * result + (this.schedule.hashCode());
            result = 31 * result + (this.securityLevel.hashCode());
            result = 31 * result + (this.targets.hashCode());
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
