package software.amazon.awscdk.services.iot;

/**
 * Properties for defining a <code>CfnThingType</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.iot.*;
 * CfnThingTypeProps cfnThingTypeProps = CfnThingTypeProps.builder()
 *         .deprecateThingType(false)
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .thingTypeName("thingTypeName")
 *         .thingTypeProperties(ThingTypePropertiesProperty.builder()
 *                 .mqtt5Configuration(Mqtt5ConfigurationProperty.builder()
 *                         .propagatingAttributes(List.of(PropagatingAttributeProperty.builder()
 *                                 .userPropertyKey("userPropertyKey")
 *                                 // the properties below are optional
 *                                 .connectionAttribute("connectionAttribute")
 *                                 .thingAttribute("thingAttribute")
 *                                 .build()))
 *                         .build())
 *                 .searchableAttributes(List.of("searchableAttributes"))
 *                 .thingTypeDescription("thingTypeDescription")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:18.197Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_iot.CfnThingTypeProps")
@software.amazon.jsii.Jsii.Proxy(CfnThingTypeProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnThingTypeProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Deprecates a thing type. You can not associate new things with deprecated thing type.
     * <p>
     * Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-deprecatethingtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-deprecatethingtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeprecateThingType() {
        return null;
    }

    /**
     * Metadata which can be used to manage the thing type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the thing type.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypename</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getThingTypeName() {
        return null;
    }

    /**
     * The thing type properties for the thing type to create.
     * <p>
     * It contains information about the new thing type including a description, a list of searchable thing attribute names, and a list of propagating attributes. After a thing type is created, you can only update <code>Mqtt5Configuration</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypeproperties">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iot-thingtype.html#cfn-iot-thingtype-thingtypeproperties</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getThingTypeProperties() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnThingTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnThingTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnThingTypeProps> {
        java.lang.Object deprecateThingType;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String thingTypeName;
        java.lang.Object thingTypeProperties;

        /**
         * Sets the value of {@link CfnThingTypeProps#getDeprecateThingType}
         * @param deprecateThingType Deprecates a thing type. You can not associate new things with deprecated thing type.
         *                           Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecateThingType(java.lang.Boolean deprecateThingType) {
            this.deprecateThingType = deprecateThingType;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingTypeProps#getDeprecateThingType}
         * @param deprecateThingType Deprecates a thing type. You can not associate new things with deprecated thing type.
         *                           Requires permission to access the <a href="https://docs.aws.amazon.com//service-authorization/latest/reference/list_awsiot.html#awsiot-actions-as-permissions">DeprecateThingType</a> action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deprecateThingType(software.amazon.awscdk.IResolvable deprecateThingType) {
            this.deprecateThingType = deprecateThingType;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingTypeProps#getTags}
         * @param tags Metadata which can be used to manage the thing type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingTypeProps#getThingTypeName}
         * @param thingTypeName The name of the thing type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeName(java.lang.String thingTypeName) {
            this.thingTypeName = thingTypeName;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingTypeProps#getThingTypeProperties}
         * @param thingTypeProperties The thing type properties for the thing type to create.
         *                            It contains information about the new thing type including a description, a list of searchable thing attribute names, and a list of propagating attributes. After a thing type is created, you can only update <code>Mqtt5Configuration</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeProperties(software.amazon.awscdk.IResolvable thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        /**
         * Sets the value of {@link CfnThingTypeProps#getThingTypeProperties}
         * @param thingTypeProperties The thing type properties for the thing type to create.
         *                            It contains information about the new thing type including a description, a list of searchable thing attribute names, and a list of propagating attributes. After a thing type is created, you can only update <code>Mqtt5Configuration</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thingTypeProperties(software.amazon.awscdk.services.iot.CfnThingType.ThingTypePropertiesProperty thingTypeProperties) {
            this.thingTypeProperties = thingTypeProperties;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnThingTypeProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnThingTypeProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnThingTypeProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnThingTypeProps {
        private final java.lang.Object deprecateThingType;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String thingTypeName;
        private final java.lang.Object thingTypeProperties;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.deprecateThingType = software.amazon.jsii.Kernel.get(this, "deprecateThingType", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.thingTypeName = software.amazon.jsii.Kernel.get(this, "thingTypeName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.thingTypeProperties = software.amazon.jsii.Kernel.get(this, "thingTypeProperties", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.deprecateThingType = builder.deprecateThingType;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.thingTypeName = builder.thingTypeName;
            this.thingTypeProperties = builder.thingTypeProperties;
        }

        @Override
        public final java.lang.Object getDeprecateThingType() {
            return this.deprecateThingType;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getThingTypeName() {
            return this.thingTypeName;
        }

        @Override
        public final java.lang.Object getThingTypeProperties() {
            return this.thingTypeProperties;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDeprecateThingType() != null) {
                data.set("deprecateThingType", om.valueToTree(this.getDeprecateThingType()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThingTypeName() != null) {
                data.set("thingTypeName", om.valueToTree(this.getThingTypeName()));
            }
            if (this.getThingTypeProperties() != null) {
                data.set("thingTypeProperties", om.valueToTree(this.getThingTypeProperties()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_iot.CfnThingTypeProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnThingTypeProps.Jsii$Proxy that = (CfnThingTypeProps.Jsii$Proxy) o;

            if (this.deprecateThingType != null ? !this.deprecateThingType.equals(that.deprecateThingType) : that.deprecateThingType != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.thingTypeName != null ? !this.thingTypeName.equals(that.thingTypeName) : that.thingTypeName != null) return false;
            return this.thingTypeProperties != null ? this.thingTypeProperties.equals(that.thingTypeProperties) : that.thingTypeProperties == null;
        }

        @Override
        public final int hashCode() {
            int result = this.deprecateThingType != null ? this.deprecateThingType.hashCode() : 0;
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.thingTypeName != null ? this.thingTypeName.hashCode() : 0);
            result = 31 * result + (this.thingTypeProperties != null ? this.thingTypeProperties.hashCode() : 0);
            return result;
        }
    }
}
