package software.amazon.awscdk.services.ivs;

/**
 * Properties for defining a <code>CfnRecordingConfiguration</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ivs.*;
 * CfnRecordingConfigurationProps cfnRecordingConfigurationProps = CfnRecordingConfigurationProps.builder()
 *         .destinationConfiguration(DestinationConfigurationProperty.builder()
 *                 .s3(S3DestinationConfigurationProperty.builder()
 *                         .bucketName("bucketName")
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .name("name")
 *         .recordingReconnectWindowSeconds(123)
 *         .renditionConfiguration(RenditionConfigurationProperty.builder()
 *                 .renditions(List.of("renditions"))
 *                 .renditionSelection("renditionSelection")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .thumbnailConfiguration(ThumbnailConfigurationProperty.builder()
 *                 .recordingMode("recordingMode")
 *                 .resolution("resolution")
 *                 .storage(List.of("storage"))
 *                 .targetIntervalSeconds(123)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:18.562Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ivs.CfnRecordingConfigurationProps")
@software.amazon.jsii.Jsii.Proxy(CfnRecordingConfigurationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnRecordingConfigurationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A destination configuration describes an S3 bucket where recorded video will be stored.
     * <p>
     * See the DestinationConfiguration property type for more information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-destinationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-destinationconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getDestinationConfiguration();

    /**
     * Recording-configuration name.
     * <p>
     * The value does not need to be unique.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together.
     * <p>
     * <em>Default</em> : <code>0</code>
     * <p>
     * Default: - 0
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-recordingreconnectwindowseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-recordingreconnectwindowseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getRecordingReconnectWindowSeconds() {
        return null;
    }

    /**
     * A rendition configuration describes which renditions should be recorded for a stream.
     * <p>
     * See the RenditionConfiguration property type for more information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-renditionconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-renditionconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRenditionConfiguration() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-recordingconfiguration-tag.html">Tag</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * A thumbnail configuration enables/disables the recording of thumbnails for a live session and controls the interval at which thumbnails are generated for the live session.
     * <p>
     * See the ThumbnailConfiguration property type for more information.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-thumbnailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ivs-recordingconfiguration.html#cfn-ivs-recordingconfiguration-thumbnailconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getThumbnailConfiguration() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnRecordingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnRecordingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnRecordingConfigurationProps> {
        java.lang.Object destinationConfiguration;
        java.lang.String name;
        java.lang.Number recordingReconnectWindowSeconds;
        java.lang.Object renditionConfiguration;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.Object thumbnailConfiguration;

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getDestinationConfiguration}
         * @param destinationConfiguration A destination configuration describes an S3 bucket where recorded video will be stored. This parameter is required.
         *                                 See the DestinationConfiguration property type for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfiguration(software.amazon.awscdk.IResolvable destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getDestinationConfiguration}
         * @param destinationConfiguration A destination configuration describes an S3 bucket where recorded video will be stored. This parameter is required.
         *                                 See the DestinationConfiguration property type for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder destinationConfiguration(software.amazon.awscdk.services.ivs.CfnRecordingConfiguration.DestinationConfigurationProperty destinationConfiguration) {
            this.destinationConfiguration = destinationConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getName}
         * @param name Recording-configuration name.
         *             The value does not need to be unique.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getRecordingReconnectWindowSeconds}
         * @param recordingReconnectWindowSeconds If a broadcast disconnects and then reconnects within the specified interval, the multiple streams will be considered a single broadcast and merged together.
         *                                        <em>Default</em> : <code>0</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recordingReconnectWindowSeconds(java.lang.Number recordingReconnectWindowSeconds) {
            this.recordingReconnectWindowSeconds = recordingReconnectWindowSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getRenditionConfiguration}
         * @param renditionConfiguration A rendition configuration describes which renditions should be recorded for a stream.
         *                               See the RenditionConfiguration property type for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renditionConfiguration(software.amazon.awscdk.IResolvable renditionConfiguration) {
            this.renditionConfiguration = renditionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getRenditionConfiguration}
         * @param renditionConfiguration A rendition configuration describes which renditions should be recorded for a stream.
         *                               See the RenditionConfiguration property type for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder renditionConfiguration(software.amazon.awscdk.services.ivs.CfnRecordingConfiguration.RenditionConfigurationProperty renditionConfiguration) {
            this.renditionConfiguration = renditionConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         *             For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ivs-recordingconfiguration-tag.html">Tag</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getThumbnailConfiguration}
         * @param thumbnailConfiguration A thumbnail configuration enables/disables the recording of thumbnails for a live session and controls the interval at which thumbnails are generated for the live session.
         *                               See the ThumbnailConfiguration property type for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thumbnailConfiguration(software.amazon.awscdk.IResolvable thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnRecordingConfigurationProps#getThumbnailConfiguration}
         * @param thumbnailConfiguration A thumbnail configuration enables/disables the recording of thumbnails for a live session and controls the interval at which thumbnails are generated for the live session.
         *                               See the ThumbnailConfiguration property type for more information.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder thumbnailConfiguration(software.amazon.awscdk.services.ivs.CfnRecordingConfiguration.ThumbnailConfigurationProperty thumbnailConfiguration) {
            this.thumbnailConfiguration = thumbnailConfiguration;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnRecordingConfigurationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnRecordingConfigurationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnRecordingConfigurationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnRecordingConfigurationProps {
        private final java.lang.Object destinationConfiguration;
        private final java.lang.String name;
        private final java.lang.Number recordingReconnectWindowSeconds;
        private final java.lang.Object renditionConfiguration;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.Object thumbnailConfiguration;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinationConfiguration = software.amazon.jsii.Kernel.get(this, "destinationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.recordingReconnectWindowSeconds = software.amazon.jsii.Kernel.get(this, "recordingReconnectWindowSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.renditionConfiguration = software.amazon.jsii.Kernel.get(this, "renditionConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.thumbnailConfiguration = software.amazon.jsii.Kernel.get(this, "thumbnailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinationConfiguration = java.util.Objects.requireNonNull(builder.destinationConfiguration, "destinationConfiguration is required");
            this.name = builder.name;
            this.recordingReconnectWindowSeconds = builder.recordingReconnectWindowSeconds;
            this.renditionConfiguration = builder.renditionConfiguration;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.thumbnailConfiguration = builder.thumbnailConfiguration;
        }

        @Override
        public final java.lang.Object getDestinationConfiguration() {
            return this.destinationConfiguration;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Number getRecordingReconnectWindowSeconds() {
            return this.recordingReconnectWindowSeconds;
        }

        @Override
        public final java.lang.Object getRenditionConfiguration() {
            return this.renditionConfiguration;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getThumbnailConfiguration() {
            return this.thumbnailConfiguration;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinationConfiguration", om.valueToTree(this.getDestinationConfiguration()));
            if (this.getName() != null) {
                data.set("name", om.valueToTree(this.getName()));
            }
            if (this.getRecordingReconnectWindowSeconds() != null) {
                data.set("recordingReconnectWindowSeconds", om.valueToTree(this.getRecordingReconnectWindowSeconds()));
            }
            if (this.getRenditionConfiguration() != null) {
                data.set("renditionConfiguration", om.valueToTree(this.getRenditionConfiguration()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getThumbnailConfiguration() != null) {
                data.set("thumbnailConfiguration", om.valueToTree(this.getThumbnailConfiguration()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ivs.CfnRecordingConfigurationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnRecordingConfigurationProps.Jsii$Proxy that = (CfnRecordingConfigurationProps.Jsii$Proxy) o;

            if (!destinationConfiguration.equals(that.destinationConfiguration)) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.recordingReconnectWindowSeconds != null ? !this.recordingReconnectWindowSeconds.equals(that.recordingReconnectWindowSeconds) : that.recordingReconnectWindowSeconds != null) return false;
            if (this.renditionConfiguration != null ? !this.renditionConfiguration.equals(that.renditionConfiguration) : that.renditionConfiguration != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.thumbnailConfiguration != null ? this.thumbnailConfiguration.equals(that.thumbnailConfiguration) : that.thumbnailConfiguration == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinationConfiguration.hashCode();
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.recordingReconnectWindowSeconds != null ? this.recordingReconnectWindowSeconds.hashCode() : 0);
            result = 31 * result + (this.renditionConfiguration != null ? this.renditionConfiguration.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.thumbnailConfiguration != null ? this.thumbnailConfiguration.hashCode() : 0);
            return result;
        }
    }
}
