package software.amazon.awscdk.services.kinesis;

/**
 * Properties to associate a data stream with a policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Stream stream = new Stream(this, "MyStream");
 * StreamConsumer streamConsumer = StreamConsumer.Builder.create(this, "MyStreamConsumer")
 *         .streamConsumerName("MyStreamConsumer")
 *         .stream(stream)
 *         .build();
 * // create a custom policy document
 * PolicyDocument policyDocument = PolicyDocument.Builder.create()
 *         .assignSids(true)
 *         .statements(List.of(
 *             PolicyStatement.Builder.create()
 *                     .actions(List.of("kinesis:GetRecords"))
 *                     .resources(List.of(stream.getStreamArn()))
 *                     .principals(List.of(new AnyPrincipal()))
 *                     .build()))
 *         .build();
 * // create a stream resource policy manually
 * // create a stream resource policy manually
 * ResourcePolicy.Builder.create(this, "ResourcePolicy")
 *         .stream(stream)
 *         .policyDocument(policyDocument)
 *         .build();
 * // create a stream consumer resource policy manually
 * // create a stream consumer resource policy manually
 * ResourcePolicy.Builder.create(this, "ResourcePolicy")
 *         .streamConsumer(streamConsumer)
 *         .policyDocument(policyDocument)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:18.709Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesis.ResourcePolicyProps")
@software.amazon.jsii.Jsii.Proxy(ResourcePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ResourcePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * IAM policy document to apply to a data stream.
     * <p>
     * Default: - empty policy document
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
        return null;
    }

    /**
     * The stream this policy applies to.
     * <p>
     * Note: only one of <code>stream</code> and <code>streamConsumer</code> must be set.
     * <p>
     * Default: - policy is not associated to a stream
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.IStream getStream() {
        return null;
    }

    /**
     * The stream consumer this policy applies to.
     * <p>
     * Note: only one of <code>stream</code> and <code>streamConsumer</code> must be set.
     * <p>
     * Default: - policy is not associated to a consumer
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kinesis.IStreamConsumer getStreamConsumer() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ResourcePolicyProps> {
        software.amazon.awscdk.services.iam.PolicyDocument policyDocument;
        software.amazon.awscdk.services.kinesis.IStream stream;
        software.amazon.awscdk.services.kinesis.IStreamConsumer streamConsumer;

        /**
         * Sets the value of {@link ResourcePolicyProps#getPolicyDocument}
         * @param policyDocument IAM policy document to apply to a data stream.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyDocument(software.amazon.awscdk.services.iam.PolicyDocument policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyProps#getStream}
         * @param stream The stream this policy applies to.
         *               Note: only one of <code>stream</code> and <code>streamConsumer</code> must be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stream(software.amazon.awscdk.services.kinesis.IStream stream) {
            this.stream = stream;
            return this;
        }

        /**
         * Sets the value of {@link ResourcePolicyProps#getStreamConsumer}
         * @param streamConsumer The stream consumer this policy applies to.
         *                       Note: only one of <code>stream</code> and <code>streamConsumer</code> must be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder streamConsumer(software.amazon.awscdk.services.kinesis.IStreamConsumer streamConsumer) {
            this.streamConsumer = streamConsumer;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ResourcePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ResourcePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ResourcePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourcePolicyProps {
        private final software.amazon.awscdk.services.iam.PolicyDocument policyDocument;
        private final software.amazon.awscdk.services.kinesis.IStream stream;
        private final software.amazon.awscdk.services.kinesis.IStreamConsumer streamConsumer;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.policyDocument = software.amazon.jsii.Kernel.get(this, "policyDocument", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyDocument.class));
            this.stream = software.amazon.jsii.Kernel.get(this, "stream", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStream.class));
            this.streamConsumer = software.amazon.jsii.Kernel.get(this, "streamConsumer", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kinesis.IStreamConsumer.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.policyDocument = builder.policyDocument;
            this.stream = builder.stream;
            this.streamConsumer = builder.streamConsumer;
        }

        @Override
        public final software.amazon.awscdk.services.iam.PolicyDocument getPolicyDocument() {
            return this.policyDocument;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStream getStream() {
            return this.stream;
        }

        @Override
        public final software.amazon.awscdk.services.kinesis.IStreamConsumer getStreamConsumer() {
            return this.streamConsumer;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPolicyDocument() != null) {
                data.set("policyDocument", om.valueToTree(this.getPolicyDocument()));
            }
            if (this.getStream() != null) {
                data.set("stream", om.valueToTree(this.getStream()));
            }
            if (this.getStreamConsumer() != null) {
                data.set("streamConsumer", om.valueToTree(this.getStreamConsumer()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_kinesis.ResourcePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ResourcePolicyProps.Jsii$Proxy that = (ResourcePolicyProps.Jsii$Proxy) o;

            if (this.policyDocument != null ? !this.policyDocument.equals(that.policyDocument) : that.policyDocument != null) return false;
            if (this.stream != null ? !this.stream.equals(that.stream) : that.stream != null) return false;
            return this.streamConsumer != null ? this.streamConsumer.equals(that.streamConsumer) : that.streamConsumer == null;
        }

        @Override
        public final int hashCode() {
            int result = this.policyDocument != null ? this.policyDocument.hashCode() : 0;
            result = 31 * result + (this.stream != null ? this.stream.hashCode() : 0);
            result = 31 * result + (this.streamConsumer != null ? this.streamConsumer.hashCode() : 0);
            return result;
        }
    }
}
