package software.amazon.awscdk.services.kinesisfirehose;

/**
 * Disables logging for error logs.
 * <p>
 * When this class is used, logging is disabled (<code>logging: false</code>)
 * and no CloudWatch log group can be specified.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket bucket;
 * S3Bucket destination = S3Bucket.Builder.create(bucket)
 *         .loggingConfig(new DisableLogging())
 *         .build();
 * DeliveryStream.Builder.create(this, "Delivery Stream")
 *         .destination(destination)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:18.919Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_kinesisfirehose.DisableLogging")
public class DisableLogging extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.kinesisfirehose.ILoggingConfig {

    protected DisableLogging(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DisableLogging(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DisableLogging() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * If true, log errors when data transformation or data delivery fails.
     * <p>
     * <code>true</code> when using <code>EnableLogging</code>, <code>false</code> when using <code>DisableLogging</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Boolean getLogging() {
        return software.amazon.jsii.Kernel.get(this, "logging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }
}
