package software.amazon.awscdk.services.lambda;

/**
 * Specific schema validation configuration settings that tell Lambda the message attributes you want to validate and filter using your schema registry.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.lambda.*;
 * KafkaSchemaValidationAttribute kafkaSchemaValidationAttribute;
 * KafkaSchemaValidationConfig kafkaSchemaValidationConfig = KafkaSchemaValidationConfig.builder()
 *         .attribute(kafkaSchemaValidationAttribute)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:19.207Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.KafkaSchemaValidationConfig")
@software.amazon.jsii.Jsii.Proxy(KafkaSchemaValidationConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface KafkaSchemaValidationConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The attributes you want your schema registry to validate and filter for.
     * <p>
     * If you selected JSON as the EventRecordFormat, Lambda also deserializes the selected message attributes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute getAttribute();

    /**
     * @return a {@link Builder} of {@link KafkaSchemaValidationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link KafkaSchemaValidationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<KafkaSchemaValidationConfig> {
        software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute attribute;

        /**
         * Sets the value of {@link KafkaSchemaValidationConfig#getAttribute}
         * @param attribute The attributes you want your schema registry to validate and filter for. This parameter is required.
         *                  If you selected JSON as the EventRecordFormat, Lambda also deserializes the selected message attributes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder attribute(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute attribute) {
            this.attribute = attribute;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link KafkaSchemaValidationConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public KafkaSchemaValidationConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link KafkaSchemaValidationConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KafkaSchemaValidationConfig {
        private final software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute attribute;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.attribute = software.amazon.jsii.Kernel.get(this, "attribute", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.attribute = java.util.Objects.requireNonNull(builder.attribute, "attribute is required");
        }

        @Override
        public final software.amazon.awscdk.services.lambda.KafkaSchemaValidationAttribute getAttribute() {
            return this.attribute;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("attribute", om.valueToTree(this.getAttribute()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_lambda.KafkaSchemaValidationConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            KafkaSchemaValidationConfig.Jsii$Proxy that = (KafkaSchemaValidationConfig.Jsii$Proxy) o;

            return this.attribute.equals(that.attribute);
        }

        @Override
        public final int hashCode() {
            int result = this.attribute.hashCode();
            return result;
        }
    }
}
