package software.amazon.awscdk.services.lambda;

/**
 * The position in the DynamoDB, Kinesis or MSK stream where AWS Lambda should start reading.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.kms.Key;
 * Function myFunction;
 * // Your MSK cluster arn
 * String clusterArn = "arn:aws:kafka:us-east-1:0123456789019:cluster/SalesCluster/abcd1234-abcd-cafe-abab-9876543210ab-4";
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * // Your self managed KMS key
 * IKey myKey = Key.fromKeyArn(this, "SourceBucketEncryptionKey", "arn:aws:kms:us-east-1:123456789012:key/&lt;key-id&gt;");
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .filters(List.of(FilterCriteria.filter(Map.of(
 *                 "stringEquals", FilterRule.isEqual("test")))))
 *         .filterEncryption(myKey)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:19.241Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda.StartingPosition")
public enum StartingPosition {
    /**
     * Start reading at the last untrimmed record in the shard in the system, which is the oldest data record in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    TRIM_HORIZON,
    /**
     * Start reading just after the most recent record in the shard, so that you always read the most recent data in the shard.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    LATEST,
    /**
     * Start reading from a position defined by a time stamp.
     * <p>
     * Only supported for Amazon Kinesis streams, otherwise an error will occur.
     * If supplied, <code>startingPositionTimestamp</code> must also be set.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    AT_TIMESTAMP,
}
