package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Glue schema registry configuration for a Lambda event source.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.glue.CfnRegistry;
 * import software.amazon.awscdk.services.lambda.eventsources.ManagedKafkaEventSource;
 * import software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistry;
 * // Your MSK cluster arn
 * String clusterArn;
 * Function myFunction;
 * // The Kafka topic you want to subscribe to
 * String topic = "some-cool-topic";
 * // Your Glue Schema Registry
 * CfnRegistry glueRegistry = CfnRegistry.Builder.create(this, "Registry")
 *         .name("schema-registry")
 *         .description("Schema registry for event source")
 *         .build();
 * myFunction.addEventSource(ManagedKafkaEventSource.Builder.create()
 *         .clusterArn(clusterArn)
 *         .topic(topic)
 *         .startingPosition(StartingPosition.TRIM_HORIZON)
 *         .provisionedPollerConfig(ProvisionedPollerConfig.builder()
 *                 .minimumPollers(1)
 *                 .maximumPollers(3)
 *                 .build())
 *         .schemaRegistryConfig(GlueSchemaRegistry.Builder.create()
 *                 .schemaRegistry(glueRegistry)
 *                 .eventRecordFormat(EventRecordFormat.JSON)
 *                 .schemaValidationConfigs(List.of(KafkaSchemaValidationConfig.builder().attribute(KafkaSchemaValidationAttribute.KEY).build()))
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:19.261Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_lambda_event_sources.GlueSchemaRegistry")
public class GlueSchemaRegistry extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.ISchemaRegistry {

    protected GlueSchemaRegistry(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected GlueSchemaRegistry(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public GlueSchemaRegistry(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistryProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Returns a schema registry configuration.
     * <p>
     * @param _target This parameter is required.
     * @param targetHandler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.KafkaSchemaRegistryConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IEventSourceMapping _target, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction targetHandler) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.KafkaSchemaRegistryConfig.class), new Object[] { java.util.Objects.requireNonNull(_target, "_target is required"), java.util.Objects.requireNonNull(targetHandler, "targetHandler is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistry}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistry> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistryProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistryProps.Builder();
        }

        /**
         * The record format that Lambda delivers to your function after schema validation.
         * <p>
         * <ul>
         * <li>Choose JSON to have Lambda deliver the record to your function as a standard JSON object.</li>
         * <li>Choose SOURCE to have Lambda deliver the record to your function in its original source format. Lambda removes all schema metadata, such as the schema ID, before sending the record to your function.</li>
         * </ul>
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param eventRecordFormat The record format that Lambda delivers to your function after schema validation. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventRecordFormat(final software.amazon.awscdk.services.lambda.EventRecordFormat eventRecordFormat) {
            this.props.eventRecordFormat(eventRecordFormat);
            return this;
        }

        /**
         * An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param schemaValidationConfigs An array of schema validation configuration objects, which tell Lambda the message attributes you want to validate and filter using your schema registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaValidationConfigs(final java.util.List<? extends software.amazon.awscdk.services.lambda.KafkaSchemaValidationConfig> schemaValidationConfigs) {
            this.props.schemaValidationConfigs(schemaValidationConfigs);
            return this;
        }

        /**
         * The CfnRegistry reference of your glue schema registry.
         * <p>
         * If used, schemaRegistryArn will be ignored.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param schemaRegistry The CfnRegistry reference of your glue schema registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistry(final software.amazon.awscdk.services.glue.CfnRegistry schemaRegistry) {
            this.props.schemaRegistry(schemaRegistry);
            return this;
        }

        /**
         * The Arn of your glue schema registry.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param schemaRegistryArn The Arn of your glue schema registry. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schemaRegistryArn(final java.lang.String schemaRegistryArn) {
            this.props.schemaRegistryArn(schemaRegistryArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistry}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistry build() {
            return new software.amazon.awscdk.services.lambda.eventsources.GlueSchemaRegistry(
                this.props.build()
            );
        }
    }
}
