package software.amazon.awscdk.services.location;

/**
 * Properties for defining a <code>CfnTracker</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.location.*;
 * CfnTrackerProps cfnTrackerProps = CfnTrackerProps.builder()
 *         .trackerName("trackerName")
 *         // the properties below are optional
 *         .description("description")
 *         .eventBridgeEnabled(false)
 *         .kmsKeyEnableGeospatialQueries(false)
 *         .kmsKeyId("kmsKeyId")
 *         .positionFiltering("positionFiltering")
 *         .pricingPlan("pricingPlan")
 *         .pricingPlanDataSource("pricingPlanDataSource")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:19.534Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_location.CfnTrackerProps")
@software.amazon.jsii.Jsii.Proxy(CfnTrackerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnTrackerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name for the tracker resource.
     * <p>
     * Requirements:
     * <p>
     * <ul>
     * <li>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</li>
     * <li>Must be a unique tracker resource name.</li>
     * <li>No spaces allowed. For example, <code>ExampleTracker</code> .</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-trackername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-trackername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getTrackerName();

    /**
     * An optional description for the tracker resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-eventbridgeenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-eventbridgeenabled</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEventBridgeEnabled() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-kmskeyenablegeospatialqueries">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-kmskeyenablegeospatialqueries</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKmsKeyEnableGeospatialQueries() {
        return null;
    }

    /**
     * A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> . Enter a key ID, key ARN, alias name, or alias ARN.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-kmskeyid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return null;
    }

    /**
     * Specifies the position filtering for the tracker resource.
     * <p>
     * Valid values:
     * <p>
     * <ul>
     * <li><code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.</li>
     * <li><code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.</li>
     * <li><code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.</li>
     * </ul>
     * <p>
     * This field is optional. If not specified, the default value is <code>TimeBased</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-positionfiltering">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-positionfiltering</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPositionFiltering() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplan</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getPricingPlan() {
        return null;
    }

    /**
     * (deprecated) This shape is deprecated since 2022-02-01: Deprecated.
     * <p>
     * No longer allowed.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplandatasource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-pricingplandatasource</a>
     * @deprecated this property has been deprecated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getPricingPlanDataSource() {
        return null;
    }

    /**
     * An array of key-value pairs to apply to this resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-location-tracker.html#cfn-location-tracker-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnTrackerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnTrackerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnTrackerProps> {
        java.lang.String trackerName;
        java.lang.String description;
        java.lang.Object eventBridgeEnabled;
        java.lang.Object kmsKeyEnableGeospatialQueries;
        java.lang.String kmsKeyId;
        java.lang.String positionFiltering;
        java.lang.String pricingPlan;
        java.lang.String pricingPlanDataSource;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnTrackerProps#getTrackerName}
         * @param trackerName The name for the tracker resource. This parameter is required.
         *                    Requirements:
         *                    <p>
         *                    <ul>
         *                    <li>Contain only alphanumeric characters (A-Z, a-z, 0-9) , hyphens (-), periods (.), and underscores (_).</li>
         *                    <li>Must be a unique tracker resource name.</li>
         *                    <li>No spaces allowed. For example, <code>ExampleTracker</code> .</li>
         *                    </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackerName(java.lang.String trackerName) {
            this.trackerName = trackerName;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getDescription}
         * @param description An optional description for the tracker resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getEventBridgeEnabled}
         * @param eventBridgeEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeEnabled(java.lang.Boolean eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getEventBridgeEnabled}
         * @param eventBridgeEnabled the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventBridgeEnabled(software.amazon.awscdk.IResolvable eventBridgeEnabled) {
            this.eventBridgeEnabled = eventBridgeEnabled;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getKmsKeyEnableGeospatialQueries}
         * @param kmsKeyEnableGeospatialQueries the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyEnableGeospatialQueries(java.lang.Boolean kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getKmsKeyEnableGeospatialQueries}
         * @param kmsKeyEnableGeospatialQueries the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyEnableGeospatialQueries(software.amazon.awscdk.IResolvable kmsKeyEnableGeospatialQueries) {
            this.kmsKeyEnableGeospatialQueries = kmsKeyEnableGeospatialQueries;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getKmsKeyId}
         * @param kmsKeyId A key identifier for an <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keys.html">AWS KMS customer managed key</a> . Enter a key ID, key ARN, alias name, or alias ARN.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(java.lang.String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getPositionFiltering}
         * @param positionFiltering Specifies the position filtering for the tracker resource.
         *                          Valid values:
         *                          <p>
         *                          <ul>
         *                          <li><code>TimeBased</code> - Location updates are evaluated against linked geofence collections, but not every location update is stored. If your update frequency is more often than 30 seconds, only one update per 30 seconds is stored for each unique device ID.</li>
         *                          <li><code>DistanceBased</code> - If the device has moved less than 30 m (98.4 ft), location updates are ignored. Location updates within this area are neither evaluated against linked geofence collections, nor stored. This helps control costs by reducing the number of geofence evaluations and historical device positions to paginate through. Distance-based filtering can also reduce the effects of GPS noise when displaying device trajectories on a map.</li>
         *                          <li><code>AccuracyBased</code> - If the device has moved less than the measured accuracy, location updates are ignored. For example, if two consecutive updates from a device have a horizontal accuracy of 5 m and 10 m, the second update is ignored if the device has moved less than 15 m. Ignored location updates are neither evaluated against linked geofence collections, nor stored. This can reduce the effects of GPS noise when displaying device trajectories on a map, and can help control your costs by reducing the number of geofence evaluations.</li>
         *                          </ul>
         *                          <p>
         *                          This field is optional. If not specified, the default value is <code>TimeBased</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder positionFiltering(java.lang.String positionFiltering) {
            this.positionFiltering = positionFiltering;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getPricingPlan}
         * @param pricingPlan the value to be set.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pricingPlan(java.lang.String pricingPlan) {
            this.pricingPlan = pricingPlan;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getPricingPlanDataSource}
         * @param pricingPlanDataSource This shape is deprecated since 2022-02-01: Deprecated.
         *                              No longer allowed.
         * @return {@code this}
         * @deprecated this property has been deprecated
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder pricingPlanDataSource(java.lang.String pricingPlanDataSource) {
            this.pricingPlanDataSource = pricingPlanDataSource;
            return this;
        }

        /**
         * Sets the value of {@link CfnTrackerProps#getTags}
         * @param tags An array of key-value pairs to apply to this resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnTrackerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnTrackerProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnTrackerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnTrackerProps {
        private final java.lang.String trackerName;
        private final java.lang.String description;
        private final java.lang.Object eventBridgeEnabled;
        private final java.lang.Object kmsKeyEnableGeospatialQueries;
        private final java.lang.String kmsKeyId;
        private final java.lang.String positionFiltering;
        private final java.lang.String pricingPlan;
        private final java.lang.String pricingPlanDataSource;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.trackerName = software.amazon.jsii.Kernel.get(this, "trackerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.eventBridgeEnabled = software.amazon.jsii.Kernel.get(this, "eventBridgeEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyEnableGeospatialQueries = software.amazon.jsii.Kernel.get(this, "kmsKeyEnableGeospatialQueries", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.positionFiltering = software.amazon.jsii.Kernel.get(this, "positionFiltering", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pricingPlan = software.amazon.jsii.Kernel.get(this, "pricingPlan", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pricingPlanDataSource = software.amazon.jsii.Kernel.get(this, "pricingPlanDataSource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.trackerName = java.util.Objects.requireNonNull(builder.trackerName, "trackerName is required");
            this.description = builder.description;
            this.eventBridgeEnabled = builder.eventBridgeEnabled;
            this.kmsKeyEnableGeospatialQueries = builder.kmsKeyEnableGeospatialQueries;
            this.kmsKeyId = builder.kmsKeyId;
            this.positionFiltering = builder.positionFiltering;
            this.pricingPlan = builder.pricingPlan;
            this.pricingPlanDataSource = builder.pricingPlanDataSource;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.lang.String getTrackerName() {
            return this.trackerName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.Object getEventBridgeEnabled() {
            return this.eventBridgeEnabled;
        }

        @Override
        public final java.lang.Object getKmsKeyEnableGeospatialQueries() {
            return this.kmsKeyEnableGeospatialQueries;
        }

        @Override
        public final java.lang.String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final java.lang.String getPositionFiltering() {
            return this.positionFiltering;
        }

        @Override
        public final java.lang.String getPricingPlan() {
            return this.pricingPlan;
        }

        @Override
        public final java.lang.String getPricingPlanDataSource() {
            return this.pricingPlanDataSource;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("trackerName", om.valueToTree(this.getTrackerName()));
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEventBridgeEnabled() != null) {
                data.set("eventBridgeEnabled", om.valueToTree(this.getEventBridgeEnabled()));
            }
            if (this.getKmsKeyEnableGeospatialQueries() != null) {
                data.set("kmsKeyEnableGeospatialQueries", om.valueToTree(this.getKmsKeyEnableGeospatialQueries()));
            }
            if (this.getKmsKeyId() != null) {
                data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
            }
            if (this.getPositionFiltering() != null) {
                data.set("positionFiltering", om.valueToTree(this.getPositionFiltering()));
            }
            if (this.getPricingPlan() != null) {
                data.set("pricingPlan", om.valueToTree(this.getPricingPlan()));
            }
            if (this.getPricingPlanDataSource() != null) {
                data.set("pricingPlanDataSource", om.valueToTree(this.getPricingPlanDataSource()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_location.CfnTrackerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnTrackerProps.Jsii$Proxy that = (CfnTrackerProps.Jsii$Proxy) o;

            if (!trackerName.equals(that.trackerName)) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.eventBridgeEnabled != null ? !this.eventBridgeEnabled.equals(that.eventBridgeEnabled) : that.eventBridgeEnabled != null) return false;
            if (this.kmsKeyEnableGeospatialQueries != null ? !this.kmsKeyEnableGeospatialQueries.equals(that.kmsKeyEnableGeospatialQueries) : that.kmsKeyEnableGeospatialQueries != null) return false;
            if (this.kmsKeyId != null ? !this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId != null) return false;
            if (this.positionFiltering != null ? !this.positionFiltering.equals(that.positionFiltering) : that.positionFiltering != null) return false;
            if (this.pricingPlan != null ? !this.pricingPlan.equals(that.pricingPlan) : that.pricingPlan != null) return false;
            if (this.pricingPlanDataSource != null ? !this.pricingPlanDataSource.equals(that.pricingPlanDataSource) : that.pricingPlanDataSource != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.trackerName.hashCode();
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.eventBridgeEnabled != null ? this.eventBridgeEnabled.hashCode() : 0);
            result = 31 * result + (this.kmsKeyEnableGeospatialQueries != null ? this.kmsKeyEnableGeospatialQueries.hashCode() : 0);
            result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
            result = 31 * result + (this.positionFiltering != null ? this.positionFiltering.hashCode() : 0);
            result = 31 * result + (this.pricingPlan != null ? this.pricingPlan.hashCode() : 0);
            result = 31 * result + (this.pricingPlanDataSource != null ? this.pricingPlanDataSource.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
