package software.amazon.awscdk.services.logs;

/**
 * Creates an integration between CloudWatch Logs and another service in this account.
 * <p>
 * Currently, only integrations with OpenSearch Service are supported, and currently you can have only one integration in your account.
 * <p>
 * Integrating with OpenSearch Service makes it possible for you to create curated vended logs dashboards, powered by OpenSearch Service analytics. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CloudWatchLogs-OpenSearch-Dashboards.html">Vended log dashboards powered by Amazon OpenSearch Service</a> .
 * <p>
 * You can use this operation only to create a new integration. You can't modify an existing integration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.logs.*;
 * CfnIntegration cfnIntegration = CfnIntegration.Builder.create(this, "MyCfnIntegration")
 *         .integrationName("integrationName")
 *         .integrationType("integrationType")
 *         .resourceConfig(ResourceConfigProperty.builder()
 *                 .openSearchResourceConfig(OpenSearchResourceConfigProperty.builder()
 *                         .dashboardViewerPrincipals(List.of("dashboardViewerPrincipals"))
 *                         .dataSourceRoleArn("dataSourceRoleArn")
 *                         // the properties below are optional
 *                         .applicationArn("applicationArn")
 *                         .kmsKeyArn("kmsKeyArn")
 *                         .retentionDays(123)
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:19.561Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnIntegration")
public class CfnIntegration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.logs.CfnIntegration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnIntegration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.CfnIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The current status of this integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIntegrationStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrIntegrationStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of this integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIntegrationName() {
        return software.amazon.jsii.Kernel.get(this, "integrationName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationName", java.util.Objects.requireNonNull(value, "integrationName is required"));
    }

    /**
     * The type of integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getIntegrationType() {
        return software.amazon.jsii.Kernel.get(this, "integrationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIntegrationType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "integrationType", java.util.Objects.requireNonNull(value, "integrationType is required"));
    }

    /**
     * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getResourceConfig() {
        return software.amazon.jsii.Kernel.get(this, "resourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "resourceConfig", java.util.Objects.requireNonNull(value, "resourceConfig is required"));
    }

    /**
     * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResourceConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.CfnIntegration.ResourceConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "resourceConfig", java.util.Objects.requireNonNull(value, "resourceConfig is required"));
    }
    /**
     * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * OpenSearchResourceConfigProperty openSearchResourceConfigProperty = OpenSearchResourceConfigProperty.builder()
     *         .dashboardViewerPrincipals(List.of("dashboardViewerPrincipals"))
     *         .dataSourceRoleArn("dataSourceRoleArn")
     *         // the properties below are optional
     *         .applicationArn("applicationArn")
     *         .kmsKeyArn("kmsKeyArn")
     *         .retentionDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnIntegration.OpenSearchResourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(OpenSearchResourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OpenSearchResourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards.
         * <p>
         * <blockquote>
         * <p>
         * In addition to specifying these users here, you must also grant them the <em>CloudWatchOpenSearchDashboardAccess</em> IAM policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html">IAM policies for users</a> .
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-dashboardviewerprincipals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-dashboardviewerprincipals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDashboardViewerPrincipals();

        /**
         * Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration.
         * <p>
         * This role must have the permissions necessary to access the OpenSearch Service collection to be able to create the dashboards. For more information about the permissions needed, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html">Permissions that the integration needs</a> in the CloudWatch Logs User Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-datasourcerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-datasourcerolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDataSourceRoleArn();

        /**
         * If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service, specify it here.
         * <p>
         * If you omit this, a new application will be created.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-applicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-applicationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getApplicationArn() {
            return null;
        }

        /**
         * To have the vended dashboard data encrypted with AWS KMS instead of the CloudWatch Logs default encryption method, specify the ARN of the AWS KMS key that you want to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-kmskeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-kmskeyarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyArn() {
            return null;
        }

        /**
         * Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that the dashboard refers to.
         * <p>
         * This also sets the maximum time period that you can choose when viewing data in the dashboard. Choosing a longer time frame will incur additional costs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-retentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-opensearchresourceconfig.html#cfn-logs-integration-opensearchresourceconfig-retentiondays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getRetentionDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OpenSearchResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OpenSearchResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OpenSearchResourceConfigProperty> {
            java.util.List<java.lang.String> dashboardViewerPrincipals;
            java.lang.String dataSourceRoleArn;
            java.lang.String applicationArn;
            java.lang.String kmsKeyArn;
            java.lang.Number retentionDays;

            /**
             * Sets the value of {@link OpenSearchResourceConfigProperty#getDashboardViewerPrincipals}
             * @param dashboardViewerPrincipals Specify the ARNs of IAM roles and IAM users who you want to grant permission to for viewing the dashboards. This parameter is required.
             *                                  <blockquote>
             *                                  <p>
             *                                  In addition to specifying these users here, you must also grant them the <em>CloudWatchOpenSearchDashboardAccess</em> IAM policy. For more information, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-UserRoles.html">IAM policies for users</a> .
             *                                  <p>
             *                                  </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dashboardViewerPrincipals(java.util.List<java.lang.String> dashboardViewerPrincipals) {
                this.dashboardViewerPrincipals = dashboardViewerPrincipals;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchResourceConfigProperty#getDataSourceRoleArn}
             * @param dataSourceRoleArn Specify the ARN of an IAM role that CloudWatch Logs will use to create the integration. This parameter is required.
             *                          This role must have the permissions necessary to access the OpenSearch Service collection to be able to create the dashboards. For more information about the permissions needed, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/OpenSearch-Dashboards-CreateRole.html">Permissions that the integration needs</a> in the CloudWatch Logs User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataSourceRoleArn(java.lang.String dataSourceRoleArn) {
                this.dataSourceRoleArn = dataSourceRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchResourceConfigProperty#getApplicationArn}
             * @param applicationArn If you want to use an existing OpenSearch Service application for your integration with OpenSearch Service, specify it here.
             *                       If you omit this, a new application will be created.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder applicationArn(java.lang.String applicationArn) {
                this.applicationArn = applicationArn;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchResourceConfigProperty#getKmsKeyArn}
             * @param kmsKeyArn To have the vended dashboard data encrypted with AWS KMS instead of the CloudWatch Logs default encryption method, specify the ARN of the AWS KMS key that you want to use.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyArn(java.lang.String kmsKeyArn) {
                this.kmsKeyArn = kmsKeyArn;
                return this;
            }

            /**
             * Sets the value of {@link OpenSearchResourceConfigProperty#getRetentionDays}
             * @param retentionDays Specify how many days that you want the data derived by OpenSearch Service to be retained in the index that the dashboard refers to.
             *                      This also sets the maximum time period that you can choose when viewing data in the dashboard. Choosing a longer time frame will incur additional costs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retentionDays(java.lang.Number retentionDays) {
                this.retentionDays = retentionDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OpenSearchResourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OpenSearchResourceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OpenSearchResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OpenSearchResourceConfigProperty {
            private final java.util.List<java.lang.String> dashboardViewerPrincipals;
            private final java.lang.String dataSourceRoleArn;
            private final java.lang.String applicationArn;
            private final java.lang.String kmsKeyArn;
            private final java.lang.Number retentionDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dashboardViewerPrincipals = software.amazon.jsii.Kernel.get(this, "dashboardViewerPrincipals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.dataSourceRoleArn = software.amazon.jsii.Kernel.get(this, "dataSourceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.applicationArn = software.amazon.jsii.Kernel.get(this, "applicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.kmsKeyArn = software.amazon.jsii.Kernel.get(this, "kmsKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.retentionDays = software.amazon.jsii.Kernel.get(this, "retentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dashboardViewerPrincipals = java.util.Objects.requireNonNull(builder.dashboardViewerPrincipals, "dashboardViewerPrincipals is required");
                this.dataSourceRoleArn = java.util.Objects.requireNonNull(builder.dataSourceRoleArn, "dataSourceRoleArn is required");
                this.applicationArn = builder.applicationArn;
                this.kmsKeyArn = builder.kmsKeyArn;
                this.retentionDays = builder.retentionDays;
            }

            @Override
            public final java.util.List<java.lang.String> getDashboardViewerPrincipals() {
                return this.dashboardViewerPrincipals;
            }

            @Override
            public final java.lang.String getDataSourceRoleArn() {
                return this.dataSourceRoleArn;
            }

            @Override
            public final java.lang.String getApplicationArn() {
                return this.applicationArn;
            }

            @Override
            public final java.lang.String getKmsKeyArn() {
                return this.kmsKeyArn;
            }

            @Override
            public final java.lang.Number getRetentionDays() {
                return this.retentionDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("dashboardViewerPrincipals", om.valueToTree(this.getDashboardViewerPrincipals()));
                data.set("dataSourceRoleArn", om.valueToTree(this.getDataSourceRoleArn()));
                if (this.getApplicationArn() != null) {
                    data.set("applicationArn", om.valueToTree(this.getApplicationArn()));
                }
                if (this.getKmsKeyArn() != null) {
                    data.set("kmsKeyArn", om.valueToTree(this.getKmsKeyArn()));
                }
                if (this.getRetentionDays() != null) {
                    data.set("retentionDays", om.valueToTree(this.getRetentionDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnIntegration.OpenSearchResourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OpenSearchResourceConfigProperty.Jsii$Proxy that = (OpenSearchResourceConfigProperty.Jsii$Proxy) o;

                if (!dashboardViewerPrincipals.equals(that.dashboardViewerPrincipals)) return false;
                if (!dataSourceRoleArn.equals(that.dataSourceRoleArn)) return false;
                if (this.applicationArn != null ? !this.applicationArn.equals(that.applicationArn) : that.applicationArn != null) return false;
                if (this.kmsKeyArn != null ? !this.kmsKeyArn.equals(that.kmsKeyArn) : that.kmsKeyArn != null) return false;
                return this.retentionDays != null ? this.retentionDays.equals(that.retentionDays) : that.retentionDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dashboardViewerPrincipals.hashCode();
                result = 31 * result + (this.dataSourceRoleArn.hashCode());
                result = 31 * result + (this.applicationArn != null ? this.applicationArn.hashCode() : 0);
                result = 31 * result + (this.kmsKeyArn != null ? this.kmsKeyArn.hashCode() : 0);
                result = 31 * result + (this.retentionDays != null ? this.retentionDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.logs.*;
     * ResourceConfigProperty resourceConfigProperty = ResourceConfigProperty.builder()
     *         .openSearchResourceConfig(OpenSearchResourceConfigProperty.builder()
     *                 .dashboardViewerPrincipals(List.of("dashboardViewerPrincipals"))
     *                 .dataSourceRoleArn("dataSourceRoleArn")
     *                 // the properties below are optional
     *                 .applicationArn("applicationArn")
     *                 .kmsKeyArn("kmsKeyArn")
     *                 .retentionDays(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-resourceconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-resourceconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.CfnIntegration.ResourceConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ResourceConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ResourceConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-resourceconfig.html#cfn-logs-integration-resourceconfig-opensearchresourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-logs-integration-resourceconfig.html#cfn-logs-integration-resourceconfig-opensearchresourceconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOpenSearchResourceConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ResourceConfigProperty> {
            java.lang.Object openSearchResourceConfig;

            /**
             * Sets the value of {@link ResourceConfigProperty#getOpenSearchResourceConfig}
             * @param openSearchResourceConfig This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openSearchResourceConfig(software.amazon.awscdk.IResolvable openSearchResourceConfig) {
                this.openSearchResourceConfig = openSearchResourceConfig;
                return this;
            }

            /**
             * Sets the value of {@link ResourceConfigProperty#getOpenSearchResourceConfig}
             * @param openSearchResourceConfig This structure contains configuration details about an integration between CloudWatch Logs and OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder openSearchResourceConfig(software.amazon.awscdk.services.logs.CfnIntegration.OpenSearchResourceConfigProperty openSearchResourceConfig) {
                this.openSearchResourceConfig = openSearchResourceConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ResourceConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ResourceConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ResourceConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ResourceConfigProperty {
            private final java.lang.Object openSearchResourceConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.openSearchResourceConfig = software.amazon.jsii.Kernel.get(this, "openSearchResourceConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.openSearchResourceConfig = builder.openSearchResourceConfig;
            }

            @Override
            public final java.lang.Object getOpenSearchResourceConfig() {
                return this.openSearchResourceConfig;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOpenSearchResourceConfig() != null) {
                    data.set("openSearchResourceConfig", om.valueToTree(this.getOpenSearchResourceConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_logs.CfnIntegration.ResourceConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ResourceConfigProperty.Jsii$Proxy that = (ResourceConfigProperty.Jsii$Proxy) o;

                return this.openSearchResourceConfig != null ? this.openSearchResourceConfig.equals(that.openSearchResourceConfig) : that.openSearchResourceConfig == null;
            }

            @Override
            public final int hashCode() {
                int result = this.openSearchResourceConfig != null ? this.openSearchResourceConfig.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.CfnIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.CfnIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.logs.CfnIntegrationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.logs.CfnIntegrationProps.Builder();
        }

        /**
         * The name of this integration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationname</a>
         * @param integrationName The name of this integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationName(final java.lang.String integrationName) {
            this.props.integrationName(integrationName);
            return this;
        }

        /**
         * The type of integration.
         * <p>
         * Integrations with OpenSearch Service have the type <code>OPENSEARCH</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-integrationtype</a>
         * @param integrationType The type of integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationType(final java.lang.String integrationType) {
            this.props.integrationType(integrationType);
            return this;
        }

        /**
         * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-resourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-resourceconfig</a>
         * @param resourceConfig This structure contains configuration details about an integration between CloudWatch Logs and another entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfig(final software.amazon.awscdk.IResolvable resourceConfig) {
            this.props.resourceConfig(resourceConfig);
            return this;
        }
        /**
         * This structure contains configuration details about an integration between CloudWatch Logs and another entity.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-resourceconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-integration.html#cfn-logs-integration-resourceconfig</a>
         * @param resourceConfig This structure contains configuration details about an integration between CloudWatch Logs and another entity. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceConfig(final software.amazon.awscdk.services.logs.CfnIntegration.ResourceConfigProperty resourceConfig) {
            this.props.resourceConfig(resourceConfig);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.CfnIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.CfnIntegration build() {
            return new software.amazon.awscdk.services.logs.CfnIntegration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
