package software.amazon.awscdk.services.logs;

/**
 * Creates a field index policy for CloudWatch Logs log groups.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * FieldIndexPolicy fieldIndexPolicy = FieldIndexPolicy.Builder.create()
 *         .fields(List.of("Operation", "RequestId"))
 *         .build();
 * LogGroup.Builder.create(this, "LogGroup")
 *         .logGroupName("cdkIntegLogGroup")
 *         .fieldIndexPolicies(List.of(fieldIndexPolicy))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:19.610Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_logs.FieldIndexPolicy")
public class FieldIndexPolicy extends software.amazon.jsii.JsiiObject {

    protected FieldIndexPolicy(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected FieldIndexPolicy(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public FieldIndexPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.logs.FieldIndexPolicyProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.logs.FieldIndexPolicy}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.logs.FieldIndexPolicy> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.logs.FieldIndexPolicyProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.logs.FieldIndexPolicyProps.Builder();
        }

        /**
         * List of fields to index in log events.
         * <p>
         * Default: no fields
         * <p>
         * @return {@code this}
         * @param fields List of fields to index in log events. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fields(final java.util.List<java.lang.String> fields) {
            this.props.fields(fields);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.logs.FieldIndexPolicy}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.logs.FieldIndexPolicy build() {
            return new software.amazon.awscdk.services.logs.FieldIndexPolicy(
                this.props.build()
            );
        }
    }
}
