package software.amazon.awscdk.services.mwaa;

/**
 * The <code>AWS::MWAA::Environment</code> resource creates an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.mwaa.*;
 * Object airflowConfigurationOptions;
 * Object tags;
 * CfnEnvironment cfnEnvironment = CfnEnvironment.Builder.create(this, "MyCfnEnvironment")
 *         .name("name")
 *         // the properties below are optional
 *         .airflowConfigurationOptions(airflowConfigurationOptions)
 *         .airflowVersion("airflowVersion")
 *         .dagS3Path("dagS3Path")
 *         .endpointManagement("endpointManagement")
 *         .environmentClass("environmentClass")
 *         .executionRoleArn("executionRoleArn")
 *         .kmsKey("kmsKey")
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .dagProcessingLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .schedulerLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .taskLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .webserverLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .workerLogs(ModuleLoggingConfigurationProperty.builder()
 *                         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
 *                         .enabled(false)
 *                         .logLevel("logLevel")
 *                         .build())
 *                 .build())
 *         .maxWebservers(123)
 *         .maxWorkers(123)
 *         .minWebservers(123)
 *         .minWorkers(123)
 *         .networkConfiguration(NetworkConfigurationProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .pluginsS3ObjectVersion("pluginsS3ObjectVersion")
 *         .pluginsS3Path("pluginsS3Path")
 *         .requirementsS3ObjectVersion("requirementsS3ObjectVersion")
 *         .requirementsS3Path("requirementsS3Path")
 *         .schedulers(123)
 *         .sourceBucketArn("sourceBucketArn")
 *         .startupScriptS3ObjectVersion("startupScriptS3ObjectVersion")
 *         .startupScriptS3Path("startupScriptS3Path")
 *         .tags(tags)
 *         .webserverAccessMode("webserverAccessMode")
 *         .weeklyMaintenanceWindowStart("weeklyMaintenanceWindowStart")
 *         .workerReplacementStrategy("workerReplacementStrategy")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:20.711Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mwaa.CfnEnvironment")
public class CfnEnvironment extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnEnvironment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnEnvironment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.mwaa.CfnEnvironment.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnEnvironment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.mwaa.CfnEnvironmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN for the Amazon MWAA environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The queue ARN for the environment's <a href="https://docs.aws.amazon.com/https://airflow.apache.org/docs/apache-airflow/stable/core-concepts/executor/celery.html">Celery Executor</a> . Amazon MWAA uses a Celery Executor to distribute tasks across multiple workers. When you create an environment in a shared VPC, you must provide access to the Celery Executor queue from your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCeleryExecutorQueue() {
        return software.amazon.jsii.Kernel.get(this, "attrCeleryExecutorQueue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The VPC endpoint for the environment's Amazon RDS database.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDatabaseVpcEndpointService() {
        return software.amazon.jsii.Kernel.get(this, "attrDatabaseVpcEndpointService", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the CloudWatch Logs group where the Apache Airflow DAG processing logs are published.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoggingConfigurationDagProcessingLogsCloudWatchLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLoggingConfigurationDagProcessingLogsCloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the CloudWatch Logs group where the Apache Airflow Scheduler logs are published.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoggingConfigurationSchedulerLogsCloudWatchLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLoggingConfigurationSchedulerLogsCloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the CloudWatch Logs group where the Apache Airflow task logs are published.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoggingConfigurationTaskLogsCloudWatchLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLoggingConfigurationTaskLogsCloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the CloudWatch Logs group where the Apache Airflow Web server logs are published.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoggingConfigurationWebserverLogsCloudWatchLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLoggingConfigurationWebserverLogsCloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN for the CloudWatch Logs group where the Apache Airflow Worker logs are published.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrLoggingConfigurationWorkerLogsCloudWatchLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrLoggingConfigurationWorkerLogsCloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The URL of your Apache Airflow UI.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWebserverUrl() {
        return software.amazon.jsii.Kernel.get(this, "attrWebserverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The VPC endpoint for the environment's web server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWebserverVpcEndpointService() {
        return software.amazon.jsii.Kernel.get(this, "attrWebserverVpcEndpointService", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of your Amazon MWAA environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of your Amazon MWAA environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * A list of key-value pairs containing the Airflow configuration options for your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAirflowConfigurationOptions() {
        return software.amazon.jsii.Kernel.get(this, "airflowConfigurationOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of key-value pairs containing the Airflow configuration options for your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAirflowConfigurationOptions(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "airflowConfigurationOptions", value);
    }

    /**
     * The version of Apache Airflow to use for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAirflowVersion() {
        return software.amazon.jsii.Kernel.get(this, "airflowVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of Apache Airflow to use for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAirflowVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "airflowVersion", value);
    }

    /**
     * The relative path to the DAGs folder on your Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDagS3Path() {
        return software.amazon.jsii.Kernel.get(this, "dagS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The relative path to the DAGs folder on your Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDagS3Path(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "dagS3Path", value);
    }

    /**
     * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEndpointManagement() {
        return software.amazon.jsii.Kernel.get(this, "endpointManagement", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEndpointManagement(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "endpointManagement", value);
    }

    /**
     * The environment class type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEnvironmentClass() {
        return software.amazon.jsii.Kernel.get(this, "environmentClass", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The environment class type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnvironmentClass(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "environmentClass", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", value);
    }

    /**
     * The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKey() {
        return software.amazon.jsii.Kernel.get(this, "kmsKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKey(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKey", value);
    }

    /**
     * The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mwaa.CfnEnvironment.LoggingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * The maximum number of web servers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxWebservers() {
        return software.amazon.jsii.Kernel.get(this, "maxWebservers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of web servers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxWebservers(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxWebservers", value);
    }

    /**
     * The maximum number of workers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxWorkers() {
        return software.amazon.jsii.Kernel.get(this, "maxWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum number of workers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxWorkers(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxWorkers", value);
    }

    /**
     * The minimum number of web servers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinWebservers() {
        return software.amazon.jsii.Kernel.get(this, "minWebservers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum number of web servers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinWebservers(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minWebservers", value);
    }

    /**
     * The minimum number of workers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMinWorkers() {
        return software.amazon.jsii.Kernel.get(this, "minWorkers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The minimum number of workers that you want to run in your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMinWorkers(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "minWorkers", value);
    }

    /**
     * The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNetworkConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "networkConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNetworkConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.mwaa.CfnEnvironment.NetworkConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "networkConfiguration", value);
    }

    /**
     * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPluginsS3ObjectVersion() {
        return software.amazon.jsii.Kernel.get(this, "pluginsS3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPluginsS3ObjectVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pluginsS3ObjectVersion", value);
    }

    /**
     * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getPluginsS3Path() {
        return software.amazon.jsii.Kernel.get(this, "pluginsS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPluginsS3Path(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "pluginsS3Path", value);
    }

    /**
     * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRequirementsS3ObjectVersion() {
        return software.amazon.jsii.Kernel.get(this, "requirementsS3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequirementsS3ObjectVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "requirementsS3ObjectVersion", value);
    }

    /**
     * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRequirementsS3Path() {
        return software.amazon.jsii.Kernel.get(this, "requirementsS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRequirementsS3Path(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "requirementsS3Path", value);
    }

    /**
     * The number of schedulers that you want to run in your environment.
     * <p>
     * Valid values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSchedulers() {
        return software.amazon.jsii.Kernel.get(this, "schedulers", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The number of schedulers that you want to run in your environment.
     * <p>
     * Valid values:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSchedulers(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "schedulers", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSourceBucketArn() {
        return software.amazon.jsii.Kernel.get(this, "sourceBucketArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSourceBucketArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "sourceBucketArn", value);
    }

    /**
     * The version of the startup shell script in your Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartupScriptS3ObjectVersion() {
        return software.amazon.jsii.Kernel.get(this, "startupScriptS3ObjectVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of the startup shell script in your Amazon S3 bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartupScriptS3ObjectVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startupScriptS3ObjectVersion", value);
    }

    /**
     * The relative path to the startup shell script in your Amazon S3 bucket.
     * <p>
     * For example, <code>s3://mwaa-environment/startup.sh</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStartupScriptS3Path() {
        return software.amazon.jsii.Kernel.get(this, "startupScriptS3Path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The relative path to the startup shell script in your Amazon S3 bucket.
     * <p>
     * For example, <code>s3://mwaa-environment/startup.sh</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStartupScriptS3Path(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "startupScriptS3Path", value);
    }

    /**
     * The key-value tag pairs associated to your environment.
     * <p>
     * For example, <code>"Environment": "Staging"</code> . To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTagsRaw() {
        return software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The key-value tag pairs associated to your environment.
     * <p>
     * For example, <code>"Environment": "Staging"</code> . To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The Apache Airflow <em>Web server</em> access mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWebserverAccessMode() {
        return software.amazon.jsii.Kernel.get(this, "webserverAccessMode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Apache Airflow <em>Web server</em> access mode.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWebserverAccessMode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "webserverAccessMode", value);
    }

    /**
     * The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWeeklyMaintenanceWindowStart() {
        return software.amazon.jsii.Kernel.get(this, "weeklyMaintenanceWindowStart", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWeeklyMaintenanceWindowStart(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "weeklyMaintenanceWindowStart", value);
    }

    /**
     * The worker replacement strategy to use when updating the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getWorkerReplacementStrategy() {
        return software.amazon.jsii.Kernel.get(this, "workerReplacementStrategy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The worker replacement strategy to use when updating the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkerReplacementStrategy(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workerReplacementStrategy", value);
    }
    /**
     * The type of Apache Airflow logs to send to CloudWatch Logs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mwaa.*;
     * LoggingConfigurationProperty loggingConfigurationProperty = LoggingConfigurationProperty.builder()
     *         .dagProcessingLogs(ModuleLoggingConfigurationProperty.builder()
     *                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                 .enabled(false)
     *                 .logLevel("logLevel")
     *                 .build())
     *         .schedulerLogs(ModuleLoggingConfigurationProperty.builder()
     *                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                 .enabled(false)
     *                 .logLevel("logLevel")
     *                 .build())
     *         .taskLogs(ModuleLoggingConfigurationProperty.builder()
     *                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                 .enabled(false)
     *                 .logLevel("logLevel")
     *                 .build())
     *         .webserverLogs(ModuleLoggingConfigurationProperty.builder()
     *                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                 .enabled(false)
     *                 .logLevel("logLevel")
     *                 .build())
     *         .workerLogs(ModuleLoggingConfigurationProperty.builder()
     *                 .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *                 .enabled(false)
     *                 .logLevel("logLevel")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mwaa.CfnEnvironment.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Defines the processing logs sent to CloudWatch Logs and the logging level to send.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-dagprocessinglogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-dagprocessinglogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDagProcessingLogs() {
            return null;
        }

        /**
         * Defines the scheduler logs sent to CloudWatch Logs and the logging level to send.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-schedulerlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-schedulerlogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSchedulerLogs() {
            return null;
        }

        /**
         * Defines the task logs sent to CloudWatch Logs and the logging level to send.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-tasklogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-tasklogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getTaskLogs() {
            return null;
        }

        /**
         * Defines the web server logs sent to CloudWatch Logs and the logging level to send.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-webserverlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-webserverlogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWebserverLogs() {
            return null;
        }

        /**
         * Defines the worker logs sent to CloudWatch Logs and the logging level to send.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-workerlogs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-loggingconfiguration.html#cfn-mwaa-environment-loggingconfiguration-workerlogs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWorkerLogs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            java.lang.Object dagProcessingLogs;
            java.lang.Object schedulerLogs;
            java.lang.Object taskLogs;
            java.lang.Object webserverLogs;
            java.lang.Object workerLogs;

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDagProcessingLogs}
             * @param dagProcessingLogs Defines the processing logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dagProcessingLogs(software.amazon.awscdk.IResolvable dagProcessingLogs) {
                this.dagProcessingLogs = dagProcessingLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDagProcessingLogs}
             * @param dagProcessingLogs Defines the processing logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dagProcessingLogs(software.amazon.awscdk.services.mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty dagProcessingLogs) {
                this.dagProcessingLogs = dagProcessingLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getSchedulerLogs}
             * @param schedulerLogs Defines the scheduler logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedulerLogs(software.amazon.awscdk.IResolvable schedulerLogs) {
                this.schedulerLogs = schedulerLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getSchedulerLogs}
             * @param schedulerLogs Defines the scheduler logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder schedulerLogs(software.amazon.awscdk.services.mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty schedulerLogs) {
                this.schedulerLogs = schedulerLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getTaskLogs}
             * @param taskLogs Defines the task logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskLogs(software.amazon.awscdk.IResolvable taskLogs) {
                this.taskLogs = taskLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getTaskLogs}
             * @param taskLogs Defines the task logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder taskLogs(software.amazon.awscdk.services.mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty taskLogs) {
                this.taskLogs = taskLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getWebserverLogs}
             * @param webserverLogs Defines the web server logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webserverLogs(software.amazon.awscdk.IResolvable webserverLogs) {
                this.webserverLogs = webserverLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getWebserverLogs}
             * @param webserverLogs Defines the web server logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webserverLogs(software.amazon.awscdk.services.mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty webserverLogs) {
                this.webserverLogs = webserverLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getWorkerLogs}
             * @param workerLogs Defines the worker logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerLogs(software.amazon.awscdk.IResolvable workerLogs) {
                this.workerLogs = workerLogs;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getWorkerLogs}
             * @param workerLogs Defines the worker logs sent to CloudWatch Logs and the logging level to send.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workerLogs(software.amazon.awscdk.services.mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty workerLogs) {
                this.workerLogs = workerLogs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.Object dagProcessingLogs;
            private final java.lang.Object schedulerLogs;
            private final java.lang.Object taskLogs;
            private final java.lang.Object webserverLogs;
            private final java.lang.Object workerLogs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dagProcessingLogs = software.amazon.jsii.Kernel.get(this, "dagProcessingLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.schedulerLogs = software.amazon.jsii.Kernel.get(this, "schedulerLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.taskLogs = software.amazon.jsii.Kernel.get(this, "taskLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.webserverLogs = software.amazon.jsii.Kernel.get(this, "webserverLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.workerLogs = software.amazon.jsii.Kernel.get(this, "workerLogs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dagProcessingLogs = builder.dagProcessingLogs;
                this.schedulerLogs = builder.schedulerLogs;
                this.taskLogs = builder.taskLogs;
                this.webserverLogs = builder.webserverLogs;
                this.workerLogs = builder.workerLogs;
            }

            @Override
            public final java.lang.Object getDagProcessingLogs() {
                return this.dagProcessingLogs;
            }

            @Override
            public final java.lang.Object getSchedulerLogs() {
                return this.schedulerLogs;
            }

            @Override
            public final java.lang.Object getTaskLogs() {
                return this.taskLogs;
            }

            @Override
            public final java.lang.Object getWebserverLogs() {
                return this.webserverLogs;
            }

            @Override
            public final java.lang.Object getWorkerLogs() {
                return this.workerLogs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDagProcessingLogs() != null) {
                    data.set("dagProcessingLogs", om.valueToTree(this.getDagProcessingLogs()));
                }
                if (this.getSchedulerLogs() != null) {
                    data.set("schedulerLogs", om.valueToTree(this.getSchedulerLogs()));
                }
                if (this.getTaskLogs() != null) {
                    data.set("taskLogs", om.valueToTree(this.getTaskLogs()));
                }
                if (this.getWebserverLogs() != null) {
                    data.set("webserverLogs", om.valueToTree(this.getWebserverLogs()));
                }
                if (this.getWorkerLogs() != null) {
                    data.set("workerLogs", om.valueToTree(this.getWorkerLogs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mwaa.CfnEnvironment.LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.dagProcessingLogs != null ? !this.dagProcessingLogs.equals(that.dagProcessingLogs) : that.dagProcessingLogs != null) return false;
                if (this.schedulerLogs != null ? !this.schedulerLogs.equals(that.schedulerLogs) : that.schedulerLogs != null) return false;
                if (this.taskLogs != null ? !this.taskLogs.equals(that.taskLogs) : that.taskLogs != null) return false;
                if (this.webserverLogs != null ? !this.webserverLogs.equals(that.webserverLogs) : that.webserverLogs != null) return false;
                return this.workerLogs != null ? this.workerLogs.equals(that.workerLogs) : that.workerLogs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dagProcessingLogs != null ? this.dagProcessingLogs.hashCode() : 0;
                result = 31 * result + (this.schedulerLogs != null ? this.schedulerLogs.hashCode() : 0);
                result = 31 * result + (this.taskLogs != null ? this.taskLogs.hashCode() : 0);
                result = 31 * result + (this.webserverLogs != null ? this.webserverLogs.hashCode() : 0);
                result = 31 * result + (this.workerLogs != null ? this.workerLogs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the type of logs to send for the Apache Airflow log type (e.g. <code>DagProcessingLogs</code> ).
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mwaa.*;
     * ModuleLoggingConfigurationProperty moduleLoggingConfigurationProperty = ModuleLoggingConfigurationProperty.builder()
     *         .cloudWatchLogGroupArn("cloudWatchLogGroupArn")
     *         .enabled(false)
     *         .logLevel("logLevel")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ModuleLoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModuleLoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the CloudWatch Logs log group for each type of Apache Airflow log type that you have enabled.
         * <p>
         * <blockquote>
         * <p>
         * <code>CloudWatchLogGroupArn</code> is available only as a return value, accessible when specified as an attribute in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#aws-resource-mwaa-environment-return-values"><code>Fn:GetAtt</code></a> intrinsic function. Any value you provide for <code>CloudWatchLogGroupArn</code> is discarded by Amazon MWAA.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-cloudwatchloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-cloudwatchloggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogGroupArn() {
            return null;
        }

        /**
         * Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code> ) in CloudWatch Logs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code> ) to CloudWatch Logs. Valid values: <code>CRITICAL</code> , <code>ERROR</code> , <code>WARNING</code> , <code>INFO</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-loglevel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-moduleloggingconfiguration.html#cfn-mwaa-environment-moduleloggingconfiguration-loglevel</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ModuleLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModuleLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModuleLoggingConfigurationProperty> {
            java.lang.String cloudWatchLogGroupArn;
            java.lang.Object enabled;
            java.lang.String logLevel;

            /**
             * Sets the value of {@link ModuleLoggingConfigurationProperty#getCloudWatchLogGroupArn}
             * @param cloudWatchLogGroupArn The ARN of the CloudWatch Logs log group for each type of Apache Airflow log type that you have enabled.
             *                              <blockquote>
             *                              <p>
             *                              <code>CloudWatchLogGroupArn</code> is available only as a return value, accessible when specified as an attribute in the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#aws-resource-mwaa-environment-return-values"><code>Fn:GetAtt</code></a> intrinsic function. Any value you provide for <code>CloudWatchLogGroupArn</code> is discarded by Amazon MWAA.
             *                              <p>
             *                              </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogGroupArn(java.lang.String cloudWatchLogGroupArn) {
                this.cloudWatchLogGroupArn = cloudWatchLogGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link ModuleLoggingConfigurationProperty#getEnabled}
             * @param enabled Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code> ) in CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ModuleLoggingConfigurationProperty#getEnabled}
             * @param enabled Indicates whether to enable the Apache Airflow log type (e.g. <code>DagProcessingLogs</code> ) in CloudWatch Logs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ModuleLoggingConfigurationProperty#getLogLevel}
             * @param logLevel Defines the Apache Airflow logs to send for the log type (e.g. <code>DagProcessingLogs</code> ) to CloudWatch Logs. Valid values: <code>CRITICAL</code> , <code>ERROR</code> , <code>WARNING</code> , <code>INFO</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logLevel(java.lang.String logLevel) {
                this.logLevel = logLevel;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModuleLoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModuleLoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModuleLoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModuleLoggingConfigurationProperty {
            private final java.lang.String cloudWatchLogGroupArn;
            private final java.lang.Object enabled;
            private final java.lang.String logLevel;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.logLevel = software.amazon.jsii.Kernel.get(this, "logLevel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogGroupArn = builder.cloudWatchLogGroupArn;
                this.enabled = builder.enabled;
                this.logLevel = builder.logLevel;
            }

            @Override
            public final java.lang.String getCloudWatchLogGroupArn() {
                return this.cloudWatchLogGroupArn;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getLogLevel() {
                return this.logLevel;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogGroupArn() != null) {
                    data.set("cloudWatchLogGroupArn", om.valueToTree(this.getCloudWatchLogGroupArn()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getLogLevel() != null) {
                    data.set("logLevel", om.valueToTree(this.getLogLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mwaa.CfnEnvironment.ModuleLoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModuleLoggingConfigurationProperty.Jsii$Proxy that = (ModuleLoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogGroupArn != null ? !this.cloudWatchLogGroupArn.equals(that.cloudWatchLogGroupArn) : that.cloudWatchLogGroupArn != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.logLevel != null ? this.logLevel.equals(that.logLevel) : that.logLevel == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogGroupArn != null ? this.cloudWatchLogGroupArn.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.logLevel != null ? this.logLevel.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.mwaa.*;
     * NetworkConfigurationProperty networkConfigurationProperty = NetworkConfigurationProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_mwaa.CfnEnvironment.NetworkConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A list of one or more security group IDs.
         * <p>
         * Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * A list of subnet IDs.
         * <p>
         * <em>Required</em> to create an environment. Must be private subnets in two different availability zones. A subnet must be attached to the same VPC as the security group. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-mwaa-environment-networkconfiguration.html#cfn-mwaa-environment-networkconfiguration-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkConfigurationProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getSecurityGroupIds}
             * @param securityGroupIds A list of one or more security group IDs.
             *                         Accepts up to 5 security group IDs. A security group must be attached to the same VPC as the subnets. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html">Security in your VPC on Amazon MWAA</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link NetworkConfigurationProperty#getSubnetIds}
             * @param subnetIds A list of subnet IDs.
             *                  <em>Required</em> to create an environment. Must be private subnets in two different availability zones. A subnet must be attached to the same VPC as the security group. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkConfigurationProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = builder.securityGroupIds;
                this.subnetIds = builder.subnetIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_mwaa.CfnEnvironment.NetworkConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkConfigurationProperty.Jsii$Proxy that = (NetworkConfigurationProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                return this.subnetIds != null ? this.subnetIds.equals(that.subnetIds) : that.subnetIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.mwaa.CfnEnvironment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.mwaa.CfnEnvironment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.mwaa.CfnEnvironmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.mwaa.CfnEnvironmentProps.Builder();
        }

        /**
         * The name of your Amazon MWAA environment.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-name</a>
         * @param name The name of your Amazon MWAA environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * A list of key-value pairs containing the Airflow configuration options for your environment.
         * <p>
         * For example, <code>core.default_timezone: utc</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html">Apache Airflow configuration options</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowconfigurationoptions</a>
         * @param airflowConfigurationOptions A list of key-value pairs containing the Airflow configuration options for your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder airflowConfigurationOptions(final java.lang.Object airflowConfigurationOptions) {
            this.props.airflowConfigurationOptions(airflowConfigurationOptions);
            return this;
        }

        /**
         * The version of Apache Airflow to use for the environment.
         * <p>
         * If no value is specified, defaults to the latest version.
         * <p>
         * If you specify a newer version number for an existing environment, the version update requires some service interruption before taking effect.
         * <p>
         * <em>Allowed Values</em> : <code>1.10.12</code> | <code>2.0.2</code> | <code>2.2.2</code> | <code>2.4.3</code> | <code>2.5.1</code> | <code>2.6.3</code> | <code>2.7.2</code> | <code>2.8.1</code> | <code>2.9.2</code> | <code>2.10.1</code> (latest)
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-airflowversion</a>
         * @param airflowVersion The version of Apache Airflow to use for the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder airflowVersion(final java.lang.String airflowVersion) {
            this.props.airflowVersion(airflowVersion);
            return this;
        }

        /**
         * The relative path to the DAGs folder on your Amazon S3 bucket.
         * <p>
         * For example, <code>dags</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html">Adding or updating DAGs</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-dags3path</a>
         * @param dagS3Path The relative path to the DAGs folder on your Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dagS3Path(final java.lang.String dagS3Path) {
            this.props.dagS3Path(dagS3Path);
            return this;
        }

        /**
         * Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA.
         * <p>
         * If set to <code>SERVICE</code> , Amazon MWAA will create and manage the required VPC endpoints in your VPC. If set to <code>CUSTOMER</code> , you must create, and manage, the VPC endpoints in your VPC.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-endpointmanagement">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-endpointmanagement</a>
         * @param endpointManagement Defines whether the VPC endpoints configured for the environment are created, and managed, by the customer or by Amazon MWAA. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointManagement(final java.lang.String endpointManagement) {
            this.props.endpointManagement(endpointManagement);
            return this;
        }

        /**
         * The environment class type.
         * <p>
         * Valid values: <code>mw1.micro</code> , <code>mw1.small</code> , <code>mw1.medium</code> , <code>mw1.large</code> , <code>mw1.1large</code> , and <code>mw1.2large</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html">Amazon MWAA environment class</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-environmentclass</a>
         * @param environmentClass The environment class type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentClass(final java.lang.String environmentClass) {
            this.props.environmentClass(environmentClass);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment.
         * <p>
         * For example, <code>arn:aws:iam::123456789:role/my-execution-role</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html">Amazon MWAA Execution role</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-executionrolearn</a>
         * @param executionRoleArn The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to access AWS resources in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment.
         * <p>
         * You can use an AWS KMS key managed by MWAA, or a customer-managed KMS key (advanced).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-kmskey</a>
         * @param kmsKey The AWS Key Management Service (KMS) key to encrypt and decrypt the data in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final java.lang.String kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration</a>
         * @param loggingConfiguration The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.IResolvable loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }
        /**
         * The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-loggingconfiguration</a>
         * @param loggingConfiguration The Apache Airflow logs being sent to CloudWatch Logs: <code>DagProcessingLogs</code> , <code>SchedulerLogs</code> , <code>TaskLogs</code> , <code>WebserverLogs</code> , <code>WorkerLogs</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.services.mwaa.CfnEnvironment.LoggingConfigurationProperty loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        /**
         * The maximum number of web servers that you want to run in your environment.
         * <p>
         * Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. For example, in scenarios where your workload requires network calls to the Apache Airflow REST API with a high transaction-per-second (TPS) rate, Amazon MWAA will increase the number of web servers up to the number set in <code>MaxWebserers</code> . As TPS rates decrease Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code> .
         * <p>
         * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code> . Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxwebservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxwebservers</a>
         * @param maxWebservers The maximum number of web servers that you want to run in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWebservers(final java.lang.Number maxWebservers) {
            this.props.maxWebservers(maxWebservers);
            return this;
        }

        /**
         * The maximum number of workers that you want to run in your environment.
         * <p>
         * MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. For example, <code>20</code> . When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the one worker that is included with your environment, or the number you specify in <code>MinWorkers</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-maxworkers</a>
         * @param maxWorkers The maximum number of workers that you want to run in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxWorkers(final java.lang.Number maxWorkers) {
            this.props.maxWorkers(maxWorkers);
            return this;
        }

        /**
         * The minimum number of web servers that you want to run in your environment.
         * <p>
         * Amazon MWAA scales the number of Apache Airflow web servers up to the number you specify for <code>MaxWebservers</code> when you interact with your Apache Airflow environment using Apache Airflow REST API, or the Apache Airflow CLI. As the transaction-per-second rate, and the network load, decrease, Amazon MWAA disposes of the additional web servers, and scales down to the number set in <code>MinxWebserers</code> .
         * <p>
         * Valid values: For environments larger than mw1.micro, accepts values from <code>2</code> to <code>5</code> . Defaults to <code>2</code> for all environment sizes except mw1.micro, which defaults to <code>1</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minwebservers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minwebservers</a>
         * @param minWebservers The minimum number of web servers that you want to run in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minWebservers(final java.lang.Number minWebservers) {
            this.props.minWebservers(minWebservers);
            return this;
        }

        /**
         * The minimum number of workers that you want to run in your environment.
         * <p>
         * MWAA scales the number of Apache Airflow workers up to the number you specify in the <code>MaxWorkers</code> field. When there are no more tasks running, and no more in the queue, MWAA disposes of the extra workers leaving the worker count you specify in the <code>MinWorkers</code> field. For example, <code>2</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minworkers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-minworkers</a>
         * @param minWorkers The minimum number of workers that you want to run in your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minWorkers(final java.lang.Number minWorkers) {
            this.props.minWorkers(minWorkers);
            return this;
        }

        /**
         * The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
         * <p>
         * To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration</a>
         * @param networkConfiguration The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.IResolvable networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }
        /**
         * The VPC networking components used to secure and enable network traffic between the AWS resources for your environment.
         * <p>
         * To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html">About networking on Amazon MWAA</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-networkconfiguration</a>
         * @param networkConfiguration The VPC networking components used to secure and enable network traffic between the AWS resources for your environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder networkConfiguration(final software.amazon.awscdk.services.mwaa.CfnEnvironment.NetworkConfigurationProperty networkConfiguration) {
            this.props.networkConfiguration(networkConfiguration);
            return this;
        }

        /**
         * The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3objectversion</a>
         * @param pluginsS3ObjectVersion The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginsS3ObjectVersion(final java.lang.String pluginsS3ObjectVersion) {
            this.props.pluginsS3ObjectVersion(pluginsS3ObjectVersion);
            return this;
        }

        /**
         * The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-pluginss3path</a>
         * @param pluginsS3Path The relative path to the <code>plugins.zip</code> file on your Amazon S3 bucket. For example, <code>plugins.zip</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html">Installing custom plugins</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pluginsS3Path(final java.lang.String pluginsS3Path) {
            this.props.pluginsS3Path(pluginsS3Path);
            return this;
        }

        /**
         * The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3objectversion</a>
         * @param requirementsS3ObjectVersion The version of the requirements.txt file on your Amazon S3 bucket. To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requirementsS3ObjectVersion(final java.lang.String requirementsS3ObjectVersion) {
            this.props.requirementsS3ObjectVersion(requirementsS3ObjectVersion);
            return this;
        }

        /**
         * The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-requirementss3path</a>
         * @param requirementsS3Path The relative path to the <code>requirements.txt</code> file on your Amazon S3 bucket. For example, <code>requirements.txt</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html">Installing Python dependencies</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requirementsS3Path(final java.lang.String requirementsS3Path) {
            this.props.requirementsS3Path(requirementsS3Path);
            return this;
        }

        /**
         * The number of schedulers that you want to run in your environment. Valid values:.
         * <p>
         * <ul>
         * <li><em>v2</em> - For environments larger than mw1.micro, accepts values from 2 to 5. Defaults to 2 for all environment sizes except mw1.micro, which defaults to 1.</li>
         * <li><em>v1</em> - Accepts 1.</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-schedulers">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-schedulers</a>
         * @param schedulers The number of schedulers that you want to run in your environment. Valid values:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulers(final java.lang.Number schedulers) {
            this.props.schedulers(schedulers);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored.
         * <p>
         * For example, <code>arn:aws:s3:::my-airflow-bucket-unique-name</code> . To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html">Create an Amazon S3 bucket for Amazon MWAA</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-sourcebucketarn</a>
         * @param sourceBucketArn The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and supporting files are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceBucketArn(final java.lang.String sourceBucketArn) {
            this.props.sourceBucketArn(sourceBucketArn);
            return this;
        }

        /**
         * The version of the startup shell script in your Amazon S3 bucket.
         * <p>
         * You must specify the <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/versioning-workflows.html">version ID</a> that Amazon S3 assigns to the file every time you update the script.
         * <p>
         * Version IDs are Unicode, UTF-8 encoded, URL-ready, opaque strings that are no more than 1,024 bytes long. The following is an example:
         * <p>
         * <code>3sL4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo</code>
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3objectversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3objectversion</a>
         * @param startupScriptS3ObjectVersion The version of the startup shell script in your Amazon S3 bucket. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startupScriptS3ObjectVersion(final java.lang.String startupScriptS3ObjectVersion) {
            this.props.startupScriptS3ObjectVersion(startupScriptS3ObjectVersion);
            return this;
        }

        /**
         * The relative path to the startup shell script in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/startup.sh</code> .
         * <p>
         * Amazon MWAA runs the script as your environment starts, and before running the Apache Airflow process. You can use this script to install dependencies, modify Apache Airflow configuration options, and set environment variables. For more information, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/using-startup-script.html">Using a startup script</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3path">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-startupscripts3path</a>
         * @param startupScriptS3Path The relative path to the startup shell script in your Amazon S3 bucket. For example, <code>s3://mwaa-environment/startup.sh</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startupScriptS3Path(final java.lang.String startupScriptS3Path) {
            this.props.startupScriptS3Path(startupScriptS3Path);
            return this;
        }

        /**
         * The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code> . To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging</a> .
         * <p>
         * If you specify new tags for an existing environment, the update requires service interruption before taking effect.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-tags</a>
         * @param tags The key-value tag pairs associated to your environment. For example, <code>"Environment": "Staging"</code> . To learn more, see <a href="https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html">Tagging</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.lang.Object tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * The Apache Airflow <em>Web server</em> access mode.
         * <p>
         * To learn more, see <a href="https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html">Apache Airflow access modes</a> . Valid values: <code>PRIVATE_ONLY</code> or <code>PUBLIC_ONLY</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-webserveraccessmode</a>
         * @param webserverAccessMode The Apache Airflow <em>Web server</em> access mode. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder webserverAccessMode(final java.lang.String webserverAccessMode) {
            this.props.webserverAccessMode(webserverAccessMode);
            return this;
        }

        /**
         * The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code> .
         * <p>
         * For example: <code>TUE:03:30</code> . You can specify a start time in 30 minute increments only. Supported input includes the following:
         * <p>
         * <ul>
         * <li>MON|TUE|WED|THU|FRI|SAT|SUN:([01]\d|2[0-3]):(00|30)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-weeklymaintenancewindowstart</a>
         * @param weeklyMaintenanceWindowStart The day and time of the week to start weekly maintenance updates of your environment in the following format: <code>DAY:HH:MM</code> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder weeklyMaintenanceWindowStart(final java.lang.String weeklyMaintenanceWindowStart) {
            this.props.weeklyMaintenanceWindowStart(weeklyMaintenanceWindowStart);
            return this;
        }

        /**
         * The worker replacement strategy to use when updating the environment.
         * <p>
         * Valid values: <code>FORCED</code>, <code>GRACEFUL</code>. FORCED means Apache Airflow workers will be stopped and replaced without waiting for tasks to complete before an update. GRACEFUL means Apache Airflow workers will be able to complete running tasks for up to 12 hours during an update before being stopped and replaced.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-workerreplacementstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-mwaa-environment.html#cfn-mwaa-environment-workerreplacementstrategy</a>
         * @param workerReplacementStrategy The worker replacement strategy to use when updating the environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workerReplacementStrategy(final java.lang.String workerReplacementStrategy) {
            this.props.workerReplacementStrategy(workerReplacementStrategy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.mwaa.CfnEnvironment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.mwaa.CfnEnvironment build() {
            return new software.amazon.awscdk.services.mwaa.CfnEnvironment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
