package software.amazon.awscdk.services.nimblestudio;

/**
 * Properties for defining a <code>CfnStudioComponent</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.nimblestudio.*;
 * CfnStudioComponentProps cfnStudioComponentProps = CfnStudioComponentProps.builder()
 *         .name("name")
 *         .studioId("studioId")
 *         .type("type")
 *         // the properties below are optional
 *         .configuration(StudioComponentConfigurationProperty.builder()
 *                 .activeDirectoryConfiguration(ActiveDirectoryConfigurationProperty.builder()
 *                         .computerAttributes(List.of(ActiveDirectoryComputerAttributeProperty.builder()
 *                                 .name("name")
 *                                 .value("value")
 *                                 .build()))
 *                         .directoryId("directoryId")
 *                         .organizationalUnitDistinguishedName("organizationalUnitDistinguishedName")
 *                         .build())
 *                 .computeFarmConfiguration(ComputeFarmConfigurationProperty.builder()
 *                         .activeDirectoryUser("activeDirectoryUser")
 *                         .endpoint("endpoint")
 *                         .build())
 *                 .licenseServiceConfiguration(LicenseServiceConfigurationProperty.builder()
 *                         .endpoint("endpoint")
 *                         .build())
 *                 .sharedFileSystemConfiguration(SharedFileSystemConfigurationProperty.builder()
 *                         .endpoint("endpoint")
 *                         .fileSystemId("fileSystemId")
 *                         .linuxMountPoint("linuxMountPoint")
 *                         .shareName("shareName")
 *                         .windowsMountDrive("windowsMountDrive")
 *                         .build())
 *                 .build())
 *         .description("description")
 *         .ec2SecurityGroupIds(List.of("ec2SecurityGroupIds"))
 *         .initializationScripts(List.of(StudioComponentInitializationScriptProperty.builder()
 *                 .launchProfileProtocolVersion("launchProfileProtocolVersion")
 *                 .platform("platform")
 *                 .runContext("runContext")
 *                 .script("script")
 *                 .build()))
 *         .scriptParameters(List.of(ScriptParameterKeyValueProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .subtype("subtype")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:21.094Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_nimblestudio.CfnStudioComponentProps")
@software.amazon.jsii.Jsii.Proxy(CfnStudioComponentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnStudioComponentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-studioid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-studioid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStudioId();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-type</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getType();

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-ec2securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-ec2securitygroupids</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEc2SecurityGroupIds() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-initializationscripts">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-initializationscripts</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getInitializationScripts() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-scriptparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-scriptparameters</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getScriptParameters() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-subtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-subtype</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSubtype() {
        return null;
    }

    /**
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-nimblestudio-studiocomponent.html#cfn-nimblestudio-studiocomponent-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnStudioComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStudioComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnStudioComponentProps> {
        java.lang.String name;
        java.lang.String studioId;
        java.lang.String type;
        java.lang.Object configuration;
        java.lang.String description;
        java.util.List<java.lang.String> ec2SecurityGroupIds;
        java.lang.Object initializationScripts;
        java.lang.Object scriptParameters;
        java.lang.String subtype;
        java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Sets the value of {@link CfnStudioComponentProps#getName}
         * @param name the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getStudioId}
         * @param studioId the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder studioId(java.lang.String studioId) {
            this.studioId = studioId;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getType}
         * @param type the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(java.lang.String type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getConfiguration}
         * @param configuration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getConfiguration}
         * @param configuration the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.nimblestudio.CfnStudioComponent.StudioComponentConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getDescription}
         * @param description the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getEc2SecurityGroupIds}
         * @param ec2SecurityGroupIds the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2SecurityGroupIds(java.util.List<java.lang.String> ec2SecurityGroupIds) {
            this.ec2SecurityGroupIds = ec2SecurityGroupIds;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getInitializationScripts}
         * @param initializationScripts the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initializationScripts(software.amazon.awscdk.IResolvable initializationScripts) {
            this.initializationScripts = initializationScripts;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getInitializationScripts}
         * @param initializationScripts the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initializationScripts(java.util.List<? extends java.lang.Object> initializationScripts) {
            this.initializationScripts = initializationScripts;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getScriptParameters}
         * @param scriptParameters the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scriptParameters(software.amazon.awscdk.IResolvable scriptParameters) {
            this.scriptParameters = scriptParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getScriptParameters}
         * @param scriptParameters the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scriptParameters(java.util.List<? extends java.lang.Object> scriptParameters) {
            this.scriptParameters = scriptParameters;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getSubtype}
         * @param subtype the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subtype(java.lang.String subtype) {
            this.subtype = subtype;
            return this;
        }

        /**
         * Sets the value of {@link CfnStudioComponentProps#getTags}
         * @param tags the value to be set.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStudioComponentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnStudioComponentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnStudioComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStudioComponentProps {
        private final java.lang.String name;
        private final java.lang.String studioId;
        private final java.lang.String type;
        private final java.lang.Object configuration;
        private final java.lang.String description;
        private final java.util.List<java.lang.String> ec2SecurityGroupIds;
        private final java.lang.Object initializationScripts;
        private final java.lang.Object scriptParameters;
        private final java.lang.String subtype;
        private final java.util.Map<java.lang.String, java.lang.String> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.studioId = software.amazon.jsii.Kernel.get(this, "studioId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ec2SecurityGroupIds = software.amazon.jsii.Kernel.get(this, "ec2SecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.initializationScripts = software.amazon.jsii.Kernel.get(this, "initializationScripts", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.scriptParameters = software.amazon.jsii.Kernel.get(this, "scriptParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.subtype = software.amazon.jsii.Kernel.get(this, "subtype", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.studioId = java.util.Objects.requireNonNull(builder.studioId, "studioId is required");
            this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            this.configuration = builder.configuration;
            this.description = builder.description;
            this.ec2SecurityGroupIds = builder.ec2SecurityGroupIds;
            this.initializationScripts = builder.initializationScripts;
            this.scriptParameters = builder.scriptParameters;
            this.subtype = builder.subtype;
            this.tags = builder.tags;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.String getStudioId() {
            return this.studioId;
        }

        @Override
        public final java.lang.String getType() {
            return this.type;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.util.List<java.lang.String> getEc2SecurityGroupIds() {
            return this.ec2SecurityGroupIds;
        }

        @Override
        public final java.lang.Object getInitializationScripts() {
            return this.initializationScripts;
        }

        @Override
        public final java.lang.Object getScriptParameters() {
            return this.scriptParameters;
        }

        @Override
        public final java.lang.String getSubtype() {
            return this.subtype;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            data.set("studioId", om.valueToTree(this.getStudioId()));
            data.set("type", om.valueToTree(this.getType()));
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEc2SecurityGroupIds() != null) {
                data.set("ec2SecurityGroupIds", om.valueToTree(this.getEc2SecurityGroupIds()));
            }
            if (this.getInitializationScripts() != null) {
                data.set("initializationScripts", om.valueToTree(this.getInitializationScripts()));
            }
            if (this.getScriptParameters() != null) {
                data.set("scriptParameters", om.valueToTree(this.getScriptParameters()));
            }
            if (this.getSubtype() != null) {
                data.set("subtype", om.valueToTree(this.getSubtype()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_nimblestudio.CfnStudioComponentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStudioComponentProps.Jsii$Proxy that = (CfnStudioComponentProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            if (!studioId.equals(that.studioId)) return false;
            if (!type.equals(that.type)) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.ec2SecurityGroupIds != null ? !this.ec2SecurityGroupIds.equals(that.ec2SecurityGroupIds) : that.ec2SecurityGroupIds != null) return false;
            if (this.initializationScripts != null ? !this.initializationScripts.equals(that.initializationScripts) : that.initializationScripts != null) return false;
            if (this.scriptParameters != null ? !this.scriptParameters.equals(that.scriptParameters) : that.scriptParameters != null) return false;
            if (this.subtype != null ? !this.subtype.equals(that.subtype) : that.subtype != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.studioId.hashCode());
            result = 31 * result + (this.type.hashCode());
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.ec2SecurityGroupIds != null ? this.ec2SecurityGroupIds.hashCode() : 0);
            result = 31 * result + (this.initializationScripts != null ? this.initializationScripts.hashCode() : 0);
            result = 31 * result + (this.scriptParameters != null ? this.scriptParameters.hashCode() : 0);
            result = 31 * result + (this.subtype != null ? this.subtype.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
