package software.amazon.awscdk.services.opensearchservice;

/**
 * The AWS::OpenSearchService::Domain resource creates an Amazon OpenSearch Service domain.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.opensearchservice.*;
 * Object accessPolicies;
 * CfnDomain cfnDomain = CfnDomain.Builder.create(this, "MyCfnDomain")
 *         .accessPolicies(accessPolicies)
 *         .advancedOptions(Map.of(
 *                 "advancedOptionsKey", "advancedOptions"))
 *         .advancedSecurityOptions(AdvancedSecurityOptionsInputProperty.builder()
 *                 .anonymousAuthDisableDate("anonymousAuthDisableDate")
 *                 .anonymousAuthEnabled(false)
 *                 .enabled(false)
 *                 .internalUserDatabaseEnabled(false)
 *                 .jwtOptions(JWTOptionsProperty.builder()
 *                         .enabled(false)
 *                         .publicKey("publicKey")
 *                         .rolesKey("rolesKey")
 *                         .subjectKey("subjectKey")
 *                         .build())
 *                 .masterUserOptions(MasterUserOptionsProperty.builder()
 *                         .masterUserArn("masterUserArn")
 *                         .masterUserName("masterUserName")
 *                         .masterUserPassword("masterUserPassword")
 *                         .build())
 *                 .samlOptions(SAMLOptionsProperty.builder()
 *                         .enabled(false)
 *                         .idp(IdpProperty.builder()
 *                                 .entityId("entityId")
 *                                 .metadataContent("metadataContent")
 *                                 .build())
 *                         .masterBackendRole("masterBackendRole")
 *                         .masterUserName("masterUserName")
 *                         .rolesKey("rolesKey")
 *                         .sessionTimeoutMinutes(123)
 *                         .subjectKey("subjectKey")
 *                         .build())
 *                 .build())
 *         .clusterConfig(ClusterConfigProperty.builder()
 *                 .coldStorageOptions(ColdStorageOptionsProperty.builder()
 *                         .enabled(false)
 *                         .build())
 *                 .dedicatedMasterCount(123)
 *                 .dedicatedMasterEnabled(false)
 *                 .dedicatedMasterType("dedicatedMasterType")
 *                 .instanceCount(123)
 *                 .instanceType("instanceType")
 *                 .multiAzWithStandbyEnabled(false)
 *                 .nodeOptions(List.of(NodeOptionProperty.builder()
 *                         .nodeConfig(NodeConfigProperty.builder()
 *                                 .count(123)
 *                                 .enabled(false)
 *                                 .type("type")
 *                                 .build())
 *                         .nodeType("nodeType")
 *                         .build()))
 *                 .warmCount(123)
 *                 .warmEnabled(false)
 *                 .warmType("warmType")
 *                 .zoneAwarenessConfig(ZoneAwarenessConfigProperty.builder()
 *                         .availabilityZoneCount(123)
 *                         .build())
 *                 .zoneAwarenessEnabled(false)
 *                 .build())
 *         .cognitoOptions(CognitoOptionsProperty.builder()
 *                 .enabled(false)
 *                 .identityPoolId("identityPoolId")
 *                 .roleArn("roleArn")
 *                 .userPoolId("userPoolId")
 *                 .build())
 *         .domainArn("domainArn")
 *         .domainEndpointOptions(DomainEndpointOptionsProperty.builder()
 *                 .customEndpoint("customEndpoint")
 *                 .customEndpointCertificateArn("customEndpointCertificateArn")
 *                 .customEndpointEnabled(false)
 *                 .enforceHttps(false)
 *                 .tlsSecurityPolicy("tlsSecurityPolicy")
 *                 .build())
 *         .domainName("domainName")
 *         .ebsOptions(EBSOptionsProperty.builder()
 *                 .ebsEnabled(false)
 *                 .iops(123)
 *                 .throughput(123)
 *                 .volumeSize(123)
 *                 .volumeType("volumeType")
 *                 .build())
 *         .encryptionAtRestOptions(EncryptionAtRestOptionsProperty.builder()
 *                 .enabled(false)
 *                 .kmsKeyId("kmsKeyId")
 *                 .build())
 *         .engineVersion("engineVersion")
 *         .identityCenterOptions(IdentityCenterOptionsProperty.builder()
 *                 .enabledApiAccess(false)
 *                 .identityCenterApplicationArn("identityCenterApplicationArn")
 *                 .identityCenterInstanceArn("identityCenterInstanceArn")
 *                 .identityStoreId("identityStoreId")
 *                 .rolesKey("rolesKey")
 *                 .subjectKey("subjectKey")
 *                 .build())
 *         .ipAddressType("ipAddressType")
 *         .logPublishingOptions(Map.of(
 *                 "logPublishingOptionsKey", LogPublishingOptionProperty.builder()
 *                         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *                         .enabled(false)
 *                         .build()))
 *         .nodeToNodeEncryptionOptions(NodeToNodeEncryptionOptionsProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .offPeakWindowOptions(OffPeakWindowOptionsProperty.builder()
 *                 .enabled(false)
 *                 .offPeakWindow(OffPeakWindowProperty.builder()
 *                         .windowStartTime(WindowStartTimeProperty.builder()
 *                                 .hours(123)
 *                                 .minutes(123)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .skipShardMigrationWait(false)
 *         .snapshotOptions(SnapshotOptionsProperty.builder()
 *                 .automatedSnapshotStartHour(123)
 *                 .build())
 *         .softwareUpdateOptions(SoftwareUpdateOptionsProperty.builder()
 *                 .autoSoftwareUpdateEnabled(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .vpcOptions(VPCOptionsProperty.builder()
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .subnetIds(List.of("subnetIds"))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:21.300Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain")
public class CfnDomain extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnDomain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.opensearchservice.CfnDomain.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomainProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDomain(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Date and time when the migration period will be disabled.
     * <p>
     * Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrAdvancedSecurityOptionsAnonymousAuthDisableDate() {
        return software.amazon.jsii.Kernel.get(this, "attrAdvancedSecurityOptionsAnonymousAuthDisableDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the CloudFormation stack.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The domain-specific endpoint used for requests to the OpenSearch APIs, such as <code>search-mystack-1ab2cdefghij-ab1c2deckoyb3hofw7wpqa3cm.us-west-1.es.amazonaws.com</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrDomainEndpoints() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainEndpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * If <code>IPAddressType</code> to set to <code>dualstack</code> , a version 2 domain endpoint is provisioned.
     * <p>
     * This endpoint functions like a normal endpoint, except that it works with both IPv4 and IPv6 IP addresses. Normal endpoints work only with IPv4 IP addresses.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainEndpointV2() {
        return software.amazon.jsii.Kernel.get(this, "attrDomainEndpointV2", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The resource ID.
     * <p>
     * For example, <code>123456789012/my-domain</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ARN of the IAM Identity Center application that integrates with Amazon OpenSearch Service.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityCenterOptionsIdentityCenterApplicationArn() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityCenterOptionsIdentityCenterApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the IAM Identity Store.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrIdentityCenterOptionsIdentityStoreId() {
        return software.amazon.jsii.Kernel.get(this, "attrIdentityCenterOptionsIdentityStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrServiceSoftwareOptions() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceSoftwareOptionsAutomatedUpdateDate() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsAutomatedUpdateDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrServiceSoftwareOptionsCancellable() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsCancellable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceSoftwareOptionsCurrentVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsCurrentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceSoftwareOptionsDescription() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceSoftwareOptionsNewVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsNewVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrServiceSoftwareOptionsOptionalDeployment() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsOptionalDeployment", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrServiceSoftwareOptionsUpdateAvailable() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsUpdateAvailable", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrServiceSoftwareOptionsUpdateStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrServiceSoftwareOptionsUpdateStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicies() {
        return software.amazon.jsii.Kernel.get(this, "accessPolicies", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessPolicies(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "accessPolicies", value);
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedOptions() {
        return software.amazon.jsii.Kernel.get(this, "advancedOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedOptions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "advancedOptions", value);
    }

    /**
     * Additional options to specify for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedOptions", value);
    }

    /**
     * Specifies options for fine-grained access control and SAML authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedSecurityOptions() {
        return software.amazon.jsii.Kernel.get(this, "advancedSecurityOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies options for fine-grained access control and SAML authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedSecurityOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedSecurityOptions", value);
    }

    /**
     * Specifies options for fine-grained access control and SAML authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedSecurityOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.AdvancedSecurityOptionsInputProperty value) {
        software.amazon.jsii.Kernel.set(this, "advancedSecurityOptions", value);
    }

    /**
     * Container for the cluster configuration of a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getClusterConfig() {
        return software.amazon.jsii.Kernel.get(this, "clusterConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Container for the cluster configuration of a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "clusterConfig", value);
    }

    /**
     * Container for the cluster configuration of a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setClusterConfig(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.ClusterConfigProperty value) {
        software.amazon.jsii.Kernel.set(this, "clusterConfig", value);
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCognitoOptions() {
        return software.amazon.jsii.Kernel.get(this, "cognitoOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "cognitoOptions", value);
    }

    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCognitoOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.CognitoOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "cognitoOptions", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainArn() {
        return software.amazon.jsii.Kernel.get(this, "domainArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainArn", value);
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDomainEndpointOptions() {
        return software.amazon.jsii.Kernel.get(this, "domainEndpointOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainEndpointOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "domainEndpointOptions", value);
    }

    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainEndpointOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.DomainEndpointOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "domainEndpointOptions", value);
    }

    /**
     * A name for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDomainName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "domainName", value);
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEbsOptions() {
        return software.amazon.jsii.Kernel.get(this, "ebsOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptions", value);
    }

    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEbsOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.EBSOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "ebsOptions", value);
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionAtRestOptions() {
        return software.amazon.jsii.Kernel.get(this, "encryptionAtRestOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "encryptionAtRestOptions", value);
    }

    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionAtRestOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.EncryptionAtRestOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "encryptionAtRestOptions", value);
    }

    /**
     * The version of OpenSearch to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEngineVersion() {
        return software.amazon.jsii.Kernel.get(this, "engineVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The version of OpenSearch to use.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEngineVersion(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "engineVersion", value);
    }

    /**
     * Configuration options for controlling IAM Identity Center integration within a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIdentityCenterOptions() {
        return software.amazon.jsii.Kernel.get(this, "identityCenterOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration options for controlling IAM Identity Center integration within a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityCenterOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "identityCenterOptions", value);
    }

    /**
     * Configuration options for controlling IAM Identity Center integration within a domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIdentityCenterOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.IdentityCenterOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "identityCenterOptions", value);
    }

    /**
     * Choose either dual stack or IPv4 as your IP address type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getIpAddressType() {
        return software.amazon.jsii.Kernel.get(this, "ipAddressType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Choose either dual stack or IPv4 as your IP address type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIpAddressType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "ipAddressType", value);
    }

    /**
     * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLogPublishingOptions() {
        return software.amazon.jsii.Kernel.get(this, "logPublishingOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "logPublishingOptions", value);
    }

    /**
     * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLogPublishingOptions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.opensearchservice.CfnDomain.LogPublishingOptionProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.opensearchservice.CfnDomain.LogPublishingOptionProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "logPublishingOptions", value);
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNodeToNodeEncryptionOptions() {
        return software.amazon.jsii.Kernel.get(this, "nodeToNodeEncryptionOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeToNodeEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "nodeToNodeEncryptionOptions", value);
    }

    /**
     * Specifies whether node-to-node encryption is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNodeToNodeEncryptionOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.NodeToNodeEncryptionOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "nodeToNodeEncryptionOptions", value);
    }

    /**
     * Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getOffPeakWindowOptions() {
        return software.amazon.jsii.Kernel.get(this, "offPeakWindowOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOffPeakWindowOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "offPeakWindowOptions", value);
    }

    /**
     * Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOffPeakWindowOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.OffPeakWindowOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "offPeakWindowOptions", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSkipShardMigrationWait() {
        return software.amazon.jsii.Kernel.get(this, "skipShardMigrationWait", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSkipShardMigrationWait(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "skipShardMigrationWait", value);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSkipShardMigrationWait(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "skipShardMigrationWait", value);
    }

    /**
     * <em>DEPRECATED</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSnapshotOptions() {
        return software.amazon.jsii.Kernel.get(this, "snapshotOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * <em>DEPRECATED</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "snapshotOptions", value);
    }

    /**
     * <em>DEPRECATED</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.SnapshotOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "snapshotOptions", value);
    }

    /**
     * Service software update options for the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getSoftwareUpdateOptions() {
        return software.amazon.jsii.Kernel.get(this, "softwareUpdateOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Service software update options for the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSoftwareUpdateOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "softwareUpdateOptions", value);
    }

    /**
     * Service software update options for the domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSoftwareUpdateOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.SoftwareUpdateOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "softwareUpdateOptions", value);
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getVpcOptions() {
        return software.amazon.jsii.Kernel.get(this, "vpcOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "vpcOptions", value);
    }

    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setVpcOptions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.opensearchservice.CfnDomain.VPCOptionsProperty value) {
        software.amazon.jsii.Kernel.set(this, "vpcOptions", value);
    }
    /**
     * Specifies options for fine-grained access control.
     * <p>
     * If you specify advanced security options, you must also enable node-to-node encryption ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html">NodeToNodeEncryptionOptions</a> ) and encryption at rest ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html">EncryptionAtRestOptions</a> ). You must also enable <code>EnforceHTTPS</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html">DomainEndpointOptions</a> , which requires HTTPS for all traffic to the domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * AdvancedSecurityOptionsInputProperty advancedSecurityOptionsInputProperty = AdvancedSecurityOptionsInputProperty.builder()
     *         .anonymousAuthDisableDate("anonymousAuthDisableDate")
     *         .anonymousAuthEnabled(false)
     *         .enabled(false)
     *         .internalUserDatabaseEnabled(false)
     *         .jwtOptions(JWTOptionsProperty.builder()
     *                 .enabled(false)
     *                 .publicKey("publicKey")
     *                 .rolesKey("rolesKey")
     *                 .subjectKey("subjectKey")
     *                 .build())
     *         .masterUserOptions(MasterUserOptionsProperty.builder()
     *                 .masterUserArn("masterUserArn")
     *                 .masterUserName("masterUserName")
     *                 .masterUserPassword("masterUserPassword")
     *                 .build())
     *         .samlOptions(SAMLOptionsProperty.builder()
     *                 .enabled(false)
     *                 .idp(IdpProperty.builder()
     *                         .entityId("entityId")
     *                         .metadataContent("metadataContent")
     *                         .build())
     *                 .masterBackendRole("masterBackendRole")
     *                 .masterUserName("masterUserName")
     *                 .rolesKey("rolesKey")
     *                 .sessionTimeoutMinutes(123)
     *                 .subjectKey("subjectKey")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.AdvancedSecurityOptionsInputProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedSecurityOptionsInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedSecurityOptionsInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Date and time when the migration period will be disabled.
         * <p>
         * Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-anonymousauthdisabledate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-anonymousauthdisabledate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAnonymousAuthDisableDate() {
            return null;
        }

        /**
         * True to enable a 30-day migration period during which administrators can create role mappings.
         * <p>
         * Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-anonymousauthenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-anonymousauthenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAnonymousAuthEnabled() {
            return null;
        }

        /**
         * True to enable fine-grained access control.
         * <p>
         * You must also enable encryption of data at rest and node-to-node encryption. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html">Fine-grained access control in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * True to enable the internal user database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-internaluserdatabaseenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-internaluserdatabaseenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInternalUserDatabaseEnabled() {
            return null;
        }

        /**
         * Container for information about the JWT configuration of the Amazon OpenSearch Service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-jwtoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-jwtoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getJwtOptions() {
            return null;
        }

        /**
         * Specifies information about the master user.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-masteruseroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-masteruseroptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMasterUserOptions() {
            return null;
        }

        /**
         * Container for information about the SAML configuration for OpenSearch Dashboards.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-samloptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html#cfn-opensearchservice-domain-advancedsecurityoptionsinput-samloptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSamlOptions() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedSecurityOptionsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedSecurityOptionsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedSecurityOptionsInputProperty> {
            java.lang.String anonymousAuthDisableDate;
            java.lang.Object anonymousAuthEnabled;
            java.lang.Object enabled;
            java.lang.Object internalUserDatabaseEnabled;
            java.lang.Object jwtOptions;
            java.lang.Object masterUserOptions;
            java.lang.Object samlOptions;

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getAnonymousAuthDisableDate}
             * @param anonymousAuthDisableDate Date and time when the migration period will be disabled.
             *                                 Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anonymousAuthDisableDate(java.lang.String anonymousAuthDisableDate) {
                this.anonymousAuthDisableDate = anonymousAuthDisableDate;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getAnonymousAuthEnabled}
             * @param anonymousAuthEnabled True to enable a 30-day migration period during which administrators can create role mappings.
             *                             Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anonymousAuthEnabled(java.lang.Boolean anonymousAuthEnabled) {
                this.anonymousAuthEnabled = anonymousAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getAnonymousAuthEnabled}
             * @param anonymousAuthEnabled True to enable a 30-day migration period during which administrators can create role mappings.
             *                             Only necessary when <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html#fgac-enabling-existing">enabling fine-grained access control on an existing domain</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder anonymousAuthEnabled(software.amazon.awscdk.IResolvable anonymousAuthEnabled) {
                this.anonymousAuthEnabled = anonymousAuthEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getEnabled}
             * @param enabled True to enable fine-grained access control.
             *                You must also enable encryption of data at rest and node-to-node encryption. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html">Fine-grained access control in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getEnabled}
             * @param enabled True to enable fine-grained access control.
             *                You must also enable encryption of data at rest and node-to-node encryption. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/fgac.html">Fine-grained access control in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getInternalUserDatabaseEnabled}
             * @param internalUserDatabaseEnabled True to enable the internal user database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internalUserDatabaseEnabled(java.lang.Boolean internalUserDatabaseEnabled) {
                this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getInternalUserDatabaseEnabled}
             * @param internalUserDatabaseEnabled True to enable the internal user database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder internalUserDatabaseEnabled(software.amazon.awscdk.IResolvable internalUserDatabaseEnabled) {
                this.internalUserDatabaseEnabled = internalUserDatabaseEnabled;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getJwtOptions}
             * @param jwtOptions Container for information about the JWT configuration of the Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jwtOptions(software.amazon.awscdk.IResolvable jwtOptions) {
                this.jwtOptions = jwtOptions;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getJwtOptions}
             * @param jwtOptions Container for information about the JWT configuration of the Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder jwtOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.JWTOptionsProperty jwtOptions) {
                this.jwtOptions = jwtOptions;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getMasterUserOptions}
             * @param masterUserOptions Specifies information about the master user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserOptions(software.amazon.awscdk.IResolvable masterUserOptions) {
                this.masterUserOptions = masterUserOptions;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getMasterUserOptions}
             * @param masterUserOptions Specifies information about the master user.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.MasterUserOptionsProperty masterUserOptions) {
                this.masterUserOptions = masterUserOptions;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getSamlOptions}
             * @param samlOptions Container for information about the SAML configuration for OpenSearch Dashboards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samlOptions(software.amazon.awscdk.IResolvable samlOptions) {
                this.samlOptions = samlOptions;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedSecurityOptionsInputProperty#getSamlOptions}
             * @param samlOptions Container for information about the SAML configuration for OpenSearch Dashboards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder samlOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.SAMLOptionsProperty samlOptions) {
                this.samlOptions = samlOptions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedSecurityOptionsInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedSecurityOptionsInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedSecurityOptionsInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedSecurityOptionsInputProperty {
            private final java.lang.String anonymousAuthDisableDate;
            private final java.lang.Object anonymousAuthEnabled;
            private final java.lang.Object enabled;
            private final java.lang.Object internalUserDatabaseEnabled;
            private final java.lang.Object jwtOptions;
            private final java.lang.Object masterUserOptions;
            private final java.lang.Object samlOptions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.anonymousAuthDisableDate = software.amazon.jsii.Kernel.get(this, "anonymousAuthDisableDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.anonymousAuthEnabled = software.amazon.jsii.Kernel.get(this, "anonymousAuthEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.internalUserDatabaseEnabled = software.amazon.jsii.Kernel.get(this, "internalUserDatabaseEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.jwtOptions = software.amazon.jsii.Kernel.get(this, "jwtOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.masterUserOptions = software.amazon.jsii.Kernel.get(this, "masterUserOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.samlOptions = software.amazon.jsii.Kernel.get(this, "samlOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.anonymousAuthDisableDate = builder.anonymousAuthDisableDate;
                this.anonymousAuthEnabled = builder.anonymousAuthEnabled;
                this.enabled = builder.enabled;
                this.internalUserDatabaseEnabled = builder.internalUserDatabaseEnabled;
                this.jwtOptions = builder.jwtOptions;
                this.masterUserOptions = builder.masterUserOptions;
                this.samlOptions = builder.samlOptions;
            }

            @Override
            public final java.lang.String getAnonymousAuthDisableDate() {
                return this.anonymousAuthDisableDate;
            }

            @Override
            public final java.lang.Object getAnonymousAuthEnabled() {
                return this.anonymousAuthEnabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getInternalUserDatabaseEnabled() {
                return this.internalUserDatabaseEnabled;
            }

            @Override
            public final java.lang.Object getJwtOptions() {
                return this.jwtOptions;
            }

            @Override
            public final java.lang.Object getMasterUserOptions() {
                return this.masterUserOptions;
            }

            @Override
            public final java.lang.Object getSamlOptions() {
                return this.samlOptions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAnonymousAuthDisableDate() != null) {
                    data.set("anonymousAuthDisableDate", om.valueToTree(this.getAnonymousAuthDisableDate()));
                }
                if (this.getAnonymousAuthEnabled() != null) {
                    data.set("anonymousAuthEnabled", om.valueToTree(this.getAnonymousAuthEnabled()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getInternalUserDatabaseEnabled() != null) {
                    data.set("internalUserDatabaseEnabled", om.valueToTree(this.getInternalUserDatabaseEnabled()));
                }
                if (this.getJwtOptions() != null) {
                    data.set("jwtOptions", om.valueToTree(this.getJwtOptions()));
                }
                if (this.getMasterUserOptions() != null) {
                    data.set("masterUserOptions", om.valueToTree(this.getMasterUserOptions()));
                }
                if (this.getSamlOptions() != null) {
                    data.set("samlOptions", om.valueToTree(this.getSamlOptions()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.AdvancedSecurityOptionsInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedSecurityOptionsInputProperty.Jsii$Proxy that = (AdvancedSecurityOptionsInputProperty.Jsii$Proxy) o;

                if (this.anonymousAuthDisableDate != null ? !this.anonymousAuthDisableDate.equals(that.anonymousAuthDisableDate) : that.anonymousAuthDisableDate != null) return false;
                if (this.anonymousAuthEnabled != null ? !this.anonymousAuthEnabled.equals(that.anonymousAuthEnabled) : that.anonymousAuthEnabled != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.internalUserDatabaseEnabled != null ? !this.internalUserDatabaseEnabled.equals(that.internalUserDatabaseEnabled) : that.internalUserDatabaseEnabled != null) return false;
                if (this.jwtOptions != null ? !this.jwtOptions.equals(that.jwtOptions) : that.jwtOptions != null) return false;
                if (this.masterUserOptions != null ? !this.masterUserOptions.equals(that.masterUserOptions) : that.masterUserOptions != null) return false;
                return this.samlOptions != null ? this.samlOptions.equals(that.samlOptions) : that.samlOptions == null;
            }

            @Override
            public final int hashCode() {
                int result = this.anonymousAuthDisableDate != null ? this.anonymousAuthDisableDate.hashCode() : 0;
                result = 31 * result + (this.anonymousAuthEnabled != null ? this.anonymousAuthEnabled.hashCode() : 0);
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.internalUserDatabaseEnabled != null ? this.internalUserDatabaseEnabled.hashCode() : 0);
                result = 31 * result + (this.jwtOptions != null ? this.jwtOptions.hashCode() : 0);
                result = 31 * result + (this.masterUserOptions != null ? this.masterUserOptions.hashCode() : 0);
                result = 31 * result + (this.samlOptions != null ? this.samlOptions.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The cluster configuration for the OpenSearch Service domain.
     * <p>
     * You can specify options such as the instance type and the number of instances. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createupdatedomains.html">Creating and managing Amazon OpenSearch Service domains</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * ClusterConfigProperty clusterConfigProperty = ClusterConfigProperty.builder()
     *         .coldStorageOptions(ColdStorageOptionsProperty.builder()
     *                 .enabled(false)
     *                 .build())
     *         .dedicatedMasterCount(123)
     *         .dedicatedMasterEnabled(false)
     *         .dedicatedMasterType("dedicatedMasterType")
     *         .instanceCount(123)
     *         .instanceType("instanceType")
     *         .multiAzWithStandbyEnabled(false)
     *         .nodeOptions(List.of(NodeOptionProperty.builder()
     *                 .nodeConfig(NodeConfigProperty.builder()
     *                         .count(123)
     *                         .enabled(false)
     *                         .type("type")
     *                         .build())
     *                 .nodeType("nodeType")
     *                 .build()))
     *         .warmCount(123)
     *         .warmEnabled(false)
     *         .warmType("warmType")
     *         .zoneAwarenessConfig(ZoneAwarenessConfigProperty.builder()
     *                 .availabilityZoneCount(123)
     *                 .build())
     *         .zoneAwarenessEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.ClusterConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ClusterConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ClusterConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Container for cold storage configuration options.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-coldstorageoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-coldstorageoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getColdStorageOptions() {
            return null;
        }

        /**
         * The number of instances to use for the master node.
         * <p>
         * If you specify this property, you must specify <code>true</code> for the <code>DedicatedMasterEnabled</code> property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-dedicatedmastercount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-dedicatedmastercount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDedicatedMasterCount() {
            return null;
        }

        /**
         * Indicates whether to use a dedicated master node for the OpenSearch Service domain.
         * <p>
         * A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html">Dedicated master nodes in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-dedicatedmasterenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-dedicatedmasterenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDedicatedMasterEnabled() {
            return null;
        }

        /**
         * The hardware configuration of the computer that hosts the dedicated master node, such as <code>m3.medium.search</code> . If you specify this property, you must specify <code>true</code> for the <code>DedicatedMasterEnabled</code> property. For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-dedicatedmastertype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-dedicatedmastertype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDedicatedMasterType() {
            return null;
        }

        /**
         * The number of data nodes (instances) to use in the OpenSearch Service domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-instancecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-instancecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getInstanceCount() {
            return null;
        }

        /**
         * The instance type for your data nodes, such as <code>m3.medium.search</code> . For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-instancetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-instancetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInstanceType() {
            return null;
        }

        /**
         * Indicates whether Multi-AZ with Standby deployment option is enabled.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html#managedomains-za-standby">Multi-AZ with Standby</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-multiazwithstandbyenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-multiazwithstandbyenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMultiAzWithStandbyEnabled() {
            return null;
        }

        /**
         * List of node options for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-nodeoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-nodeoptions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNodeOptions() {
            return null;
        }

        /**
         * The number of warm nodes in the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-warmcount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-warmcount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getWarmCount() {
            return null;
        }

        /**
         * Whether to enable UltraWarm storage for the cluster.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ultrawarm.html">UltraWarm storage for Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-warmenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-warmenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWarmEnabled() {
            return null;
        }

        /**
         * The instance type for the cluster's warm nodes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-warmtype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-warmtype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWarmType() {
            return null;
        }

        /**
         * Specifies zone awareness configuration options.
         * <p>
         * Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-zoneawarenessconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-zoneawarenessconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZoneAwarenessConfig() {
            return null;
        }

        /**
         * Indicates whether to enable zone awareness for the OpenSearch Service domain.
         * <p>
         * When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-zoneawarenessenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html#cfn-opensearchservice-domain-clusterconfig-zoneawarenessenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getZoneAwarenessEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ClusterConfigProperty> {
            java.lang.Object coldStorageOptions;
            java.lang.Number dedicatedMasterCount;
            java.lang.Object dedicatedMasterEnabled;
            java.lang.String dedicatedMasterType;
            java.lang.Number instanceCount;
            java.lang.String instanceType;
            java.lang.Object multiAzWithStandbyEnabled;
            java.lang.Object nodeOptions;
            java.lang.Number warmCount;
            java.lang.Object warmEnabled;
            java.lang.String warmType;
            java.lang.Object zoneAwarenessConfig;
            java.lang.Object zoneAwarenessEnabled;

            /**
             * Sets the value of {@link ClusterConfigProperty#getColdStorageOptions}
             * @param coldStorageOptions Container for cold storage configuration options.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coldStorageOptions(software.amazon.awscdk.IResolvable coldStorageOptions) {
                this.coldStorageOptions = coldStorageOptions;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getColdStorageOptions}
             * @param coldStorageOptions Container for cold storage configuration options.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder coldStorageOptions(software.amazon.awscdk.services.opensearchservice.CfnDomain.ColdStorageOptionsProperty coldStorageOptions) {
                this.coldStorageOptions = coldStorageOptions;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getDedicatedMasterCount}
             * @param dedicatedMasterCount The number of instances to use for the master node.
             *                             If you specify this property, you must specify <code>true</code> for the <code>DedicatedMasterEnabled</code> property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterCount(java.lang.Number dedicatedMasterCount) {
                this.dedicatedMasterCount = dedicatedMasterCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getDedicatedMasterEnabled}
             * @param dedicatedMasterEnabled Indicates whether to use a dedicated master node for the OpenSearch Service domain.
             *                               A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html">Dedicated master nodes in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterEnabled(java.lang.Boolean dedicatedMasterEnabled) {
                this.dedicatedMasterEnabled = dedicatedMasterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getDedicatedMasterEnabled}
             * @param dedicatedMasterEnabled Indicates whether to use a dedicated master node for the OpenSearch Service domain.
             *                               A dedicated master node is a cluster node that performs cluster management tasks, but doesn't hold data or respond to data upload requests. Dedicated master nodes offload cluster management tasks to increase the stability of your search clusters. See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-dedicatedmasternodes.html">Dedicated master nodes in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterEnabled(software.amazon.awscdk.IResolvable dedicatedMasterEnabled) {
                this.dedicatedMasterEnabled = dedicatedMasterEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getDedicatedMasterType}
             * @param dedicatedMasterType The hardware configuration of the computer that hosts the dedicated master node, such as <code>m3.medium.search</code> . If you specify this property, you must specify <code>true</code> for the <code>DedicatedMasterEnabled</code> property. For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dedicatedMasterType(java.lang.String dedicatedMasterType) {
                this.dedicatedMasterType = dedicatedMasterType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceCount}
             * @param instanceCount The number of data nodes (instances) to use in the OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceCount(java.lang.Number instanceCount) {
                this.instanceCount = instanceCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getInstanceType}
             * @param instanceType The instance type for your data nodes, such as <code>m3.medium.search</code> . For valid values, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/supported-instance-types.html">Supported instance types in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder instanceType(java.lang.String instanceType) {
                this.instanceType = instanceType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getMultiAzWithStandbyEnabled}
             * @param multiAzWithStandbyEnabled Indicates whether Multi-AZ with Standby deployment option is enabled.
             *                                  For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html#managedomains-za-standby">Multi-AZ with Standby</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiAzWithStandbyEnabled(java.lang.Boolean multiAzWithStandbyEnabled) {
                this.multiAzWithStandbyEnabled = multiAzWithStandbyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getMultiAzWithStandbyEnabled}
             * @param multiAzWithStandbyEnabled Indicates whether Multi-AZ with Standby deployment option is enabled.
             *                                  For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html#managedomains-za-standby">Multi-AZ with Standby</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder multiAzWithStandbyEnabled(software.amazon.awscdk.IResolvable multiAzWithStandbyEnabled) {
                this.multiAzWithStandbyEnabled = multiAzWithStandbyEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getNodeOptions}
             * @param nodeOptions List of node options for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeOptions(software.amazon.awscdk.IResolvable nodeOptions) {
                this.nodeOptions = nodeOptions;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getNodeOptions}
             * @param nodeOptions List of node options for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeOptions(java.util.List<? extends java.lang.Object> nodeOptions) {
                this.nodeOptions = nodeOptions;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getWarmCount}
             * @param warmCount The number of warm nodes in the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmCount(java.lang.Number warmCount) {
                this.warmCount = warmCount;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getWarmEnabled}
             * @param warmEnabled Whether to enable UltraWarm storage for the cluster.
             *                    See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ultrawarm.html">UltraWarm storage for Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmEnabled(java.lang.Boolean warmEnabled) {
                this.warmEnabled = warmEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getWarmEnabled}
             * @param warmEnabled Whether to enable UltraWarm storage for the cluster.
             *                    See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ultrawarm.html">UltraWarm storage for Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmEnabled(software.amazon.awscdk.IResolvable warmEnabled) {
                this.warmEnabled = warmEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getWarmType}
             * @param warmType The instance type for the cluster's warm nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder warmType(java.lang.String warmType) {
                this.warmType = warmType;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getZoneAwarenessConfig}
             * @param zoneAwarenessConfig Specifies zone awareness configuration options.
             *                            Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessConfig(software.amazon.awscdk.IResolvable zoneAwarenessConfig) {
                this.zoneAwarenessConfig = zoneAwarenessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getZoneAwarenessConfig}
             * @param zoneAwarenessConfig Specifies zone awareness configuration options.
             *                            Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessConfig(software.amazon.awscdk.services.opensearchservice.CfnDomain.ZoneAwarenessConfigProperty zoneAwarenessConfig) {
                this.zoneAwarenessConfig = zoneAwarenessConfig;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getZoneAwarenessEnabled}
             * @param zoneAwarenessEnabled Indicates whether to enable zone awareness for the OpenSearch Service domain.
             *                             When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessEnabled(java.lang.Boolean zoneAwarenessEnabled) {
                this.zoneAwarenessEnabled = zoneAwarenessEnabled;
                return this;
            }

            /**
             * Sets the value of {@link ClusterConfigProperty#getZoneAwarenessEnabled}
             * @param zoneAwarenessEnabled Indicates whether to enable zone awareness for the OpenSearch Service domain.
             *                             When you enable zone awareness, OpenSearch Service allocates the nodes and replica index shards that belong to a cluster across two Availability Zones (AZs) in the same region to prevent data loss and minimize downtime in the event of node or data center failure. Don't enable zone awareness if your cluster has no replica index shards or is a single-node cluster. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/managedomains-multiaz.html">Configuring a multi-AZ domain in Amazon OpenSearch Service</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder zoneAwarenessEnabled(software.amazon.awscdk.IResolvable zoneAwarenessEnabled) {
                this.zoneAwarenessEnabled = zoneAwarenessEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ClusterConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ClusterConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ClusterConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ClusterConfigProperty {
            private final java.lang.Object coldStorageOptions;
            private final java.lang.Number dedicatedMasterCount;
            private final java.lang.Object dedicatedMasterEnabled;
            private final java.lang.String dedicatedMasterType;
            private final java.lang.Number instanceCount;
            private final java.lang.String instanceType;
            private final java.lang.Object multiAzWithStandbyEnabled;
            private final java.lang.Object nodeOptions;
            private final java.lang.Number warmCount;
            private final java.lang.Object warmEnabled;
            private final java.lang.String warmType;
            private final java.lang.Object zoneAwarenessConfig;
            private final java.lang.Object zoneAwarenessEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.coldStorageOptions = software.amazon.jsii.Kernel.get(this, "coldStorageOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dedicatedMasterCount = software.amazon.jsii.Kernel.get(this, "dedicatedMasterCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.dedicatedMasterEnabled = software.amazon.jsii.Kernel.get(this, "dedicatedMasterEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.dedicatedMasterType = software.amazon.jsii.Kernel.get(this, "dedicatedMasterType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.instanceCount = software.amazon.jsii.Kernel.get(this, "instanceCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.multiAzWithStandbyEnabled = software.amazon.jsii.Kernel.get(this, "multiAzWithStandbyEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nodeOptions = software.amazon.jsii.Kernel.get(this, "nodeOptions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.warmCount = software.amazon.jsii.Kernel.get(this, "warmCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.warmEnabled = software.amazon.jsii.Kernel.get(this, "warmEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.warmType = software.amazon.jsii.Kernel.get(this, "warmType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.zoneAwarenessConfig = software.amazon.jsii.Kernel.get(this, "zoneAwarenessConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.zoneAwarenessEnabled = software.amazon.jsii.Kernel.get(this, "zoneAwarenessEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.coldStorageOptions = builder.coldStorageOptions;
                this.dedicatedMasterCount = builder.dedicatedMasterCount;
                this.dedicatedMasterEnabled = builder.dedicatedMasterEnabled;
                this.dedicatedMasterType = builder.dedicatedMasterType;
                this.instanceCount = builder.instanceCount;
                this.instanceType = builder.instanceType;
                this.multiAzWithStandbyEnabled = builder.multiAzWithStandbyEnabled;
                this.nodeOptions = builder.nodeOptions;
                this.warmCount = builder.warmCount;
                this.warmEnabled = builder.warmEnabled;
                this.warmType = builder.warmType;
                this.zoneAwarenessConfig = builder.zoneAwarenessConfig;
                this.zoneAwarenessEnabled = builder.zoneAwarenessEnabled;
            }

            @Override
            public final java.lang.Object getColdStorageOptions() {
                return this.coldStorageOptions;
            }

            @Override
            public final java.lang.Number getDedicatedMasterCount() {
                return this.dedicatedMasterCount;
            }

            @Override
            public final java.lang.Object getDedicatedMasterEnabled() {
                return this.dedicatedMasterEnabled;
            }

            @Override
            public final java.lang.String getDedicatedMasterType() {
                return this.dedicatedMasterType;
            }

            @Override
            public final java.lang.Number getInstanceCount() {
                return this.instanceCount;
            }

            @Override
            public final java.lang.String getInstanceType() {
                return this.instanceType;
            }

            @Override
            public final java.lang.Object getMultiAzWithStandbyEnabled() {
                return this.multiAzWithStandbyEnabled;
            }

            @Override
            public final java.lang.Object getNodeOptions() {
                return this.nodeOptions;
            }

            @Override
            public final java.lang.Number getWarmCount() {
                return this.warmCount;
            }

            @Override
            public final java.lang.Object getWarmEnabled() {
                return this.warmEnabled;
            }

            @Override
            public final java.lang.String getWarmType() {
                return this.warmType;
            }

            @Override
            public final java.lang.Object getZoneAwarenessConfig() {
                return this.zoneAwarenessConfig;
            }

            @Override
            public final java.lang.Object getZoneAwarenessEnabled() {
                return this.zoneAwarenessEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getColdStorageOptions() != null) {
                    data.set("coldStorageOptions", om.valueToTree(this.getColdStorageOptions()));
                }
                if (this.getDedicatedMasterCount() != null) {
                    data.set("dedicatedMasterCount", om.valueToTree(this.getDedicatedMasterCount()));
                }
                if (this.getDedicatedMasterEnabled() != null) {
                    data.set("dedicatedMasterEnabled", om.valueToTree(this.getDedicatedMasterEnabled()));
                }
                if (this.getDedicatedMasterType() != null) {
                    data.set("dedicatedMasterType", om.valueToTree(this.getDedicatedMasterType()));
                }
                if (this.getInstanceCount() != null) {
                    data.set("instanceCount", om.valueToTree(this.getInstanceCount()));
                }
                if (this.getInstanceType() != null) {
                    data.set("instanceType", om.valueToTree(this.getInstanceType()));
                }
                if (this.getMultiAzWithStandbyEnabled() != null) {
                    data.set("multiAzWithStandbyEnabled", om.valueToTree(this.getMultiAzWithStandbyEnabled()));
                }
                if (this.getNodeOptions() != null) {
                    data.set("nodeOptions", om.valueToTree(this.getNodeOptions()));
                }
                if (this.getWarmCount() != null) {
                    data.set("warmCount", om.valueToTree(this.getWarmCount()));
                }
                if (this.getWarmEnabled() != null) {
                    data.set("warmEnabled", om.valueToTree(this.getWarmEnabled()));
                }
                if (this.getWarmType() != null) {
                    data.set("warmType", om.valueToTree(this.getWarmType()));
                }
                if (this.getZoneAwarenessConfig() != null) {
                    data.set("zoneAwarenessConfig", om.valueToTree(this.getZoneAwarenessConfig()));
                }
                if (this.getZoneAwarenessEnabled() != null) {
                    data.set("zoneAwarenessEnabled", om.valueToTree(this.getZoneAwarenessEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.ClusterConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ClusterConfigProperty.Jsii$Proxy that = (ClusterConfigProperty.Jsii$Proxy) o;

                if (this.coldStorageOptions != null ? !this.coldStorageOptions.equals(that.coldStorageOptions) : that.coldStorageOptions != null) return false;
                if (this.dedicatedMasterCount != null ? !this.dedicatedMasterCount.equals(that.dedicatedMasterCount) : that.dedicatedMasterCount != null) return false;
                if (this.dedicatedMasterEnabled != null ? !this.dedicatedMasterEnabled.equals(that.dedicatedMasterEnabled) : that.dedicatedMasterEnabled != null) return false;
                if (this.dedicatedMasterType != null ? !this.dedicatedMasterType.equals(that.dedicatedMasterType) : that.dedicatedMasterType != null) return false;
                if (this.instanceCount != null ? !this.instanceCount.equals(that.instanceCount) : that.instanceCount != null) return false;
                if (this.instanceType != null ? !this.instanceType.equals(that.instanceType) : that.instanceType != null) return false;
                if (this.multiAzWithStandbyEnabled != null ? !this.multiAzWithStandbyEnabled.equals(that.multiAzWithStandbyEnabled) : that.multiAzWithStandbyEnabled != null) return false;
                if (this.nodeOptions != null ? !this.nodeOptions.equals(that.nodeOptions) : that.nodeOptions != null) return false;
                if (this.warmCount != null ? !this.warmCount.equals(that.warmCount) : that.warmCount != null) return false;
                if (this.warmEnabled != null ? !this.warmEnabled.equals(that.warmEnabled) : that.warmEnabled != null) return false;
                if (this.warmType != null ? !this.warmType.equals(that.warmType) : that.warmType != null) return false;
                if (this.zoneAwarenessConfig != null ? !this.zoneAwarenessConfig.equals(that.zoneAwarenessConfig) : that.zoneAwarenessConfig != null) return false;
                return this.zoneAwarenessEnabled != null ? this.zoneAwarenessEnabled.equals(that.zoneAwarenessEnabled) : that.zoneAwarenessEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.coldStorageOptions != null ? this.coldStorageOptions.hashCode() : 0;
                result = 31 * result + (this.dedicatedMasterCount != null ? this.dedicatedMasterCount.hashCode() : 0);
                result = 31 * result + (this.dedicatedMasterEnabled != null ? this.dedicatedMasterEnabled.hashCode() : 0);
                result = 31 * result + (this.dedicatedMasterType != null ? this.dedicatedMasterType.hashCode() : 0);
                result = 31 * result + (this.instanceCount != null ? this.instanceCount.hashCode() : 0);
                result = 31 * result + (this.instanceType != null ? this.instanceType.hashCode() : 0);
                result = 31 * result + (this.multiAzWithStandbyEnabled != null ? this.multiAzWithStandbyEnabled.hashCode() : 0);
                result = 31 * result + (this.nodeOptions != null ? this.nodeOptions.hashCode() : 0);
                result = 31 * result + (this.warmCount != null ? this.warmCount.hashCode() : 0);
                result = 31 * result + (this.warmEnabled != null ? this.warmEnabled.hashCode() : 0);
                result = 31 * result + (this.warmType != null ? this.warmType.hashCode() : 0);
                result = 31 * result + (this.zoneAwarenessConfig != null ? this.zoneAwarenessConfig.hashCode() : 0);
                result = 31 * result + (this.zoneAwarenessEnabled != null ? this.zoneAwarenessEnabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * CognitoOptionsProperty cognitoOptionsProperty = CognitoOptionsProperty.builder()
     *         .enabled(false)
     *         .identityPoolId("identityPoolId")
     *         .roleArn("roleArn")
     *         .userPoolId("userPoolId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.CognitoOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(CognitoOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CognitoOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Amazon Cognito authentication for OpenSearch Dashboards</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
         * <p>
         * Required if you enabled Cognito Authentication for OpenSearch Dashboards.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-identitypoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-identitypoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityPoolId() {
            return null;
        }

        /**
         * The <code>AmazonOpenSearchServiceCognitoAccess</code> role that allows OpenSearch Service to configure your user pool and identity pool.
         * <p>
         * Required if you enabled Cognito Authentication for OpenSearch Dashboards.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRoleArn() {
            return null;
        }

        /**
         * The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
         * <p>
         * Required if you enabled Cognito Authentication for OpenSearch Dashboards.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-userpoolid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-cognitooptions.html#cfn-opensearchservice-domain-cognitooptions-userpoolid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUserPoolId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CognitoOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String identityPoolId;
            java.lang.String roleArn;
            java.lang.String userPoolId;

            /**
             * Sets the value of {@link CognitoOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
             *                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Amazon Cognito authentication for OpenSearch Dashboards</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable Amazon Cognito authentication for OpenSearch Dashboards.
             *                See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cognito-auth.html">Amazon Cognito authentication for OpenSearch Dashboards</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getIdentityPoolId}
             * @param identityPoolId The Amazon Cognito identity pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
             *                       Required if you enabled Cognito Authentication for OpenSearch Dashboards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityPoolId(java.lang.String identityPoolId) {
                this.identityPoolId = identityPoolId;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getRoleArn}
             * @param roleArn The <code>AmazonOpenSearchServiceCognitoAccess</code> role that allows OpenSearch Service to configure your user pool and identity pool.
             *                Required if you enabled Cognito Authentication for OpenSearch Dashboards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link CognitoOptionsProperty#getUserPoolId}
             * @param userPoolId The Amazon Cognito user pool ID that you want OpenSearch Service to use for OpenSearch Dashboards authentication.
             *                   Required if you enabled Cognito Authentication for OpenSearch Dashboards.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder userPoolId(java.lang.String userPoolId) {
                this.userPoolId = userPoolId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CognitoOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CognitoOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CognitoOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String identityPoolId;
            private final java.lang.String roleArn;
            private final java.lang.String userPoolId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.identityPoolId = software.amazon.jsii.Kernel.get(this, "identityPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.userPoolId = software.amazon.jsii.Kernel.get(this, "userPoolId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.identityPoolId = builder.identityPoolId;
                this.roleArn = builder.roleArn;
                this.userPoolId = builder.userPoolId;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getIdentityPoolId() {
                return this.identityPoolId;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getUserPoolId() {
                return this.userPoolId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIdentityPoolId() != null) {
                    data.set("identityPoolId", om.valueToTree(this.getIdentityPoolId()));
                }
                if (this.getRoleArn() != null) {
                    data.set("roleArn", om.valueToTree(this.getRoleArn()));
                }
                if (this.getUserPoolId() != null) {
                    data.set("userPoolId", om.valueToTree(this.getUserPoolId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.CognitoOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CognitoOptionsProperty.Jsii$Proxy that = (CognitoOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.identityPoolId != null ? !this.identityPoolId.equals(that.identityPoolId) : that.identityPoolId != null) return false;
                if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
                return this.userPoolId != null ? this.userPoolId.equals(that.userPoolId) : that.userPoolId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.identityPoolId != null ? this.identityPoolId.hashCode() : 0);
                result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
                result = 31 * result + (this.userPoolId != null ? this.userPoolId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Container for the parameters required to enable cold storage for an OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/cold-storage.html">Cold storage for Amazon OpenSearch Service</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * ColdStorageOptionsProperty coldStorageOptionsProperty = ColdStorageOptionsProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-coldstorageoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-coldstorageoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.ColdStorageOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ColdStorageOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ColdStorageOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Whether to enable or disable cold storage on the domain.
         * <p>
         * You must enable UltraWarm storage to enable cold storage.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-coldstorageoptions.html#cfn-opensearchservice-domain-coldstorageoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-coldstorageoptions.html#cfn-opensearchservice-domain-coldstorageoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ColdStorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ColdStorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ColdStorageOptionsProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link ColdStorageOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable cold storage on the domain.
             *                You must enable UltraWarm storage to enable cold storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link ColdStorageOptionsProperty#getEnabled}
             * @param enabled Whether to enable or disable cold storage on the domain.
             *                You must enable UltraWarm storage to enable cold storage.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ColdStorageOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ColdStorageOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ColdStorageOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ColdStorageOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.ColdStorageOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ColdStorageOptionsProperty.Jsii$Proxy that = (ColdStorageOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * DomainEndpointOptionsProperty domainEndpointOptionsProperty = DomainEndpointOptionsProperty.builder()
     *         .customEndpoint("customEndpoint")
     *         .customEndpointCertificateArn("customEndpointCertificateArn")
     *         .customEndpointEnabled(false)
     *         .enforceHttps(false)
     *         .tlsSecurityPolicy("tlsSecurityPolicy")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.DomainEndpointOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(DomainEndpointOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DomainEndpointOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The fully qualified URL for your custom endpoint.
         * <p>
         * Required if you enabled a custom endpoint for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-customendpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-customendpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomEndpoint() {
            return null;
        }

        /**
         * The AWS Certificate Manager ARN for your domain's SSL/TLS certificate.
         * <p>
         * Required if you enabled a custom endpoint for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-customendpointcertificatearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-customendpointcertificatearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCustomEndpointCertificateArn() {
            return null;
        }

        /**
         * True to enable a custom endpoint for the domain.
         * <p>
         * If enabled, you must also provide values for <code>CustomEndpoint</code> and <code>CustomEndpointCertificateArn</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-customendpointenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-customendpointenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomEndpointEnabled() {
            return null;
        }

        /**
         * True to require that all traffic to the domain arrive over HTTPS.
         * <p>
         * Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptions</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-enforcehttps">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-enforcehttps</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnforceHttps() {
            return null;
        }

        /**
         * The minimum TLS version required for traffic to the domain. The policy can be one of the following values:.
         * <p>
         * <ul>
         * <li><em>Policy-Min-TLS-1-0-2019-07:</em> TLS security policy that supports TLS version 1.0 to TLS version 1.2</li>
         * <li><em>Policy-Min-TLS-1-2-2019-07:</em> TLS security policy that supports only TLS version 1.2</li>
         * <li><em>Policy-Min-TLS-1-2-PFS-2023-10:</em> TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-tlssecuritypolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html#cfn-opensearchservice-domain-domainendpointoptions-tlssecuritypolicy</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTlsSecurityPolicy() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DomainEndpointOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainEndpointOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DomainEndpointOptionsProperty> {
            java.lang.String customEndpoint;
            java.lang.String customEndpointCertificateArn;
            java.lang.Object customEndpointEnabled;
            java.lang.Object enforceHttps;
            java.lang.String tlsSecurityPolicy;

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpoint}
             * @param customEndpoint The fully qualified URL for your custom endpoint.
             *                       Required if you enabled a custom endpoint for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpoint(java.lang.String customEndpoint) {
                this.customEndpoint = customEndpoint;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpointCertificateArn}
             * @param customEndpointCertificateArn The AWS Certificate Manager ARN for your domain's SSL/TLS certificate.
             *                                     Required if you enabled a custom endpoint for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpointCertificateArn(java.lang.String customEndpointCertificateArn) {
                this.customEndpointCertificateArn = customEndpointCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpointEnabled}
             * @param customEndpointEnabled True to enable a custom endpoint for the domain.
             *                              If enabled, you must also provide values for <code>CustomEndpoint</code> and <code>CustomEndpointCertificateArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpointEnabled(java.lang.Boolean customEndpointEnabled) {
                this.customEndpointEnabled = customEndpointEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getCustomEndpointEnabled}
             * @param customEndpointEnabled True to enable a custom endpoint for the domain.
             *                              If enabled, you must also provide values for <code>CustomEndpoint</code> and <code>CustomEndpointCertificateArn</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customEndpointEnabled(software.amazon.awscdk.IResolvable customEndpointEnabled) {
                this.customEndpointEnabled = customEndpointEnabled;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getEnforceHttps}
             * @param enforceHttps True to require that all traffic to the domain arrive over HTTPS.
             *                     Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceHttps(java.lang.Boolean enforceHttps) {
                this.enforceHttps = enforceHttps;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getEnforceHttps}
             * @param enforceHttps True to require that all traffic to the domain arrive over HTTPS.
             *                     Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptions</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enforceHttps(software.amazon.awscdk.IResolvable enforceHttps) {
                this.enforceHttps = enforceHttps;
                return this;
            }

            /**
             * Sets the value of {@link DomainEndpointOptionsProperty#getTlsSecurityPolicy}
             * @param tlsSecurityPolicy The minimum TLS version required for traffic to the domain. The policy can be one of the following values:.
             *                          <ul>
             *                          <li><em>Policy-Min-TLS-1-0-2019-07:</em> TLS security policy that supports TLS version 1.0 to TLS version 1.2</li>
             *                          <li><em>Policy-Min-TLS-1-2-2019-07:</em> TLS security policy that supports only TLS version 1.2</li>
             *                          <li><em>Policy-Min-TLS-1-2-PFS-2023-10:</em> TLS security policy that supports TLS version 1.2 to TLS version 1.3 with perfect forward secrecy cipher suites</li>
             *                          </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tlsSecurityPolicy(java.lang.String tlsSecurityPolicy) {
                this.tlsSecurityPolicy = tlsSecurityPolicy;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainEndpointOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DomainEndpointOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DomainEndpointOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainEndpointOptionsProperty {
            private final java.lang.String customEndpoint;
            private final java.lang.String customEndpointCertificateArn;
            private final java.lang.Object customEndpointEnabled;
            private final java.lang.Object enforceHttps;
            private final java.lang.String tlsSecurityPolicy;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customEndpoint = software.amazon.jsii.Kernel.get(this, "customEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customEndpointCertificateArn = software.amazon.jsii.Kernel.get(this, "customEndpointCertificateArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.customEndpointEnabled = software.amazon.jsii.Kernel.get(this, "customEndpointEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enforceHttps = software.amazon.jsii.Kernel.get(this, "enforceHttps", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.tlsSecurityPolicy = software.amazon.jsii.Kernel.get(this, "tlsSecurityPolicy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customEndpoint = builder.customEndpoint;
                this.customEndpointCertificateArn = builder.customEndpointCertificateArn;
                this.customEndpointEnabled = builder.customEndpointEnabled;
                this.enforceHttps = builder.enforceHttps;
                this.tlsSecurityPolicy = builder.tlsSecurityPolicy;
            }

            @Override
            public final java.lang.String getCustomEndpoint() {
                return this.customEndpoint;
            }

            @Override
            public final java.lang.String getCustomEndpointCertificateArn() {
                return this.customEndpointCertificateArn;
            }

            @Override
            public final java.lang.Object getCustomEndpointEnabled() {
                return this.customEndpointEnabled;
            }

            @Override
            public final java.lang.Object getEnforceHttps() {
                return this.enforceHttps;
            }

            @Override
            public final java.lang.String getTlsSecurityPolicy() {
                return this.tlsSecurityPolicy;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCustomEndpoint() != null) {
                    data.set("customEndpoint", om.valueToTree(this.getCustomEndpoint()));
                }
                if (this.getCustomEndpointCertificateArn() != null) {
                    data.set("customEndpointCertificateArn", om.valueToTree(this.getCustomEndpointCertificateArn()));
                }
                if (this.getCustomEndpointEnabled() != null) {
                    data.set("customEndpointEnabled", om.valueToTree(this.getCustomEndpointEnabled()));
                }
                if (this.getEnforceHttps() != null) {
                    data.set("enforceHttps", om.valueToTree(this.getEnforceHttps()));
                }
                if (this.getTlsSecurityPolicy() != null) {
                    data.set("tlsSecurityPolicy", om.valueToTree(this.getTlsSecurityPolicy()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.DomainEndpointOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainEndpointOptionsProperty.Jsii$Proxy that = (DomainEndpointOptionsProperty.Jsii$Proxy) o;

                if (this.customEndpoint != null ? !this.customEndpoint.equals(that.customEndpoint) : that.customEndpoint != null) return false;
                if (this.customEndpointCertificateArn != null ? !this.customEndpointCertificateArn.equals(that.customEndpointCertificateArn) : that.customEndpointCertificateArn != null) return false;
                if (this.customEndpointEnabled != null ? !this.customEndpointEnabled.equals(that.customEndpointEnabled) : that.customEndpointEnabled != null) return false;
                if (this.enforceHttps != null ? !this.enforceHttps.equals(that.enforceHttps) : that.enforceHttps != null) return false;
                return this.tlsSecurityPolicy != null ? this.tlsSecurityPolicy.equals(that.tlsSecurityPolicy) : that.tlsSecurityPolicy == null;
            }

            @Override
            public final int hashCode() {
                int result = this.customEndpoint != null ? this.customEndpoint.hashCode() : 0;
                result = 31 * result + (this.customEndpointCertificateArn != null ? this.customEndpointCertificateArn.hashCode() : 0);
                result = 31 * result + (this.customEndpointEnabled != null ? this.customEndpointEnabled.hashCode() : 0);
                result = 31 * result + (this.enforceHttps != null ? this.enforceHttps.hashCode() : 0);
                result = 31 * result + (this.tlsSecurityPolicy != null ? this.tlsSecurityPolicy.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * EBSOptionsProperty eBSOptionsProperty = EBSOptionsProperty.builder()
     *         .ebsEnabled(false)
     *         .iops(123)
     *         .throughput(123)
     *         .volumeSize(123)
     *         .volumeType("volumeType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.EBSOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EBSOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EBSOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-ebsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-ebsenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEbsEnabled() {
            return null;
        }

        /**
         * The number of I/O operations per second (IOPS) that the volume supports.
         * <p>
         * This property applies only to the <code>gp3</code> and provisioned IOPS EBS volume types.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-iops">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-iops</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getIops() {
            return null;
        }

        /**
         * The throughput (in MiB/s) of the EBS volumes attached to data nodes.
         * <p>
         * Applies only to the <code>gp3</code> volume type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-throughput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-throughput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getThroughput() {
            return null;
        }

        /**
         * The size (in GiB) of the EBS volume for each data node.
         * <p>
         * The minimum and maximum size of an EBS volume depends on the EBS volume type and the instance type to which it is attached. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-volumesize">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-volumesize</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
            return null;
        }

        /**
         * The EBS volume type to use with the OpenSearch Service domain.
         * <p>
         * If you choose <code>gp3</code> , you must also specify values for <code>Iops</code> and <code>Throughput</code> . For more information about each type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-volumetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-ebsoptions.html#cfn-opensearchservice-domain-ebsoptions-volumetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVolumeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EBSOptionsProperty> {
            java.lang.Object ebsEnabled;
            java.lang.Number iops;
            java.lang.Number throughput;
            java.lang.Number volumeSize;
            java.lang.String volumeType;

            /**
             * Sets the value of {@link EBSOptionsProperty#getEbsEnabled}
             * @param ebsEnabled Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsEnabled(java.lang.Boolean ebsEnabled) {
                this.ebsEnabled = ebsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getEbsEnabled}
             * @param ebsEnabled Specifies whether Amazon EBS volumes are attached to data nodes in the OpenSearch Service domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ebsEnabled(software.amazon.awscdk.IResolvable ebsEnabled) {
                this.ebsEnabled = ebsEnabled;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getIops}
             * @param iops The number of I/O operations per second (IOPS) that the volume supports.
             *             This property applies only to the <code>gp3</code> and provisioned IOPS EBS volume types.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iops(java.lang.Number iops) {
                this.iops = iops;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getThroughput}
             * @param throughput The throughput (in MiB/s) of the EBS volumes attached to data nodes.
             *                   Applies only to the <code>gp3</code> volume type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder throughput(java.lang.Number throughput) {
                this.throughput = throughput;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getVolumeSize}
             * @param volumeSize The size (in GiB) of the EBS volume for each data node.
             *                   The minimum and maximum size of an EBS volume depends on the EBS volume type and the instance type to which it is attached. For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeSize(java.lang.Number volumeSize) {
                this.volumeSize = volumeSize;
                return this;
            }

            /**
             * Sets the value of {@link EBSOptionsProperty#getVolumeType}
             * @param volumeType The EBS volume type to use with the OpenSearch Service domain.
             *                   If you choose <code>gp3</code> , you must also specify values for <code>Iops</code> and <code>Throughput</code> . For more information about each type, see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html">Amazon EBS volume types</a> in the <em>Amazon EC2 User Guide for Linux Instances</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder volumeType(java.lang.String volumeType) {
                this.volumeType = volumeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EBSOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EBSOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EBSOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EBSOptionsProperty {
            private final java.lang.Object ebsEnabled;
            private final java.lang.Number iops;
            private final java.lang.Number throughput;
            private final java.lang.Number volumeSize;
            private final java.lang.String volumeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.ebsEnabled = software.amazon.jsii.Kernel.get(this, "ebsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.ebsEnabled = builder.ebsEnabled;
                this.iops = builder.iops;
                this.throughput = builder.throughput;
                this.volumeSize = builder.volumeSize;
                this.volumeType = builder.volumeType;
            }

            @Override
            public final java.lang.Object getEbsEnabled() {
                return this.ebsEnabled;
            }

            @Override
            public final java.lang.Number getIops() {
                return this.iops;
            }

            @Override
            public final java.lang.Number getThroughput() {
                return this.throughput;
            }

            @Override
            public final java.lang.Number getVolumeSize() {
                return this.volumeSize;
            }

            @Override
            public final java.lang.String getVolumeType() {
                return this.volumeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEbsEnabled() != null) {
                    data.set("ebsEnabled", om.valueToTree(this.getEbsEnabled()));
                }
                if (this.getIops() != null) {
                    data.set("iops", om.valueToTree(this.getIops()));
                }
                if (this.getThroughput() != null) {
                    data.set("throughput", om.valueToTree(this.getThroughput()));
                }
                if (this.getVolumeSize() != null) {
                    data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
                }
                if (this.getVolumeType() != null) {
                    data.set("volumeType", om.valueToTree(this.getVolumeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.EBSOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EBSOptionsProperty.Jsii$Proxy that = (EBSOptionsProperty.Jsii$Proxy) o;

                if (this.ebsEnabled != null ? !this.ebsEnabled.equals(that.ebsEnabled) : that.ebsEnabled != null) return false;
                if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
                if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
                if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
                return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.ebsEnabled != null ? this.ebsEnabled.hashCode() : 0;
                result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
                result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
                result = 31 * result + (this.volumeSize != null ? this.volumeSize.hashCode() : 0);
                result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Whether the domain should encrypt data at rest, and if so, the AWS Key Management Service key to use.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * EncryptionAtRestOptionsProperty encryptionAtRestOptionsProperty = EncryptionAtRestOptionsProperty.builder()
     *         .enabled(false)
     *         .kmsKeyId("kmsKeyId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.EncryptionAtRestOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(EncryptionAtRestOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EncryptionAtRestOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specify <code>true</code> to enable encryption at rest. Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
         * <p>
         * If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html#cfn-opensearchservice-domain-encryptionatrestoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html#cfn-opensearchservice-domain-encryptionatrestoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The KMS key ID. Takes the form <code>1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a</code> . Required if you enable encryption at rest.
         * <p>
         * You can also use <code>keyAlias</code> as a value.
         * <p>
         * If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html#cfn-opensearchservice-domain-encryptionatrestoptions-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html#cfn-opensearchservice-domain-encryptionatrestoptions-kmskeyid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EncryptionAtRestOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String kmsKeyId;

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getEnabled}
             * @param enabled Specify <code>true</code> to enable encryption at rest. Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
             *                If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getEnabled}
             * @param enabled Specify <code>true</code> to enable encryption at rest. Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
             *                If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link EncryptionAtRestOptionsProperty#getKmsKeyId}
             * @param kmsKeyId The KMS key ID. Takes the form <code>1a2a3a4-1a2a-3a4a-5a6a-1a2a3a4a5a6a</code> . Required if you enable encryption at rest.
             *                 You can also use <code>keyAlias</code> as a value.
             *                 <p>
             *                 If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder kmsKeyId(java.lang.String kmsKeyId) {
                this.kmsKeyId = kmsKeyId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EncryptionAtRestOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EncryptionAtRestOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EncryptionAtRestOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EncryptionAtRestOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String kmsKeyId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.kmsKeyId = software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.kmsKeyId = builder.kmsKeyId;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getKmsKeyId() {
                return this.kmsKeyId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getKmsKeyId() != null) {
                    data.set("kmsKeyId", om.valueToTree(this.getKmsKeyId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.EncryptionAtRestOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EncryptionAtRestOptionsProperty.Jsii$Proxy that = (EncryptionAtRestOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.kmsKeyId != null ? this.kmsKeyId.equals(that.kmsKeyId) : that.kmsKeyId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.kmsKeyId != null ? this.kmsKeyId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Settings container for integrating IAM Identity Center with OpenSearch UI applications, which enables enabling secure user authentication and access control across multiple data sources.
     * <p>
     * This setup supports single sign-on (SSO) through IAM Identity Center, allowing centralized user management.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * IdentityCenterOptionsProperty identityCenterOptionsProperty = IdentityCenterOptionsProperty.builder()
     *         .enabledApiAccess(false)
     *         .identityCenterApplicationArn("identityCenterApplicationArn")
     *         .identityCenterInstanceArn("identityCenterInstanceArn")
     *         .identityStoreId("identityStoreId")
     *         .rolesKey("rolesKey")
     *         .subjectKey("subjectKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.IdentityCenterOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(IdentityCenterOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdentityCenterOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether IAM Identity Center is enabled for the application.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-enabledapiaccess">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-enabledapiaccess</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabledApiAccess() {
            return null;
        }

        /**
         * The ARN of the IAM Identity Center application that integrates with Amazon OpenSearch Service.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-identitycenterapplicationarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-identitycenterapplicationarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityCenterApplicationArn() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM Identity Center instance.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-identitycenterinstancearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-identitycenterinstancearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityCenterInstanceArn() {
            return null;
        }

        /**
         * The identifier of the IAM Identity Store.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-identitystoreid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-identitystoreid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIdentityStoreId() {
            return null;
        }

        /**
         * Specifies the attribute that contains the backend role identifier (such as group name or group ID) in IAM Identity Center.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-roleskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-roleskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRolesKey() {
            return null;
        }

        /**
         * Specifies the attribute that contains the subject identifier (such as username, user ID, or email) in IAM Identity Center.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-subjectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-identitycenteroptions.html#cfn-opensearchservice-domain-identitycenteroptions-subjectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubjectKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link IdentityCenterOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdentityCenterOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdentityCenterOptionsProperty> {
            java.lang.Object enabledApiAccess;
            java.lang.String identityCenterApplicationArn;
            java.lang.String identityCenterInstanceArn;
            java.lang.String identityStoreId;
            java.lang.String rolesKey;
            java.lang.String subjectKey;

            /**
             * Sets the value of {@link IdentityCenterOptionsProperty#getEnabledApiAccess}
             * @param enabledApiAccess Indicates whether IAM Identity Center is enabled for the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledApiAccess(java.lang.Boolean enabledApiAccess) {
                this.enabledApiAccess = enabledApiAccess;
                return this;
            }

            /**
             * Sets the value of {@link IdentityCenterOptionsProperty#getEnabledApiAccess}
             * @param enabledApiAccess Indicates whether IAM Identity Center is enabled for the application.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabledApiAccess(software.amazon.awscdk.IResolvable enabledApiAccess) {
                this.enabledApiAccess = enabledApiAccess;
                return this;
            }

            /**
             * Sets the value of {@link IdentityCenterOptionsProperty#getIdentityCenterApplicationArn}
             * @param identityCenterApplicationArn The ARN of the IAM Identity Center application that integrates with Amazon OpenSearch Service.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityCenterApplicationArn(java.lang.String identityCenterApplicationArn) {
                this.identityCenterApplicationArn = identityCenterApplicationArn;
                return this;
            }

            /**
             * Sets the value of {@link IdentityCenterOptionsProperty#getIdentityCenterInstanceArn}
             * @param identityCenterInstanceArn The Amazon Resource Name (ARN) of the IAM Identity Center instance.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityCenterInstanceArn(java.lang.String identityCenterInstanceArn) {
                this.identityCenterInstanceArn = identityCenterInstanceArn;
                return this;
            }

            /**
             * Sets the value of {@link IdentityCenterOptionsProperty#getIdentityStoreId}
             * @param identityStoreId The identifier of the IAM Identity Store.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder identityStoreId(java.lang.String identityStoreId) {
                this.identityStoreId = identityStoreId;
                return this;
            }

            /**
             * Sets the value of {@link IdentityCenterOptionsProperty#getRolesKey}
             * @param rolesKey Specifies the attribute that contains the backend role identifier (such as group name or group ID) in IAM Identity Center.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rolesKey(java.lang.String rolesKey) {
                this.rolesKey = rolesKey;
                return this;
            }

            /**
             * Sets the value of {@link IdentityCenterOptionsProperty#getSubjectKey}
             * @param subjectKey Specifies the attribute that contains the subject identifier (such as username, user ID, or email) in IAM Identity Center.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectKey(java.lang.String subjectKey) {
                this.subjectKey = subjectKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdentityCenterOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdentityCenterOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdentityCenterOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdentityCenterOptionsProperty {
            private final java.lang.Object enabledApiAccess;
            private final java.lang.String identityCenterApplicationArn;
            private final java.lang.String identityCenterInstanceArn;
            private final java.lang.String identityStoreId;
            private final java.lang.String rolesKey;
            private final java.lang.String subjectKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabledApiAccess = software.amazon.jsii.Kernel.get(this, "enabledApiAccess", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.identityCenterApplicationArn = software.amazon.jsii.Kernel.get(this, "identityCenterApplicationArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityCenterInstanceArn = software.amazon.jsii.Kernel.get(this, "identityCenterInstanceArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.identityStoreId = software.amazon.jsii.Kernel.get(this, "identityStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rolesKey = software.amazon.jsii.Kernel.get(this, "rolesKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subjectKey = software.amazon.jsii.Kernel.get(this, "subjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabledApiAccess = builder.enabledApiAccess;
                this.identityCenterApplicationArn = builder.identityCenterApplicationArn;
                this.identityCenterInstanceArn = builder.identityCenterInstanceArn;
                this.identityStoreId = builder.identityStoreId;
                this.rolesKey = builder.rolesKey;
                this.subjectKey = builder.subjectKey;
            }

            @Override
            public final java.lang.Object getEnabledApiAccess() {
                return this.enabledApiAccess;
            }

            @Override
            public final java.lang.String getIdentityCenterApplicationArn() {
                return this.identityCenterApplicationArn;
            }

            @Override
            public final java.lang.String getIdentityCenterInstanceArn() {
                return this.identityCenterInstanceArn;
            }

            @Override
            public final java.lang.String getIdentityStoreId() {
                return this.identityStoreId;
            }

            @Override
            public final java.lang.String getRolesKey() {
                return this.rolesKey;
            }

            @Override
            public final java.lang.String getSubjectKey() {
                return this.subjectKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabledApiAccess() != null) {
                    data.set("enabledApiAccess", om.valueToTree(this.getEnabledApiAccess()));
                }
                if (this.getIdentityCenterApplicationArn() != null) {
                    data.set("identityCenterApplicationArn", om.valueToTree(this.getIdentityCenterApplicationArn()));
                }
                if (this.getIdentityCenterInstanceArn() != null) {
                    data.set("identityCenterInstanceArn", om.valueToTree(this.getIdentityCenterInstanceArn()));
                }
                if (this.getIdentityStoreId() != null) {
                    data.set("identityStoreId", om.valueToTree(this.getIdentityStoreId()));
                }
                if (this.getRolesKey() != null) {
                    data.set("rolesKey", om.valueToTree(this.getRolesKey()));
                }
                if (this.getSubjectKey() != null) {
                    data.set("subjectKey", om.valueToTree(this.getSubjectKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.IdentityCenterOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdentityCenterOptionsProperty.Jsii$Proxy that = (IdentityCenterOptionsProperty.Jsii$Proxy) o;

                if (this.enabledApiAccess != null ? !this.enabledApiAccess.equals(that.enabledApiAccess) : that.enabledApiAccess != null) return false;
                if (this.identityCenterApplicationArn != null ? !this.identityCenterApplicationArn.equals(that.identityCenterApplicationArn) : that.identityCenterApplicationArn != null) return false;
                if (this.identityCenterInstanceArn != null ? !this.identityCenterInstanceArn.equals(that.identityCenterInstanceArn) : that.identityCenterInstanceArn != null) return false;
                if (this.identityStoreId != null ? !this.identityStoreId.equals(that.identityStoreId) : that.identityStoreId != null) return false;
                if (this.rolesKey != null ? !this.rolesKey.equals(that.rolesKey) : that.rolesKey != null) return false;
                return this.subjectKey != null ? this.subjectKey.equals(that.subjectKey) : that.subjectKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabledApiAccess != null ? this.enabledApiAccess.hashCode() : 0;
                result = 31 * result + (this.identityCenterApplicationArn != null ? this.identityCenterApplicationArn.hashCode() : 0);
                result = 31 * result + (this.identityCenterInstanceArn != null ? this.identityCenterInstanceArn.hashCode() : 0);
                result = 31 * result + (this.identityStoreId != null ? this.identityStoreId.hashCode() : 0);
                result = 31 * result + (this.rolesKey != null ? this.rolesKey.hashCode() : 0);
                result = 31 * result + (this.subjectKey != null ? this.subjectKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The SAML Identity Provider's information.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * IdpProperty idpProperty = IdpProperty.builder()
     *         .entityId("entityId")
     *         .metadataContent("metadataContent")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-idp.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-idp.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.IdpProperty")
    @software.amazon.jsii.Jsii.Proxy(IdpProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface IdpProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique entity ID of the application in the SAML identity provider.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-idp.html#cfn-opensearchservice-domain-idp-entityid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-idp.html#cfn-opensearchservice-domain-idp-entityid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEntityId();

        /**
         * The metadata of the SAML application, in XML format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-idp.html#cfn-opensearchservice-domain-idp-metadatacontent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-idp.html#cfn-opensearchservice-domain-idp-metadatacontent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMetadataContent();

        /**
         * @return a {@link Builder} of {@link IdpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IdpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<IdpProperty> {
            java.lang.String entityId;
            java.lang.String metadataContent;

            /**
             * Sets the value of {@link IdpProperty#getEntityId}
             * @param entityId The unique entity ID of the application in the SAML identity provider. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder entityId(java.lang.String entityId) {
                this.entityId = entityId;
                return this;
            }

            /**
             * Sets the value of {@link IdpProperty#getMetadataContent}
             * @param metadataContent The metadata of the SAML application, in XML format. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder metadataContent(java.lang.String metadataContent) {
                this.metadataContent = metadataContent;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IdpProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public IdpProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link IdpProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IdpProperty {
            private final java.lang.String entityId;
            private final java.lang.String metadataContent;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.entityId = software.amazon.jsii.Kernel.get(this, "entityId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.metadataContent = software.amazon.jsii.Kernel.get(this, "metadataContent", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.entityId = java.util.Objects.requireNonNull(builder.entityId, "entityId is required");
                this.metadataContent = java.util.Objects.requireNonNull(builder.metadataContent, "metadataContent is required");
            }

            @Override
            public final java.lang.String getEntityId() {
                return this.entityId;
            }

            @Override
            public final java.lang.String getMetadataContent() {
                return this.metadataContent;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("entityId", om.valueToTree(this.getEntityId()));
                data.set("metadataContent", om.valueToTree(this.getMetadataContent()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.IdpProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IdpProperty.Jsii$Proxy that = (IdpProperty.Jsii$Proxy) o;

                if (!entityId.equals(that.entityId)) return false;
                return this.metadataContent.equals(that.metadataContent);
            }

            @Override
            public final int hashCode() {
                int result = this.entityId.hashCode();
                result = 31 * result + (this.metadataContent.hashCode());
                return result;
            }
        }
    }
    /**
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * JWTOptionsProperty jWTOptionsProperty = JWTOptionsProperty.builder()
     *         .enabled(false)
     *         .publicKey("publicKey")
     *         .rolesKey("rolesKey")
     *         .subjectKey("subjectKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.JWTOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(JWTOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface JWTOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-publickey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-publickey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPublicKey() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-roleskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-roleskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRolesKey() {
            return null;
        }

        /**
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-subjectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-jwtoptions.html#cfn-opensearchservice-domain-jwtoptions-subjectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubjectKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link JWTOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link JWTOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<JWTOptionsProperty> {
            java.lang.Object enabled;
            java.lang.String publicKey;
            java.lang.String rolesKey;
            java.lang.String subjectKey;

            /**
             * Sets the value of {@link JWTOptionsProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link JWTOptionsProperty#getEnabled}
             * @param enabled the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link JWTOptionsProperty#getPublicKey}
             * @param publicKey the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publicKey(java.lang.String publicKey) {
                this.publicKey = publicKey;
                return this;
            }

            /**
             * Sets the value of {@link JWTOptionsProperty#getRolesKey}
             * @param rolesKey the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rolesKey(java.lang.String rolesKey) {
                this.rolesKey = rolesKey;
                return this;
            }

            /**
             * Sets the value of {@link JWTOptionsProperty#getSubjectKey}
             * @param subjectKey the value to be set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectKey(java.lang.String subjectKey) {
                this.subjectKey = subjectKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link JWTOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public JWTOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link JWTOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements JWTOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.String publicKey;
            private final java.lang.String rolesKey;
            private final java.lang.String subjectKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publicKey = software.amazon.jsii.Kernel.get(this, "publicKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rolesKey = software.amazon.jsii.Kernel.get(this, "rolesKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subjectKey = software.amazon.jsii.Kernel.get(this, "subjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.publicKey = builder.publicKey;
                this.rolesKey = builder.rolesKey;
                this.subjectKey = builder.subjectKey;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getPublicKey() {
                return this.publicKey;
            }

            @Override
            public final java.lang.String getRolesKey() {
                return this.rolesKey;
            }

            @Override
            public final java.lang.String getSubjectKey() {
                return this.subjectKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getPublicKey() != null) {
                    data.set("publicKey", om.valueToTree(this.getPublicKey()));
                }
                if (this.getRolesKey() != null) {
                    data.set("rolesKey", om.valueToTree(this.getRolesKey()));
                }
                if (this.getSubjectKey() != null) {
                    data.set("subjectKey", om.valueToTree(this.getSubjectKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.JWTOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                JWTOptionsProperty.Jsii$Proxy that = (JWTOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.publicKey != null ? !this.publicKey.equals(that.publicKey) : that.publicKey != null) return false;
                if (this.rolesKey != null ? !this.rolesKey.equals(that.rolesKey) : that.rolesKey != null) return false;
                return this.subjectKey != null ? this.subjectKey.equals(that.subjectKey) : that.subjectKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.publicKey != null ? this.publicKey.hashCode() : 0);
                result = 31 * result + (this.rolesKey != null ? this.rolesKey.hashCode() : 0);
                result = 31 * result + (this.subjectKey != null ? this.subjectKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies whether the OpenSearch Service domain publishes application, search slow logs, or index slow logs to Amazon CloudWatch.
     * <p>
     * Each option must be an object of name <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , or <code>AUDIT_LOGS</code> depending on the type of logs you want to publish. For the full syntax, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--examples">examples</a> .
     * <p>
     * Before you enable log publishing, you need to create a CloudWatch log group and provide OpenSearch Service the correct permissions to write to it. To learn more, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/createdomain-configure-slow-logs.html#createdomain-configure-slow-logs-cfn">Enabling log publishing ( AWS CloudFormation)</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * LogPublishingOptionProperty logPublishingOptionProperty = LogPublishingOptionProperty.builder()
     *         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-logpublishingoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-logpublishingoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.LogPublishingOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(LogPublishingOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogPublishingOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies the CloudWatch log group to publish to.
         * <p>
         * Required if you enable log publishing.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-logpublishingoption.html#cfn-opensearchservice-domain-logpublishingoption-cloudwatchlogsloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-logpublishingoption.html#cfn-opensearchservice-domain-logpublishingoption-cloudwatchlogsloggrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsLogGroupArn() {
            return null;
        }

        /**
         * If <code>true</code> , enables the publishing of logs to CloudWatch.
         * <p>
         * Default: <code>false</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-logpublishingoption.html#cfn-opensearchservice-domain-logpublishingoption-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-logpublishingoption.html#cfn-opensearchservice-domain-logpublishingoption-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogPublishingOptionProperty> {
            java.lang.String cloudWatchLogsLogGroupArn;
            java.lang.Object enabled;

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getCloudWatchLogsLogGroupArn}
             * @param cloudWatchLogsLogGroupArn Specifies the CloudWatch log group to publish to.
             *                                  Required if you enable log publishing.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroupArn(java.lang.String cloudWatchLogsLogGroupArn) {
                this.cloudWatchLogsLogGroupArn = cloudWatchLogsLogGroupArn;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getEnabled}
             * @param enabled If <code>true</code> , enables the publishing of logs to CloudWatch.
             *                Default: <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link LogPublishingOptionProperty#getEnabled}
             * @param enabled If <code>true</code> , enables the publishing of logs to CloudWatch.
             *                Default: <code>false</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogPublishingOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogPublishingOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogPublishingOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogPublishingOptionProperty {
            private final java.lang.String cloudWatchLogsLogGroupArn;
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsLogGroupArn = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsLogGroupArn = builder.cloudWatchLogsLogGroupArn;
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.String getCloudWatchLogsLogGroupArn() {
                return this.cloudWatchLogsLogGroupArn;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsLogGroupArn() != null) {
                    data.set("cloudWatchLogsLogGroupArn", om.valueToTree(this.getCloudWatchLogsLogGroupArn()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.LogPublishingOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogPublishingOptionProperty.Jsii$Proxy that = (LogPublishingOptionProperty.Jsii$Proxy) o;

                if (this.cloudWatchLogsLogGroupArn != null ? !this.cloudWatchLogsLogGroupArn.equals(that.cloudWatchLogsLogGroupArn) : that.cloudWatchLogsLogGroupArn != null) return false;
                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsLogGroupArn != null ? this.cloudWatchLogsLogGroupArn.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies information about the master user.
     * <p>
     * Required if <code>InternalUserDatabaseEnabled</code> is true in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptions</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * MasterUserOptionsProperty masterUserOptionsProperty = MasterUserOptionsProperty.builder()
     *         .masterUserArn("masterUserArn")
     *         .masterUserName("masterUserName")
     *         .masterUserPassword("masterUserPassword")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.MasterUserOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(MasterUserOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MasterUserOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Amazon Resource Name (ARN) for the master user.
         * <p>
         * The ARN can point to an IAM user or role. This property is required for Amazon Cognito to work, and it must match the role configured for Cognito. Only specify if <code>InternalUserDatabaseEnabled</code> is false in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html#cfn-opensearchservice-domain-masteruseroptions-masteruserarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html#cfn-opensearchservice-domain-masteruseroptions-masteruserarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserArn() {
            return null;
        }

        /**
         * Username for the master user. Only specify if <code>InternalUserDatabaseEnabled</code> is true in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
         * <p>
         * If you don't want to specify this value directly within the template, you can use a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">dynamic reference</a> instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html#cfn-opensearchservice-domain-masteruseroptions-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html#cfn-opensearchservice-domain-masteruseroptions-masterusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserName() {
            return null;
        }

        /**
         * Password for the master user. Only specify if <code>InternalUserDatabaseEnabled</code> is true in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
         * <p>
         * If you don't want to specify this value directly within the template, you can use a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">dynamic reference</a> instead.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html#cfn-opensearchservice-domain-masteruseroptions-masteruserpassword">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-masteruseroptions.html#cfn-opensearchservice-domain-masteruseroptions-masteruserpassword</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserPassword() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MasterUserOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MasterUserOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MasterUserOptionsProperty> {
            java.lang.String masterUserArn;
            java.lang.String masterUserName;
            java.lang.String masterUserPassword;

            /**
             * Sets the value of {@link MasterUserOptionsProperty#getMasterUserArn}
             * @param masterUserArn Amazon Resource Name (ARN) for the master user.
             *                      The ARN can point to an IAM user or role. This property is required for Amazon Cognito to work, and it must match the role configured for Cognito. Only specify if <code>InternalUserDatabaseEnabled</code> is false in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserArn(java.lang.String masterUserArn) {
                this.masterUserArn = masterUserArn;
                return this;
            }

            /**
             * Sets the value of {@link MasterUserOptionsProperty#getMasterUserName}
             * @param masterUserName Username for the master user. Only specify if <code>InternalUserDatabaseEnabled</code> is true in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
             *                       If you don't want to specify this value directly within the template, you can use a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">dynamic reference</a> instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserName(java.lang.String masterUserName) {
                this.masterUserName = masterUserName;
                return this;
            }

            /**
             * Sets the value of {@link MasterUserOptionsProperty#getMasterUserPassword}
             * @param masterUserPassword Password for the master user. Only specify if <code>InternalUserDatabaseEnabled</code> is true in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
             *                           If you don't want to specify this value directly within the template, you can use a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html">dynamic reference</a> instead.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserPassword(java.lang.String masterUserPassword) {
                this.masterUserPassword = masterUserPassword;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MasterUserOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MasterUserOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MasterUserOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MasterUserOptionsProperty {
            private final java.lang.String masterUserArn;
            private final java.lang.String masterUserName;
            private final java.lang.String masterUserPassword;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.masterUserArn = software.amazon.jsii.Kernel.get(this, "masterUserArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterUserName = software.amazon.jsii.Kernel.get(this, "masterUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterUserPassword = software.amazon.jsii.Kernel.get(this, "masterUserPassword", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.masterUserArn = builder.masterUserArn;
                this.masterUserName = builder.masterUserName;
                this.masterUserPassword = builder.masterUserPassword;
            }

            @Override
            public final java.lang.String getMasterUserArn() {
                return this.masterUserArn;
            }

            @Override
            public final java.lang.String getMasterUserName() {
                return this.masterUserName;
            }

            @Override
            public final java.lang.String getMasterUserPassword() {
                return this.masterUserPassword;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMasterUserArn() != null) {
                    data.set("masterUserArn", om.valueToTree(this.getMasterUserArn()));
                }
                if (this.getMasterUserName() != null) {
                    data.set("masterUserName", om.valueToTree(this.getMasterUserName()));
                }
                if (this.getMasterUserPassword() != null) {
                    data.set("masterUserPassword", om.valueToTree(this.getMasterUserPassword()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.MasterUserOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MasterUserOptionsProperty.Jsii$Proxy that = (MasterUserOptionsProperty.Jsii$Proxy) o;

                if (this.masterUserArn != null ? !this.masterUserArn.equals(that.masterUserArn) : that.masterUserArn != null) return false;
                if (this.masterUserName != null ? !this.masterUserName.equals(that.masterUserName) : that.masterUserName != null) return false;
                return this.masterUserPassword != null ? this.masterUserPassword.equals(that.masterUserPassword) : that.masterUserPassword == null;
            }

            @Override
            public final int hashCode() {
                int result = this.masterUserArn != null ? this.masterUserArn.hashCode() : 0;
                result = 31 * result + (this.masterUserName != null ? this.masterUserName.hashCode() : 0);
                result = 31 * result + (this.masterUserPassword != null ? this.masterUserPassword.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration options for defining the setup of any node type within the cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * NodeConfigProperty nodeConfigProperty = NodeConfigProperty.builder()
     *         .count(123)
     *         .enabled(false)
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.NodeConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The number of nodes of a specific type within the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html#cfn-opensearchservice-domain-nodeconfig-count">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html#cfn-opensearchservice-domain-nodeconfig-count</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getCount() {
            return null;
        }

        /**
         * A boolean value indicating whether a specific node type is active or inactive.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html#cfn-opensearchservice-domain-nodeconfig-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html#cfn-opensearchservice-domain-nodeconfig-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The instance type of a particular node within the cluster.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html#cfn-opensearchservice-domain-nodeconfig-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeconfig.html#cfn-opensearchservice-domain-nodeconfig-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeConfigProperty> {
            java.lang.Number count;
            java.lang.Object enabled;
            java.lang.String type;

            /**
             * Sets the value of {@link NodeConfigProperty#getCount}
             * @param count The number of nodes of a specific type within the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder count(java.lang.Number count) {
                this.count = count;
                return this;
            }

            /**
             * Sets the value of {@link NodeConfigProperty#getEnabled}
             * @param enabled A boolean value indicating whether a specific node type is active or inactive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link NodeConfigProperty#getEnabled}
             * @param enabled A boolean value indicating whether a specific node type is active or inactive.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link NodeConfigProperty#getType}
             * @param type The instance type of a particular node within the cluster.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeConfigProperty {
            private final java.lang.Number count;
            private final java.lang.Object enabled;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.count = software.amazon.jsii.Kernel.get(this, "count", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.count = builder.count;
                this.enabled = builder.enabled;
                this.type = builder.type;
            }

            @Override
            public final java.lang.Number getCount() {
                return this.count;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCount() != null) {
                    data.set("count", om.valueToTree(this.getCount()));
                }
                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getType() != null) {
                    data.set("type", om.valueToTree(this.getType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.NodeConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeConfigProperty.Jsii$Proxy that = (NodeConfigProperty.Jsii$Proxy) o;

                if (this.count != null ? !this.count.equals(that.count) : that.count != null) return false;
                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.type != null ? this.type.equals(that.type) : that.type == null;
            }

            @Override
            public final int hashCode() {
                int result = this.count != null ? this.count.hashCode() : 0;
                result = 31 * result + (this.enabled != null ? this.enabled.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Configuration settings for defining the node type within a cluster.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * NodeOptionProperty nodeOptionProperty = NodeOptionProperty.builder()
     *         .nodeConfig(NodeConfigProperty.builder()
     *                 .count(123)
     *                 .enabled(false)
     *                 .type("type")
     *                 .build())
     *         .nodeType("nodeType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeoption.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeoption.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.NodeOptionProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeOptionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeOptionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Configuration options for defining the setup of any node type.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeoption.html#cfn-opensearchservice-domain-nodeoption-nodeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeoption.html#cfn-opensearchservice-domain-nodeoption-nodeconfig</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNodeConfig() {
            return null;
        }

        /**
         * Defines the type of node, such as coordinating nodes.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeoption.html#cfn-opensearchservice-domain-nodeoption-nodetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodeoption.html#cfn-opensearchservice-domain-nodeoption-nodetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNodeType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeOptionProperty> {
            java.lang.Object nodeConfig;
            java.lang.String nodeType;

            /**
             * Sets the value of {@link NodeOptionProperty#getNodeConfig}
             * @param nodeConfig Configuration options for defining the setup of any node type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeConfig(software.amazon.awscdk.IResolvable nodeConfig) {
                this.nodeConfig = nodeConfig;
                return this;
            }

            /**
             * Sets the value of {@link NodeOptionProperty#getNodeConfig}
             * @param nodeConfig Configuration options for defining the setup of any node type.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeConfig(software.amazon.awscdk.services.opensearchservice.CfnDomain.NodeConfigProperty nodeConfig) {
                this.nodeConfig = nodeConfig;
                return this;
            }

            /**
             * Sets the value of {@link NodeOptionProperty#getNodeType}
             * @param nodeType Defines the type of node, such as coordinating nodes.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodeType(java.lang.String nodeType) {
                this.nodeType = nodeType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeOptionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeOptionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeOptionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeOptionProperty {
            private final java.lang.Object nodeConfig;
            private final java.lang.String nodeType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.nodeConfig = software.amazon.jsii.Kernel.get(this, "nodeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nodeType = software.amazon.jsii.Kernel.get(this, "nodeType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.nodeConfig = builder.nodeConfig;
                this.nodeType = builder.nodeType;
            }

            @Override
            public final java.lang.Object getNodeConfig() {
                return this.nodeConfig;
            }

            @Override
            public final java.lang.String getNodeType() {
                return this.nodeType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNodeConfig() != null) {
                    data.set("nodeConfig", om.valueToTree(this.getNodeConfig()));
                }
                if (this.getNodeType() != null) {
                    data.set("nodeType", om.valueToTree(this.getNodeType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.NodeOptionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeOptionProperty.Jsii$Proxy that = (NodeOptionProperty.Jsii$Proxy) o;

                if (this.nodeConfig != null ? !this.nodeConfig.equals(that.nodeConfig) : that.nodeConfig != null) return false;
                return this.nodeType != null ? this.nodeType.equals(that.nodeType) : that.nodeType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.nodeConfig != null ? this.nodeConfig.hashCode() : 0;
                result = 31 * result + (this.nodeType != null ? this.nodeType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies options for node-to-node encryption.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * NodeToNodeEncryptionOptionsProperty nodeToNodeEncryptionOptionsProperty = NodeToNodeEncryptionOptionsProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.NodeToNodeEncryptionOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(NodeToNodeEncryptionOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NodeToNodeEncryptionOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies to enable or disable node-to-node encryption on the domain.
         * <p>
         * Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NodeToNodeEncryptionOptionsProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link NodeToNodeEncryptionOptionsProperty#getEnabled}
             * @param enabled Specifies to enable or disable node-to-node encryption on the domain.
             *                Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link NodeToNodeEncryptionOptionsProperty#getEnabled}
             * @param enabled Specifies to enable or disable node-to-node encryption on the domain.
             *                Required if you enable fine-grained access control in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-advancedsecurityoptionsinput.html">AdvancedSecurityOptionsInput</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NodeToNodeEncryptionOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NodeToNodeEncryptionOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NodeToNodeEncryptionOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NodeToNodeEncryptionOptionsProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.NodeToNodeEncryptionOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NodeToNodeEncryptionOptionsProperty.Jsii$Proxy that = (NodeToNodeEncryptionOptionsProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Off-peak window settings for the domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * OffPeakWindowOptionsProperty offPeakWindowOptionsProperty = OffPeakWindowOptionsProperty.builder()
     *         .enabled(false)
     *         .offPeakWindow(OffPeakWindowProperty.builder()
     *                 .windowStartTime(WindowStartTimeProperty.builder()
     *                         .hours(123)
     *                         .minutes(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindowoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindowoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.OffPeakWindowOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(OffPeakWindowOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OffPeakWindowOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether off-peak window settings are enabled for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindowoptions.html#cfn-opensearchservice-domain-offpeakwindowoptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindowoptions.html#cfn-opensearchservice-domain-offpeakwindowoptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * Off-peak window settings for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindowoptions.html#cfn-opensearchservice-domain-offpeakwindowoptions-offpeakwindow">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindowoptions.html#cfn-opensearchservice-domain-offpeakwindowoptions-offpeakwindow</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOffPeakWindow() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OffPeakWindowOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OffPeakWindowOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OffPeakWindowOptionsProperty> {
            java.lang.Object enabled;
            java.lang.Object offPeakWindow;

            /**
             * Sets the value of {@link OffPeakWindowOptionsProperty#getEnabled}
             * @param enabled Specifies whether off-peak window settings are enabled for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OffPeakWindowOptionsProperty#getEnabled}
             * @param enabled Specifies whether off-peak window settings are enabled for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link OffPeakWindowOptionsProperty#getOffPeakWindow}
             * @param offPeakWindow Off-peak window settings for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offPeakWindow(software.amazon.awscdk.IResolvable offPeakWindow) {
                this.offPeakWindow = offPeakWindow;
                return this;
            }

            /**
             * Sets the value of {@link OffPeakWindowOptionsProperty#getOffPeakWindow}
             * @param offPeakWindow Off-peak window settings for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder offPeakWindow(software.amazon.awscdk.services.opensearchservice.CfnDomain.OffPeakWindowProperty offPeakWindow) {
                this.offPeakWindow = offPeakWindow;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OffPeakWindowOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OffPeakWindowOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OffPeakWindowOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OffPeakWindowOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object offPeakWindow;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.offPeakWindow = software.amazon.jsii.Kernel.get(this, "offPeakWindow", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.offPeakWindow = builder.offPeakWindow;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getOffPeakWindow() {
                return this.offPeakWindow;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getOffPeakWindow() != null) {
                    data.set("offPeakWindow", om.valueToTree(this.getOffPeakWindow()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.OffPeakWindowOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OffPeakWindowOptionsProperty.Jsii$Proxy that = (OffPeakWindowOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                return this.offPeakWindow != null ? this.offPeakWindow.equals(that.offPeakWindow) : that.offPeakWindow == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.offPeakWindow != null ? this.offPeakWindow.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom 10-hour, low-traffic window during which OpenSearch Service can perform mandatory configuration changes on the domain.
     * <p>
     * These actions can include scheduled service software updates and blue/green Auto-Tune enhancements. OpenSearch Service will schedule these actions during the window that you specify. If you don't specify a window start time, it defaults to 10:00 P.M. local time.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * OffPeakWindowProperty offPeakWindowProperty = OffPeakWindowProperty.builder()
     *         .windowStartTime(WindowStartTimeProperty.builder()
     *                 .hours(123)
     *                 .minutes(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindow.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.OffPeakWindowProperty")
    @software.amazon.jsii.Jsii.Proxy(OffPeakWindowProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OffPeakWindowProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The desired start time for an off-peak maintenance window.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindow.html#cfn-opensearchservice-domain-offpeakwindow-windowstarttime">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-offpeakwindow.html#cfn-opensearchservice-domain-offpeakwindow-windowstarttime</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getWindowStartTime() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OffPeakWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OffPeakWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OffPeakWindowProperty> {
            java.lang.Object windowStartTime;

            /**
             * Sets the value of {@link OffPeakWindowProperty#getWindowStartTime}
             * @param windowStartTime The desired start time for an off-peak maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windowStartTime(software.amazon.awscdk.IResolvable windowStartTime) {
                this.windowStartTime = windowStartTime;
                return this;
            }

            /**
             * Sets the value of {@link OffPeakWindowProperty#getWindowStartTime}
             * @param windowStartTime The desired start time for an off-peak maintenance window.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder windowStartTime(software.amazon.awscdk.services.opensearchservice.CfnDomain.WindowStartTimeProperty windowStartTime) {
                this.windowStartTime = windowStartTime;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OffPeakWindowProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OffPeakWindowProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OffPeakWindowProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OffPeakWindowProperty {
            private final java.lang.Object windowStartTime;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.windowStartTime = software.amazon.jsii.Kernel.get(this, "windowStartTime", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.windowStartTime = builder.windowStartTime;
            }

            @Override
            public final java.lang.Object getWindowStartTime() {
                return this.windowStartTime;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getWindowStartTime() != null) {
                    data.set("windowStartTime", om.valueToTree(this.getWindowStartTime()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.OffPeakWindowProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OffPeakWindowProperty.Jsii$Proxy that = (OffPeakWindowProperty.Jsii$Proxy) o;

                return this.windowStartTime != null ? this.windowStartTime.equals(that.windowStartTime) : that.windowStartTime == null;
            }

            @Override
            public final int hashCode() {
                int result = this.windowStartTime != null ? this.windowStartTime.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Container for information about the SAML configuration for OpenSearch Dashboards.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * SAMLOptionsProperty sAMLOptionsProperty = SAMLOptionsProperty.builder()
     *         .enabled(false)
     *         .idp(IdpProperty.builder()
     *                 .entityId("entityId")
     *                 .metadataContent("metadataContent")
     *                 .build())
     *         .masterBackendRole("masterBackendRole")
     *         .masterUserName("masterUserName")
     *         .rolesKey("rolesKey")
     *         .sessionTimeoutMinutes(123)
     *         .subjectKey("subjectKey")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.SAMLOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SAMLOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SAMLOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * True to enable SAML authentication for a domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-enabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-enabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * The SAML Identity Provider's information.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-idp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-idp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIdp() {
            return null;
        }

        /**
         * The backend role that the SAML master user is mapped to.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-masterbackendrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-masterbackendrole</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterBackendRole() {
            return null;
        }

        /**
         * The SAML master user name, which is stored in the domain's internal user database.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-masterusername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-masterusername</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMasterUserName() {
            return null;
        }

        /**
         * Element of the SAML assertion to use for backend roles.
         * <p>
         * Default is <code>roles</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-roleskey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-roleskey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRolesKey() {
            return null;
        }

        /**
         * The duration, in minutes, after which a user session becomes inactive.
         * <p>
         * Acceptable values are between 1 and 1440, and the default value is 60.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-sessiontimeoutminutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-sessiontimeoutminutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getSessionTimeoutMinutes() {
            return null;
        }

        /**
         * Element of the SAML assertion to use for the user name.
         * <p>
         * Default is <code>NameID</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-subjectkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-samloptions.html#cfn-opensearchservice-domain-samloptions-subjectkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubjectKey() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SAMLOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SAMLOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SAMLOptionsProperty> {
            java.lang.Object enabled;
            java.lang.Object idp;
            java.lang.String masterBackendRole;
            java.lang.String masterUserName;
            java.lang.String rolesKey;
            java.lang.Number sessionTimeoutMinutes;
            java.lang.String subjectKey;

            /**
             * Sets the value of {@link SAMLOptionsProperty#getEnabled}
             * @param enabled True to enable SAML authentication for a domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getEnabled}
             * @param enabled True to enable SAML authentication for a domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getIdp}
             * @param idp The SAML Identity Provider's information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idp(software.amazon.awscdk.IResolvable idp) {
                this.idp = idp;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getIdp}
             * @param idp The SAML Identity Provider's information.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder idp(software.amazon.awscdk.services.opensearchservice.CfnDomain.IdpProperty idp) {
                this.idp = idp;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getMasterBackendRole}
             * @param masterBackendRole The backend role that the SAML master user is mapped to.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterBackendRole(java.lang.String masterBackendRole) {
                this.masterBackendRole = masterBackendRole;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getMasterUserName}
             * @param masterUserName The SAML master user name, which is stored in the domain's internal user database.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder masterUserName(java.lang.String masterUserName) {
                this.masterUserName = masterUserName;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getRolesKey}
             * @param rolesKey Element of the SAML assertion to use for backend roles.
             *                 Default is <code>roles</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder rolesKey(java.lang.String rolesKey) {
                this.rolesKey = rolesKey;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getSessionTimeoutMinutes}
             * @param sessionTimeoutMinutes The duration, in minutes, after which a user session becomes inactive.
             *                              Acceptable values are between 1 and 1440, and the default value is 60.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sessionTimeoutMinutes(java.lang.Number sessionTimeoutMinutes) {
                this.sessionTimeoutMinutes = sessionTimeoutMinutes;
                return this;
            }

            /**
             * Sets the value of {@link SAMLOptionsProperty#getSubjectKey}
             * @param subjectKey Element of the SAML assertion to use for the user name.
             *                   Default is <code>NameID</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subjectKey(java.lang.String subjectKey) {
                this.subjectKey = subjectKey;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SAMLOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SAMLOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SAMLOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SAMLOptionsProperty {
            private final java.lang.Object enabled;
            private final java.lang.Object idp;
            private final java.lang.String masterBackendRole;
            private final java.lang.String masterUserName;
            private final java.lang.String rolesKey;
            private final java.lang.Number sessionTimeoutMinutes;
            private final java.lang.String subjectKey;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.idp = software.amazon.jsii.Kernel.get(this, "idp", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.masterBackendRole = software.amazon.jsii.Kernel.get(this, "masterBackendRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.masterUserName = software.amazon.jsii.Kernel.get(this, "masterUserName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.rolesKey = software.amazon.jsii.Kernel.get(this, "rolesKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.sessionTimeoutMinutes = software.amazon.jsii.Kernel.get(this, "sessionTimeoutMinutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.subjectKey = software.amazon.jsii.Kernel.get(this, "subjectKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
                this.idp = builder.idp;
                this.masterBackendRole = builder.masterBackendRole;
                this.masterUserName = builder.masterUserName;
                this.rolesKey = builder.rolesKey;
                this.sessionTimeoutMinutes = builder.sessionTimeoutMinutes;
                this.subjectKey = builder.subjectKey;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public final java.lang.Object getIdp() {
                return this.idp;
            }

            @Override
            public final java.lang.String getMasterBackendRole() {
                return this.masterBackendRole;
            }

            @Override
            public final java.lang.String getMasterUserName() {
                return this.masterUserName;
            }

            @Override
            public final java.lang.String getRolesKey() {
                return this.rolesKey;
            }

            @Override
            public final java.lang.Number getSessionTimeoutMinutes() {
                return this.sessionTimeoutMinutes;
            }

            @Override
            public final java.lang.String getSubjectKey() {
                return this.subjectKey;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }
                if (this.getIdp() != null) {
                    data.set("idp", om.valueToTree(this.getIdp()));
                }
                if (this.getMasterBackendRole() != null) {
                    data.set("masterBackendRole", om.valueToTree(this.getMasterBackendRole()));
                }
                if (this.getMasterUserName() != null) {
                    data.set("masterUserName", om.valueToTree(this.getMasterUserName()));
                }
                if (this.getRolesKey() != null) {
                    data.set("rolesKey", om.valueToTree(this.getRolesKey()));
                }
                if (this.getSessionTimeoutMinutes() != null) {
                    data.set("sessionTimeoutMinutes", om.valueToTree(this.getSessionTimeoutMinutes()));
                }
                if (this.getSubjectKey() != null) {
                    data.set("subjectKey", om.valueToTree(this.getSubjectKey()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.SAMLOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SAMLOptionsProperty.Jsii$Proxy that = (SAMLOptionsProperty.Jsii$Proxy) o;

                if (this.enabled != null ? !this.enabled.equals(that.enabled) : that.enabled != null) return false;
                if (this.idp != null ? !this.idp.equals(that.idp) : that.idp != null) return false;
                if (this.masterBackendRole != null ? !this.masterBackendRole.equals(that.masterBackendRole) : that.masterBackendRole != null) return false;
                if (this.masterUserName != null ? !this.masterUserName.equals(that.masterUserName) : that.masterUserName != null) return false;
                if (this.rolesKey != null ? !this.rolesKey.equals(that.rolesKey) : that.rolesKey != null) return false;
                if (this.sessionTimeoutMinutes != null ? !this.sessionTimeoutMinutes.equals(that.sessionTimeoutMinutes) : that.sessionTimeoutMinutes != null) return false;
                return this.subjectKey != null ? this.subjectKey.equals(that.subjectKey) : that.subjectKey == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                result = 31 * result + (this.idp != null ? this.idp.hashCode() : 0);
                result = 31 * result + (this.masterBackendRole != null ? this.masterBackendRole.hashCode() : 0);
                result = 31 * result + (this.masterUserName != null ? this.masterUserName.hashCode() : 0);
                result = 31 * result + (this.rolesKey != null ? this.rolesKey.hashCode() : 0);
                result = 31 * result + (this.sessionTimeoutMinutes != null ? this.sessionTimeoutMinutes.hashCode() : 0);
                result = 31 * result + (this.subjectKey != null ? this.subjectKey.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The current status of the service software for an Amazon OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">Service software updates in Amazon OpenSearch Service</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * ServiceSoftwareOptionsProperty serviceSoftwareOptionsProperty = ServiceSoftwareOptionsProperty.builder()
     *         .automatedUpdateDate("automatedUpdateDate")
     *         .cancellable(false)
     *         .currentVersion("currentVersion")
     *         .description("description")
     *         .newVersion("newVersion")
     *         .optionalDeployment(false)
     *         .updateAvailable(false)
     *         .updateStatus("updateStatus")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.ServiceSoftwareOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(ServiceSoftwareOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ServiceSoftwareOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The timestamp, in Epoch time, until which you can manually request a service software update.
         * <p>
         * After this date, we automatically update your service software.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-automatedupdatedate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-automatedupdatedate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAutomatedUpdateDate() {
            return null;
        }

        /**
         * True if you're able to cancel your service software version update.
         * <p>
         * False if you can't cancel your service software update.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-cancellable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-cancellable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCancellable() {
            return null;
        }

        /**
         * The current service software version present on the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-currentversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-currentversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCurrentVersion() {
            return null;
        }

        /**
         * A description of the service software update status.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return null;
        }

        /**
         * The new service software version, if one is available.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-newversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-newversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNewVersion() {
            return null;
        }

        /**
         * True if a service software is never automatically updated.
         * <p>
         * False if a service software is automatically updated after the automated update date.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-optionaldeployment">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-optionaldeployment</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOptionalDeployment() {
            return null;
        }

        /**
         * True if you're able to update your service software version.
         * <p>
         * False if you can't update your service software version.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-updateavailable">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-updateavailable</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getUpdateAvailable() {
            return null;
        }

        /**
         * The status of your service software update.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-updatestatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-servicesoftwareoptions.html#cfn-opensearchservice-domain-servicesoftwareoptions-updatestatus</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getUpdateStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ServiceSoftwareOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ServiceSoftwareOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ServiceSoftwareOptionsProperty> {
            java.lang.String automatedUpdateDate;
            java.lang.Object cancellable;
            java.lang.String currentVersion;
            java.lang.String description;
            java.lang.String newVersion;
            java.lang.Object optionalDeployment;
            java.lang.Object updateAvailable;
            java.lang.String updateStatus;

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getAutomatedUpdateDate}
             * @param automatedUpdateDate The timestamp, in Epoch time, until which you can manually request a service software update.
             *                            After this date, we automatically update your service software.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatedUpdateDate(java.lang.String automatedUpdateDate) {
                this.automatedUpdateDate = automatedUpdateDate;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getCancellable}
             * @param cancellable True if you're able to cancel your service software version update.
             *                    False if you can't cancel your service software update.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cancellable(java.lang.Boolean cancellable) {
                this.cancellable = cancellable;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getCancellable}
             * @param cancellable True if you're able to cancel your service software version update.
             *                    False if you can't cancel your service software update.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cancellable(software.amazon.awscdk.IResolvable cancellable) {
                this.cancellable = cancellable;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getCurrentVersion}
             * @param currentVersion The current service software version present on the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder currentVersion(java.lang.String currentVersion) {
                this.currentVersion = currentVersion;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getDescription}
             * @param description A description of the service software update status.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getNewVersion}
             * @param newVersion The new service software version, if one is available.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder newVersion(java.lang.String newVersion) {
                this.newVersion = newVersion;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getOptionalDeployment}
             * @param optionalDeployment True if a service software is never automatically updated.
             *                           False if a service software is automatically updated after the automated update date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionalDeployment(java.lang.Boolean optionalDeployment) {
                this.optionalDeployment = optionalDeployment;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getOptionalDeployment}
             * @param optionalDeployment True if a service software is never automatically updated.
             *                           False if a service software is automatically updated after the automated update date.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder optionalDeployment(software.amazon.awscdk.IResolvable optionalDeployment) {
                this.optionalDeployment = optionalDeployment;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getUpdateAvailable}
             * @param updateAvailable True if you're able to update your service software version.
             *                        False if you can't update your service software version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateAvailable(java.lang.Boolean updateAvailable) {
                this.updateAvailable = updateAvailable;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getUpdateAvailable}
             * @param updateAvailable True if you're able to update your service software version.
             *                        False if you can't update your service software version.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateAvailable(software.amazon.awscdk.IResolvable updateAvailable) {
                this.updateAvailable = updateAvailable;
                return this;
            }

            /**
             * Sets the value of {@link ServiceSoftwareOptionsProperty#getUpdateStatus}
             * @param updateStatus The status of your service software update.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder updateStatus(java.lang.String updateStatus) {
                this.updateStatus = updateStatus;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ServiceSoftwareOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ServiceSoftwareOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ServiceSoftwareOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ServiceSoftwareOptionsProperty {
            private final java.lang.String automatedUpdateDate;
            private final java.lang.Object cancellable;
            private final java.lang.String currentVersion;
            private final java.lang.String description;
            private final java.lang.String newVersion;
            private final java.lang.Object optionalDeployment;
            private final java.lang.Object updateAvailable;
            private final java.lang.String updateStatus;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatedUpdateDate = software.amazon.jsii.Kernel.get(this, "automatedUpdateDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.cancellable = software.amazon.jsii.Kernel.get(this, "cancellable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.currentVersion = software.amazon.jsii.Kernel.get(this, "currentVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.newVersion = software.amazon.jsii.Kernel.get(this, "newVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.optionalDeployment = software.amazon.jsii.Kernel.get(this, "optionalDeployment", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updateAvailable = software.amazon.jsii.Kernel.get(this, "updateAvailable", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.updateStatus = software.amazon.jsii.Kernel.get(this, "updateStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatedUpdateDate = builder.automatedUpdateDate;
                this.cancellable = builder.cancellable;
                this.currentVersion = builder.currentVersion;
                this.description = builder.description;
                this.newVersion = builder.newVersion;
                this.optionalDeployment = builder.optionalDeployment;
                this.updateAvailable = builder.updateAvailable;
                this.updateStatus = builder.updateStatus;
            }

            @Override
            public final java.lang.String getAutomatedUpdateDate() {
                return this.automatedUpdateDate;
            }

            @Override
            public final java.lang.Object getCancellable() {
                return this.cancellable;
            }

            @Override
            public final java.lang.String getCurrentVersion() {
                return this.currentVersion;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            public final java.lang.String getNewVersion() {
                return this.newVersion;
            }

            @Override
            public final java.lang.Object getOptionalDeployment() {
                return this.optionalDeployment;
            }

            @Override
            public final java.lang.Object getUpdateAvailable() {
                return this.updateAvailable;
            }

            @Override
            public final java.lang.String getUpdateStatus() {
                return this.updateStatus;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatedUpdateDate() != null) {
                    data.set("automatedUpdateDate", om.valueToTree(this.getAutomatedUpdateDate()));
                }
                if (this.getCancellable() != null) {
                    data.set("cancellable", om.valueToTree(this.getCancellable()));
                }
                if (this.getCurrentVersion() != null) {
                    data.set("currentVersion", om.valueToTree(this.getCurrentVersion()));
                }
                if (this.getDescription() != null) {
                    data.set("description", om.valueToTree(this.getDescription()));
                }
                if (this.getNewVersion() != null) {
                    data.set("newVersion", om.valueToTree(this.getNewVersion()));
                }
                if (this.getOptionalDeployment() != null) {
                    data.set("optionalDeployment", om.valueToTree(this.getOptionalDeployment()));
                }
                if (this.getUpdateAvailable() != null) {
                    data.set("updateAvailable", om.valueToTree(this.getUpdateAvailable()));
                }
                if (this.getUpdateStatus() != null) {
                    data.set("updateStatus", om.valueToTree(this.getUpdateStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.ServiceSoftwareOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ServiceSoftwareOptionsProperty.Jsii$Proxy that = (ServiceSoftwareOptionsProperty.Jsii$Proxy) o;

                if (this.automatedUpdateDate != null ? !this.automatedUpdateDate.equals(that.automatedUpdateDate) : that.automatedUpdateDate != null) return false;
                if (this.cancellable != null ? !this.cancellable.equals(that.cancellable) : that.cancellable != null) return false;
                if (this.currentVersion != null ? !this.currentVersion.equals(that.currentVersion) : that.currentVersion != null) return false;
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
                if (this.newVersion != null ? !this.newVersion.equals(that.newVersion) : that.newVersion != null) return false;
                if (this.optionalDeployment != null ? !this.optionalDeployment.equals(that.optionalDeployment) : that.optionalDeployment != null) return false;
                if (this.updateAvailable != null ? !this.updateAvailable.equals(that.updateAvailable) : that.updateAvailable != null) return false;
                return this.updateStatus != null ? this.updateStatus.equals(that.updateStatus) : that.updateStatus == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automatedUpdateDate != null ? this.automatedUpdateDate.hashCode() : 0;
                result = 31 * result + (this.cancellable != null ? this.cancellable.hashCode() : 0);
                result = 31 * result + (this.currentVersion != null ? this.currentVersion.hashCode() : 0);
                result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
                result = 31 * result + (this.newVersion != null ? this.newVersion.hashCode() : 0);
                result = 31 * result + (this.optionalDeployment != null ? this.optionalDeployment.hashCode() : 0);
                result = 31 * result + (this.updateAvailable != null ? this.updateAvailable.hashCode() : 0);
                result = 31 * result + (this.updateStatus != null ? this.updateStatus.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * <em>DEPRECATED</em> .
     * <p>
     * This setting is only relevant to domains running legacy Elasticsearch OSS versions earlier than 5.3. It does not apply to OpenSearch domains.
     * <p>
     * The automated snapshot configuration for the OpenSearch Service domain indexes.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * SnapshotOptionsProperty snapshotOptionsProperty = SnapshotOptionsProperty.builder()
     *         .automatedSnapshotStartHour(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-snapshotoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-snapshotoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.SnapshotOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SnapshotOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SnapshotOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The hour in UTC during which the service takes an automated daily snapshot of the indexes in the OpenSearch Service domain.
         * <p>
         * For example, if you specify 0, OpenSearch Service takes an automated snapshot everyday between midnight and 1 am. You can specify a value between 0 and 23.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-snapshotoptions.html#cfn-opensearchservice-domain-snapshotoptions-automatedsnapshotstarthour">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-snapshotoptions.html#cfn-opensearchservice-domain-snapshotoptions-automatedsnapshotstarthour</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAutomatedSnapshotStartHour() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SnapshotOptionsProperty> {
            java.lang.Number automatedSnapshotStartHour;

            /**
             * Sets the value of {@link SnapshotOptionsProperty#getAutomatedSnapshotStartHour}
             * @param automatedSnapshotStartHour The hour in UTC during which the service takes an automated daily snapshot of the indexes in the OpenSearch Service domain.
             *                                   For example, if you specify 0, OpenSearch Service takes an automated snapshot everyday between midnight and 1 am. You can specify a value between 0 and 23.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder automatedSnapshotStartHour(java.lang.Number automatedSnapshotStartHour) {
                this.automatedSnapshotStartHour = automatedSnapshotStartHour;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SnapshotOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SnapshotOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SnapshotOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SnapshotOptionsProperty {
            private final java.lang.Number automatedSnapshotStartHour;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.automatedSnapshotStartHour = software.amazon.jsii.Kernel.get(this, "automatedSnapshotStartHour", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.automatedSnapshotStartHour = builder.automatedSnapshotStartHour;
            }

            @Override
            public final java.lang.Number getAutomatedSnapshotStartHour() {
                return this.automatedSnapshotStartHour;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutomatedSnapshotStartHour() != null) {
                    data.set("automatedSnapshotStartHour", om.valueToTree(this.getAutomatedSnapshotStartHour()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.SnapshotOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SnapshotOptionsProperty.Jsii$Proxy that = (SnapshotOptionsProperty.Jsii$Proxy) o;

                return this.automatedSnapshotStartHour != null ? this.automatedSnapshotStartHour.equals(that.automatedSnapshotStartHour) : that.automatedSnapshotStartHour == null;
            }

            @Override
            public final int hashCode() {
                int result = this.automatedSnapshotStartHour != null ? this.automatedSnapshotStartHour.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Options for configuring service software updates for a domain.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * SoftwareUpdateOptionsProperty softwareUpdateOptionsProperty = SoftwareUpdateOptionsProperty.builder()
     *         .autoSoftwareUpdateEnabled(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-softwareupdateoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-softwareupdateoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.SoftwareUpdateOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(SoftwareUpdateOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface SoftwareUpdateOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether automatic service software updates are enabled for the domain.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-softwareupdateoptions.html#cfn-opensearchservice-domain-softwareupdateoptions-autosoftwareupdateenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-softwareupdateoptions.html#cfn-opensearchservice-domain-softwareupdateoptions-autosoftwareupdateenabled</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAutoSoftwareUpdateEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link SoftwareUpdateOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link SoftwareUpdateOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<SoftwareUpdateOptionsProperty> {
            java.lang.Object autoSoftwareUpdateEnabled;

            /**
             * Sets the value of {@link SoftwareUpdateOptionsProperty#getAutoSoftwareUpdateEnabled}
             * @param autoSoftwareUpdateEnabled Specifies whether automatic service software updates are enabled for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoSoftwareUpdateEnabled(java.lang.Boolean autoSoftwareUpdateEnabled) {
                this.autoSoftwareUpdateEnabled = autoSoftwareUpdateEnabled;
                return this;
            }

            /**
             * Sets the value of {@link SoftwareUpdateOptionsProperty#getAutoSoftwareUpdateEnabled}
             * @param autoSoftwareUpdateEnabled Specifies whether automatic service software updates are enabled for the domain.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder autoSoftwareUpdateEnabled(software.amazon.awscdk.IResolvable autoSoftwareUpdateEnabled) {
                this.autoSoftwareUpdateEnabled = autoSoftwareUpdateEnabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link SoftwareUpdateOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public SoftwareUpdateOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link SoftwareUpdateOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SoftwareUpdateOptionsProperty {
            private final java.lang.Object autoSoftwareUpdateEnabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.autoSoftwareUpdateEnabled = software.amazon.jsii.Kernel.get(this, "autoSoftwareUpdateEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.autoSoftwareUpdateEnabled = builder.autoSoftwareUpdateEnabled;
            }

            @Override
            public final java.lang.Object getAutoSoftwareUpdateEnabled() {
                return this.autoSoftwareUpdateEnabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAutoSoftwareUpdateEnabled() != null) {
                    data.set("autoSoftwareUpdateEnabled", om.valueToTree(this.getAutoSoftwareUpdateEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.SoftwareUpdateOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                SoftwareUpdateOptionsProperty.Jsii$Proxy that = (SoftwareUpdateOptionsProperty.Jsii$Proxy) o;

                return this.autoSoftwareUpdateEnabled != null ? this.autoSoftwareUpdateEnabled.equals(that.autoSoftwareUpdateEnabled) : that.autoSoftwareUpdateEnabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.autoSoftwareUpdateEnabled != null ? this.autoSoftwareUpdateEnabled.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains using a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * VPCOptionsProperty vPCOptionsProperty = VPCOptionsProperty.builder()
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .subnetIds(List.of("subnetIds"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-vpcoptions.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-vpcoptions.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.VPCOptionsProperty")
    @software.amazon.jsii.Jsii.Proxy(VPCOptionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VPCOptionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The list of security group IDs that are associated with the VPC endpoints for the domain.
         * <p>
         * If you don't provide a security group ID, OpenSearch Service uses the default security group for the VPC. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security groups for your VPC</a> in the <em>Amazon VPC User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-vpcoptions.html#cfn-opensearchservice-domain-vpcoptions-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-vpcoptions.html#cfn-opensearchservice-domain-vpcoptions-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * Provide one subnet ID for each Availability Zone that your domain uses.
         * <p>
         * For example, you must specify three subnet IDs for a three-AZ domain. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <em>Amazon VPC User Guide</em> .
         * <p>
         * If you specify more than one subnet, you must also configure <code>ZoneAwarenessEnabled</code> and <code>ZoneAwarenessConfig</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html">ClusterConfig</a> , otherwise you'll see the error "You must specify exactly one subnet" during template creation.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-vpcoptions.html#cfn-opensearchservice-domain-vpcoptions-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-vpcoptions.html#cfn-opensearchservice-domain-vpcoptions-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VPCOptionsProperty> {
            java.util.List<java.lang.String> securityGroupIds;
            java.util.List<java.lang.String> subnetIds;

            /**
             * Sets the value of {@link VPCOptionsProperty#getSecurityGroupIds}
             * @param securityGroupIds The list of security group IDs that are associated with the VPC endpoints for the domain.
             *                         If you don't provide a security group ID, OpenSearch Service uses the default security group for the VPC. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_SecurityGroups.html">Security groups for your VPC</a> in the <em>Amazon VPC User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link VPCOptionsProperty#getSubnetIds}
             * @param subnetIds Provide one subnet ID for each Availability Zone that your domain uses.
             *                  For example, you must specify three subnet IDs for a three-AZ domain. To learn more, see <a href="https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html">VPCs and subnets</a> in the <em>Amazon VPC User Guide</em> .
             *                  <p>
             *                  If you specify more than one subnet, you must also configure <code>ZoneAwarenessEnabled</code> and <code>ZoneAwarenessConfig</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-clusterconfig.html">ClusterConfig</a> , otherwise you'll see the error "You must specify exactly one subnet" during template creation.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VPCOptionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VPCOptionsProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VPCOptionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VPCOptionsProperty {
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.util.List<java.lang.String> subnetIds;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.securityGroupIds = builder.securityGroupIds;
                this.subnetIds = builder.subnetIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.VPCOptionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VPCOptionsProperty.Jsii$Proxy that = (VPCOptionsProperty.Jsii$Proxy) o;

                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                return this.subnetIds != null ? this.subnetIds.equals(that.subnetIds) : that.subnetIds == null;
            }

            @Override
            public final int hashCode() {
                int result = this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0;
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A custom start time for the off-peak window, in Coordinated Universal Time (UTC).
     * <p>
     * The window length will always be 10 hours, so you can't specify an end time. For example, if you specify 11:00 P.M. UTC as a start time, the end time will automatically be set to 9:00 A.M.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * WindowStartTimeProperty windowStartTimeProperty = WindowStartTimeProperty.builder()
     *         .hours(123)
     *         .minutes(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-windowstarttime.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-windowstarttime.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.WindowStartTimeProperty")
    @software.amazon.jsii.Jsii.Proxy(WindowStartTimeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WindowStartTimeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time.
         * <p>
         * For example, 17 refers to 5:00 P.M. UTC. The minimum value is 0 and the maximum value is 23.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-windowstarttime.html#cfn-opensearchservice-domain-windowstarttime-hours">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-windowstarttime.html#cfn-opensearchservice-domain-windowstarttime-hours</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getHours();

        /**
         * The start minute of the window, in UTC.
         * <p>
         * The minimum value is 0 and the maximum value is 59.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-windowstarttime.html#cfn-opensearchservice-domain-windowstarttime-minutes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-windowstarttime.html#cfn-opensearchservice-domain-windowstarttime-minutes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinutes();

        /**
         * @return a {@link Builder} of {@link WindowStartTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WindowStartTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WindowStartTimeProperty> {
            java.lang.Number hours;
            java.lang.Number minutes;

            /**
             * Sets the value of {@link WindowStartTimeProperty#getHours}
             * @param hours The start hour of the window in Coordinated Universal Time (UTC), using 24-hour time. This parameter is required.
             *              For example, 17 refers to 5:00 P.M. UTC. The minimum value is 0 and the maximum value is 23.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder hours(java.lang.Number hours) {
                this.hours = hours;
                return this;
            }

            /**
             * Sets the value of {@link WindowStartTimeProperty#getMinutes}
             * @param minutes The start minute of the window, in UTC. This parameter is required.
             *                The minimum value is 0 and the maximum value is 59.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minutes(java.lang.Number minutes) {
                this.minutes = minutes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WindowStartTimeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WindowStartTimeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WindowStartTimeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WindowStartTimeProperty {
            private final java.lang.Number hours;
            private final java.lang.Number minutes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.hours = software.amazon.jsii.Kernel.get(this, "hours", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.minutes = software.amazon.jsii.Kernel.get(this, "minutes", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.hours = java.util.Objects.requireNonNull(builder.hours, "hours is required");
                this.minutes = java.util.Objects.requireNonNull(builder.minutes, "minutes is required");
            }

            @Override
            public final java.lang.Number getHours() {
                return this.hours;
            }

            @Override
            public final java.lang.Number getMinutes() {
                return this.minutes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("hours", om.valueToTree(this.getHours()));
                data.set("minutes", om.valueToTree(this.getMinutes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.WindowStartTimeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WindowStartTimeProperty.Jsii$Proxy that = (WindowStartTimeProperty.Jsii$Proxy) o;

                if (!hours.equals(that.hours)) return false;
                return this.minutes.equals(that.minutes);
            }

            @Override
            public final int hashCode() {
                int result = this.hours.hashCode();
                result = 31 * result + (this.minutes.hashCode());
                return result;
            }
        }
    }
    /**
     * Specifies zone awareness configuration options.
     * <p>
     * Only use if <code>ZoneAwarenessEnabled</code> is <code>true</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.opensearchservice.*;
     * ZoneAwarenessConfigProperty zoneAwarenessConfigProperty = ZoneAwarenessConfigProperty.builder()
     *         .availabilityZoneCount(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-zoneawarenessconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-zoneawarenessconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_opensearchservice.CfnDomain.ZoneAwarenessConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ZoneAwarenessConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ZoneAwarenessConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
         * <p>
         * Valid values are <code>2</code> and <code>3</code> . Default is 2.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-zoneawarenessconfig.html#cfn-opensearchservice-domain-zoneawarenessconfig-availabilityzonecount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-zoneawarenessconfig.html#cfn-opensearchservice-domain-zoneawarenessconfig-availabilityzonecount</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getAvailabilityZoneCount() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ZoneAwarenessConfigProperty> {
            java.lang.Number availabilityZoneCount;

            /**
             * Sets the value of {@link ZoneAwarenessConfigProperty#getAvailabilityZoneCount}
             * @param availabilityZoneCount If you enabled multiple Availability Zones (AZs), the number of AZs that you want the domain to use.
             *                              Valid values are <code>2</code> and <code>3</code> . Default is 2.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZoneCount(java.lang.Number availabilityZoneCount) {
                this.availabilityZoneCount = availabilityZoneCount;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ZoneAwarenessConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ZoneAwarenessConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ZoneAwarenessConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ZoneAwarenessConfigProperty {
            private final java.lang.Number availabilityZoneCount;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZoneCount = software.amazon.jsii.Kernel.get(this, "availabilityZoneCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZoneCount = builder.availabilityZoneCount;
            }

            @Override
            public final java.lang.Number getAvailabilityZoneCount() {
                return this.availabilityZoneCount;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZoneCount() != null) {
                    data.set("availabilityZoneCount", om.valueToTree(this.getAvailabilityZoneCount()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_opensearchservice.CfnDomain.ZoneAwarenessConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ZoneAwarenessConfigProperty.Jsii$Proxy that = (ZoneAwarenessConfigProperty.Jsii$Proxy) o;

                return this.availabilityZoneCount != null ? this.availabilityZoneCount.equals(that.availabilityZoneCount) : that.availabilityZoneCount == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZoneCount != null ? this.availabilityZoneCount.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.opensearchservice.CfnDomain}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.opensearchservice.CfnDomain> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.opensearchservice.CfnDomainProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ac.html#ac-creating">Configuring access policies</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-accesspolicies">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-accesspolicies</a>
         * @param accessPolicies An AWS Identity and Access Management ( IAM ) policy document that specifies who can access the OpenSearch Service domain and their permissions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicies(final java.lang.Object accessPolicies) {
            this.props().accessPolicies(accessPolicies);
            return this;
        }

        /**
         * Additional options to specify for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateDomain.html#API_CreateDomain_RequestBody">AdvancedOptions</a> in the OpenSearch Service API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedoptions</a>
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(final java.util.Map<java.lang.String, java.lang.String> advancedOptions) {
            this.props().advancedOptions(advancedOptions);
            return this;
        }
        /**
         * Additional options to specify for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/APIReference/API_CreateDomain.html#API_CreateDomain_RequestBody">AdvancedOptions</a> in the OpenSearch Service API reference.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedoptions</a>
         * @param advancedOptions Additional options to specify for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedOptions(final software.amazon.awscdk.IResolvable advancedOptions) {
            this.props().advancedOptions(advancedOptions);
            return this;
        }

        /**
         * Specifies options for fine-grained access control and SAML authentication.
         * <p>
         * If you specify advanced security options, you must also enable node-to-node encryption ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html">NodeToNodeEncryptionOptions</a> ) and encryption at rest ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html">EncryptionAtRestOptions</a> ). You must also enable <code>EnforceHTTPS</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html">DomainEndpointOptions</a> , which requires HTTPS for all traffic to the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedsecurityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedsecurityoptions</a>
         * @param advancedSecurityOptions Specifies options for fine-grained access control and SAML authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(final software.amazon.awscdk.IResolvable advancedSecurityOptions) {
            this.props().advancedSecurityOptions(advancedSecurityOptions);
            return this;
        }
        /**
         * Specifies options for fine-grained access control and SAML authentication.
         * <p>
         * If you specify advanced security options, you must also enable node-to-node encryption ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-nodetonodeencryptionoptions.html">NodeToNodeEncryptionOptions</a> ) and encryption at rest ( <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-encryptionatrestoptions.html">EncryptionAtRestOptions</a> ). You must also enable <code>EnforceHTTPS</code> within <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-opensearchservice-domain-domainendpointoptions.html">DomainEndpointOptions</a> , which requires HTTPS for all traffic to the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedsecurityoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-advancedsecurityoptions</a>
         * @param advancedSecurityOptions Specifies options for fine-grained access control and SAML authentication. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedSecurityOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.AdvancedSecurityOptionsInputProperty advancedSecurityOptions) {
            this.props().advancedSecurityOptions(advancedSecurityOptions);
            return this;
        }

        /**
         * Container for the cluster configuration of a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-clusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-clusterconfig</a>
         * @param clusterConfig Container for the cluster configuration of a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterConfig(final software.amazon.awscdk.IResolvable clusterConfig) {
            this.props().clusterConfig(clusterConfig);
            return this;
        }
        /**
         * Container for the cluster configuration of a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-clusterconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-clusterconfig</a>
         * @param clusterConfig Container for the cluster configuration of a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterConfig(final software.amazon.awscdk.services.opensearchservice.CfnDomain.ClusterConfigProperty clusterConfig) {
            this.props().clusterConfig(clusterConfig);
            return this;
        }

        /**
         * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-cognitooptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-cognitooptions</a>
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(final software.amazon.awscdk.IResolvable cognitoOptions) {
            this.props().cognitoOptions(cognitoOptions);
            return this;
        }
        /**
         * Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-cognitooptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-cognitooptions</a>
         * @param cognitoOptions Configures OpenSearch Service to use Amazon Cognito authentication for OpenSearch Dashboards. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cognitoOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.CognitoOptionsProperty cognitoOptions) {
            this.props().cognitoOptions(cognitoOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainarn</a>
         * @param domainArn This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainArn(final java.lang.String domainArn) {
            this.props().domainArn(domainArn);
            return this;
        }

        /**
         * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainendpointoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainendpointoptions</a>
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(final software.amazon.awscdk.IResolvable domainEndpointOptions) {
            this.props().domainEndpointOptions(domainEndpointOptions);
            return this;
        }
        /**
         * Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainendpointoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainendpointoptions</a>
         * @param domainEndpointOptions Specifies additional options for the domain endpoint, such as whether to require HTTPS for all traffic or whether to use a custom endpoint rather than the default endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainEndpointOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.DomainEndpointOptionsProperty domainEndpointOptions) {
            this.props().domainEndpointOptions(domainEndpointOptions);
            return this;
        }

        /**
         * A name for the OpenSearch Service domain.
         * <p>
         * The name must have a minimum length of 3 and a maximum length of 28. If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the domain name. For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-name.html">Name Type</a> .
         * <p>
         * Required when creating a new domain.
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you can't perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-domainname</a>
         * @param domainName A name for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props().domainName(domainName);
            return this;
        }

        /**
         * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ebsoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ebsoptions</a>
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(final software.amazon.awscdk.IResolvable ebsOptions) {
            this.props().ebsOptions(ebsOptions);
            return this;
        }
        /**
         * The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/limits.html#ebsresource">EBS volume size limits</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ebsoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ebsoptions</a>
         * @param ebsOptions The configurations of Amazon Elastic Block Store (Amazon EBS) volumes that are attached to data nodes in the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.EBSOptionsProperty ebsOptions) {
            this.props().ebsOptions(ebsOptions);
            return this;
        }

        /**
         * Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         * <p>
         * If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-encryptionatrestoptions</a>
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.IResolvable encryptionAtRestOptions) {
            this.props().encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }
        /**
         * Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/encryption-at-rest.html">Encryption of data at rest for Amazon OpenSearch Service</a> .
         * <p>
         * If no encryption at rest options were initially specified in the template, updating this property by adding it causes no interruption. However, if you change this property after it's already been set within a template, the domain is deleted and recreated in order to modify the property.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-encryptionatrestoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-encryptionatrestoptions</a>
         * @param encryptionAtRestOptions Whether the domain should encrypt data at rest, and if so, the AWS KMS key to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionAtRestOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.EncryptionAtRestOptionsProperty encryptionAtRestOptions) {
            this.props().encryptionAtRestOptions(encryptionAtRestOptions);
            return this;
        }

        /**
         * The version of OpenSearch to use.
         * <p>
         * The value must be in the format <code>OpenSearch_X.Y</code> or <code>Elasticsearch_X.Y</code> . If not specified, the latest version of OpenSearch is used. For information about the versions that OpenSearch Service supports, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/what-is.html#choosing-version">Supported versions of OpenSearch and Elasticsearch</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * If you set the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatepolicy.html#cfn-attributes-updatepolicy-upgradeopensearchdomain">EnableVersionUpgrade</a> update policy to <code>true</code> , you can update <code>EngineVersion</code> without interruption. When <code>EnableVersionUpgrade</code> is set to <code>false</code> , or is not specified, updating <code>EngineVersion</code> results in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-updating-stacks-update-behaviors.html#update-replacement">replacement</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-engineversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-engineversion</a>
         * @param engineVersion The version of OpenSearch to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder engineVersion(final java.lang.String engineVersion) {
            this.props().engineVersion(engineVersion);
            return this;
        }

        /**
         * Configuration options for controlling IAM Identity Center integration within a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-identitycenteroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-identitycenteroptions</a>
         * @param identityCenterOptions Configuration options for controlling IAM Identity Center integration within a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityCenterOptions(final software.amazon.awscdk.IResolvable identityCenterOptions) {
            this.props().identityCenterOptions(identityCenterOptions);
            return this;
        }
        /**
         * Configuration options for controlling IAM Identity Center integration within a domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-identitycenteroptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-identitycenteroptions</a>
         * @param identityCenterOptions Configuration options for controlling IAM Identity Center integration within a domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identityCenterOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.IdentityCenterOptionsProperty identityCenterOptions) {
            this.props().identityCenterOptions(identityCenterOptions);
            return this;
        }

        /**
         * Choose either dual stack or IPv4 as your IP address type.
         * <p>
         * Dual stack allows you to share domain resources across IPv4 and IPv6 address types, and is the recommended option. If you set your IP address type to dual stack, you can't change your address type later.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ipaddresstype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-ipaddresstype</a>
         * @param ipAddressType Choose either dual stack or IPv4 as your IP address type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipAddressType(final java.lang.String ipAddressType) {
            this.props().ipAddressType(ipAddressType);
            return this;
        }

        /**
         * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
         * <p>
         * Each key needs a valid <code>LogPublishingOption</code> value. For the full syntax, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--examples">examples</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-logpublishingoptions</a>
         * @param logPublishingOptions An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final software.amazon.awscdk.IResolvable logPublishingOptions) {
            this.props().logPublishingOptions(logPublishingOptions);
            return this;
        }
        /**
         * An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish.
         * <p>
         * Each key needs a valid <code>LogPublishingOption</code> value. For the full syntax, see the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#aws-resource-opensearchservice-domain--examples">examples</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-logpublishingoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-logpublishingoptions</a>
         * @param logPublishingOptions An object with one or more of the following keys: <code>SEARCH_SLOW_LOGS</code> , <code>ES_APPLICATION_LOGS</code> , <code>INDEX_SLOW_LOGS</code> , <code>AUDIT_LOGS</code> , depending on the types of logs you want to publish. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logPublishingOptions(final java.util.Map<java.lang.String, ? extends java.lang.Object> logPublishingOptions) {
            this.props().logPublishingOptions(logPublishingOptions);
            return this;
        }

        /**
         * Specifies whether node-to-node encryption is enabled.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions</a>
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(final software.amazon.awscdk.IResolvable nodeToNodeEncryptionOptions) {
            this.props().nodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
            return this;
        }
        /**
         * Specifies whether node-to-node encryption is enabled.
         * <p>
         * See <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/ntn.html">Node-to-node encryption for Amazon OpenSearch Service</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-nodetonodeencryptionoptions</a>
         * @param nodeToNodeEncryptionOptions Specifies whether node-to-node encryption is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder nodeToNodeEncryptionOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.NodeToNodeEncryptionOptionsProperty nodeToNodeEncryptionOptions) {
            this.props().nodeToNodeEncryptionOptions(nodeToNodeEncryptionOptions);
            return this;
        }

        /**
         * Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-offpeakwindowoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-offpeakwindowoptions</a>
         * @param offPeakWindowOptions Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offPeakWindowOptions(final software.amazon.awscdk.IResolvable offPeakWindowOptions) {
            this.props().offPeakWindowOptions(offPeakWindowOptions);
            return this;
        }
        /**
         * Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-offpeakwindowoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-offpeakwindowoptions</a>
         * @param offPeakWindowOptions Options for a domain's off-peak window, during which OpenSearch Service can perform mandatory configuration changes on the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder offPeakWindowOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.OffPeakWindowOptionsProperty offPeakWindowOptions) {
            this.props().offPeakWindowOptions(offPeakWindowOptions);
            return this;
        }

        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-skipshardmigrationwait">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-skipshardmigrationwait</a>
         * @param skipShardMigrationWait This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipShardMigrationWait(final java.lang.Boolean skipShardMigrationWait) {
            this.props().skipShardMigrationWait(skipShardMigrationWait);
            return this;
        }
        /**
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-skipshardmigrationwait">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-skipshardmigrationwait</a>
         * @param skipShardMigrationWait This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipShardMigrationWait(final software.amazon.awscdk.IResolvable skipShardMigrationWait) {
            this.props().skipShardMigrationWait(skipShardMigrationWait);
            return this;
        }

        /**
         * <em>DEPRECATED</em> .
         * <p>
         * The automated snapshot configuration for the OpenSearch Service domain indexes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-snapshotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-snapshotoptions</a>
         * @param snapshotOptions <em>DEPRECATED</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(final software.amazon.awscdk.IResolvable snapshotOptions) {
            this.props().snapshotOptions(snapshotOptions);
            return this;
        }
        /**
         * <em>DEPRECATED</em> .
         * <p>
         * The automated snapshot configuration for the OpenSearch Service domain indexes.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-snapshotoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-snapshotoptions</a>
         * @param snapshotOptions <em>DEPRECATED</em> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.SnapshotOptionsProperty snapshotOptions) {
            this.props().snapshotOptions(snapshotOptions);
            return this;
        }

        /**
         * Service software update options for the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-softwareupdateoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-softwareupdateoptions</a>
         * @param softwareUpdateOptions Service software update options for the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareUpdateOptions(final software.amazon.awscdk.IResolvable softwareUpdateOptions) {
            this.props().softwareUpdateOptions(softwareUpdateOptions);
            return this;
        }
        /**
         * Service software update options for the domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-softwareupdateoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-softwareupdateoptions</a>
         * @param softwareUpdateOptions Service software update options for the domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder softwareUpdateOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.SoftwareUpdateOptionsProperty softwareUpdateOptions) {
            this.props().softwareUpdateOptions(softwareUpdateOptions);
            return this;
        }

        /**
         * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-tags</a>
         * @param tags An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props().tags(tags);
            return this;
        }

        /**
         * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * If you remove this entity altogether, along with its associated properties, it causes a replacement. You might encounter this scenario if you're updating your security configuration from a VPC to a public endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-vpcoptions</a>
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.IResolvable vpcOptions) {
            this.props().vpcOptions(vpcOptions);
            return this;
        }
        /**
         * The virtual private cloud (VPC) configuration for the OpenSearch Service domain.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/vpc.html">Launching your Amazon OpenSearch Service domains within a VPC</a> in the <em>Amazon OpenSearch Service Developer Guide</em> .
         * <p>
         * If you remove this entity altogether, along with its associated properties, it causes a replacement. You might encounter this scenario if you're updating your security configuration from a VPC to a public endpoint.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-vpcoptions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-opensearchservice-domain.html#cfn-opensearchservice-domain-vpcoptions</a>
         * @param vpcOptions The virtual private cloud (VPC) configuration for the OpenSearch Service domain. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcOptions(final software.amazon.awscdk.services.opensearchservice.CfnDomain.VPCOptionsProperty vpcOptions) {
            this.props().vpcOptions(vpcOptions);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.opensearchservice.CfnDomain}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.opensearchservice.CfnDomain build() {
            return new software.amazon.awscdk.services.opensearchservice.CfnDomain(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.opensearchservice.CfnDomainProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.opensearchservice.CfnDomainProps.Builder();
            }
            return this.props;
        }
    }
}
