package software.amazon.awscdk.services.panorama;

/**
 * <blockquote><p>End of support notice: On May 31, 2026, AWS will end support for AWS Panorama .<p></blockquote>
 * <p>
 * After May 31, 2026,
 * <p>
 * <blockquote>
 * <p>
 * you will no longer be able to access the AWS Panorama console or AWS Panorama resources. For more information, see <a href="https://docs.aws.amazon.com/panorama/latest/dev/panorama-end-of-support.html">AWS Panorama end of support</a> .
 * <p>
 * </blockquote>
 * <p>
 * Creates a package and storage location in an Amazon S3 access point.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.panorama.*;
 * CfnPackage cfnPackage = CfnPackage.Builder.create(this, "MyCfnPackage")
 *         .packageName("packageName")
 *         // the properties below are optional
 *         .storageLocation(StorageLocationProperty.builder()
 *                 .binaryPrefixLocation("binaryPrefixLocation")
 *                 .bucket("bucket")
 *                 .generatedPrefixLocation("generatedPrefixLocation")
 *                 .manifestPrefixLocation("manifestPrefixLocation")
 *                 .repoPrefixLocation("repoPrefixLocation")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:21.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_panorama.CfnPackage")
public class CfnPackage extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnPackage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPackage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.panorama.CfnPackage.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPackage(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.panorama.CfnPackageProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The package's ARN.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * When the package was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrCreatedTime() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedTime", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The package's ID.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPackageId() {
        return software.amazon.jsii.Kernel.get(this, "attrPackageId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location's binary prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageLocationBinaryPrefixLocation() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageLocationBinaryPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location's bucket.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageLocationBucket() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageLocationBucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location's generated prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageLocationGeneratedPrefixLocation() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageLocationGeneratedPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location's manifest prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageLocationManifestPrefixLocation() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageLocationManifestPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The location's repo prefix.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStorageLocationRepoPrefixLocation() {
        return software.amazon.jsii.Kernel.get(this, "attrStorageLocationRepoPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * A name for the package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPackageName() {
        return software.amazon.jsii.Kernel.get(this, "packageName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A name for the package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPackageName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "packageName", java.util.Objects.requireNonNull(value, "packageName is required"));
    }

    /**
     * A storage location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getStorageLocation() {
        return software.amazon.jsii.Kernel.get(this, "storageLocation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A storage location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "storageLocation", value);
    }

    /**
     * A storage location.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStorageLocation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.panorama.CfnPackage.StorageLocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "storageLocation", value);
    }

    /**
     * Tags for the package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * Tags for the package.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }
    /**
     * A storage location.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.panorama.*;
     * StorageLocationProperty storageLocationProperty = StorageLocationProperty.builder()
     *         .binaryPrefixLocation("binaryPrefixLocation")
     *         .bucket("bucket")
     *         .generatedPrefixLocation("generatedPrefixLocation")
     *         .manifestPrefixLocation("manifestPrefixLocation")
     *         .repoPrefixLocation("repoPrefixLocation")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_panorama.CfnPackage.StorageLocationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageLocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageLocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The location's binary prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-binaryprefixlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-binaryprefixlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBinaryPrefixLocation() {
            return null;
        }

        /**
         * The location's bucket.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getBucket() {
            return null;
        }

        /**
         * The location's generated prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-generatedprefixlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-generatedprefixlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGeneratedPrefixLocation() {
            return null;
        }

        /**
         * The location's manifest prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-manifestprefixlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-manifestprefixlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getManifestPrefixLocation() {
            return null;
        }

        /**
         * The location's repo prefix.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-repoprefixlocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-panorama-package-storagelocation.html#cfn-panorama-package-storagelocation-repoprefixlocation</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getRepoPrefixLocation() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageLocationProperty> {
            java.lang.String binaryPrefixLocation;
            java.lang.String bucket;
            java.lang.String generatedPrefixLocation;
            java.lang.String manifestPrefixLocation;
            java.lang.String repoPrefixLocation;

            /**
             * Sets the value of {@link StorageLocationProperty#getBinaryPrefixLocation}
             * @param binaryPrefixLocation The location's binary prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder binaryPrefixLocation(java.lang.String binaryPrefixLocation) {
                this.binaryPrefixLocation = binaryPrefixLocation;
                return this;
            }

            /**
             * Sets the value of {@link StorageLocationProperty#getBucket}
             * @param bucket The location's bucket.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link StorageLocationProperty#getGeneratedPrefixLocation}
             * @param generatedPrefixLocation The location's generated prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder generatedPrefixLocation(java.lang.String generatedPrefixLocation) {
                this.generatedPrefixLocation = generatedPrefixLocation;
                return this;
            }

            /**
             * Sets the value of {@link StorageLocationProperty#getManifestPrefixLocation}
             * @param manifestPrefixLocation The location's manifest prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder manifestPrefixLocation(java.lang.String manifestPrefixLocation) {
                this.manifestPrefixLocation = manifestPrefixLocation;
                return this;
            }

            /**
             * Sets the value of {@link StorageLocationProperty#getRepoPrefixLocation}
             * @param repoPrefixLocation The location's repo prefix.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder repoPrefixLocation(java.lang.String repoPrefixLocation) {
                this.repoPrefixLocation = repoPrefixLocation;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageLocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageLocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageLocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageLocationProperty {
            private final java.lang.String binaryPrefixLocation;
            private final java.lang.String bucket;
            private final java.lang.String generatedPrefixLocation;
            private final java.lang.String manifestPrefixLocation;
            private final java.lang.String repoPrefixLocation;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.binaryPrefixLocation = software.amazon.jsii.Kernel.get(this, "binaryPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.generatedPrefixLocation = software.amazon.jsii.Kernel.get(this, "generatedPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.manifestPrefixLocation = software.amazon.jsii.Kernel.get(this, "manifestPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.repoPrefixLocation = software.amazon.jsii.Kernel.get(this, "repoPrefixLocation", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.binaryPrefixLocation = builder.binaryPrefixLocation;
                this.bucket = builder.bucket;
                this.generatedPrefixLocation = builder.generatedPrefixLocation;
                this.manifestPrefixLocation = builder.manifestPrefixLocation;
                this.repoPrefixLocation = builder.repoPrefixLocation;
            }

            @Override
            public final java.lang.String getBinaryPrefixLocation() {
                return this.binaryPrefixLocation;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getGeneratedPrefixLocation() {
                return this.generatedPrefixLocation;
            }

            @Override
            public final java.lang.String getManifestPrefixLocation() {
                return this.manifestPrefixLocation;
            }

            @Override
            public final java.lang.String getRepoPrefixLocation() {
                return this.repoPrefixLocation;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBinaryPrefixLocation() != null) {
                    data.set("binaryPrefixLocation", om.valueToTree(this.getBinaryPrefixLocation()));
                }
                if (this.getBucket() != null) {
                    data.set("bucket", om.valueToTree(this.getBucket()));
                }
                if (this.getGeneratedPrefixLocation() != null) {
                    data.set("generatedPrefixLocation", om.valueToTree(this.getGeneratedPrefixLocation()));
                }
                if (this.getManifestPrefixLocation() != null) {
                    data.set("manifestPrefixLocation", om.valueToTree(this.getManifestPrefixLocation()));
                }
                if (this.getRepoPrefixLocation() != null) {
                    data.set("repoPrefixLocation", om.valueToTree(this.getRepoPrefixLocation()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_panorama.CfnPackage.StorageLocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageLocationProperty.Jsii$Proxy that = (StorageLocationProperty.Jsii$Proxy) o;

                if (this.binaryPrefixLocation != null ? !this.binaryPrefixLocation.equals(that.binaryPrefixLocation) : that.binaryPrefixLocation != null) return false;
                if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
                if (this.generatedPrefixLocation != null ? !this.generatedPrefixLocation.equals(that.generatedPrefixLocation) : that.generatedPrefixLocation != null) return false;
                if (this.manifestPrefixLocation != null ? !this.manifestPrefixLocation.equals(that.manifestPrefixLocation) : that.manifestPrefixLocation != null) return false;
                return this.repoPrefixLocation != null ? this.repoPrefixLocation.equals(that.repoPrefixLocation) : that.repoPrefixLocation == null;
            }

            @Override
            public final int hashCode() {
                int result = this.binaryPrefixLocation != null ? this.binaryPrefixLocation.hashCode() : 0;
                result = 31 * result + (this.bucket != null ? this.bucket.hashCode() : 0);
                result = 31 * result + (this.generatedPrefixLocation != null ? this.generatedPrefixLocation.hashCode() : 0);
                result = 31 * result + (this.manifestPrefixLocation != null ? this.manifestPrefixLocation.hashCode() : 0);
                result = 31 * result + (this.repoPrefixLocation != null ? this.repoPrefixLocation.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.panorama.CfnPackage}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.panorama.CfnPackage> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.panorama.CfnPackageProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.panorama.CfnPackageProps.Builder();
        }

        /**
         * A name for the package.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-packagename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-packagename</a>
         * @param packageName A name for the package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder packageName(final java.lang.String packageName) {
            this.props.packageName(packageName);
            return this;
        }

        /**
         * A storage location.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-storagelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-storagelocation</a>
         * @param storageLocation A storage location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageLocation(final software.amazon.awscdk.IResolvable storageLocation) {
            this.props.storageLocation(storageLocation);
            return this;
        }
        /**
         * A storage location.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-storagelocation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-storagelocation</a>
         * @param storageLocation A storage location. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder storageLocation(final software.amazon.awscdk.services.panorama.CfnPackage.StorageLocationProperty storageLocation) {
            this.props.storageLocation(storageLocation);
            return this;
        }

        /**
         * Tags for the package.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-panorama-package.html#cfn-panorama-package-tags</a>
         * @param tags Tags for the package. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.panorama.CfnPackage}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.panorama.CfnPackage build() {
            return new software.amazon.awscdk.services.panorama.CfnPackage(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
