package software.amazon.awscdk.services.qbusiness;

/**
 * Information about an Amazon Q Business plugin and its configuration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.qbusiness.*;
 * Object noAuthConfiguration;
 * CfnPlugin cfnPlugin = CfnPlugin.Builder.create(this, "MyCfnPlugin")
 *         .authConfiguration(PluginAuthConfigurationProperty.builder()
 *                 .basicAuthConfiguration(BasicAuthConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .secretArn("secretArn")
 *                         .build())
 *                 .noAuthConfiguration(noAuthConfiguration)
 *                 .oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfigurationProperty.builder()
 *                         .roleArn("roleArn")
 *                         .secretArn("secretArn")
 *                         // the properties below are optional
 *                         .authorizationUrl("authorizationUrl")
 *                         .tokenUrl("tokenUrl")
 *                         .build())
 *                 .build())
 *         .displayName("displayName")
 *         .type("type")
 *         // the properties below are optional
 *         .applicationId("applicationId")
 *         .customPluginConfiguration(CustomPluginConfigurationProperty.builder()
 *                 .apiSchema(APISchemaProperty.builder()
 *                         .payload("payload")
 *                         .s3(S3Property.builder()
 *                                 .bucket("bucket")
 *                                 .key("key")
 *                                 .build())
 *                         .build())
 *                 .apiSchemaType("apiSchemaType")
 *                 .description("description")
 *                 .build())
 *         .serverUrl("serverUrl")
 *         .state("state")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:22.049Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPlugin")
public class CfnPlugin extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnPlugin(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnPlugin(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.qbusiness.CfnPlugin.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnPlugin(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.qbusiness.CfnPluginProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The current status of a plugin.
     * <p>
     * A plugin is modified asynchronously.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBuildStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrBuildStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the plugin was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of a plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPluginArn() {
        return software.amazon.jsii.Kernel.get(this, "attrPluginArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrPluginId() {
        return software.amazon.jsii.Kernel.get(this, "attrPluginId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The timestamp for when the plugin was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Authentication configuration information for an Amazon Q Business plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getAuthConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "authConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Authentication configuration information for an Amazon Q Business plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "authConfiguration", java.util.Objects.requireNonNull(value, "authConfiguration is required"));
    }

    /**
     * Authentication configuration information for an Amazon Q Business plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAuthConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.qbusiness.CfnPlugin.PluginAuthConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "authConfiguration", java.util.Objects.requireNonNull(value, "authConfiguration is required"));
    }

    /**
     * The name of the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "displayName", java.util.Objects.requireNonNull(value, "displayName is required"));
    }

    /**
     * The type of the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * The identifier of the application that will contain the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getApplicationId() {
        return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the application that will contain the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setApplicationId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "applicationId", value);
    }

    /**
     * Configuration information required to create a custom plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCustomPluginConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "customPluginConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration information required to create a custom plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomPluginConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "customPluginConfiguration", value);
    }

    /**
     * Configuration information required to create a custom plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomPluginConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.qbusiness.CfnPlugin.CustomPluginConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "customPluginConfiguration", value);
    }

    /**
     * The plugin server URL used for configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getServerUrl() {
        return software.amazon.jsii.Kernel.get(this, "serverUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The plugin server URL used for configuration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setServerUrl(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "serverUrl", value);
    }

    /**
     * The current status of the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getState() {
        return software.amazon.jsii.Kernel.get(this, "state", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The current status of the plugin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setState(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "state", value);
    }

    /**
     * A list of key-value pairs that identify or categorize the data source connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs that identify or categorize the data source connector.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * Contains details about the OpenAPI schema for a custom plugin.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/amazonq/latest/qbusiness-ug/custom-plugin.html#plugins-api-schema">custom plugin OpenAPI schemas</a> . You can either include the schema directly in the payload field or you can upload it to an S3 bucket and specify the S3 bucket location in the <code>s3</code> field.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * APISchemaProperty aPISchemaProperty = APISchemaProperty.builder()
     *         .payload("payload")
     *         .s3(S3Property.builder()
     *                 .bucket("bucket")
     *                 .key("key")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-apischema.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-apischema.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPlugin.APISchemaProperty")
    @software.amazon.jsii.Jsii.Proxy(APISchemaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface APISchemaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The JSON or YAML-formatted payload defining the OpenAPI schema for a custom plugin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-apischema.html#cfn-qbusiness-plugin-apischema-payload">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-apischema.html#cfn-qbusiness-plugin-apischema-payload</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPayload() {
            return null;
        }

        /**
         * Contains details about the S3 object containing the OpenAPI schema for a custom plugin.
         * <p>
         * The schema could be in either JSON or YAML format.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-apischema.html#cfn-qbusiness-plugin-apischema-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-apischema.html#cfn-qbusiness-plugin-apischema-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link APISchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link APISchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<APISchemaProperty> {
            java.lang.String payload;
            java.lang.Object s3;

            /**
             * Sets the value of {@link APISchemaProperty#getPayload}
             * @param payload The JSON or YAML-formatted payload defining the OpenAPI schema for a custom plugin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder payload(java.lang.String payload) {
                this.payload = payload;
                return this;
            }

            /**
             * Sets the value of {@link APISchemaProperty#getS3}
             * @param s3 Contains details about the S3 object containing the OpenAPI schema for a custom plugin.
             *           The schema could be in either JSON or YAML format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link APISchemaProperty#getS3}
             * @param s3 Contains details about the S3 object containing the OpenAPI schema for a custom plugin.
             *           The schema could be in either JSON or YAML format.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.qbusiness.CfnPlugin.S3Property s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link APISchemaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public APISchemaProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link APISchemaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements APISchemaProperty {
            private final java.lang.String payload;
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.payload = software.amazon.jsii.Kernel.get(this, "payload", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.payload = builder.payload;
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.String getPayload() {
                return this.payload;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getPayload() != null) {
                    data.set("payload", om.valueToTree(this.getPayload()));
                }
                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnPlugin.APISchemaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                APISchemaProperty.Jsii$Proxy that = (APISchemaProperty.Jsii$Proxy) o;

                if (this.payload != null ? !this.payload.equals(that.payload) : that.payload != null) return false;
                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.payload != null ? this.payload.hashCode() : 0;
                result = 31 * result + (this.s3 != null ? this.s3.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information about the basic authentication credentials used to configure a plugin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * BasicAuthConfigurationProperty basicAuthConfigurationProperty = BasicAuthConfigurationProperty.builder()
     *         .roleArn("roleArn")
     *         .secretArn("secretArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-basicauthconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-basicauthconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPlugin.BasicAuthConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(BasicAuthConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface BasicAuthConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a Secrets Manager secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-basicauthconfiguration.html#cfn-qbusiness-plugin-basicauthconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-basicauthconfiguration.html#cfn-qbusiness-plugin-basicauthconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The ARN of the Secrets Manager secret that stores the basic authentication credentials used for plugin configuration..
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-basicauthconfiguration.html#cfn-qbusiness-plugin-basicauthconfiguration-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-basicauthconfiguration.html#cfn-qbusiness-plugin-basicauthconfiguration-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * @return a {@link Builder} of {@link BasicAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link BasicAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<BasicAuthConfigurationProperty> {
            java.lang.String roleArn;
            java.lang.String secretArn;

            /**
             * Sets the value of {@link BasicAuthConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of an IAM role used by Amazon Q Business to access the basic authentication credentials stored in a Secrets Manager secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link BasicAuthConfigurationProperty#getSecretArn}
             * @param secretArn The ARN of the Secrets Manager secret that stores the basic authentication credentials used for plugin configuration.. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link BasicAuthConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public BasicAuthConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link BasicAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BasicAuthConfigurationProperty {
            private final java.lang.String roleArn;
            private final java.lang.String secretArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnPlugin.BasicAuthConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                BasicAuthConfigurationProperty.Jsii$Proxy that = (BasicAuthConfigurationProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                return this.secretArn.equals(that.secretArn);
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                return result;
            }
        }
    }
    /**
     * Configuration information required to create a custom plugin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * CustomPluginConfigurationProperty customPluginConfigurationProperty = CustomPluginConfigurationProperty.builder()
     *         .apiSchema(APISchemaProperty.builder()
     *                 .payload("payload")
     *                 .s3(S3Property.builder()
     *                         .bucket("bucket")
     *                         .key("key")
     *                         .build())
     *                 .build())
     *         .apiSchemaType("apiSchemaType")
     *         .description("description")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPlugin.CustomPluginConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomPluginConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomPluginConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html#cfn-qbusiness-plugin-custompluginconfiguration-apischema">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html#cfn-qbusiness-plugin-custompluginconfiguration-apischema</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getApiSchema();

        /**
         * The type of OpenAPI schema to use.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html#cfn-qbusiness-plugin-custompluginconfiguration-apischematype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html#cfn-qbusiness-plugin-custompluginconfiguration-apischematype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getApiSchemaType();

        /**
         * A description for your custom plugin configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html#cfn-qbusiness-plugin-custompluginconfiguration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-custompluginconfiguration.html#cfn-qbusiness-plugin-custompluginconfiguration-description</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDescription();

        /**
         * @return a {@link Builder} of {@link CustomPluginConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomPluginConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomPluginConfigurationProperty> {
            java.lang.Object apiSchema;
            java.lang.String apiSchemaType;
            java.lang.String description;

            /**
             * Sets the value of {@link CustomPluginConfigurationProperty#getApiSchema}
             * @param apiSchema Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSchema(software.amazon.awscdk.IResolvable apiSchema) {
                this.apiSchema = apiSchema;
                return this;
            }

            /**
             * Sets the value of {@link CustomPluginConfigurationProperty#getApiSchema}
             * @param apiSchema Contains either details about the S3 object containing the OpenAPI schema for the action group or the JSON or YAML-formatted payload defining the schema. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSchema(software.amazon.awscdk.services.qbusiness.CfnPlugin.APISchemaProperty apiSchema) {
                this.apiSchema = apiSchema;
                return this;
            }

            /**
             * Sets the value of {@link CustomPluginConfigurationProperty#getApiSchemaType}
             * @param apiSchemaType The type of OpenAPI schema to use. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder apiSchemaType(java.lang.String apiSchemaType) {
                this.apiSchemaType = apiSchemaType;
                return this;
            }

            /**
             * Sets the value of {@link CustomPluginConfigurationProperty#getDescription}
             * @param description A description for your custom plugin configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder description(java.lang.String description) {
                this.description = description;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomPluginConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomPluginConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CustomPluginConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomPluginConfigurationProperty {
            private final java.lang.Object apiSchema;
            private final java.lang.String apiSchemaType;
            private final java.lang.String description;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.apiSchema = software.amazon.jsii.Kernel.get(this, "apiSchema", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.apiSchemaType = software.amazon.jsii.Kernel.get(this, "apiSchemaType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.apiSchema = java.util.Objects.requireNonNull(builder.apiSchema, "apiSchema is required");
                this.apiSchemaType = java.util.Objects.requireNonNull(builder.apiSchemaType, "apiSchemaType is required");
                this.description = java.util.Objects.requireNonNull(builder.description, "description is required");
            }

            @Override
            public final java.lang.Object getApiSchema() {
                return this.apiSchema;
            }

            @Override
            public final java.lang.String getApiSchemaType() {
                return this.apiSchemaType;
            }

            @Override
            public final java.lang.String getDescription() {
                return this.description;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("apiSchema", om.valueToTree(this.getApiSchema()));
                data.set("apiSchemaType", om.valueToTree(this.getApiSchemaType()));
                data.set("description", om.valueToTree(this.getDescription()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnPlugin.CustomPluginConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomPluginConfigurationProperty.Jsii$Proxy that = (CustomPluginConfigurationProperty.Jsii$Proxy) o;

                if (!apiSchema.equals(that.apiSchema)) return false;
                if (!apiSchemaType.equals(that.apiSchemaType)) return false;
                return this.description.equals(that.description);
            }

            @Override
            public final int hashCode() {
                int result = this.apiSchema.hashCode();
                result = 31 * result + (this.apiSchemaType.hashCode());
                result = 31 * result + (this.description.hashCode());
                return result;
            }
        }
    }
    /**
     * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * OAuth2ClientCredentialConfigurationProperty oAuth2ClientCredentialConfigurationProperty = OAuth2ClientCredentialConfigurationProperty.builder()
     *         .roleArn("roleArn")
     *         .secretArn("secretArn")
     *         // the properties below are optional
     *         .authorizationUrl("authorizationUrl")
     *         .tokenUrl("tokenUrl")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPlugin.OAuth2ClientCredentialConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(OAuth2ClientCredentialConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OAuth2ClientCredentialConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of an IAM role used by Amazon Q Business to access the OAuth 2.0 authentication credentials stored in a Secrets Manager secret.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-rolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-rolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRoleArn();

        /**
         * The ARN of the Secrets Manager secret that stores the OAuth 2.0 credentials/token used for plugin configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-secretarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-secretarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSecretArn();

        /**
         * The redirect URL required by the OAuth 2.0 protocol for Amazon Q Business to authenticate a plugin user through a third party authentication server.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-authorizationurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-authorizationurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationUrl() {
            return null;
        }

        /**
         * The URL required by the OAuth 2.0 protocol to exchange an end user authorization code for an access token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-tokenurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-oauth2clientcredentialconfiguration.html#cfn-qbusiness-plugin-oauth2clientcredentialconfiguration-tokenurl</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTokenUrl() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OAuth2ClientCredentialConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OAuth2ClientCredentialConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OAuth2ClientCredentialConfigurationProperty> {
            java.lang.String roleArn;
            java.lang.String secretArn;
            java.lang.String authorizationUrl;
            java.lang.String tokenUrl;

            /**
             * Sets the value of {@link OAuth2ClientCredentialConfigurationProperty#getRoleArn}
             * @param roleArn The ARN of an IAM role used by Amazon Q Business to access the OAuth 2.0 authentication credentials stored in a Secrets Manager secret. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder roleArn(java.lang.String roleArn) {
                this.roleArn = roleArn;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2ClientCredentialConfigurationProperty#getSecretArn}
             * @param secretArn The ARN of the Secrets Manager secret that stores the OAuth 2.0 credentials/token used for plugin configuration. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder secretArn(java.lang.String secretArn) {
                this.secretArn = secretArn;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2ClientCredentialConfigurationProperty#getAuthorizationUrl}
             * @param authorizationUrl The redirect URL required by the OAuth 2.0 protocol for Amazon Q Business to authenticate a plugin user through a third party authentication server.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationUrl(java.lang.String authorizationUrl) {
                this.authorizationUrl = authorizationUrl;
                return this;
            }

            /**
             * Sets the value of {@link OAuth2ClientCredentialConfigurationProperty#getTokenUrl}
             * @param tokenUrl The URL required by the OAuth 2.0 protocol to exchange an end user authorization code for an access token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder tokenUrl(java.lang.String tokenUrl) {
                this.tokenUrl = tokenUrl;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OAuth2ClientCredentialConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OAuth2ClientCredentialConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link OAuth2ClientCredentialConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OAuth2ClientCredentialConfigurationProperty {
            private final java.lang.String roleArn;
            private final java.lang.String secretArn;
            private final java.lang.String authorizationUrl;
            private final java.lang.String tokenUrl;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.secretArn = software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationUrl = software.amazon.jsii.Kernel.get(this, "authorizationUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.tokenUrl = software.amazon.jsii.Kernel.get(this, "tokenUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.roleArn = java.util.Objects.requireNonNull(builder.roleArn, "roleArn is required");
                this.secretArn = java.util.Objects.requireNonNull(builder.secretArn, "secretArn is required");
                this.authorizationUrl = builder.authorizationUrl;
                this.tokenUrl = builder.tokenUrl;
            }

            @Override
            public final java.lang.String getRoleArn() {
                return this.roleArn;
            }

            @Override
            public final java.lang.String getSecretArn() {
                return this.secretArn;
            }

            @Override
            public final java.lang.String getAuthorizationUrl() {
                return this.authorizationUrl;
            }

            @Override
            public final java.lang.String getTokenUrl() {
                return this.tokenUrl;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("roleArn", om.valueToTree(this.getRoleArn()));
                data.set("secretArn", om.valueToTree(this.getSecretArn()));
                if (this.getAuthorizationUrl() != null) {
                    data.set("authorizationUrl", om.valueToTree(this.getAuthorizationUrl()));
                }
                if (this.getTokenUrl() != null) {
                    data.set("tokenUrl", om.valueToTree(this.getTokenUrl()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnPlugin.OAuth2ClientCredentialConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OAuth2ClientCredentialConfigurationProperty.Jsii$Proxy that = (OAuth2ClientCredentialConfigurationProperty.Jsii$Proxy) o;

                if (!roleArn.equals(that.roleArn)) return false;
                if (!secretArn.equals(that.secretArn)) return false;
                if (this.authorizationUrl != null ? !this.authorizationUrl.equals(that.authorizationUrl) : that.authorizationUrl != null) return false;
                return this.tokenUrl != null ? this.tokenUrl.equals(that.tokenUrl) : that.tokenUrl == null;
            }

            @Override
            public final int hashCode() {
                int result = this.roleArn.hashCode();
                result = 31 * result + (this.secretArn.hashCode());
                result = 31 * result + (this.authorizationUrl != null ? this.authorizationUrl.hashCode() : 0);
                result = 31 * result + (this.tokenUrl != null ? this.tokenUrl.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Authentication configuration information for an Amazon Q Business plugin.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * Object noAuthConfiguration;
     * PluginAuthConfigurationProperty pluginAuthConfigurationProperty = PluginAuthConfigurationProperty.builder()
     *         .basicAuthConfiguration(BasicAuthConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 .build())
     *         .noAuthConfiguration(noAuthConfiguration)
     *         .oAuth2ClientCredentialConfiguration(OAuth2ClientCredentialConfigurationProperty.builder()
     *                 .roleArn("roleArn")
     *                 .secretArn("secretArn")
     *                 // the properties below are optional
     *                 .authorizationUrl("authorizationUrl")
     *                 .tokenUrl("tokenUrl")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPlugin.PluginAuthConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PluginAuthConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PluginAuthConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Information about the basic authentication credentials used to configure a plugin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html#cfn-qbusiness-plugin-pluginauthconfiguration-basicauthconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html#cfn-qbusiness-plugin-pluginauthconfiguration-basicauthconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getBasicAuthConfiguration() {
            return null;
        }

        /**
         * Information about invoking a custom plugin without any authentication.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html#cfn-qbusiness-plugin-pluginauthconfiguration-noauthconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html#cfn-qbusiness-plugin-pluginauthconfiguration-noauthconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNoAuthConfiguration() {
            return null;
        }

        /**
         * Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html#cfn-qbusiness-plugin-pluginauthconfiguration-oauth2clientcredentialconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-pluginauthconfiguration.html#cfn-qbusiness-plugin-pluginauthconfiguration-oauth2clientcredentialconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOAuth2ClientCredentialConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PluginAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PluginAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PluginAuthConfigurationProperty> {
            java.lang.Object basicAuthConfiguration;
            java.lang.Object noAuthConfiguration;
            java.lang.Object oAuth2ClientCredentialConfiguration;

            /**
             * Sets the value of {@link PluginAuthConfigurationProperty#getBasicAuthConfiguration}
             * @param basicAuthConfiguration Information about the basic authentication credentials used to configure a plugin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthConfiguration(software.amazon.awscdk.IResolvable basicAuthConfiguration) {
                this.basicAuthConfiguration = basicAuthConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PluginAuthConfigurationProperty#getBasicAuthConfiguration}
             * @param basicAuthConfiguration Information about the basic authentication credentials used to configure a plugin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder basicAuthConfiguration(software.amazon.awscdk.services.qbusiness.CfnPlugin.BasicAuthConfigurationProperty basicAuthConfiguration) {
                this.basicAuthConfiguration = basicAuthConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PluginAuthConfigurationProperty#getNoAuthConfiguration}
             * @param noAuthConfiguration Information about invoking a custom plugin without any authentication.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder noAuthConfiguration(java.lang.Object noAuthConfiguration) {
                this.noAuthConfiguration = noAuthConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PluginAuthConfigurationProperty#getOAuth2ClientCredentialConfiguration}
             * @param oAuth2ClientCredentialConfiguration Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2ClientCredentialConfiguration(software.amazon.awscdk.IResolvable oAuth2ClientCredentialConfiguration) {
                this.oAuth2ClientCredentialConfiguration = oAuth2ClientCredentialConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PluginAuthConfigurationProperty#getOAuth2ClientCredentialConfiguration}
             * @param oAuth2ClientCredentialConfiguration Information about the OAuth 2.0 authentication credential/token used to configure a plugin.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder oAuth2ClientCredentialConfiguration(software.amazon.awscdk.services.qbusiness.CfnPlugin.OAuth2ClientCredentialConfigurationProperty oAuth2ClientCredentialConfiguration) {
                this.oAuth2ClientCredentialConfiguration = oAuth2ClientCredentialConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PluginAuthConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PluginAuthConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PluginAuthConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PluginAuthConfigurationProperty {
            private final java.lang.Object basicAuthConfiguration;
            private final java.lang.Object noAuthConfiguration;
            private final java.lang.Object oAuth2ClientCredentialConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.basicAuthConfiguration = software.amazon.jsii.Kernel.get(this, "basicAuthConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.noAuthConfiguration = software.amazon.jsii.Kernel.get(this, "noAuthConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.oAuth2ClientCredentialConfiguration = software.amazon.jsii.Kernel.get(this, "oAuth2ClientCredentialConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.basicAuthConfiguration = builder.basicAuthConfiguration;
                this.noAuthConfiguration = builder.noAuthConfiguration;
                this.oAuth2ClientCredentialConfiguration = builder.oAuth2ClientCredentialConfiguration;
            }

            @Override
            public final java.lang.Object getBasicAuthConfiguration() {
                return this.basicAuthConfiguration;
            }

            @Override
            public final java.lang.Object getNoAuthConfiguration() {
                return this.noAuthConfiguration;
            }

            @Override
            public final java.lang.Object getOAuth2ClientCredentialConfiguration() {
                return this.oAuth2ClientCredentialConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBasicAuthConfiguration() != null) {
                    data.set("basicAuthConfiguration", om.valueToTree(this.getBasicAuthConfiguration()));
                }
                if (this.getNoAuthConfiguration() != null) {
                    data.set("noAuthConfiguration", om.valueToTree(this.getNoAuthConfiguration()));
                }
                if (this.getOAuth2ClientCredentialConfiguration() != null) {
                    data.set("oAuth2ClientCredentialConfiguration", om.valueToTree(this.getOAuth2ClientCredentialConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnPlugin.PluginAuthConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PluginAuthConfigurationProperty.Jsii$Proxy that = (PluginAuthConfigurationProperty.Jsii$Proxy) o;

                if (this.basicAuthConfiguration != null ? !this.basicAuthConfiguration.equals(that.basicAuthConfiguration) : that.basicAuthConfiguration != null) return false;
                if (this.noAuthConfiguration != null ? !this.noAuthConfiguration.equals(that.noAuthConfiguration) : that.noAuthConfiguration != null) return false;
                return this.oAuth2ClientCredentialConfiguration != null ? this.oAuth2ClientCredentialConfiguration.equals(that.oAuth2ClientCredentialConfiguration) : that.oAuth2ClientCredentialConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.basicAuthConfiguration != null ? this.basicAuthConfiguration.hashCode() : 0;
                result = 31 * result + (this.noAuthConfiguration != null ? this.noAuthConfiguration.hashCode() : 0);
                result = 31 * result + (this.oAuth2ClientCredentialConfiguration != null ? this.oAuth2ClientCredentialConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Information required for Amazon Q Business to find a specific file in an Amazon S3 bucket.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.qbusiness.*;
     * S3Property s3Property = S3Property.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-s3.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-s3.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_qbusiness.CfnPlugin.S3Property")
    @software.amazon.jsii.Jsii.Proxy(S3Property.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3Property extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket that contains the file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-s3.html#cfn-qbusiness-plugin-s3-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-s3.html#cfn-qbusiness-plugin-s3-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The name of the file.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-s3.html#cfn-qbusiness-plugin-s3-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-qbusiness-plugin-s3.html#cfn-qbusiness-plugin-s3-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * @return a {@link Builder} of {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3Property> {
            java.lang.String bucket;
            java.lang.String key;

            /**
             * Sets the value of {@link S3Property#getBucket}
             * @param bucket The name of the S3 bucket that contains the file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3Property#getKey}
             * @param key The name of the file. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3Property}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3Property build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3Property}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3Property {
            private final java.lang.String bucket;
            private final java.lang.String key;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_qbusiness.CfnPlugin.S3Property"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3Property.Jsii$Proxy that = (S3Property.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                return this.key.equals(that.key);
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.qbusiness.CfnPlugin}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.qbusiness.CfnPlugin> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.qbusiness.CfnPluginProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.qbusiness.CfnPluginProps.Builder();
        }

        /**
         * Authentication configuration information for an Amazon Q Business plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-authconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-authconfiguration</a>
         * @param authConfiguration Authentication configuration information for an Amazon Q Business plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authConfiguration(final software.amazon.awscdk.IResolvable authConfiguration) {
            this.props.authConfiguration(authConfiguration);
            return this;
        }
        /**
         * Authentication configuration information for an Amazon Q Business plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-authconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-authconfiguration</a>
         * @param authConfiguration Authentication configuration information for an Amazon Q Business plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authConfiguration(final software.amazon.awscdk.services.qbusiness.CfnPlugin.PluginAuthConfigurationProperty authConfiguration) {
            this.props.authConfiguration(authConfiguration);
            return this;
        }

        /**
         * The name of the plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-displayname</a>
         * @param displayName The name of the plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder displayName(final java.lang.String displayName) {
            this.props.displayName(displayName);
            return this;
        }

        /**
         * The type of the plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-type</a>
         * @param type The type of the plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * The identifier of the application that will contain the plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-applicationid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-applicationid</a>
         * @param applicationId The identifier of the application that will contain the plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder applicationId(final java.lang.String applicationId) {
            this.props.applicationId(applicationId);
            return this;
        }

        /**
         * Configuration information required to create a custom plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-custompluginconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-custompluginconfiguration</a>
         * @param customPluginConfiguration Configuration information required to create a custom plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPluginConfiguration(final software.amazon.awscdk.IResolvable customPluginConfiguration) {
            this.props.customPluginConfiguration(customPluginConfiguration);
            return this;
        }
        /**
         * Configuration information required to create a custom plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-custompluginconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-custompluginconfiguration</a>
         * @param customPluginConfiguration Configuration information required to create a custom plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customPluginConfiguration(final software.amazon.awscdk.services.qbusiness.CfnPlugin.CustomPluginConfigurationProperty customPluginConfiguration) {
            this.props.customPluginConfiguration(customPluginConfiguration);
            return this;
        }

        /**
         * The plugin server URL used for configuration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-serverurl">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-serverurl</a>
         * @param serverUrl The plugin server URL used for configuration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serverUrl(final java.lang.String serverUrl) {
            this.props.serverUrl(serverUrl);
            return this;
        }

        /**
         * The current status of the plugin.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-state">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-state</a>
         * @param state The current status of the plugin. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder state(final java.lang.String state) {
            this.props.state(state);
            return this;
        }

        /**
         * A list of key-value pairs that identify or categorize the data source connector.
         * <p>
         * You can also use tags to help control access to the data source connector. Tag keys and values can consist of Unicode letters, digits, white space, and any of the following symbols: _ . : / = + -
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-qbusiness-plugin.html#cfn-qbusiness-plugin-tags</a>
         * @param tags A list of key-value pairs that identify or categorize the data source connector. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.qbusiness.CfnPlugin}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.qbusiness.CfnPlugin build() {
            return new software.amazon.awscdk.services.qbusiness.CfnPlugin(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
