package software.amazon.awscdk.services.rds;

/**
 * The versions for the MySQL instance engines (those returned by <code>DatabaseInstanceEngine.mysql</code>).
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Vpc vpc;
 * Key kmsKey;
 * DatabaseInstance instance = DatabaseInstance.Builder.create(this, "Instance")
 *         .engine(DatabaseInstanceEngine.mysql(MySqlInstanceEngineProps.builder().version(MysqlEngineVersion.VER_8_0_39).build()))
 *         .instanceType(InstanceType.of(InstanceClass.R7G, InstanceSize.LARGE))
 *         .vpc(vpc)
 *         .enablePerformanceInsights(true)
 *         .performanceInsightRetention(PerformanceInsightRetention.LONG_TERM)
 *         .performanceInsightEncryptionKey(kmsKey)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:24.140Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_rds.MysqlEngineVersion")
public class MysqlEngineVersion extends software.amazon.jsii.JsiiObject {

    protected MysqlEngineVersion(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MysqlEngineVersion(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        VER_5_5_54 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_5_54", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_22 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_22", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_24 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_24", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_25 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_25", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_26 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_26", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_30 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_30", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_33 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_33", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_34 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_34", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_35 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_35", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_36 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_36", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_37 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_37", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_38 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_38", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_39 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_39", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_40 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_40", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_41 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_41", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_42 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_42", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_43 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_43", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44_RDS_20240408 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44_RDS_20240408", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44_RDS_20240529 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44_RDS_20240529", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44_RDS_20240808 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44_RDS_20240808", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44_RDS_20250103 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44_RDS_20250103", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44_RDS_20250213 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44_RDS_20250213", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_5_7_44_RDS_20250508 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_5_7_44_RDS_20250508", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_11 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_11", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_13 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_13", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_15 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_15", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_16 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_16", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_17 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_17", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_19 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_19", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_20 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_20", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_21 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_21", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_23 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_23", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_25 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_25", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_26 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_26", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_27 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_27", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_28 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_28", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_29 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_29", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_30 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_30", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_31 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_31", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_32 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_32", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_33 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_33", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_34 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_34", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_35 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_35", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_36 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_36", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_37 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_37", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_39 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_39", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_40 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_40", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_41 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_41", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_0_42 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_0_42", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_4_3 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_4_3", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_4_4 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_4_4", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
        VER_8_4_5 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "VER_8_4_5", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class));
    }

    /**
     * Create a new MysqlEngineVersion with an arbitrary version.
     * <p>
     * @param mysqlFullVersion the full version string, for example "8.1.43". This parameter is required.
     * @param mysqlMajorVersion the major version of the engine, for example "8.1". This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.rds.MysqlEngineVersion of(final @org.jetbrains.annotations.NotNull java.lang.String mysqlFullVersion, final @org.jetbrains.annotations.NotNull java.lang.String mysqlMajorVersion) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.rds.MysqlEngineVersion.class, "of", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.rds.MysqlEngineVersion.class), new Object[] { java.util.Objects.requireNonNull(mysqlFullVersion, "mysqlFullVersion is required"), java.util.Objects.requireNonNull(mysqlMajorVersion, "mysqlMajorVersion is required") });
    }

    /**
     * (deprecated) Version "5.5.54".
     * <p>
     * @deprecated MySQL 5.5.54 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_5_54;

    /**
     * Version "5.7" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7;

    /**
     * (deprecated) Version "5.7.16".
     * <p>
     * @deprecated MySQL 5.7.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_16;

    /**
     * (deprecated) Version "5.7.17".
     * <p>
     * @deprecated MySQL 5.7.17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_17;

    /**
     * (deprecated) Version "5.7.19".
     * <p>
     * @deprecated MySQL 5.7.19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_19;

    /**
     * (deprecated) Version "5.7.21".
     * <p>
     * @deprecated MySQL 5.7.21 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_21;

    /**
     * (deprecated) Version "5.7.22".
     * <p>
     * @deprecated MySQL 5.7.22 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_22;

    /**
     * (deprecated) Version "5.7.23".
     * <p>
     * @deprecated MySQL 5.7.23 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_23;

    /**
     * (deprecated) Version "5.7.24".
     * <p>
     * @deprecated MySQL 5.7.24 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_24;

    /**
     * (deprecated) Version "5.7.25".
     * <p>
     * @deprecated MySQL 5.7.25 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_25;

    /**
     * (deprecated) Version "5.7.26".
     * <p>
     * @deprecated MySQL 5.7.26 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_26;

    /**
     * (deprecated) Version "5.7.28".
     * <p>
     * @deprecated MySQL 5.7.28 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_28;

    /**
     * (deprecated) Version "5.7.30".
     * <p>
     * @deprecated MySQL 5.7.30 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_30;

    /**
     * (deprecated) Version "5.7.31".
     * <p>
     * @deprecated MySQL 5.7.31 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_31;

    /**
     * (deprecated) Version "5.7.33".
     * <p>
     * @deprecated MySQL 5.7.33 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_33;

    /**
     * (deprecated) Version "5.7.34".
     * <p>
     * @deprecated MySQL 5.7.34 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_34;

    /**
     * (deprecated) Version "5.7.35".
     * <p>
     * @deprecated MySQL 5.7.35 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_35;

    /**
     * (deprecated) Version "5.7.36".
     * <p>
     * @deprecated MySQL 5.7.36 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_36;

    /**
     * (deprecated) Version "5.7.37".
     * <p>
     * @deprecated MySQL 5.7.37 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_37;

    /**
     * (deprecated) Version "5.7.38".
     * <p>
     * @deprecated MySQL 5.7.38 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_38;

    /**
     * (deprecated) Version "5.7.39".
     * <p>
     * @deprecated MySQL 5.7.39 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_39;

    /**
     * (deprecated) Version "5.7.40".
     * <p>
     * @deprecated MySQL 5.7.40 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_40;

    /**
     * (deprecated) Version "5.7.41".
     * <p>
     * @deprecated MySQL 5.7.41 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_41;

    /**
     * (deprecated) Version "5.7.42".
     * <p>
     * @deprecated MySQL 5.7.42 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_42;

    /**
     * (deprecated) Version "5.7.43".
     * <p>
     * @deprecated MySQL 5.7.43 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_43;

    /**
     * Version "5.7.44".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44;

    /**
     * Version "5.7.44-rds.20240408".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44_RDS_20240408;

    /**
     * Version "5.7.44-rds.20240529".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44_RDS_20240529;

    /**
     * Version "5.7.44-rds.20240808".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44_RDS_20240808;

    /**
     * Version "5.7.44-rds.20250103".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44_RDS_20250103;

    /**
     * Version "5.7.44-rds.20250213".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44_RDS_20250213;

    /**
     * Version "5.7.44-rds.20250508".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_5_7_44_RDS_20250508;

    /**
     * Version "8.0" (only a major version, without a specific minor version).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0;

    /**
     * (deprecated) Version "8.0.11".
     * <p>
     * @deprecated MySQL 8.0.11 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_11;

    /**
     * (deprecated) Version "8.0.13".
     * <p>
     * @deprecated MySQL 8.0.13 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_13;

    /**
     * (deprecated) Version "8.0.15".
     * <p>
     * @deprecated MySQL 8.0.15 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_15;

    /**
     * (deprecated) Version "8.0.16".
     * <p>
     * @deprecated MySQL 8.0.16 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_16;

    /**
     * (deprecated) Version "8.0.17".
     * <p>
     * @deprecated MySQL 8.0.17 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_17;

    /**
     * (deprecated) Version "8.0.19".
     * <p>
     * @deprecated MySQL 8.0.19 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_19;

    /**
     * (deprecated) Version "8.0.20".
     * <p>
     * @deprecated MySQL 8.0.20 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_20;

    /**
     * (deprecated) Version "8.0.21".
     * <p>
     * @deprecated MySQL 8.0.21 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_21;

    /**
     * (deprecated) Version "8.0.23".
     * <p>
     * @deprecated MySQL 8.0.23 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_23;

    /**
     * (deprecated) Version "8.0.25".
     * <p>
     * @deprecated MySQL 8.0.25 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_25;

    /**
     * (deprecated) Version "8.0.26".
     * <p>
     * @deprecated MySQL 8.0.26 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_26;

    /**
     * (deprecated) Version "8.0.27".
     * <p>
     * @deprecated MySQL 8.0.27 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_27;

    /**
     * (deprecated) Version "8.0.28".
     * <p>
     * @deprecated MySQL 8.0.28 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_28;

    /**
     * (deprecated) Version "8.0.29".
     * <p>
     * @deprecated MySQL 8.0.29 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_29;

    /**
     * (deprecated) Version "8.0.30".
     * <p>
     * @deprecated MySQL 8.0.30 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_30;

    /**
     * (deprecated) Version "8.0.31".
     * <p>
     * @deprecated MySQL 8.0.31 is no longer supported by Amazon RDS.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_31;

    /**
     * Version "8.0.32".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_32;

    /**
     * Version "8.0.33".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_33;

    /**
     * Version "8.0.34".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_34;

    /**
     * Version "8.0.35".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_35;

    /**
     * Version "8.0.36".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_36;

    /**
     * Version "8.0.37".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_37;

    /**
     * Version "8.0.39".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_39;

    /**
     * Version "8.0.40".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_40;

    /**
     * Version "8.0.41".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_41;

    /**
     * Version "8.0.42".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_0_42;

    /**
     * Version "8.4.3".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_4_3;

    /**
     * Version "8.4.4".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_4_4;

    /**
     * Version "8.4.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.rds.MysqlEngineVersion VER_8_4_5;

    /**
     * The full version string, for example, "10.5.28".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMysqlFullVersion() {
        return software.amazon.jsii.Kernel.get(this, "mysqlFullVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The major version of the engine, for example, "10.5".
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getMysqlMajorVersion() {
        return software.amazon.jsii.Kernel.get(this, "mysqlMajorVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }
}
