package software.amazon.awscdk.services.redshiftserverless;

/**
 * The collection of compute resources in Amazon Redshift Serverless.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.redshiftserverless.*;
 * CfnWorkgroup cfnWorkgroup = CfnWorkgroup.Builder.create(this, "MyCfnWorkgroup")
 *         .workgroupName("workgroupName")
 *         // the properties below are optional
 *         .baseCapacity(123)
 *         .configParameters(List.of(ConfigParameterProperty.builder()
 *                 .parameterKey("parameterKey")
 *                 .parameterValue("parameterValue")
 *                 .build()))
 *         .enhancedVpcRouting(false)
 *         .maxCapacity(123)
 *         .namespaceName("namespaceName")
 *         .port(123)
 *         .pricePerformanceTarget(PerformanceTargetProperty.builder()
 *                 .level(123)
 *                 .status("status")
 *                 .build())
 *         .publiclyAccessible(false)
 *         .recoveryPointId("recoveryPointId")
 *         .securityGroupIds(List.of("securityGroupIds"))
 *         .snapshotArn("snapshotArn")
 *         .snapshotName("snapshotName")
 *         .snapshotOwnerAccount("snapshotOwnerAccount")
 *         .subnetIds(List.of("subnetIds"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trackName("trackName")
 *         .workgroup(WorkgroupProperty.builder()
 *                 .baseCapacity(123)
 *                 .configParameters(List.of(ConfigParameterProperty.builder()
 *                         .parameterKey("parameterKey")
 *                         .parameterValue("parameterValue")
 *                         .build()))
 *                 .creationDate("creationDate")
 *                 .endpoint(EndpointProperty.builder()
 *                         .address("address")
 *                         .port(123)
 *                         .vpcEndpoints(List.of(VpcEndpointProperty.builder()
 *                                 .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
 *                                         .availabilityZone("availabilityZone")
 *                                         .networkInterfaceId("networkInterfaceId")
 *                                         .privateIpAddress("privateIpAddress")
 *                                         .subnetId("subnetId")
 *                                         .build()))
 *                                 .vpcEndpointId("vpcEndpointId")
 *                                 .vpcId("vpcId")
 *                                 .build()))
 *                         .build())
 *                 .enhancedVpcRouting(false)
 *                 .maxCapacity(123)
 *                 .namespaceName("namespaceName")
 *                 .pricePerformanceTarget(PerformanceTargetProperty.builder()
 *                         .level(123)
 *                         .status("status")
 *                         .build())
 *                 .publiclyAccessible(false)
 *                 .securityGroupIds(List.of("securityGroupIds"))
 *                 .status("status")
 *                 .subnetIds(List.of("subnetIds"))
 *                 .trackName("trackName")
 *                 .workgroupArn("workgroupArn")
 *                 .workgroupId("workgroupId")
 *                 .workgroupName("workgroupName")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:24.248Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup")
public class CfnWorkgroup extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnWorkgroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnWorkgroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnWorkgroup(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrWorkgroup() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrWorkgroupBaseCapacity() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupBaseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrWorkgroupConfigParameters() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupConfigParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The creation date of the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupCreationDate() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupCreationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrWorkgroupEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The DNS address of the VPC endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupEndpointAddress() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupEndpointAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The custom port to use when connecting to a workgroup.
     * <p>
     * Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrWorkgroupEndpointPort() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupEndpointPort", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrWorkgroupEndpointVpcEndpoints() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupEndpointVpcEndpoints", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrWorkgroupEnhancedVpcRouting() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupEnhancedVpcRouting", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
     * <p>
     * The max capacity is specified in RPUs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getAttrWorkgroupMaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupMaxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The namespace the workgroup is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupNamespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A value that specifies whether the workgroup can be accessible from a public network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrWorkgroupPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupPubliclyAccessible", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * An array of security group IDs to associate with the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrWorkgroupSecurityGroupIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrWorkgroupSecurityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The status of the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An array of subnet IDs the workgroup is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getAttrWorkgroupSubnetIds() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "attrWorkgroupSubnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The name of the track for the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupTrackName() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupTrackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) that links to the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupWorkgroupArn() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupWorkgroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupWorkgroupId() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupWorkgroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrWorkgroupWorkgroupName() {
        return software.amazon.jsii.Kernel.get(this, "attrWorkgroupWorkgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * The name of the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getWorkgroupName() {
        return software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkgroupName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "workgroupName", java.util.Objects.requireNonNull(value, "workgroupName is required"));
    }

    /**
     * The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getBaseCapacity() {
        return software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBaseCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "baseCapacity", value);
    }

    /**
     * The key of the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getConfigParameters() {
        return software.amazon.jsii.Kernel.get(this, "configParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The key of the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "configParameters", value);
    }

    /**
     * The key of the parameter.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setConfigParameters(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.ConfigParameterProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.ConfigParameterProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "configParameters", value);
    }

    /**
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedVpcRouting() {
        return software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedVpcRouting(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enhancedVpcRouting", value);
    }

    /**
     * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnhancedVpcRouting(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enhancedVpcRouting", value);
    }

    /**
     * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
        return software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMaxCapacity(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "maxCapacity", value);
    }

    /**
     * The namespace the workgroup is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getNamespaceName() {
        return software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The namespace the workgroup is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNamespaceName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "namespaceName", value);
    }

    /**
     * The custom port to use when connecting to a workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
        return software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The custom port to use when connecting to a workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPort(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "port", value);
    }

    /**
     * An object that represents the price performance target settings for the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPricePerformanceTarget() {
        return software.amazon.jsii.Kernel.get(this, "pricePerformanceTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object that represents the price performance target settings for the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPricePerformanceTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "pricePerformanceTarget", value);
    }

    /**
     * An object that represents the price performance target settings for the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPricePerformanceTarget(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.PerformanceTargetProperty value) {
        software.amazon.jsii.Kernel.set(this, "pricePerformanceTarget", value);
    }

    /**
     * A value that specifies whether the workgroup can be accessible from a public network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
        return software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A value that specifies whether the workgroup can be accessible from a public network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * A value that specifies whether the workgroup can be accessible from a public network.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setPubliclyAccessible(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "publiclyAccessible", value);
    }

    /**
     * The recovery point id to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getRecoveryPointId() {
        return software.amazon.jsii.Kernel.get(this, "recoveryPointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The recovery point id to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRecoveryPointId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "recoveryPointId", value);
    }

    /**
     * A list of security group IDs to associate with the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of security group IDs to associate with the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSecurityGroupIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "securityGroupIds", value);
    }

    /**
     * The Amazon Resource Name (ARN) of the snapshot to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotArn() {
        return software.amazon.jsii.Kernel.get(this, "snapshotArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the snapshot to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotArn", value);
    }

    /**
     * The snapshot name to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotName() {
        return software.amazon.jsii.Kernel.get(this, "snapshotName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The snapshot name to restore from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotName", value);
    }

    /**
     * The Amazon Web Services account that owns the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnapshotOwnerAccount() {
        return software.amazon.jsii.Kernel.get(this, "snapshotOwnerAccount", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Web Services account that owns the snapshot.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnapshotOwnerAccount(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snapshotOwnerAccount", value);
    }

    /**
     * A list of subnet IDs the workgroup is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of subnet IDs the workgroup is associated with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubnetIds(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "subnetIds", value);
    }

    /**
     * The map of the key-value pairs used to tag the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The map of the key-value pairs used to tag the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * An optional parameter for the name of the track for the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTrackName() {
        return software.amazon.jsii.Kernel.get(this, "trackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An optional parameter for the name of the track for the workgroup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrackName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trackName", value);
    }

    /**
     * The collection of computing resources from which an endpoint is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getWorkgroup() {
        return software.amazon.jsii.Kernel.get(this, "workgroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The collection of computing resources from which an endpoint is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkgroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "workgroup", value);
    }

    /**
     * The collection of computing resources from which an endpoint is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setWorkgroup(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.WorkgroupProperty value) {
        software.amazon.jsii.Kernel.set(this, "workgroup", value);
    }
    /**
     * A array of parameters to set for more control over a serverless database.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * ConfigParameterProperty configParameterProperty = ConfigParameterProperty.builder()
     *         .parameterKey("parameterKey")
     *         .parameterValue("parameterValue")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-configparameter.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-configparameter.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.ConfigParameterProperty")
    @software.amazon.jsii.Jsii.Proxy(ConfigParameterProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConfigParameterProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The key of the parameter.
         * <p>
         * The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-configparameter.html#cfn-redshiftserverless-workgroup-configparameter-parameterkey">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-configparameter.html#cfn-redshiftserverless-workgroup-configparameter-parameterkey</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterKey() {
            return null;
        }

        /**
         * The value of the parameter to set.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-configparameter.html#cfn-redshiftserverless-workgroup-configparameter-parametervalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-configparameter.html#cfn-redshiftserverless-workgroup-configparameter-parametervalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getParameterValue() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ConfigParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConfigParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConfigParameterProperty> {
            java.lang.String parameterKey;
            java.lang.String parameterValue;

            /**
             * Sets the value of {@link ConfigParameterProperty#getParameterKey}
             * @param parameterKey The key of the parameter.
             *                     The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterKey(java.lang.String parameterKey) {
                this.parameterKey = parameterKey;
                return this;
            }

            /**
             * Sets the value of {@link ConfigParameterProperty#getParameterValue}
             * @param parameterValue The value of the parameter to set.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder parameterValue(java.lang.String parameterValue) {
                this.parameterValue = parameterValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConfigParameterProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConfigParameterProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConfigParameterProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConfigParameterProperty {
            private final java.lang.String parameterKey;
            private final java.lang.String parameterValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.parameterKey = software.amazon.jsii.Kernel.get(this, "parameterKey", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.parameterValue = software.amazon.jsii.Kernel.get(this, "parameterValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.parameterKey = builder.parameterKey;
                this.parameterValue = builder.parameterValue;
            }

            @Override
            public final java.lang.String getParameterKey() {
                return this.parameterKey;
            }

            @Override
            public final java.lang.String getParameterValue() {
                return this.parameterValue;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getParameterKey() != null) {
                    data.set("parameterKey", om.valueToTree(this.getParameterKey()));
                }
                if (this.getParameterValue() != null) {
                    data.set("parameterValue", om.valueToTree(this.getParameterValue()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.ConfigParameterProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConfigParameterProperty.Jsii$Proxy that = (ConfigParameterProperty.Jsii$Proxy) o;

                if (this.parameterKey != null ? !this.parameterKey.equals(that.parameterKey) : that.parameterKey != null) return false;
                return this.parameterValue != null ? this.parameterValue.equals(that.parameterValue) : that.parameterValue == null;
            }

            @Override
            public final int hashCode() {
                int result = this.parameterKey != null ? this.parameterKey.hashCode() : 0;
                result = 31 * result + (this.parameterValue != null ? this.parameterValue.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The VPC endpoint object.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * EndpointProperty endpointProperty = EndpointProperty.builder()
     *         .address("address")
     *         .port(123)
     *         .vpcEndpoints(List.of(VpcEndpointProperty.builder()
     *                 .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
     *                         .availabilityZone("availabilityZone")
     *                         .networkInterfaceId("networkInterfaceId")
     *                         .privateIpAddress("privateIpAddress")
     *                         .subnetId("subnetId")
     *                         .build()))
     *                 .vpcEndpointId("vpcEndpointId")
     *                 .vpcId("vpcId")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.EndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(EndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The DNS address of the VPC endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html#cfn-redshiftserverless-workgroup-endpoint-address">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html#cfn-redshiftserverless-workgroup-endpoint-address</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAddress() {
            return null;
        }

        /**
         * The port that Amazon Redshift Serverless listens on.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html#cfn-redshiftserverless-workgroup-endpoint-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html#cfn-redshiftserverless-workgroup-endpoint-port</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getPort() {
            return null;
        }

        /**
         * An array of <code>VpcEndpoint</code> objects.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html#cfn-redshiftserverless-workgroup-endpoint-vpcendpoints">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-endpoint.html#cfn-redshiftserverless-workgroup-endpoint-vpcendpoints</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getVpcEndpoints() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EndpointProperty> {
            java.lang.String address;
            java.lang.Number port;
            java.lang.Object vpcEndpoints;

            /**
             * Sets the value of {@link EndpointProperty#getAddress}
             * @param address The DNS address of the VPC endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder address(java.lang.String address) {
                this.address = address;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getPort}
             * @param port The port that Amazon Redshift Serverless listens on.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder port(java.lang.Number port) {
                this.port = port;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getVpcEndpoints}
             * @param vpcEndpoints An array of <code>VpcEndpoint</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpoints(software.amazon.awscdk.IResolvable vpcEndpoints) {
                this.vpcEndpoints = vpcEndpoints;
                return this;
            }

            /**
             * Sets the value of {@link EndpointProperty#getVpcEndpoints}
             * @param vpcEndpoints An array of <code>VpcEndpoint</code> objects.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpoints(java.util.List<? extends java.lang.Object> vpcEndpoints) {
                this.vpcEndpoints = vpcEndpoints;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointProperty {
            private final java.lang.String address;
            private final java.lang.Number port;
            private final java.lang.Object vpcEndpoints;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.address = software.amazon.jsii.Kernel.get(this, "address", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.port = software.amazon.jsii.Kernel.get(this, "port", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.vpcEndpoints = software.amazon.jsii.Kernel.get(this, "vpcEndpoints", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.address = builder.address;
                this.port = builder.port;
                this.vpcEndpoints = builder.vpcEndpoints;
            }

            @Override
            public final java.lang.String getAddress() {
                return this.address;
            }

            @Override
            public final java.lang.Number getPort() {
                return this.port;
            }

            @Override
            public final java.lang.Object getVpcEndpoints() {
                return this.vpcEndpoints;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAddress() != null) {
                    data.set("address", om.valueToTree(this.getAddress()));
                }
                if (this.getPort() != null) {
                    data.set("port", om.valueToTree(this.getPort()));
                }
                if (this.getVpcEndpoints() != null) {
                    data.set("vpcEndpoints", om.valueToTree(this.getVpcEndpoints()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.EndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EndpointProperty.Jsii$Proxy that = (EndpointProperty.Jsii$Proxy) o;

                if (this.address != null ? !this.address.equals(that.address) : that.address != null) return false;
                if (this.port != null ? !this.port.equals(that.port) : that.port != null) return false;
                return this.vpcEndpoints != null ? this.vpcEndpoints.equals(that.vpcEndpoints) : that.vpcEndpoints == null;
            }

            @Override
            public final int hashCode() {
                int result = this.address != null ? this.address.hashCode() : 0;
                result = 31 * result + (this.port != null ? this.port.hashCode() : 0);
                result = 31 * result + (this.vpcEndpoints != null ? this.vpcEndpoints.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a network interface in an Amazon Redshift Serverless managed VPC endpoint.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * NetworkInterfaceProperty networkInterfaceProperty = NetworkInterfaceProperty.builder()
     *         .availabilityZone("availabilityZone")
     *         .networkInterfaceId("networkInterfaceId")
     *         .privateIpAddress("privateIpAddress")
     *         .subnetId("subnetId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.NetworkInterfaceProperty")
    @software.amazon.jsii.Jsii.Proxy(NetworkInterfaceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NetworkInterfaceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The availability Zone.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-availabilityzone">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-availabilityzone</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
            return null;
        }

        /**
         * The unique identifier of the network interface.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-networkinterfaceid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-networkinterfaceid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNetworkInterfaceId() {
            return null;
        }

        /**
         * The IPv4 address of the network interface within the subnet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-privateipaddress">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-privateipaddress</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
            return null;
        }

        /**
         * The unique identifier of the subnet.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-subnetid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-networkinterface.html#cfn-redshiftserverless-workgroup-networkinterface-subnetid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSubnetId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NetworkInterfaceProperty> {
            java.lang.String availabilityZone;
            java.lang.String networkInterfaceId;
            java.lang.String privateIpAddress;
            java.lang.String subnetId;

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getAvailabilityZone}
             * @param availabilityZone The availability Zone.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder availabilityZone(java.lang.String availabilityZone) {
                this.availabilityZone = availabilityZone;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getNetworkInterfaceId}
             * @param networkInterfaceId The unique identifier of the network interface.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaceId(java.lang.String networkInterfaceId) {
                this.networkInterfaceId = networkInterfaceId;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getPrivateIpAddress}
             * @param privateIpAddress The IPv4 address of the network interface within the subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder privateIpAddress(java.lang.String privateIpAddress) {
                this.privateIpAddress = privateIpAddress;
                return this;
            }

            /**
             * Sets the value of {@link NetworkInterfaceProperty#getSubnetId}
             * @param subnetId The unique identifier of the subnet.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetId(java.lang.String subnetId) {
                this.subnetId = subnetId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NetworkInterfaceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NetworkInterfaceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NetworkInterfaceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NetworkInterfaceProperty {
            private final java.lang.String availabilityZone;
            private final java.lang.String networkInterfaceId;
            private final java.lang.String privateIpAddress;
            private final java.lang.String subnetId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.networkInterfaceId = software.amazon.jsii.Kernel.get(this, "networkInterfaceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subnetId = software.amazon.jsii.Kernel.get(this, "subnetId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.availabilityZone = builder.availabilityZone;
                this.networkInterfaceId = builder.networkInterfaceId;
                this.privateIpAddress = builder.privateIpAddress;
                this.subnetId = builder.subnetId;
            }

            @Override
            public final java.lang.String getAvailabilityZone() {
                return this.availabilityZone;
            }

            @Override
            public final java.lang.String getNetworkInterfaceId() {
                return this.networkInterfaceId;
            }

            @Override
            public final java.lang.String getPrivateIpAddress() {
                return this.privateIpAddress;
            }

            @Override
            public final java.lang.String getSubnetId() {
                return this.subnetId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAvailabilityZone() != null) {
                    data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
                }
                if (this.getNetworkInterfaceId() != null) {
                    data.set("networkInterfaceId", om.valueToTree(this.getNetworkInterfaceId()));
                }
                if (this.getPrivateIpAddress() != null) {
                    data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
                }
                if (this.getSubnetId() != null) {
                    data.set("subnetId", om.valueToTree(this.getSubnetId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.NetworkInterfaceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NetworkInterfaceProperty.Jsii$Proxy that = (NetworkInterfaceProperty.Jsii$Proxy) o;

                if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
                if (this.networkInterfaceId != null ? !this.networkInterfaceId.equals(that.networkInterfaceId) : that.networkInterfaceId != null) return false;
                if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
                return this.subnetId != null ? this.subnetId.equals(that.subnetId) : that.subnetId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.availabilityZone != null ? this.availabilityZone.hashCode() : 0;
                result = 31 * result + (this.networkInterfaceId != null ? this.networkInterfaceId.hashCode() : 0);
                result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
                result = 31 * result + (this.subnetId != null ? this.subnetId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object that represents the price performance target settings for the workgroup.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * PerformanceTargetProperty performanceTargetProperty = PerformanceTargetProperty.builder()
     *         .level(123)
     *         .status("status")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-performancetarget.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-performancetarget.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.PerformanceTargetProperty")
    @software.amazon.jsii.Jsii.Proxy(PerformanceTargetProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PerformanceTargetProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The target price performance level for the workgroup.
         * <p>
         * Valid values include 1, 25, 50, 75, and 100. These correspond to the price performance levels LOW_COST, ECONOMICAL, BALANCED, RESOURCEFUL, and HIGH_PERFORMANCE.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-performancetarget.html#cfn-redshiftserverless-workgroup-performancetarget-level">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-performancetarget.html#cfn-redshiftserverless-workgroup-performancetarget-level</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getLevel() {
            return null;
        }

        /**
         * Whether the price performance target is enabled for the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-performancetarget.html#cfn-redshiftserverless-workgroup-performancetarget-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-performancetarget.html#cfn-redshiftserverless-workgroup-performancetarget-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PerformanceTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PerformanceTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PerformanceTargetProperty> {
            java.lang.Number level;
            java.lang.String status;

            /**
             * Sets the value of {@link PerformanceTargetProperty#getLevel}
             * @param level The target price performance level for the workgroup.
             *              Valid values include 1, 25, 50, 75, and 100. These correspond to the price performance levels LOW_COST, ECONOMICAL, BALANCED, RESOURCEFUL, and HIGH_PERFORMANCE.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder level(java.lang.Number level) {
                this.level = level;
                return this;
            }

            /**
             * Sets the value of {@link PerformanceTargetProperty#getStatus}
             * @param status Whether the price performance target is enabled for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PerformanceTargetProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PerformanceTargetProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PerformanceTargetProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PerformanceTargetProperty {
            private final java.lang.Number level;
            private final java.lang.String status;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.level = builder.level;
                this.status = builder.status;
            }

            @Override
            public final java.lang.Number getLevel() {
                return this.level;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLevel() != null) {
                    data.set("level", om.valueToTree(this.getLevel()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.PerformanceTargetProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PerformanceTargetProperty.Jsii$Proxy that = (PerformanceTargetProperty.Jsii$Proxy) o;

                if (this.level != null ? !this.level.equals(that.level) : that.level != null) return false;
                return this.status != null ? this.status.equals(that.status) : that.status == null;
            }

            @Override
            public final int hashCode() {
                int result = this.level != null ? this.level.hashCode() : 0;
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The connection endpoint for connecting to Amazon Redshift Serverless through the proxy.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * VpcEndpointProperty vpcEndpointProperty = VpcEndpointProperty.builder()
     *         .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
     *                 .availabilityZone("availabilityZone")
     *                 .networkInterfaceId("networkInterfaceId")
     *                 .privateIpAddress("privateIpAddress")
     *                 .subnetId("subnetId")
     *                 .build()))
     *         .vpcEndpointId("vpcEndpointId")
     *         .vpcId("vpcId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.VpcEndpointProperty")
    @software.amazon.jsii.Jsii.Proxy(VpcEndpointProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface VpcEndpointProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * One or more network interfaces of the endpoint.
         * <p>
         * Also known as an interface endpoint.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html#cfn-redshiftserverless-workgroup-vpcendpoint-networkinterfaces">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html#cfn-redshiftserverless-workgroup-vpcendpoint-networkinterfaces</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNetworkInterfaces() {
            return null;
        }

        /**
         * The connection endpoint ID for connecting to Amazon Redshift Serverless.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html#cfn-redshiftserverless-workgroup-vpcendpoint-vpcendpointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html#cfn-redshiftserverless-workgroup-vpcendpoint-vpcendpointid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcEndpointId() {
            return null;
        }

        /**
         * The VPC identifier that the endpoint is associated with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html#cfn-redshiftserverless-workgroup-vpcendpoint-vpcid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-vpcendpoint.html#cfn-redshiftserverless-workgroup-vpcendpoint-vpcid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVpcId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link VpcEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link VpcEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<VpcEndpointProperty> {
            java.lang.Object networkInterfaces;
            java.lang.String vpcEndpointId;
            java.lang.String vpcId;

            /**
             * Sets the value of {@link VpcEndpointProperty#getNetworkInterfaces}
             * @param networkInterfaces One or more network interfaces of the endpoint.
             *                          Also known as an interface endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(software.amazon.awscdk.IResolvable networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link VpcEndpointProperty#getNetworkInterfaces}
             * @param networkInterfaces One or more network interfaces of the endpoint.
             *                          Also known as an interface endpoint.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder networkInterfaces(java.util.List<? extends java.lang.Object> networkInterfaces) {
                this.networkInterfaces = networkInterfaces;
                return this;
            }

            /**
             * Sets the value of {@link VpcEndpointProperty#getVpcEndpointId}
             * @param vpcEndpointId The connection endpoint ID for connecting to Amazon Redshift Serverless.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcEndpointId(java.lang.String vpcEndpointId) {
                this.vpcEndpointId = vpcEndpointId;
                return this;
            }

            /**
             * Sets the value of {@link VpcEndpointProperty#getVpcId}
             * @param vpcId The VPC identifier that the endpoint is associated with.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder vpcId(java.lang.String vpcId) {
                this.vpcId = vpcId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link VpcEndpointProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public VpcEndpointProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link VpcEndpointProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VpcEndpointProperty {
            private final java.lang.Object networkInterfaces;
            private final java.lang.String vpcEndpointId;
            private final java.lang.String vpcId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.networkInterfaces = software.amazon.jsii.Kernel.get(this, "networkInterfaces", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.vpcEndpointId = software.amazon.jsii.Kernel.get(this, "vpcEndpointId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.vpcId = software.amazon.jsii.Kernel.get(this, "vpcId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.networkInterfaces = builder.networkInterfaces;
                this.vpcEndpointId = builder.vpcEndpointId;
                this.vpcId = builder.vpcId;
            }

            @Override
            public final java.lang.Object getNetworkInterfaces() {
                return this.networkInterfaces;
            }

            @Override
            public final java.lang.String getVpcEndpointId() {
                return this.vpcEndpointId;
            }

            @Override
            public final java.lang.String getVpcId() {
                return this.vpcId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getNetworkInterfaces() != null) {
                    data.set("networkInterfaces", om.valueToTree(this.getNetworkInterfaces()));
                }
                if (this.getVpcEndpointId() != null) {
                    data.set("vpcEndpointId", om.valueToTree(this.getVpcEndpointId()));
                }
                if (this.getVpcId() != null) {
                    data.set("vpcId", om.valueToTree(this.getVpcId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.VpcEndpointProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                VpcEndpointProperty.Jsii$Proxy that = (VpcEndpointProperty.Jsii$Proxy) o;

                if (this.networkInterfaces != null ? !this.networkInterfaces.equals(that.networkInterfaces) : that.networkInterfaces != null) return false;
                if (this.vpcEndpointId != null ? !this.vpcEndpointId.equals(that.vpcEndpointId) : that.vpcEndpointId != null) return false;
                return this.vpcId != null ? this.vpcId.equals(that.vpcId) : that.vpcId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.networkInterfaces != null ? this.networkInterfaces.hashCode() : 0;
                result = 31 * result + (this.vpcEndpointId != null ? this.vpcEndpointId.hashCode() : 0);
                result = 31 * result + (this.vpcId != null ? this.vpcId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The collection of computing resources from which an endpoint is created.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.redshiftserverless.*;
     * WorkgroupProperty workgroupProperty = WorkgroupProperty.builder()
     *         .baseCapacity(123)
     *         .configParameters(List.of(ConfigParameterProperty.builder()
     *                 .parameterKey("parameterKey")
     *                 .parameterValue("parameterValue")
     *                 .build()))
     *         .creationDate("creationDate")
     *         .endpoint(EndpointProperty.builder()
     *                 .address("address")
     *                 .port(123)
     *                 .vpcEndpoints(List.of(VpcEndpointProperty.builder()
     *                         .networkInterfaces(List.of(NetworkInterfaceProperty.builder()
     *                                 .availabilityZone("availabilityZone")
     *                                 .networkInterfaceId("networkInterfaceId")
     *                                 .privateIpAddress("privateIpAddress")
     *                                 .subnetId("subnetId")
     *                                 .build()))
     *                         .vpcEndpointId("vpcEndpointId")
     *                         .vpcId("vpcId")
     *                         .build()))
     *                 .build())
     *         .enhancedVpcRouting(false)
     *         .maxCapacity(123)
     *         .namespaceName("namespaceName")
     *         .pricePerformanceTarget(PerformanceTargetProperty.builder()
     *                 .level(123)
     *                 .status("status")
     *                 .build())
     *         .publiclyAccessible(false)
     *         .securityGroupIds(List.of("securityGroupIds"))
     *         .status("status")
     *         .subnetIds(List.of("subnetIds"))
     *         .trackName("trackName")
     *         .workgroupArn("workgroupArn")
     *         .workgroupId("workgroupId")
     *         .workgroupName("workgroupName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.WorkgroupProperty")
    @software.amazon.jsii.Jsii.Proxy(WorkgroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface WorkgroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-basecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-basecapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getBaseCapacity() {
            return null;
        }

        /**
         * An array of parameters to set for advanced control over a database.
         * <p>
         * The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-configparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-configparameters</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfigParameters() {
            return null;
        }

        /**
         * The creation date of the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-creationdate">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-creationdate</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCreationDate() {
            return null;
        }

        /**
         * The endpoint that is created from the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEndpoint() {
            return null;
        }

        /**
         * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-enhancedvpcrouting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-enhancedvpcrouting</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnhancedVpcRouting() {
            return null;
        }

        /**
         * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
         * <p>
         * The max capacity is specified in RPUs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-maxcapacity</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxCapacity() {
            return null;
        }

        /**
         * The namespace the workgroup is associated with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-namespacename</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getNamespaceName() {
            return null;
        }

        /**
         * An object that represents the price performance target settings for the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-priceperformancetarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-priceperformancetarget</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPricePerformanceTarget() {
            return null;
        }

        /**
         * A value that specifies whether the workgroup can be accessible from a public network.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-publiclyaccessible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPubliclyAccessible() {
            return null;
        }

        /**
         * An array of security group IDs to associate with the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-securitygroupids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSecurityGroupIds() {
            return null;
        }

        /**
         * The status of the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-status">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-status</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getStatus() {
            return null;
        }

        /**
         * An array of subnet IDs the workgroup is associated with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-subnetids</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getSubnetIds() {
            return null;
        }

        /**
         * The name of the track for the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-trackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-trackname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getTrackName() {
            return null;
        }

        /**
         * The Amazon Resource Name (ARN) that links to the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-workgrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-workgrouparn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkgroupArn() {
            return null;
        }

        /**
         * The unique identifier of the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-workgroupid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-workgroupid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkgroupId() {
            return null;
        }

        /**
         * The name of the workgroup.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-workgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-redshiftserverless-workgroup-workgroup.html#cfn-redshiftserverless-workgroup-workgroup-workgroupname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWorkgroupName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link WorkgroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link WorkgroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<WorkgroupProperty> {
            java.lang.Number baseCapacity;
            java.lang.Object configParameters;
            java.lang.String creationDate;
            java.lang.Object endpoint;
            java.lang.Object enhancedVpcRouting;
            java.lang.Number maxCapacity;
            java.lang.String namespaceName;
            java.lang.Object pricePerformanceTarget;
            java.lang.Object publiclyAccessible;
            java.util.List<java.lang.String> securityGroupIds;
            java.lang.String status;
            java.util.List<java.lang.String> subnetIds;
            java.lang.String trackName;
            java.lang.String workgroupArn;
            java.lang.String workgroupId;
            java.lang.String workgroupName;

            /**
             * Sets the value of {@link WorkgroupProperty#getBaseCapacity}
             * @param baseCapacity The base data warehouse capacity of the workgroup in Redshift Processing Units (RPUs).
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder baseCapacity(java.lang.Number baseCapacity) {
                this.baseCapacity = baseCapacity;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getConfigParameters}
             * @param configParameters An array of parameters to set for advanced control over a database.
             *                         The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configParameters(software.amazon.awscdk.IResolvable configParameters) {
                this.configParameters = configParameters;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getConfigParameters}
             * @param configParameters An array of parameters to set for advanced control over a database.
             *                         The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configParameters(java.util.List<? extends java.lang.Object> configParameters) {
                this.configParameters = configParameters;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getCreationDate}
             * @param creationDate The creation date of the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder creationDate(java.lang.String creationDate) {
                this.creationDate = creationDate;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getEndpoint}
             * @param endpoint The endpoint that is created from the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(software.amazon.awscdk.IResolvable endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getEndpoint}
             * @param endpoint The endpoint that is created from the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.EndpointProperty endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getEnhancedVpcRouting}
             * @param enhancedVpcRouting The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enhancedVpcRouting(java.lang.Boolean enhancedVpcRouting) {
                this.enhancedVpcRouting = enhancedVpcRouting;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getEnhancedVpcRouting}
             * @param enhancedVpcRouting The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enhancedVpcRouting(software.amazon.awscdk.IResolvable enhancedVpcRouting) {
                this.enhancedVpcRouting = enhancedVpcRouting;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getMaxCapacity}
             * @param maxCapacity The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
             *                    The max capacity is specified in RPUs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxCapacity(java.lang.Number maxCapacity) {
                this.maxCapacity = maxCapacity;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getNamespaceName}
             * @param namespaceName The namespace the workgroup is associated with.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder namespaceName(java.lang.String namespaceName) {
                this.namespaceName = namespaceName;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getPricePerformanceTarget}
             * @param pricePerformanceTarget An object that represents the price performance target settings for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pricePerformanceTarget(software.amazon.awscdk.IResolvable pricePerformanceTarget) {
                this.pricePerformanceTarget = pricePerformanceTarget;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getPricePerformanceTarget}
             * @param pricePerformanceTarget An object that represents the price performance target settings for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pricePerformanceTarget(software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.PerformanceTargetProperty pricePerformanceTarget) {
                this.pricePerformanceTarget = pricePerformanceTarget;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getPubliclyAccessible}
             * @param publiclyAccessible A value that specifies whether the workgroup can be accessible from a public network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publiclyAccessible(java.lang.Boolean publiclyAccessible) {
                this.publiclyAccessible = publiclyAccessible;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getPubliclyAccessible}
             * @param publiclyAccessible A value that specifies whether the workgroup can be accessible from a public network.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder publiclyAccessible(software.amazon.awscdk.IResolvable publiclyAccessible) {
                this.publiclyAccessible = publiclyAccessible;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getSecurityGroupIds}
             * @param securityGroupIds An array of security group IDs to associate with the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder securityGroupIds(java.util.List<java.lang.String> securityGroupIds) {
                this.securityGroupIds = securityGroupIds;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getStatus}
             * @param status The status of the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder status(java.lang.String status) {
                this.status = status;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getSubnetIds}
             * @param subnetIds An array of subnet IDs the workgroup is associated with.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder subnetIds(java.util.List<java.lang.String> subnetIds) {
                this.subnetIds = subnetIds;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getTrackName}
             * @param trackName The name of the track for the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trackName(java.lang.String trackName) {
                this.trackName = trackName;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getWorkgroupArn}
             * @param workgroupArn The Amazon Resource Name (ARN) that links to the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupArn(java.lang.String workgroupArn) {
                this.workgroupArn = workgroupArn;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getWorkgroupId}
             * @param workgroupId The unique identifier of the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupId(java.lang.String workgroupId) {
                this.workgroupId = workgroupId;
                return this;
            }

            /**
             * Sets the value of {@link WorkgroupProperty#getWorkgroupName}
             * @param workgroupName The name of the workgroup.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder workgroupName(java.lang.String workgroupName) {
                this.workgroupName = workgroupName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link WorkgroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public WorkgroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link WorkgroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WorkgroupProperty {
            private final java.lang.Number baseCapacity;
            private final java.lang.Object configParameters;
            private final java.lang.String creationDate;
            private final java.lang.Object endpoint;
            private final java.lang.Object enhancedVpcRouting;
            private final java.lang.Number maxCapacity;
            private final java.lang.String namespaceName;
            private final java.lang.Object pricePerformanceTarget;
            private final java.lang.Object publiclyAccessible;
            private final java.util.List<java.lang.String> securityGroupIds;
            private final java.lang.String status;
            private final java.util.List<java.lang.String> subnetIds;
            private final java.lang.String trackName;
            private final java.lang.String workgroupArn;
            private final java.lang.String workgroupId;
            private final java.lang.String workgroupName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.baseCapacity = software.amazon.jsii.Kernel.get(this, "baseCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.configParameters = software.amazon.jsii.Kernel.get(this, "configParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.creationDate = software.amazon.jsii.Kernel.get(this, "creationDate", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.enhancedVpcRouting = software.amazon.jsii.Kernel.get(this, "enhancedVpcRouting", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.maxCapacity = software.amazon.jsii.Kernel.get(this, "maxCapacity", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.namespaceName = software.amazon.jsii.Kernel.get(this, "namespaceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.pricePerformanceTarget = software.amazon.jsii.Kernel.get(this, "pricePerformanceTarget", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.publiclyAccessible = software.amazon.jsii.Kernel.get(this, "publiclyAccessible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.securityGroupIds = software.amazon.jsii.Kernel.get(this, "securityGroupIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.status = software.amazon.jsii.Kernel.get(this, "status", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.subnetIds = software.amazon.jsii.Kernel.get(this, "subnetIds", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.trackName = software.amazon.jsii.Kernel.get(this, "trackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workgroupArn = software.amazon.jsii.Kernel.get(this, "workgroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workgroupId = software.amazon.jsii.Kernel.get(this, "workgroupId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.workgroupName = software.amazon.jsii.Kernel.get(this, "workgroupName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.baseCapacity = builder.baseCapacity;
                this.configParameters = builder.configParameters;
                this.creationDate = builder.creationDate;
                this.endpoint = builder.endpoint;
                this.enhancedVpcRouting = builder.enhancedVpcRouting;
                this.maxCapacity = builder.maxCapacity;
                this.namespaceName = builder.namespaceName;
                this.pricePerformanceTarget = builder.pricePerformanceTarget;
                this.publiclyAccessible = builder.publiclyAccessible;
                this.securityGroupIds = builder.securityGroupIds;
                this.status = builder.status;
                this.subnetIds = builder.subnetIds;
                this.trackName = builder.trackName;
                this.workgroupArn = builder.workgroupArn;
                this.workgroupId = builder.workgroupId;
                this.workgroupName = builder.workgroupName;
            }

            @Override
            public final java.lang.Number getBaseCapacity() {
                return this.baseCapacity;
            }

            @Override
            public final java.lang.Object getConfigParameters() {
                return this.configParameters;
            }

            @Override
            public final java.lang.String getCreationDate() {
                return this.creationDate;
            }

            @Override
            public final java.lang.Object getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.Object getEnhancedVpcRouting() {
                return this.enhancedVpcRouting;
            }

            @Override
            public final java.lang.Number getMaxCapacity() {
                return this.maxCapacity;
            }

            @Override
            public final java.lang.String getNamespaceName() {
                return this.namespaceName;
            }

            @Override
            public final java.lang.Object getPricePerformanceTarget() {
                return this.pricePerformanceTarget;
            }

            @Override
            public final java.lang.Object getPubliclyAccessible() {
                return this.publiclyAccessible;
            }

            @Override
            public final java.util.List<java.lang.String> getSecurityGroupIds() {
                return this.securityGroupIds;
            }

            @Override
            public final java.lang.String getStatus() {
                return this.status;
            }

            @Override
            public final java.util.List<java.lang.String> getSubnetIds() {
                return this.subnetIds;
            }

            @Override
            public final java.lang.String getTrackName() {
                return this.trackName;
            }

            @Override
            public final java.lang.String getWorkgroupArn() {
                return this.workgroupArn;
            }

            @Override
            public final java.lang.String getWorkgroupId() {
                return this.workgroupId;
            }

            @Override
            public final java.lang.String getWorkgroupName() {
                return this.workgroupName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getBaseCapacity() != null) {
                    data.set("baseCapacity", om.valueToTree(this.getBaseCapacity()));
                }
                if (this.getConfigParameters() != null) {
                    data.set("configParameters", om.valueToTree(this.getConfigParameters()));
                }
                if (this.getCreationDate() != null) {
                    data.set("creationDate", om.valueToTree(this.getCreationDate()));
                }
                if (this.getEndpoint() != null) {
                    data.set("endpoint", om.valueToTree(this.getEndpoint()));
                }
                if (this.getEnhancedVpcRouting() != null) {
                    data.set("enhancedVpcRouting", om.valueToTree(this.getEnhancedVpcRouting()));
                }
                if (this.getMaxCapacity() != null) {
                    data.set("maxCapacity", om.valueToTree(this.getMaxCapacity()));
                }
                if (this.getNamespaceName() != null) {
                    data.set("namespaceName", om.valueToTree(this.getNamespaceName()));
                }
                if (this.getPricePerformanceTarget() != null) {
                    data.set("pricePerformanceTarget", om.valueToTree(this.getPricePerformanceTarget()));
                }
                if (this.getPubliclyAccessible() != null) {
                    data.set("publiclyAccessible", om.valueToTree(this.getPubliclyAccessible()));
                }
                if (this.getSecurityGroupIds() != null) {
                    data.set("securityGroupIds", om.valueToTree(this.getSecurityGroupIds()));
                }
                if (this.getStatus() != null) {
                    data.set("status", om.valueToTree(this.getStatus()));
                }
                if (this.getSubnetIds() != null) {
                    data.set("subnetIds", om.valueToTree(this.getSubnetIds()));
                }
                if (this.getTrackName() != null) {
                    data.set("trackName", om.valueToTree(this.getTrackName()));
                }
                if (this.getWorkgroupArn() != null) {
                    data.set("workgroupArn", om.valueToTree(this.getWorkgroupArn()));
                }
                if (this.getWorkgroupId() != null) {
                    data.set("workgroupId", om.valueToTree(this.getWorkgroupId()));
                }
                if (this.getWorkgroupName() != null) {
                    data.set("workgroupName", om.valueToTree(this.getWorkgroupName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_redshiftserverless.CfnWorkgroup.WorkgroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                WorkgroupProperty.Jsii$Proxy that = (WorkgroupProperty.Jsii$Proxy) o;

                if (this.baseCapacity != null ? !this.baseCapacity.equals(that.baseCapacity) : that.baseCapacity != null) return false;
                if (this.configParameters != null ? !this.configParameters.equals(that.configParameters) : that.configParameters != null) return false;
                if (this.creationDate != null ? !this.creationDate.equals(that.creationDate) : that.creationDate != null) return false;
                if (this.endpoint != null ? !this.endpoint.equals(that.endpoint) : that.endpoint != null) return false;
                if (this.enhancedVpcRouting != null ? !this.enhancedVpcRouting.equals(that.enhancedVpcRouting) : that.enhancedVpcRouting != null) return false;
                if (this.maxCapacity != null ? !this.maxCapacity.equals(that.maxCapacity) : that.maxCapacity != null) return false;
                if (this.namespaceName != null ? !this.namespaceName.equals(that.namespaceName) : that.namespaceName != null) return false;
                if (this.pricePerformanceTarget != null ? !this.pricePerformanceTarget.equals(that.pricePerformanceTarget) : that.pricePerformanceTarget != null) return false;
                if (this.publiclyAccessible != null ? !this.publiclyAccessible.equals(that.publiclyAccessible) : that.publiclyAccessible != null) return false;
                if (this.securityGroupIds != null ? !this.securityGroupIds.equals(that.securityGroupIds) : that.securityGroupIds != null) return false;
                if (this.status != null ? !this.status.equals(that.status) : that.status != null) return false;
                if (this.subnetIds != null ? !this.subnetIds.equals(that.subnetIds) : that.subnetIds != null) return false;
                if (this.trackName != null ? !this.trackName.equals(that.trackName) : that.trackName != null) return false;
                if (this.workgroupArn != null ? !this.workgroupArn.equals(that.workgroupArn) : that.workgroupArn != null) return false;
                if (this.workgroupId != null ? !this.workgroupId.equals(that.workgroupId) : that.workgroupId != null) return false;
                return this.workgroupName != null ? this.workgroupName.equals(that.workgroupName) : that.workgroupName == null;
            }

            @Override
            public final int hashCode() {
                int result = this.baseCapacity != null ? this.baseCapacity.hashCode() : 0;
                result = 31 * result + (this.configParameters != null ? this.configParameters.hashCode() : 0);
                result = 31 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
                result = 31 * result + (this.endpoint != null ? this.endpoint.hashCode() : 0);
                result = 31 * result + (this.enhancedVpcRouting != null ? this.enhancedVpcRouting.hashCode() : 0);
                result = 31 * result + (this.maxCapacity != null ? this.maxCapacity.hashCode() : 0);
                result = 31 * result + (this.namespaceName != null ? this.namespaceName.hashCode() : 0);
                result = 31 * result + (this.pricePerformanceTarget != null ? this.pricePerformanceTarget.hashCode() : 0);
                result = 31 * result + (this.publiclyAccessible != null ? this.publiclyAccessible.hashCode() : 0);
                result = 31 * result + (this.securityGroupIds != null ? this.securityGroupIds.hashCode() : 0);
                result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
                result = 31 * result + (this.subnetIds != null ? this.subnetIds.hashCode() : 0);
                result = 31 * result + (this.trackName != null ? this.trackName.hashCode() : 0);
                result = 31 * result + (this.workgroupArn != null ? this.workgroupArn.hashCode() : 0);
                result = 31 * result + (this.workgroupId != null ? this.workgroupId.hashCode() : 0);
                result = 31 * result + (this.workgroupName != null ? this.workgroupName.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.redshiftserverless.CfnWorkgroupProps.Builder();
        }

        /**
         * The name of the workgroup.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroupname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroupname</a>
         * @param workgroupName The name of the workgroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workgroupName(final java.lang.String workgroupName) {
            this.props.workgroupName(workgroupName);
            return this;
        }

        /**
         * The base compute capacity of the workgroup in Redshift Processing Units (RPUs).
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-basecapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-basecapacity</a>
         * @param baseCapacity The base compute capacity of the workgroup in Redshift Processing Units (RPUs). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseCapacity(final java.lang.Number baseCapacity) {
            this.props.baseCapacity(baseCapacity);
            return this;
        }

        /**
         * The key of the parameter.
         * <p>
         * The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-configparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-configparameters</a>
         * @param configParameters The key of the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configParameters(final software.amazon.awscdk.IResolvable configParameters) {
            this.props.configParameters(configParameters);
            return this;
        }
        /**
         * The key of the parameter.
         * <p>
         * The options are <code>auto_mv</code> , <code>datestyle</code> , <code>enable_case_sensitive_identifier</code> , <code>enable_user_activity_logging</code> , <code>query_group</code> , <code>search_path</code> , <code>require_ssl</code> , <code>use_fips_ssl</code> , and query monitoring metrics that let you define performance boundaries. For more information about query monitoring rules and available metrics, see <a href="https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless">Query monitoring metrics for Amazon Redshift Serverless</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-configparameters">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-configparameters</a>
         * @param configParameters The key of the parameter. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configParameters(final java.util.List<? extends java.lang.Object> configParameters) {
            this.props.configParameters(configParameters);
            return this;
        }

        /**
         * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-enhancedvpcrouting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-enhancedvpcrouting</a>
         * @param enhancedVpcRouting The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(final java.lang.Boolean enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }
        /**
         * The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-enhancedvpcrouting">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-enhancedvpcrouting</a>
         * @param enhancedVpcRouting The value that specifies whether to enable enhanced virtual private cloud (VPC) routing, which forces Amazon Redshift Serverless to route traffic through your VPC. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enhancedVpcRouting(final software.amazon.awscdk.IResolvable enhancedVpcRouting) {
            this.props.enhancedVpcRouting(enhancedVpcRouting);
            return this;
        }

        /**
         * The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries.
         * <p>
         * The max capacity is specified in RPUs.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-maxcapacity">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-maxcapacity</a>
         * @param maxCapacity The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve queries. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxCapacity(final java.lang.Number maxCapacity) {
            this.props.maxCapacity(maxCapacity);
            return this;
        }

        /**
         * The namespace the workgroup is associated with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-namespacename">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-namespacename</a>
         * @param namespaceName The namespace the workgroup is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespaceName(final java.lang.String namespaceName) {
            this.props.namespaceName(namespaceName);
            return this;
        }

        /**
         * The custom port to use when connecting to a workgroup.
         * <p>
         * Valid port ranges are 5431-5455 and 8191-8215. The default is 5439.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-port">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-port</a>
         * @param port The custom port to use when connecting to a workgroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder port(final java.lang.Number port) {
            this.props.port(port);
            return this;
        }

        /**
         * An object that represents the price performance target settings for the workgroup.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-priceperformancetarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-priceperformancetarget</a>
         * @param pricePerformanceTarget An object that represents the price performance target settings for the workgroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricePerformanceTarget(final software.amazon.awscdk.IResolvable pricePerformanceTarget) {
            this.props.pricePerformanceTarget(pricePerformanceTarget);
            return this;
        }
        /**
         * An object that represents the price performance target settings for the workgroup.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-priceperformancetarget">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-priceperformancetarget</a>
         * @param pricePerformanceTarget An object that represents the price performance target settings for the workgroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pricePerformanceTarget(final software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.PerformanceTargetProperty pricePerformanceTarget) {
            this.props.pricePerformanceTarget(pricePerformanceTarget);
            return this;
        }

        /**
         * A value that specifies whether the workgroup can be accessible from a public network.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-publiclyaccessible</a>
         * @param publiclyAccessible A value that specifies whether the workgroup can be accessible from a public network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final java.lang.Boolean publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }
        /**
         * A value that specifies whether the workgroup can be accessible from a public network.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-publiclyaccessible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-publiclyaccessible</a>
         * @param publiclyAccessible A value that specifies whether the workgroup can be accessible from a public network. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder publiclyAccessible(final software.amazon.awscdk.IResolvable publiclyAccessible) {
            this.props.publiclyAccessible(publiclyAccessible);
            return this;
        }

        /**
         * The recovery point id to restore from.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-recoverypointid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-recoverypointid</a>
         * @param recoveryPointId The recovery point id to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder recoveryPointId(final java.lang.String recoveryPointId) {
            this.props.recoveryPointId(recoveryPointId);
            return this;
        }

        /**
         * A list of security group IDs to associate with the workgroup.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-securitygroupids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-securitygroupids</a>
         * @param securityGroupIds A list of security group IDs to associate with the workgroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroupIds(final java.util.List<java.lang.String> securityGroupIds) {
            this.props.securityGroupIds(securityGroupIds);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the snapshot to restore from.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotarn</a>
         * @param snapshotArn The Amazon Resource Name (ARN) of the snapshot to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotArn(final java.lang.String snapshotArn) {
            this.props.snapshotArn(snapshotArn);
            return this;
        }

        /**
         * The snapshot name to restore from.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotname</a>
         * @param snapshotName The snapshot name to restore from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotName(final java.lang.String snapshotName) {
            this.props.snapshotName(snapshotName);
            return this;
        }

        /**
         * The Amazon Web Services account that owns the snapshot.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotowneraccount">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-snapshotowneraccount</a>
         * @param snapshotOwnerAccount The Amazon Web Services account that owns the snapshot. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snapshotOwnerAccount(final java.lang.String snapshotOwnerAccount) {
            this.props.snapshotOwnerAccount(snapshotOwnerAccount);
            return this;
        }

        /**
         * A list of subnet IDs the workgroup is associated with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-subnetids">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-subnetids</a>
         * @param subnetIds A list of subnet IDs the workgroup is associated with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subnetIds(final java.util.List<java.lang.String> subnetIds) {
            this.props.subnetIds(subnetIds);
            return this;
        }

        /**
         * The map of the key-value pairs used to tag the workgroup.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-tags</a>
         * @param tags The map of the key-value pairs used to tag the workgroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * An optional parameter for the name of the track for the workgroup.
         * <p>
         * If you don't provide a track name, the workgroup is assigned to the current track.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-trackname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-trackname</a>
         * @param trackName An optional parameter for the name of the track for the workgroup. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trackName(final java.lang.String trackName) {
            this.props.trackName(trackName);
            return this;
        }

        /**
         * The collection of computing resources from which an endpoint is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroup</a>
         * @param workgroup The collection of computing resources from which an endpoint is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workgroup(final software.amazon.awscdk.IResolvable workgroup) {
            this.props.workgroup(workgroup);
            return this;
        }
        /**
         * The collection of computing resources from which an endpoint is created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroup">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-redshiftserverless-workgroup.html#cfn-redshiftserverless-workgroup-workgroup</a>
         * @param workgroup The collection of computing resources from which an endpoint is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder workgroup(final software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup.WorkgroupProperty workgroup) {
            this.props.workgroup(workgroup);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup build() {
            return new software.amazon.awscdk.services.redshiftserverless.CfnWorkgroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
