package software.amazon.awscdk.services.s3;

/**
 * The properties for the destination bucket for granting replication permission.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IBucket destinationBucket1;
 * IBucket destinationBucket2;
 * IRole replicationRole;
 * IKey encryptionKey;
 * IKey destinationEncryptionKey;
 * Bucket sourceBucket = Bucket.Builder.create(this, "SourceBucket")
 *         // Versioning must be enabled on both the source and destination bucket
 *         .versioned(true)
 *         // Optional. Specify the KMS key to use for encrypts objects in the source bucket.
 *         .encryptionKey(encryptionKey)
 *         // Optional. If not specified, a new role will be created.
 *         .replicationRole(replicationRole)
 *         .replicationRules(List.of(ReplicationRule.builder()
 *                 // The destination bucket for the replication rule.
 *                 .destination(destinationBucket1)
 *                 // The priority of the rule.
 *                 // Amazon S3 will attempt to replicate objects according to all replication rules.
 *                 // However, if there are two or more rules with the same destination bucket, then objects will be replicated according to the rule with the highest priority.
 *                 // The higher the number, the higher the priority.
 *                 // It is essential to specify priority explicitly when the replication configuration has multiple rules.
 *                 .priority(1)
 *                 .build(), ReplicationRule.builder()
 *                 .destination(destinationBucket2)
 *                 .priority(2)
 *                 // Whether to specify S3 Replication Time Control (S3 RTC).
 *                 // S3 RTC replicates most objects that you upload to Amazon S3 in seconds,
 *                 // and 99.99 percent of those objects within specified time.
 *                 .replicationTimeControl(ReplicationTimeValue.FIFTEEN_MINUTES)
 *                 // Whether to enable replication metrics about S3 RTC.
 *                 // If set, metrics will be output to indicate whether replication by S3 RTC took longer than the configured time.
 *                 .metrics(ReplicationTimeValue.FIFTEEN_MINUTES)
 *                 // The kms key to use for the destination bucket.
 *                 .kmsKey(destinationEncryptionKey)
 *                 // The storage class to use for the destination bucket.
 *                 .storageClass(StorageClass.INFREQUENT_ACCESS)
 *                 // Whether to replicate objects with SSE-KMS encryption.
 *                 .sseKmsEncryptedObjects(false)
 *                 // Whether to replicate modifications on replicas.
 *                 .replicaModifications(true)
 *                 // Whether to replicate delete markers.
 *                 // This property cannot be enabled if the replication rule has a tag filter.
 *                 .deleteMarkerReplication(false)
 *                 // The ID of the rule.
 *                 .id("full-settings-rule")
 *                 // The object filter for the rule.
 *                 .filter(Filter.builder()
 *                         // The prefix filter for the rule.
 *                         .prefix("prefix")
 *                         // The tag filter for the rule.
 *                         .tags(List.of(Tag.builder()
 *                                 .key("tagKey")
 *                                 .value("tagValue")
 *                                 .build()))
 *                         .build())
 *                 .build()))
 *         .build();
 * // Grant permissions to the replication role.
 * // This method is not required if you choose to use an auto-generated replication role or manually grant permissions.
 * sourceBucket.grantReplicationPermission(replicationRole, GrantReplicationPermissionProps.builder()
 *         // Optional. Specify the KMS key to use for decrypting objects in the source bucket.
 *         .sourceDecryptionKey(encryptionKey)
 *         .destinations(List.of(GrantReplicationPermissionDestinationProps.builder().bucket(destinationBucket1).build(), GrantReplicationPermissionDestinationProps.builder().bucket(destinationBucket2).encryptionKey(destinationEncryptionKey).build()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:24.734Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_s3.GrantReplicationPermissionProps")
@software.amazon.jsii.Jsii.Proxy(GrantReplicationPermissionProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface GrantReplicationPermissionProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The destination buckets for replication.
     * <p>
     * Specify the KMS key to use for encryption if a destination bucket needs to be encrypted with a customer-managed KMS key.
     * One or more destination buckets are required if replication configuration is enabled (i.e., <code>replicationRole</code> is specified).
     * <p>
     * Default: - empty array (valid only if the `replicationRole` property is NOT specified)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps> getDestinations();

    /**
     * The KMS key used to decrypt objects in the source bucket for replication.
     * <p>
     * <strong>Required if</strong> the source bucket is encrypted with a customer-managed KMS key.
     * <p>
     * Default: - it's assumed the source bucket is not encrypted with a customer-managed KMS key.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getSourceDecryptionKey() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link GrantReplicationPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link GrantReplicationPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<GrantReplicationPermissionProps> {
        java.util.List<software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps> destinations;
        software.amazon.awscdk.services.kms.IKey sourceDecryptionKey;

        /**
         * Sets the value of {@link GrantReplicationPermissionProps#getDestinations}
         * @param destinations The destination buckets for replication. This parameter is required.
         *                     Specify the KMS key to use for encryption if a destination bucket needs to be encrypted with a customer-managed KMS key.
         *                     One or more destination buckets are required if replication configuration is enabled (i.e., <code>replicationRole</code> is specified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder destinations(java.util.List<? extends software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps> destinations) {
            this.destinations = (java.util.List<software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps>)destinations;
            return this;
        }

        /**
         * Sets the value of {@link GrantReplicationPermissionProps#getSourceDecryptionKey}
         * @param sourceDecryptionKey The KMS key used to decrypt objects in the source bucket for replication.
         *                            <strong>Required if</strong> the source bucket is encrypted with a customer-managed KMS key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDecryptionKey(software.amazon.awscdk.services.kms.IKey sourceDecryptionKey) {
            this.sourceDecryptionKey = sourceDecryptionKey;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link GrantReplicationPermissionProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public GrantReplicationPermissionProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link GrantReplicationPermissionProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GrantReplicationPermissionProps {
        private final java.util.List<software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps> destinations;
        private final software.amazon.awscdk.services.kms.IKey sourceDecryptionKey;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps.class)));
            this.sourceDecryptionKey = software.amazon.jsii.Kernel.get(this, "sourceDecryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.destinations = (java.util.List<software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps>)java.util.Objects.requireNonNull(builder.destinations, "destinations is required");
            this.sourceDecryptionKey = builder.sourceDecryptionKey;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.s3.GrantReplicationPermissionDestinationProps> getDestinations() {
            return this.destinations;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getSourceDecryptionKey() {
            return this.sourceDecryptionKey;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("destinations", om.valueToTree(this.getDestinations()));
            if (this.getSourceDecryptionKey() != null) {
                data.set("sourceDecryptionKey", om.valueToTree(this.getSourceDecryptionKey()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_s3.GrantReplicationPermissionProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            GrantReplicationPermissionProps.Jsii$Proxy that = (GrantReplicationPermissionProps.Jsii$Proxy) o;

            if (!destinations.equals(that.destinations)) return false;
            return this.sourceDecryptionKey != null ? this.sourceDecryptionKey.equals(that.sourceDecryptionKey) : that.sourceDecryptionKey == null;
        }

        @Override
        public final int hashCode() {
            int result = this.destinations.hashCode();
            result = 31 * result + (this.sourceDecryptionKey != null ? this.sourceDecryptionKey.hashCode() : 0);
            return result;
        }
    }
}
