package software.amazon.awscdk.services.sagemaker;

/**
 * Properties for defining a <code>CfnInferenceComponent</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sagemaker.*;
 * CfnInferenceComponentProps cfnInferenceComponentProps = CfnInferenceComponentProps.builder()
 *         .endpointName("endpointName")
 *         .specification(InferenceComponentSpecificationProperty.builder()
 *                 .baseInferenceComponentName("baseInferenceComponentName")
 *                 .computeResourceRequirements(InferenceComponentComputeResourceRequirementsProperty.builder()
 *                         .maxMemoryRequiredInMb(123)
 *                         .minMemoryRequiredInMb(123)
 *                         .numberOfAcceleratorDevicesRequired(123)
 *                         .numberOfCpuCoresRequired(123)
 *                         .build())
 *                 .container(InferenceComponentContainerSpecificationProperty.builder()
 *                         .artifactUrl("artifactUrl")
 *                         .deployedImage(DeployedImageProperty.builder()
 *                                 .resolutionTime("resolutionTime")
 *                                 .resolvedImage("resolvedImage")
 *                                 .specifiedImage("specifiedImage")
 *                                 .build())
 *                         .environment(Map.of(
 *                                 "environmentKey", "environment"))
 *                         .image("image")
 *                         .build())
 *                 .modelName("modelName")
 *                 .startupParameters(InferenceComponentStartupParametersProperty.builder()
 *                         .containerStartupHealthCheckTimeoutInSeconds(123)
 *                         .modelDataDownloadTimeoutInSeconds(123)
 *                         .build())
 *                 .build())
 *         // the properties below are optional
 *         .deploymentConfig(InferenceComponentDeploymentConfigProperty.builder()
 *                 .autoRollbackConfiguration(AutoRollbackConfigurationProperty.builder()
 *                         .alarms(List.of(AlarmProperty.builder()
 *                                 .alarmName("alarmName")
 *                                 .build()))
 *                         .build())
 *                 .rollingUpdatePolicy(InferenceComponentRollingUpdatePolicyProperty.builder()
 *                         .maximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
 *                                 .type("type")
 *                                 .value(123)
 *                                 .build())
 *                         .maximumExecutionTimeoutInSeconds(123)
 *                         .rollbackMaximumBatchSize(InferenceComponentCapacitySizeProperty.builder()
 *                                 .type("type")
 *                                 .value(123)
 *                                 .build())
 *                         .waitIntervalInSeconds(123)
 *                         .build())
 *                 .build())
 *         .endpointArn("endpointArn")
 *         .inferenceComponentName("inferenceComponentName")
 *         .runtimeConfig(InferenceComponentRuntimeConfigProperty.builder()
 *                 .copyCount(123)
 *                 .currentCopyCount(123)
 *                 .desiredCopyCount(123)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .variantName("variantName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:24.982Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sagemaker.CfnInferenceComponentProps")
@software.amazon.jsii.Jsii.Proxy(CfnInferenceComponentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnInferenceComponentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the endpoint that hosts the inference component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEndpointName();

    /**
     * The specification for the inference component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-specification">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-specification</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSpecification();

    /**
     * The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-deploymentconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-deploymentconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDeploymentConfig() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-endpointarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEndpointArn() {
        return null;
    }

    /**
     * The name of the inference component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-inferencecomponentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-inferencecomponentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInferenceComponentName() {
        return null;
    }

    /**
     * The runtime config for the inference component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-runtimeconfig">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-runtimeconfig</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getRuntimeConfig() {
        return null;
    }

    /**
     * An array of tags to apply to the resource.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * The name of the production variant that hosts the inference component.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-variantname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-sagemaker-inferencecomponent.html#cfn-sagemaker-inferencecomponent-variantname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVariantName() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnInferenceComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnInferenceComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnInferenceComponentProps> {
        java.lang.String endpointName;
        java.lang.Object specification;
        java.lang.Object deploymentConfig;
        java.lang.String endpointArn;
        java.lang.String inferenceComponentName;
        java.lang.Object runtimeConfig;
        java.util.List<software.amazon.awscdk.CfnTag> tags;
        java.lang.String variantName;

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getEndpointName}
         * @param endpointName The name of the endpoint that hosts the inference component. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointName(java.lang.String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getSpecification}
         * @param specification The specification for the inference component. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder specification(software.amazon.awscdk.IResolvable specification) {
            this.specification = specification;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getSpecification}
         * @param specification The specification for the inference component. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder specification(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentSpecificationProperty specification) {
            this.specification = specification;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getDeploymentConfig}
         * @param deploymentConfig The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.IResolvable deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getDeploymentConfig}
         * @param deploymentConfig The deployment configuration for an endpoint, which contains the desired deployment strategy and rollback configurations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentConfig(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentDeploymentConfigProperty deploymentConfig) {
            this.deploymentConfig = deploymentConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getEndpointArn}
         * @param endpointArn The Amazon Resource Name (ARN) of the endpoint that hosts the inference component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointArn(java.lang.String endpointArn) {
            this.endpointArn = endpointArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getInferenceComponentName}
         * @param inferenceComponentName The name of the inference component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inferenceComponentName(java.lang.String inferenceComponentName) {
            this.inferenceComponentName = inferenceComponentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getRuntimeConfig}
         * @param runtimeConfig The runtime config for the inference component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfig(software.amazon.awscdk.IResolvable runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getRuntimeConfig}
         * @param runtimeConfig The runtime config for the inference component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimeConfig(software.amazon.awscdk.services.sagemaker.CfnInferenceComponent.InferenceComponentRuntimeConfigProperty runtimeConfig) {
            this.runtimeConfig = runtimeConfig;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getTags}
         * @param tags An array of tags to apply to the resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnInferenceComponentProps#getVariantName}
         * @param variantName The name of the production variant that hosts the inference component.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variantName(java.lang.String variantName) {
            this.variantName = variantName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnInferenceComponentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnInferenceComponentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnInferenceComponentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnInferenceComponentProps {
        private final java.lang.String endpointName;
        private final java.lang.Object specification;
        private final java.lang.Object deploymentConfig;
        private final java.lang.String endpointArn;
        private final java.lang.String inferenceComponentName;
        private final java.lang.Object runtimeConfig;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;
        private final java.lang.String variantName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.endpointName = software.amazon.jsii.Kernel.get(this, "endpointName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.specification = software.amazon.jsii.Kernel.get(this, "specification", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.deploymentConfig = software.amazon.jsii.Kernel.get(this, "deploymentConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.endpointArn = software.amazon.jsii.Kernel.get(this, "endpointArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.inferenceComponentName = software.amazon.jsii.Kernel.get(this, "inferenceComponentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.runtimeConfig = software.amazon.jsii.Kernel.get(this, "runtimeConfig", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
            this.variantName = software.amazon.jsii.Kernel.get(this, "variantName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.endpointName = java.util.Objects.requireNonNull(builder.endpointName, "endpointName is required");
            this.specification = java.util.Objects.requireNonNull(builder.specification, "specification is required");
            this.deploymentConfig = builder.deploymentConfig;
            this.endpointArn = builder.endpointArn;
            this.inferenceComponentName = builder.inferenceComponentName;
            this.runtimeConfig = builder.runtimeConfig;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
            this.variantName = builder.variantName;
        }

        @Override
        public final java.lang.String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final java.lang.Object getSpecification() {
            return this.specification;
        }

        @Override
        public final java.lang.Object getDeploymentConfig() {
            return this.deploymentConfig;
        }

        @Override
        public final java.lang.String getEndpointArn() {
            return this.endpointArn;
        }

        @Override
        public final java.lang.String getInferenceComponentName() {
            return this.inferenceComponentName;
        }

        @Override
        public final java.lang.Object getRuntimeConfig() {
            return this.runtimeConfig;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.String getVariantName() {
            return this.variantName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("endpointName", om.valueToTree(this.getEndpointName()));
            data.set("specification", om.valueToTree(this.getSpecification()));
            if (this.getDeploymentConfig() != null) {
                data.set("deploymentConfig", om.valueToTree(this.getDeploymentConfig()));
            }
            if (this.getEndpointArn() != null) {
                data.set("endpointArn", om.valueToTree(this.getEndpointArn()));
            }
            if (this.getInferenceComponentName() != null) {
                data.set("inferenceComponentName", om.valueToTree(this.getInferenceComponentName()));
            }
            if (this.getRuntimeConfig() != null) {
                data.set("runtimeConfig", om.valueToTree(this.getRuntimeConfig()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getVariantName() != null) {
                data.set("variantName", om.valueToTree(this.getVariantName()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sagemaker.CfnInferenceComponentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnInferenceComponentProps.Jsii$Proxy that = (CfnInferenceComponentProps.Jsii$Proxy) o;

            if (!endpointName.equals(that.endpointName)) return false;
            if (!specification.equals(that.specification)) return false;
            if (this.deploymentConfig != null ? !this.deploymentConfig.equals(that.deploymentConfig) : that.deploymentConfig != null) return false;
            if (this.endpointArn != null ? !this.endpointArn.equals(that.endpointArn) : that.endpointArn != null) return false;
            if (this.inferenceComponentName != null ? !this.inferenceComponentName.equals(that.inferenceComponentName) : that.inferenceComponentName != null) return false;
            if (this.runtimeConfig != null ? !this.runtimeConfig.equals(that.runtimeConfig) : that.runtimeConfig != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.variantName != null ? this.variantName.equals(that.variantName) : that.variantName == null;
        }

        @Override
        public final int hashCode() {
            int result = this.endpointName.hashCode();
            result = 31 * result + (this.specification.hashCode());
            result = 31 * result + (this.deploymentConfig != null ? this.deploymentConfig.hashCode() : 0);
            result = 31 * result + (this.endpointArn != null ? this.endpointArn.hashCode() : 0);
            result = 31 * result + (this.inferenceComponentName != null ? this.inferenceComponentName.hashCode() : 0);
            result = 31 * result + (this.runtimeConfig != null ? this.runtimeConfig.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.variantName != null ? this.variantName.hashCode() : 0);
            return result;
        }
    }
}
