package software.amazon.awscdk.services.scheduler.targets;

/**
 * Use a wider set of AWS API as a target for AWS EventBridge Scheduler.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Schedule.Builder.create(this, "Schedule")
 *         .schedule(ScheduleExpression.cron(CronOptionsWithTimezone.builder()
 *                 .minute("0")
 *                 .hour("0")
 *                 .build()))
 *         .target(Universal.Builder.create()
 *                 .service("rds")
 *                 .action("stopDBCluster")
 *                 .input(ScheduleTargetInput.fromObject(Map.of(
 *                         "DbClusterIdentifier", "my-db")))
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:25.385Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_scheduler_targets.Universal")
public class Universal extends software.amazon.awscdk.services.scheduler.targets.ScheduleTargetBase implements software.amazon.awscdk.services.scheduler.IScheduleTarget {

    protected Universal(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Universal(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Universal(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.scheduler.targets.UniversalTargetProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param role This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected void addTargetActionToRole(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IRole role) {
        software.amazon.jsii.Kernel.call(this, "addTargetActionToRole", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(role, "role is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.scheduler.targets.Universal}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.scheduler.targets.Universal> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.scheduler.targets.UniversalTargetProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.scheduler.targets.UniversalTargetProps.Builder();
        }

        /**
         * The SQS queue to be used as deadLetterQueue.
         * <p>
         * The events not successfully delivered are automatically retried for a specified period of time,
         * depending on the retry policy of the target.
         * If an event is not delivered before all retry attempts are exhausted, it will be sent to the dead letter queue.
         * <p>
         * Default: - no dead-letter queue
         * <p>
         * @return {@code this}
         * @param deadLetterQueue The SQS queue to be used as deadLetterQueue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deadLetterQueue(final software.amazon.awscdk.services.sqs.IQueue deadLetterQueue) {
            this.props.deadLetterQueue(deadLetterQueue);
            return this;
        }

        /**
         * Input passed to the target.
         * <p>
         * Default: - no input.
         * <p>
         * @return {@code this}
         * @param input Input passed to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.scheduler.ScheduleTargetInput input) {
            this.props.input(input);
            return this;
        }

        /**
         * The maximum age of a request that Scheduler sends to a target for processing.
         * <p>
         * Minimum value of 60.
         * Maximum value of 86400.
         * <p>
         * Default: Duration.hours(24)
         * <p>
         * @return {@code this}
         * @param maxEventAge The maximum age of a request that Scheduler sends to a target for processing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxEventAge(final software.amazon.awscdk.Duration maxEventAge) {
            this.props.maxEventAge(maxEventAge);
            return this;
        }

        /**
         * The maximum number of times to retry when the target returns an error.
         * <p>
         * Minimum value of 0.
         * Maximum value of 185.
         * <p>
         * Default: 185
         * <p>
         * @return {@code this}
         * @param retryAttempts The maximum number of times to retry when the target returns an error. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf.
         * <p>
         * If none provided templates target will automatically create an IAM role with all the minimum necessary
         * permissions to interact with the templated target. If you wish you may specify your own IAM role, then the templated targets
         * will grant minimal required permissions.
         * <p>
         * Default: - created by target
         * <p>
         * @return {@code this}
         * @param role An execution role is an IAM role that EventBridge Scheduler assumes in order to interact with other AWS services on your behalf. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * The API action to call. Must be camelCase.
         * <p>
         * You cannot use read-only API actions such as common GET operations.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#unsupported-api-actions">https://docs.aws.amazon.com/scheduler/latest/UserGuide/managing-targets-universal.html#unsupported-api-actions</a>
         * @param action The API action to call. Must be camelCase. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(final java.lang.String action) {
            this.props.action(action);
            return this;
        }

        /**
         * The AWS service to call.
         * <p>
         * This must be in lowercase.
         * <p>
         * @return {@code this}
         * @param service The AWS service to call. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(final java.lang.String service) {
            this.props.service(service);
            return this;
        }

        /**
         * The IAM policy statements needed to invoke the target. These statements are attached to the Scheduler's role.
         * <p>
         * Note that the default may not be the correct actions as not all AWS services follows the same IAM action pattern, or there may be more actions needed to invoke the target.
         * <p>
         * Default: - Policy with `service:action` action only.
         * <p>
         * @return {@code this}
         * @param policyStatements The IAM policy statements needed to invoke the target. These statements are attached to the Scheduler's role. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policyStatements(final java.util.List<? extends software.amazon.awscdk.services.iam.PolicyStatement> policyStatements) {
            this.props.policyStatements(policyStatements);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.scheduler.targets.Universal}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.scheduler.targets.Universal build() {
            return new software.amazon.awscdk.services.scheduler.targets.Universal(
                this.props.build()
            );
        }
    }
}
