package software.amazon.awscdk.services.secretsmanager;

/**
 * An attached secret.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.secretsmanager.*;
 * Secret secret;
 * ISecretAttachmentTarget secretAttachmentTarget;
 * SecretTargetAttachment secretTargetAttachment = SecretTargetAttachment.Builder.create(this, "MySecretTargetAttachment")
 *         .secret(secret)
 *         .target(secretAttachmentTarget)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:25.453Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_secretsmanager.SecretTargetAttachment")
public class SecretTargetAttachment extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.secretsmanager.ISecretTargetAttachment, software.amazon.awscdk.services.secretsmanager.ISecret {

    protected SecretTargetAttachment(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SecretTargetAttachment(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        PROPERTY_INJECTION_ID = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment.class, "PROPERTY_INJECTION_ID", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SecretTargetAttachment(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.SecretTargetAttachmentProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param secretTargetAttachmentSecretArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecretTargetAttachment fromSecretTargetAttachmentSecretArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String secretTargetAttachmentSecretArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment.class, "fromSecretTargetAttachmentSecretArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecretTargetAttachment.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(secretTargetAttachmentSecretArn, "secretTargetAttachmentSecretArn is required") });
    }

    /**
     * Adds a rotation schedule to the secret.
     * <p>
     * @param id This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationSchedule addRotationSchedule(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.RotationScheduleOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addRotationSchedule", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.RotationSchedule.class), new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Forward any additions to the resource policy to the original secret.
     * <p>
     * This is required because a secret can only have a single resource policy.
     * If we do not forward policy additions, a new policy resource is created using the secret attachment ARN.
     * This ends up being rejected by CloudFormation.
     * <p>
     * @param statement This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.AddToResourcePolicyResult addToResourcePolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.PolicyStatement statement) {
        return software.amazon.jsii.Kernel.call(this, "addToResourcePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.AddToResourcePolicyResult.class), new Object[] { java.util.Objects.requireNonNull(statement, "statement is required") });
    }

    /**
     * Attach a target to this secret.
     * <p>
     * @return An attached secret
     * @param target The target to attach. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecret attach(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target) {
        return software.amazon.jsii.Kernel.call(this, "attach", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.secretsmanager.ISecret.class), new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * Denies the <code>DeleteSecret</code> action to all principals within the current account.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void denyAccountRootDelete() {
        software.amazon.jsii.Kernel.call(this, "denyAccountRootDelete", software.amazon.jsii.NativeType.VOID);
    }

    /**
     * Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     * @param versionStages
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> versionStages) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required"), versionStages });
    }

    /**
     * Grants reading the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantRead(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantRead", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Grants writing and updating the secret value to some role.
     * <p>
     * @param grantee This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
        return software.amazon.jsii.Kernel.call(this, "grantWrite", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
    }

    /**
     * Interpret the secret as a JSON object and return a field's value from it as a <code>SecretValue</code>.
     * <p>
     * @param jsonField This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue secretValueFromJson(final @org.jetbrains.annotations.NotNull java.lang.String jsonField) {
        return software.amazon.jsii.Kernel.call(this, "secretValueFromJson", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class), new Object[] { java.util.Objects.requireNonNull(jsonField, "jsonField is required") });
    }

    /**
     * Uniquely identifies this class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String PROPERTY_INJECTION_ID;

    /**
     * Provides an identifier for this secret for use in IAM policies.
     * <p>
     * If there is a full ARN, this is just the ARN;
     * if we have a partial ARN -- due to either importing by secret name or partial ARN --
     * then we need to add a suffix to capture the full ARN's format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.String getArnForPolicies() {
        return software.amazon.jsii.Kernel.get(this, "arnForPolicies", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.lang.Boolean getAutoCreatePolicy() {
        return software.amazon.jsii.Kernel.get(this, "autoCreatePolicy", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The ARN of the secret in AWS Secrets Manager.
     * <p>
     * Will return the full ARN if available, otherwise a partial arn.
     * For secrets imported by the deprecated <code>fromSecretName</code>, it will return the <code>secretName</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "secretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the secret.
     * <p>
     * For "owned" secrets, this will be the full resource name (secret name + suffix), unless the
     * '&#64;aws-cdk/aws-secretsmanager:parseOwnedSecretName' feature flag is set.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretName() {
        return software.amazon.jsii.Kernel.get(this, "secretName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Same as <code>secretArn</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSecretTargetAttachmentSecretArn() {
        return software.amazon.jsii.Kernel.get(this, "secretTargetAttachmentSecretArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Retrieve the value of the stored secret as a <code>SecretValue</code>.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.SecretValue getSecretValue() {
        return software.amazon.jsii.Kernel.get(this, "secretValue", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.SecretValue.class));
    }

    /**
     * The customer-managed encryption key that is used to encrypt this secret, if any.
     * <p>
     * When not specified, the default
     * KMS key for the account and region is being used.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getEncryptionKey() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
    }

    /**
     * The full ARN of the secret in AWS Secrets Manager, which is the ARN including the Secrets Manager-supplied 6-character suffix.
     * <p>
     * This is equal to <code>secretArn</code> in most cases, but is undefined when a full ARN is not available (e.g., secrets imported by name).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSecretFullArn() {
        return software.amazon.jsii.Kernel.get(this, "secretFullArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.secretsmanager.SecretTargetAttachmentProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.secretsmanager.SecretTargetAttachmentProps.Builder();
        }

        /**
         * The target to attach the secret to.
         * <p>
         * @return {@code this}
         * @param target The target to attach the secret to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.secretsmanager.ISecretAttachmentTarget target) {
            this.props.target(target);
            return this;
        }

        /**
         * The secret to attach to the target.
         * <p>
         * @return {@code this}
         * @param secret The secret to attach to the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secret(final software.amazon.awscdk.services.secretsmanager.ISecret secret) {
            this.props.secret(secret);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment build() {
            return new software.amazon.awscdk.services.secretsmanager.SecretTargetAttachment(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
