package software.amazon.awscdk.services.securitylake;

/**
 * Notifies the subscriber when new data is written to the data lake for the sources that the subscriber consumes in Security Lake.
 * <p>
 * You can create only one subscriber notification per subscriber.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.securitylake.*;
 * Object sqsNotificationConfiguration;
 * CfnSubscriberNotification cfnSubscriberNotification = CfnSubscriberNotification.Builder.create(this, "MyCfnSubscriberNotification")
 *         .notificationConfiguration(NotificationConfigurationProperty.builder()
 *                 .httpsNotificationConfiguration(HttpsNotificationConfigurationProperty.builder()
 *                         .endpoint("endpoint")
 *                         .targetRoleArn("targetRoleArn")
 *                         // the properties below are optional
 *                         .authorizationApiKeyName("authorizationApiKeyName")
 *                         .authorizationApiKeyValue("authorizationApiKeyValue")
 *                         .httpMethod("httpMethod")
 *                         .build())
 *                 .sqsNotificationConfiguration(sqsNotificationConfiguration)
 *                 .build())
 *         .subscriberArn("subscriberArn")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:25.557Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.CfnSubscriberNotification")
public class CfnSubscriberNotification extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable {

    protected CfnSubscriberNotification(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnSubscriberNotification(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.securitylake.CfnSubscriberNotification.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnSubscriberNotification(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securitylake.CfnSubscriberNotificationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The endpoint the subscriber should listen to for notifications.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSubscriberEndpoint() {
        return software.amazon.jsii.Kernel.get(this, "attrSubscriberEndpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Specify the configurations you want to use for subscriber notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getNotificationConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "notificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specify the configurations you want to use for subscriber notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", java.util.Objects.requireNonNull(value, "notificationConfiguration is required"));
    }

    /**
     * Specify the configurations you want to use for subscriber notification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotificationConfiguration(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.securitylake.CfnSubscriberNotification.NotificationConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "notificationConfiguration", java.util.Objects.requireNonNull(value, "notificationConfiguration is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the Security Lake subscriber.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getSubscriberArn() {
        return software.amazon.jsii.Kernel.get(this, "subscriberArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the Security Lake subscriber.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSubscriberArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "subscriberArn", java.util.Objects.requireNonNull(value, "subscriberArn is required"));
    }
    /**
     * Specify the configurations you want to use for HTTPS subscriber notification.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securitylake.*;
     * HttpsNotificationConfigurationProperty httpsNotificationConfigurationProperty = HttpsNotificationConfigurationProperty.builder()
     *         .endpoint("endpoint")
     *         .targetRoleArn("targetRoleArn")
     *         // the properties below are optional
     *         .authorizationApiKeyName("authorizationApiKeyName")
     *         .authorizationApiKeyValue("authorizationApiKeyValue")
     *         .httpMethod("httpMethod")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.CfnSubscriberNotification.HttpsNotificationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(HttpsNotificationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface HttpsNotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The subscription endpoint in Security Lake .
         * <p>
         * If you prefer notification with an HTTPS endpoint, populate this field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-endpoint">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-endpoint</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getEndpoint();

        /**
         * The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created.
         * <p>
         * For more information about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com///security-lake/latest/userguide/subscriber-data-access.html">Managing data access</a> and <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/security-iam-awsmanpol.html">AWS Managed Policies</a> in the <em>Amazon Security Lake User Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-targetrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-targetrolearn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetRoleArn();

        /**
         * The key name for the notification subscription.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-authorizationapikeyname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-authorizationapikeyname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationApiKeyName() {
            return null;
        }

        /**
         * The key value for the notification subscription.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-authorizationapikeyvalue">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-authorizationapikeyvalue</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizationApiKeyValue() {
            return null;
        }

        /**
         * The HTTPS method used for the notification subscription.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-httpmethod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-httpsnotificationconfiguration.html#cfn-securitylake-subscribernotification-httpsnotificationconfiguration-httpmethod</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpMethod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link HttpsNotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link HttpsNotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<HttpsNotificationConfigurationProperty> {
            java.lang.String endpoint;
            java.lang.String targetRoleArn;
            java.lang.String authorizationApiKeyName;
            java.lang.String authorizationApiKeyValue;
            java.lang.String httpMethod;

            /**
             * Sets the value of {@link HttpsNotificationConfigurationProperty#getEndpoint}
             * @param endpoint The subscription endpoint in Security Lake . This parameter is required.
             *                 If you prefer notification with an HTTPS endpoint, populate this field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endpoint(java.lang.String endpoint) {
                this.endpoint = endpoint;
                return this;
            }

            /**
             * Sets the value of {@link HttpsNotificationConfigurationProperty#getTargetRoleArn}
             * @param targetRoleArn The Amazon Resource Name (ARN) of the EventBridge API destinations IAM role that you created. This parameter is required.
             *                      For more information about ARNs and how to use them in policies, see <a href="https://docs.aws.amazon.com///security-lake/latest/userguide/subscriber-data-access.html">Managing data access</a> and <a href="https://docs.aws.amazon.com//security-lake/latest/userguide/security-iam-awsmanpol.html">AWS Managed Policies</a> in the <em>Amazon Security Lake User Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetRoleArn(java.lang.String targetRoleArn) {
                this.targetRoleArn = targetRoleArn;
                return this;
            }

            /**
             * Sets the value of {@link HttpsNotificationConfigurationProperty#getAuthorizationApiKeyName}
             * @param authorizationApiKeyName The key name for the notification subscription.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationApiKeyName(java.lang.String authorizationApiKeyName) {
                this.authorizationApiKeyName = authorizationApiKeyName;
                return this;
            }

            /**
             * Sets the value of {@link HttpsNotificationConfigurationProperty#getAuthorizationApiKeyValue}
             * @param authorizationApiKeyValue The key value for the notification subscription.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder authorizationApiKeyValue(java.lang.String authorizationApiKeyValue) {
                this.authorizationApiKeyValue = authorizationApiKeyValue;
                return this;
            }

            /**
             * Sets the value of {@link HttpsNotificationConfigurationProperty#getHttpMethod}
             * @param httpMethod The HTTPS method used for the notification subscription.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpMethod(java.lang.String httpMethod) {
                this.httpMethod = httpMethod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link HttpsNotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public HttpsNotificationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link HttpsNotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpsNotificationConfigurationProperty {
            private final java.lang.String endpoint;
            private final java.lang.String targetRoleArn;
            private final java.lang.String authorizationApiKeyName;
            private final java.lang.String authorizationApiKeyValue;
            private final java.lang.String httpMethod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.endpoint = software.amazon.jsii.Kernel.get(this, "endpoint", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetRoleArn = software.amazon.jsii.Kernel.get(this, "targetRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationApiKeyName = software.amazon.jsii.Kernel.get(this, "authorizationApiKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.authorizationApiKeyValue = software.amazon.jsii.Kernel.get(this, "authorizationApiKeyValue", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.httpMethod = software.amazon.jsii.Kernel.get(this, "httpMethod", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.endpoint = java.util.Objects.requireNonNull(builder.endpoint, "endpoint is required");
                this.targetRoleArn = java.util.Objects.requireNonNull(builder.targetRoleArn, "targetRoleArn is required");
                this.authorizationApiKeyName = builder.authorizationApiKeyName;
                this.authorizationApiKeyValue = builder.authorizationApiKeyValue;
                this.httpMethod = builder.httpMethod;
            }

            @Override
            public final java.lang.String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public final java.lang.String getTargetRoleArn() {
                return this.targetRoleArn;
            }

            @Override
            public final java.lang.String getAuthorizationApiKeyName() {
                return this.authorizationApiKeyName;
            }

            @Override
            public final java.lang.String getAuthorizationApiKeyValue() {
                return this.authorizationApiKeyValue;
            }

            @Override
            public final java.lang.String getHttpMethod() {
                return this.httpMethod;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("endpoint", om.valueToTree(this.getEndpoint()));
                data.set("targetRoleArn", om.valueToTree(this.getTargetRoleArn()));
                if (this.getAuthorizationApiKeyName() != null) {
                    data.set("authorizationApiKeyName", om.valueToTree(this.getAuthorizationApiKeyName()));
                }
                if (this.getAuthorizationApiKeyValue() != null) {
                    data.set("authorizationApiKeyValue", om.valueToTree(this.getAuthorizationApiKeyValue()));
                }
                if (this.getHttpMethod() != null) {
                    data.set("httpMethod", om.valueToTree(this.getHttpMethod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securitylake.CfnSubscriberNotification.HttpsNotificationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                HttpsNotificationConfigurationProperty.Jsii$Proxy that = (HttpsNotificationConfigurationProperty.Jsii$Proxy) o;

                if (!endpoint.equals(that.endpoint)) return false;
                if (!targetRoleArn.equals(that.targetRoleArn)) return false;
                if (this.authorizationApiKeyName != null ? !this.authorizationApiKeyName.equals(that.authorizationApiKeyName) : that.authorizationApiKeyName != null) return false;
                if (this.authorizationApiKeyValue != null ? !this.authorizationApiKeyValue.equals(that.authorizationApiKeyValue) : that.authorizationApiKeyValue != null) return false;
                return this.httpMethod != null ? this.httpMethod.equals(that.httpMethod) : that.httpMethod == null;
            }

            @Override
            public final int hashCode() {
                int result = this.endpoint.hashCode();
                result = 31 * result + (this.targetRoleArn.hashCode());
                result = 31 * result + (this.authorizationApiKeyName != null ? this.authorizationApiKeyName.hashCode() : 0);
                result = 31 * result + (this.authorizationApiKeyValue != null ? this.authorizationApiKeyValue.hashCode() : 0);
                result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specify the configurations you want to use for subscriber notification.
     * <p>
     * The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.securitylake.*;
     * Object sqsNotificationConfiguration;
     * NotificationConfigurationProperty notificationConfigurationProperty = NotificationConfigurationProperty.builder()
     *         .httpsNotificationConfiguration(HttpsNotificationConfigurationProperty.builder()
     *                 .endpoint("endpoint")
     *                 .targetRoleArn("targetRoleArn")
     *                 // the properties below are optional
     *                 .authorizationApiKeyName("authorizationApiKeyName")
     *                 .authorizationApiKeyValue("authorizationApiKeyValue")
     *                 .httpMethod("httpMethod")
     *                 .build())
     *         .sqsNotificationConfiguration(sqsNotificationConfiguration)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-notificationconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-notificationconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_securitylake.CfnSubscriberNotification.NotificationConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configurations used for HTTPS subscriber notification.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-notificationconfiguration.html#cfn-securitylake-subscribernotification-notificationconfiguration-httpsnotificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-notificationconfiguration.html#cfn-securitylake-subscribernotification-notificationconfiguration-httpsnotificationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getHttpsNotificationConfiguration() {
            return null;
        }

        /**
         * The configurations for SQS subscriber notification.
         * <p>
         * The members of this structure are context-dependent.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-notificationconfiguration.html#cfn-securitylake-subscribernotification-notificationconfiguration-sqsnotificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-securitylake-subscribernotification-notificationconfiguration.html#cfn-securitylake-subscribernotification-notificationconfiguration-sqsnotificationconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSqsNotificationConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationConfigurationProperty> {
            java.lang.Object httpsNotificationConfiguration;
            java.lang.Object sqsNotificationConfiguration;

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getHttpsNotificationConfiguration}
             * @param httpsNotificationConfiguration The configurations used for HTTPS subscriber notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsNotificationConfiguration(software.amazon.awscdk.IResolvable httpsNotificationConfiguration) {
                this.httpsNotificationConfiguration = httpsNotificationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getHttpsNotificationConfiguration}
             * @param httpsNotificationConfiguration The configurations used for HTTPS subscriber notification.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsNotificationConfiguration(software.amazon.awscdk.services.securitylake.CfnSubscriberNotification.HttpsNotificationConfigurationProperty httpsNotificationConfiguration) {
                this.httpsNotificationConfiguration = httpsNotificationConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link NotificationConfigurationProperty#getSqsNotificationConfiguration}
             * @param sqsNotificationConfiguration The configurations for SQS subscriber notification.
             *                                     The members of this structure are context-dependent.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sqsNotificationConfiguration(java.lang.Object sqsNotificationConfiguration) {
                this.sqsNotificationConfiguration = sqsNotificationConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationConfigurationProperty {
            private final java.lang.Object httpsNotificationConfiguration;
            private final java.lang.Object sqsNotificationConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.httpsNotificationConfiguration = software.amazon.jsii.Kernel.get(this, "httpsNotificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.sqsNotificationConfiguration = software.amazon.jsii.Kernel.get(this, "sqsNotificationConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.httpsNotificationConfiguration = builder.httpsNotificationConfiguration;
                this.sqsNotificationConfiguration = builder.sqsNotificationConfiguration;
            }

            @Override
            public final java.lang.Object getHttpsNotificationConfiguration() {
                return this.httpsNotificationConfiguration;
            }

            @Override
            public final java.lang.Object getSqsNotificationConfiguration() {
                return this.sqsNotificationConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getHttpsNotificationConfiguration() != null) {
                    data.set("httpsNotificationConfiguration", om.valueToTree(this.getHttpsNotificationConfiguration()));
                }
                if (this.getSqsNotificationConfiguration() != null) {
                    data.set("sqsNotificationConfiguration", om.valueToTree(this.getSqsNotificationConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_securitylake.CfnSubscriberNotification.NotificationConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationConfigurationProperty.Jsii$Proxy that = (NotificationConfigurationProperty.Jsii$Proxy) o;

                if (this.httpsNotificationConfiguration != null ? !this.httpsNotificationConfiguration.equals(that.httpsNotificationConfiguration) : that.httpsNotificationConfiguration != null) return false;
                return this.sqsNotificationConfiguration != null ? this.sqsNotificationConfiguration.equals(that.sqsNotificationConfiguration) : that.sqsNotificationConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.httpsNotificationConfiguration != null ? this.httpsNotificationConfiguration.hashCode() : 0;
                result = 31 * result + (this.sqsNotificationConfiguration != null ? this.sqsNotificationConfiguration.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.securitylake.CfnSubscriberNotification}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.securitylake.CfnSubscriberNotification> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.securitylake.CfnSubscriberNotificationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.securitylake.CfnSubscriberNotificationProps.Builder();
        }

        /**
         * Specify the configurations you want to use for subscriber notification.
         * <p>
         * The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-notificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-notificationconfiguration</a>
         * @param notificationConfiguration Specify the configurations you want to use for subscriber notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.IResolvable notificationConfiguration) {
            this.props.notificationConfiguration(notificationConfiguration);
            return this;
        }
        /**
         * Specify the configurations you want to use for subscriber notification.
         * <p>
         * The subscriber is notified when new data is written to the data lake for sources that the subscriber consumes in Security Lake .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-notificationconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-notificationconfiguration</a>
         * @param notificationConfiguration Specify the configurations you want to use for subscriber notification. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationConfiguration(final software.amazon.awscdk.services.securitylake.CfnSubscriberNotification.NotificationConfigurationProperty notificationConfiguration) {
            this.props.notificationConfiguration(notificationConfiguration);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the Security Lake subscriber.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-subscriberarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-securitylake-subscribernotification.html#cfn-securitylake-subscribernotification-subscriberarn</a>
         * @param subscriberArn The Amazon Resource Name (ARN) of the Security Lake subscriber. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subscriberArn(final java.lang.String subscriberArn) {
            this.props.subscriberArn(subscriberArn);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.securitylake.CfnSubscriberNotification}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.securitylake.CfnSubscriberNotification build() {
            return new software.amazon.awscdk.services.securitylake.CfnSubscriberNotification(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
