package software.amazon.awscdk.services.servicediscovery;

/**
 * Specifies information about the discovery type of a service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.ec2.*;
 * import software.amazon.awscdk.services.elasticloadbalancingv2.*;
 * import software.amazon.awscdk.*;
 * import software.amazon.awscdk.*;
 * App app = new App();
 * Stack stack = new Stack(app, "aws-servicediscovery-integ");
 * Vpc vpc = Vpc.Builder.create(stack, "Vpc").maxAzs(2).build();
 * PrivateDnsNamespace namespace = PrivateDnsNamespace.Builder.create(stack, "Namespace")
 *         .name("boobar.com")
 *         .vpc(vpc)
 *         .build();
 * Service service = namespace.createService("Service", DnsServiceProps.builder()
 *         .dnsRecordType(DnsRecordType.A_AAAA)
 *         .dnsTtl(Duration.seconds(30))
 *         .loadBalancer(true)
 *         .build());
 * ApplicationLoadBalancer loadbalancer = ApplicationLoadBalancer.Builder.create(stack, "LB").vpc(vpc).internetFacing(true).build();
 * service.registerLoadBalancer("Loadbalancer", loadbalancer);
 * Service arnService = namespace.createService("ArnService", DnsServiceProps.builder()
 *         .discoveryType(DiscoveryType.API)
 *         .build());
 * arnService.registerNonIpInstance("NonIpInstance", NonIpInstanceBaseProps.builder()
 *         .customAttributes(Map.of("arn", "arn://"))
 *         .build());
 * app.synth();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:25.680Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_servicediscovery.DiscoveryType")
public enum DiscoveryType {
    /**
     * Instances are discoverable via API only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    API,
    /**
     * Instances are discoverable via DNS or API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DNS_AND_API,
}
