package software.amazon.awscdk.services.ses;

/**
 * Email sending event.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:25.826Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.EmailSendingEvent")
public enum EmailSendingEvent {
    /**
     * The send request was successful and SES will attempt to deliver the message to the recipient's mail server.
     * <p>
     * (If account-level or global suppression is
     * being used, SES will still count it as a send, but delivery is suppressed.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SEND,
    /**
     * SES accepted the email, but determined that it contained a virus and didn’t attempt to deliver it to the recipient’s mail server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    REJECT,
    /**
     * (Hard bounce) The recipient's mail server permanently rejected the email.
     * <p>
     * (Soft bounces are only included when SES fails to deliver the email after
     * retrying for a period of time.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOUNCE,
    /**
     * The email was successfully delivered to the recipient’s mail server, but the recipient marked it as spam.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPLAINT,
    /**
     * SES successfully delivered the email to the recipient's mail server.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELIVERY,
    /**
     * The recipient received the message and opened it in their email client.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    OPEN,
    /**
     * The recipient clicked one or more links in the email.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLICK,
    /**
     * The email wasn't sent because of a template rendering issue.
     * <p>
     * This event type
     * can occur when template data is missing, or when there is a mismatch between
     * template parameters and data. (This event type only occurs when you send email
     * using the <code>SendTemplatedEmail</code> or <code>SendBulkTemplatedEmail</code> API operations.)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    RENDERING_FAILURE,
    /**
     * The email couldn't be delivered to the recipient’s mail server because a temporary issue occurred.
     * <p>
     * Delivery delays can occur, for example, when the recipient's inbox
     * is full, or when the receiving email server experiences a transient issue.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DELIVERY_DELAY,
    /**
     * The email was successfully delivered, but the recipient updated their subscription preferences by clicking on an unsubscribe link as part of your subscription management.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    SUBSCRIPTION,
}
