package software.amazon.awscdk.services.sqs;

/**
 * Properties to associate SQS queues with a policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.sqs.*;
 * Queue queue;
 * QueuePolicyProps queuePolicyProps = QueuePolicyProps.builder()
 *         .queues(List.of(queue))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:25.982Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sqs.QueuePolicyProps")
@software.amazon.jsii.Jsii.Proxy(QueuePolicyProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface QueuePolicyProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The set of queues this policy applies to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.sqs.IQueue> getQueues();

    /**
     * @return a {@link Builder} of {@link QueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link QueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<QueuePolicyProps> {
        java.util.List<software.amazon.awscdk.services.sqs.IQueue> queues;

        /**
         * Sets the value of {@link QueuePolicyProps#getQueues}
         * @param queues The set of queues this policy applies to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder queues(java.util.List<? extends software.amazon.awscdk.services.sqs.IQueue> queues) {
            this.queues = (java.util.List<software.amazon.awscdk.services.sqs.IQueue>)queues;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link QueuePolicyProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public QueuePolicyProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link QueuePolicyProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueuePolicyProps {
        private final java.util.List<software.amazon.awscdk.services.sqs.IQueue> queues;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.queues = software.amazon.jsii.Kernel.get(this, "queues", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sqs.IQueue.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.queues = (java.util.List<software.amazon.awscdk.services.sqs.IQueue>)java.util.Objects.requireNonNull(builder.queues, "queues is required");
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.sqs.IQueue> getQueues() {
            return this.queues;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("queues", om.valueToTree(this.getQueues()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sqs.QueuePolicyProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            QueuePolicyProps.Jsii$Proxy that = (QueuePolicyProps.Jsii$Proxy) o;

            return this.queues.equals(that.queues);
        }

        @Override
        public final int hashCode() {
            int result = this.queues.hashCode();
            return result;
        }
    }
}
