package software.amazon.awscdk.services.stepfunctions;

/**
 * Configuration for CSV header options for a CSV Item Reader.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * CsvHeaders csvHeaders = CsvHeaders.use(List.of("headers"));
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:26.197Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.CsvHeaders")
public class CsvHeaders extends software.amazon.jsii.JsiiObject {

    protected CsvHeaders(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CsvHeaders(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Configures S3CsvItemReader to use the headers provided in the <code>headers</code> parameter.
     * <p>
     * @return <ul>
     * <li>CsvHeaders</li>
     * </ul>
     * @param headers <ul><li>List of headers.</li></ul> This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.CsvHeaders use(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> headers) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.CsvHeaders.class, "use", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.CsvHeaders.class), new Object[] { java.util.Objects.requireNonNull(headers, "headers is required") });
    }

    /**
     * Configures S3CsvItemReader to read headers from the first row of the CSV file.
     * <p>
     * @return <ul>
     * <li>CsvHeaders</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.CsvHeaders useFirstRow() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.CsvHeaders.class, "useFirstRow", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.CsvHeaders.class));
    }

    /**
     * Location of headers in CSV file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.CsvHeaderLocation getHeaderLocation() {
        return software.amazon.jsii.Kernel.get(this, "headerLocation", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.CsvHeaderLocation.class));
    }

    /**
     * List of headers if <code>headerLocation</code> is <code>GIVEN</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }
}
