package software.amazon.awscdk.services.stepfunctions;

/**
 * Properties for configuring a Distribute Map state that using JSONata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object assign;
 * ItemBatcher itemBatcher;
 * IItemReader itemReader;
 * Object itemSelector;
 * Object outputs;
 * ProvideItems provideItems;
 * ResultWriter resultWriter;
 * ResultWriterV2 resultWriterV2;
 * DistributedMapJsonataProps distributedMapJsonataProps = DistributedMapJsonataProps.builder()
 *         .assign(Map.of(
 *                 "assignKey", assign))
 *         .comment("comment")
 *         .itemBatcher(itemBatcher)
 *         .itemReader(itemReader)
 *         .items(provideItems)
 *         .itemSelector(Map.of(
 *                 "itemSelectorKey", itemSelector))
 *         .jsonataItemSelector("jsonataItemSelector")
 *         .label("label")
 *         .mapExecutionType(StateMachineType.EXPRESS)
 *         .maxConcurrency(123)
 *         .outputs(outputs)
 *         .queryLanguage(QueryLanguage.JSON_PATH)
 *         .resultWriter(resultWriter)
 *         .resultWriterV2(resultWriterV2)
 *         .stateName("stateName")
 *         .toleratedFailureCount(123)
 *         .toleratedFailurePercentage(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:26.216Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.DistributedMapJsonataProps")
@software.amazon.jsii.Jsii.Proxy(DistributedMapJsonataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DistributedMapJsonataProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.StateBaseProps, software.amazon.awscdk.services.stepfunctions.MapBaseOptions, software.amazon.awscdk.services.stepfunctions.MapBaseJsonataOptions {

    /**
     * Specifies to process a group of items in a single child workflow execution.
     * <p>
     * Default: - No itemBatcher
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ItemBatcher getItemBatcher() {
        return null;
    }

    /**
     * ItemReader.
     * <p>
     * Configuration for where to read items dataset in S3 to iterate
     * <p>
     * Default: - No itemReader
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.IItemReader getItemReader() {
        return null;
    }

    /**
     * Label.
     * <p>
     * Unique name for the Distributed Map state added to each Map Run
     * <p>
     * Default: - No label
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getLabel() {
        return null;
    }

    /**
     * MapExecutionType.
     * <p>
     * The execution type of the distributed map state
     * <p>
     * This property overwrites ProcessorConfig.executionType
     * <p>
     * Default: StateMachineType.STANDARD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.StateMachineType getMapExecutionType() {
        return null;
    }

    /**
     * (deprecated) Configuration for S3 location in which to save Map Run results.
     * <p>
     * Default: - No resultWriter
     * <p>
     * @deprecated Use {@link resultWriterV2 }
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ResultWriter getResultWriter() {
        return null;
    }

    /**
     * Configuration for S3 location in which to save Map Run results Enable "&#64;aws-cdk/aws-stepfunctions:useDistributedMapResultWriterV2" feature in the context to use resultWriterV2 Example: stack.node.setContext("&#64;aws-cdk/aws-stepfunctions:useDistributedMapResultWriterV2", true);
     * <p>
     * Default: - No resultWriterV2
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ResultWriterV2 getResultWriterV2() {
        return null;
    }

    /**
     * ToleratedFailureCount.
     * <p>
     * Number of failed items to tolerate in a Map Run, as static number
     * <p>
     * Default: - No toleratedFailureCount
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getToleratedFailureCount() {
        return null;
    }

    /**
     * ToleratedFailurePercentage.
     * <p>
     * Percentage of failed items to tolerate in a Map Run, as static number
     * <p>
     * Default: - No toleratedFailurePercentage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getToleratedFailurePercentage() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DistributedMapJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DistributedMapJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DistributedMapJsonataProps> {
        software.amazon.awscdk.services.stepfunctions.ItemBatcher itemBatcher;
        software.amazon.awscdk.services.stepfunctions.IItemReader itemReader;
        java.lang.String label;
        software.amazon.awscdk.services.stepfunctions.StateMachineType mapExecutionType;
        software.amazon.awscdk.services.stepfunctions.ResultWriter resultWriter;
        software.amazon.awscdk.services.stepfunctions.ResultWriterV2 resultWriterV2;
        java.lang.Number toleratedFailureCount;
        java.lang.Number toleratedFailurePercentage;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        java.lang.String jsonataItemSelector;
        java.lang.Number maxConcurrency;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        software.amazon.awscdk.services.stepfunctions.ProvideItems items;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getItemBatcher}
         * @param itemBatcher Specifies to process a group of items in a single child workflow execution.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemBatcher(software.amazon.awscdk.services.stepfunctions.ItemBatcher itemBatcher) {
            this.itemBatcher = itemBatcher;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getItemReader}
         * @param itemReader ItemReader.
         *                   Configuration for where to read items dataset in S3 to iterate
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder itemReader(software.amazon.awscdk.services.stepfunctions.IItemReader itemReader) {
            this.itemReader = itemReader;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getLabel}
         * @param label Label.
         *              Unique name for the Distributed Map state added to each Map Run
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder label(java.lang.String label) {
            this.label = label;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getMapExecutionType}
         * @param mapExecutionType MapExecutionType.
         *                         The execution type of the distributed map state
         *                         <p>
         *                         This property overwrites ProcessorConfig.executionType
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapExecutionType(software.amazon.awscdk.services.stepfunctions.StateMachineType mapExecutionType) {
            this.mapExecutionType = mapExecutionType;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getResultWriter}
         * @param resultWriter Configuration for S3 location in which to save Map Run results.
         * @return {@code this}
         * @deprecated Use {@link resultWriterV2 }
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder resultWriter(software.amazon.awscdk.services.stepfunctions.ResultWriter resultWriter) {
            this.resultWriter = resultWriter;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getResultWriterV2}
         * @param resultWriterV2 Configuration for S3 location in which to save Map Run results Enable "&#64;aws-cdk/aws-stepfunctions:useDistributedMapResultWriterV2" feature in the context to use resultWriterV2 Example: stack.node.setContext("&#64;aws-cdk/aws-stepfunctions:useDistributedMapResultWriterV2", true);.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultWriterV2(software.amazon.awscdk.services.stepfunctions.ResultWriterV2 resultWriterV2) {
            this.resultWriterV2 = resultWriterV2;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getToleratedFailureCount}
         * @param toleratedFailureCount ToleratedFailureCount.
         *                              Number of failed items to tolerate in a Map Run, as static number
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toleratedFailureCount(java.lang.Number toleratedFailureCount) {
            this.toleratedFailureCount = toleratedFailureCount;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getToleratedFailurePercentage}
         * @param toleratedFailurePercentage ToleratedFailurePercentage.
         *                                   Percentage of failed items to tolerate in a Map Run, as static number
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toleratedFailurePercentage(java.lang.Number toleratedFailurePercentage) {
            this.toleratedFailurePercentage = toleratedFailurePercentage;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getItemSelector}
         * @param itemSelector The JSON that you want to override your default iteration input (mutually exclusive  with <code>parameters</code> and <code>jsonataItemSelector</code>).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder itemSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> itemSelector) {
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)itemSelector;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getJsonataItemSelector}
         * @param jsonataItemSelector Jsonata expression that evaluates to a JSON array to override your default iteration input (mutually exclusive with <code>parameters</code> and <code>itemSelector</code>).
         *                            Example value: <code>{% {\"foo\": \"foo\", \"input\": $states.input} %}</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jsonataItemSelector(java.lang.String jsonataItemSelector) {
            this.jsonataItemSelector = jsonataItemSelector;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getMaxConcurrency}
         * @param maxConcurrency MaxConcurrency.
         *                       An upper bound on the number of iterations you want running at once.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxConcurrency(java.lang.Number maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getItems}
         * @param items The array that the Map state will iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder items(software.amazon.awscdk.services.stepfunctions.ProvideItems items) {
            this.items = items;
            return this;
        }

        /**
         * Sets the value of {@link DistributedMapJsonataProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DistributedMapJsonataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DistributedMapJsonataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DistributedMapJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributedMapJsonataProps {
        private final software.amazon.awscdk.services.stepfunctions.ItemBatcher itemBatcher;
        private final software.amazon.awscdk.services.stepfunctions.IItemReader itemReader;
        private final java.lang.String label;
        private final software.amazon.awscdk.services.stepfunctions.StateMachineType mapExecutionType;
        private final software.amazon.awscdk.services.stepfunctions.ResultWriter resultWriter;
        private final software.amazon.awscdk.services.stepfunctions.ResultWriterV2 resultWriterV2;
        private final java.lang.Number toleratedFailureCount;
        private final java.lang.Number toleratedFailurePercentage;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final java.util.Map<java.lang.String, java.lang.Object> itemSelector;
        private final java.lang.String jsonataItemSelector;
        private final java.lang.Number maxConcurrency;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final software.amazon.awscdk.services.stepfunctions.ProvideItems items;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.itemBatcher = software.amazon.jsii.Kernel.get(this, "itemBatcher", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ItemBatcher.class));
            this.itemReader = software.amazon.jsii.Kernel.get(this, "itemReader", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IItemReader.class));
            this.label = software.amazon.jsii.Kernel.get(this, "label", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.mapExecutionType = software.amazon.jsii.Kernel.get(this, "mapExecutionType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.StateMachineType.class));
            this.resultWriter = software.amazon.jsii.Kernel.get(this, "resultWriter", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ResultWriter.class));
            this.resultWriterV2 = software.amazon.jsii.Kernel.get(this, "resultWriterV2", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ResultWriterV2.class));
            this.toleratedFailureCount = software.amazon.jsii.Kernel.get(this, "toleratedFailureCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.toleratedFailurePercentage = software.amazon.jsii.Kernel.get(this, "toleratedFailurePercentage", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.itemSelector = software.amazon.jsii.Kernel.get(this, "itemSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.jsonataItemSelector = software.amazon.jsii.Kernel.get(this, "jsonataItemSelector", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxConcurrency = software.amazon.jsii.Kernel.get(this, "maxConcurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.items = software.amazon.jsii.Kernel.get(this, "items", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.ProvideItems.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.itemBatcher = builder.itemBatcher;
            this.itemReader = builder.itemReader;
            this.label = builder.label;
            this.mapExecutionType = builder.mapExecutionType;
            this.resultWriter = builder.resultWriter;
            this.resultWriterV2 = builder.resultWriterV2;
            this.toleratedFailureCount = builder.toleratedFailureCount;
            this.toleratedFailurePercentage = builder.toleratedFailurePercentage;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.itemSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.itemSelector;
            this.jsonataItemSelector = builder.jsonataItemSelector;
            this.maxConcurrency = builder.maxConcurrency;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.items = builder.items;
            this.outputs = builder.outputs;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ItemBatcher getItemBatcher() {
            return this.itemBatcher;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IItemReader getItemReader() {
            return this.itemReader;
        }

        @Override
        public final java.lang.String getLabel() {
            return this.label;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.StateMachineType getMapExecutionType() {
            return this.mapExecutionType;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ResultWriter getResultWriter() {
            return this.resultWriter;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ResultWriterV2 getResultWriterV2() {
            return this.resultWriterV2;
        }

        @Override
        public final java.lang.Number getToleratedFailureCount() {
            return this.toleratedFailureCount;
        }

        @Override
        public final java.lang.Number getToleratedFailurePercentage() {
            return this.toleratedFailurePercentage;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getItemSelector() {
            return this.itemSelector;
        }

        @Override
        public final java.lang.String getJsonataItemSelector() {
            return this.jsonataItemSelector;
        }

        @Override
        public final java.lang.Number getMaxConcurrency() {
            return this.maxConcurrency;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.ProvideItems getItems() {
            return this.items;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getItemBatcher() != null) {
                data.set("itemBatcher", om.valueToTree(this.getItemBatcher()));
            }
            if (this.getItemReader() != null) {
                data.set("itemReader", om.valueToTree(this.getItemReader()));
            }
            if (this.getLabel() != null) {
                data.set("label", om.valueToTree(this.getLabel()));
            }
            if (this.getMapExecutionType() != null) {
                data.set("mapExecutionType", om.valueToTree(this.getMapExecutionType()));
            }
            if (this.getResultWriter() != null) {
                data.set("resultWriter", om.valueToTree(this.getResultWriter()));
            }
            if (this.getResultWriterV2() != null) {
                data.set("resultWriterV2", om.valueToTree(this.getResultWriterV2()));
            }
            if (this.getToleratedFailureCount() != null) {
                data.set("toleratedFailureCount", om.valueToTree(this.getToleratedFailureCount()));
            }
            if (this.getToleratedFailurePercentage() != null) {
                data.set("toleratedFailurePercentage", om.valueToTree(this.getToleratedFailurePercentage()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getItemSelector() != null) {
                data.set("itemSelector", om.valueToTree(this.getItemSelector()));
            }
            if (this.getJsonataItemSelector() != null) {
                data.set("jsonataItemSelector", om.valueToTree(this.getJsonataItemSelector()));
            }
            if (this.getMaxConcurrency() != null) {
                data.set("maxConcurrency", om.valueToTree(this.getMaxConcurrency()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getItems() != null) {
                data.set("items", om.valueToTree(this.getItems()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.DistributedMapJsonataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DistributedMapJsonataProps.Jsii$Proxy that = (DistributedMapJsonataProps.Jsii$Proxy) o;

            if (this.itemBatcher != null ? !this.itemBatcher.equals(that.itemBatcher) : that.itemBatcher != null) return false;
            if (this.itemReader != null ? !this.itemReader.equals(that.itemReader) : that.itemReader != null) return false;
            if (this.label != null ? !this.label.equals(that.label) : that.label != null) return false;
            if (this.mapExecutionType != null ? !this.mapExecutionType.equals(that.mapExecutionType) : that.mapExecutionType != null) return false;
            if (this.resultWriter != null ? !this.resultWriter.equals(that.resultWriter) : that.resultWriter != null) return false;
            if (this.resultWriterV2 != null ? !this.resultWriterV2.equals(that.resultWriterV2) : that.resultWriterV2 != null) return false;
            if (this.toleratedFailureCount != null ? !this.toleratedFailureCount.equals(that.toleratedFailureCount) : that.toleratedFailureCount != null) return false;
            if (this.toleratedFailurePercentage != null ? !this.toleratedFailurePercentage.equals(that.toleratedFailurePercentage) : that.toleratedFailurePercentage != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.itemSelector != null ? !this.itemSelector.equals(that.itemSelector) : that.itemSelector != null) return false;
            if (this.jsonataItemSelector != null ? !this.jsonataItemSelector.equals(that.jsonataItemSelector) : that.jsonataItemSelector != null) return false;
            if (this.maxConcurrency != null ? !this.maxConcurrency.equals(that.maxConcurrency) : that.maxConcurrency != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.items != null ? !this.items.equals(that.items) : that.items != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.itemBatcher != null ? this.itemBatcher.hashCode() : 0;
            result = 31 * result + (this.itemReader != null ? this.itemReader.hashCode() : 0);
            result = 31 * result + (this.label != null ? this.label.hashCode() : 0);
            result = 31 * result + (this.mapExecutionType != null ? this.mapExecutionType.hashCode() : 0);
            result = 31 * result + (this.resultWriter != null ? this.resultWriter.hashCode() : 0);
            result = 31 * result + (this.resultWriterV2 != null ? this.resultWriterV2.hashCode() : 0);
            result = 31 * result + (this.toleratedFailureCount != null ? this.toleratedFailureCount.hashCode() : 0);
            result = 31 * result + (this.toleratedFailurePercentage != null ? this.toleratedFailurePercentage.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.itemSelector != null ? this.itemSelector.hashCode() : 0);
            result = 31 * result + (this.jsonataItemSelector != null ? this.jsonataItemSelector.hashCode() : 0);
            result = 31 * result + (this.maxConcurrency != null ? this.maxConcurrency.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
