package software.amazon.awscdk.services.stepfunctions;

/**
 * Base interface for Item Reader configuration properties.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.s3.*;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Bucket bucket;
 * ItemReaderProps itemReaderProps = ItemReaderProps.builder()
 *         .bucket(bucket)
 *         .bucketNamePath("bucketNamePath")
 *         .maxItems(123)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:26.230Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.ItemReaderProps")
@software.amazon.jsii.Jsii.Proxy(ItemReaderProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ItemReaderProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * S3 Bucket containing objects to iterate over or a file with a list to iterate over.
     * <p>
     * Default: - S3 bucket will be determined from
     * <p>
     * @see <a href="bucketNamePath">bucketNamePath</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getBucket() {
        return null;
    }

    /**
     * S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
     * <p>
     * Default: - S3 bucket will be determined from
     * <p>
     * @see <a href="bucket">bucket</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBucketNamePath() {
        return null;
    }

    /**
     * Limits the number of items passed to the Distributed Map state.
     * <p>
     * Default: - Distributed Map state will iterate over all items provided by the ItemReader
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMaxItems() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ItemReaderProps> {
        software.amazon.awscdk.services.s3.IBucket bucket;
        java.lang.String bucketNamePath;
        java.lang.Number maxItems;

        /**
         * Sets the value of {@link ItemReaderProps#getBucket}
         * @param bucket S3 Bucket containing objects to iterate over or a file with a list to iterate over.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucket(software.amazon.awscdk.services.s3.IBucket bucket) {
            this.bucket = bucket;
            return this;
        }

        /**
         * Sets the value of {@link ItemReaderProps#getBucketNamePath}
         * @param bucketNamePath S3 bucket name containing objects to iterate over or a file with a list to iterate over, as JsonPath.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder bucketNamePath(java.lang.String bucketNamePath) {
            this.bucketNamePath = bucketNamePath;
            return this;
        }

        /**
         * Sets the value of {@link ItemReaderProps#getMaxItems}
         * @param maxItems Limits the number of items passed to the Distributed Map state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxItems(java.lang.Number maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ItemReaderProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ItemReaderProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ItemReaderProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ItemReaderProps {
        private final software.amazon.awscdk.services.s3.IBucket bucket;
        private final java.lang.String bucketNamePath;
        private final java.lang.Number maxItems;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.s3.IBucket.class));
            this.bucketNamePath = software.amazon.jsii.Kernel.get(this, "bucketNamePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.maxItems = software.amazon.jsii.Kernel.get(this, "maxItems", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.bucket = builder.bucket;
            this.bucketNamePath = builder.bucketNamePath;
            this.maxItems = builder.maxItems;
        }

        @Override
        public final software.amazon.awscdk.services.s3.IBucket getBucket() {
            return this.bucket;
        }

        @Override
        public final java.lang.String getBucketNamePath() {
            return this.bucketNamePath;
        }

        @Override
        public final java.lang.Number getMaxItems() {
            return this.maxItems;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getBucket() != null) {
                data.set("bucket", om.valueToTree(this.getBucket()));
            }
            if (this.getBucketNamePath() != null) {
                data.set("bucketNamePath", om.valueToTree(this.getBucketNamePath()));
            }
            if (this.getMaxItems() != null) {
                data.set("maxItems", om.valueToTree(this.getMaxItems()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions.ItemReaderProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ItemReaderProps.Jsii$Proxy that = (ItemReaderProps.Jsii$Proxy) o;

            if (this.bucket != null ? !this.bucket.equals(that.bucket) : that.bucket != null) return false;
            if (this.bucketNamePath != null ? !this.bucketNamePath.equals(that.bucketNamePath) : that.bucketNamePath != null) return false;
            return this.maxItems != null ? this.maxItems.equals(that.maxItems) : that.maxItems == null;
        }

        @Override
        public final int hashCode() {
            int result = this.bucket != null ? this.bucket.hashCode() : 0;
            result = 31 * result + (this.bucketNamePath != null ? this.bucketNamePath.hashCode() : 0);
            result = 31 * result + (this.maxItems != null ? this.maxItems.hashCode() : 0);
            return result;
        }
    }
}
