package software.amazon.awscdk.services.stepfunctions;

/**
 * Define a Parallel state in the state machine.
 * <p>
 * A Parallel state can be used to run one or more state machines at the same
 * time.
 * <p>
 * The Result of a Parallel state is an array of the results of its substatemachines.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.Stack;
 * import software.constructs.Construct;
 * import software.amazon.awscdk.services.stepfunctions.*;
 * public class MyJobProps {
 *     private String jobFlavor;
 *     public String getJobFlavor() {
 *         return this.jobFlavor;
 *     }
 *     public MyJobProps jobFlavor(String jobFlavor) {
 *         this.jobFlavor = jobFlavor;
 *         return this;
 *     }
 * }
 * public class MyJob extends StateMachineFragment {
 *     public final State startState;
 *     public final INextable[] endStates;
 *     public MyJob(Construct parent, String id, MyJobProps props) {
 *         super(parent, id);
 *         Choice choice = new Choice(this, "Choice").when(Condition.stringEquals("$.branch", "left"), new Pass(this, "Left Branch")).when(Condition.stringEquals("$.branch", "right"), new Pass(this, "Right Branch"));
 *         // ...
 *         this.startState = choice;
 *         this.endStates = choice.afterwards().getEndStates();
 *     }
 * }
 * public class MyStack extends Stack {
 *     public MyStack(Construct scope, String id) {
 *         super(scope, id);
 *         // Do 3 different variants of MyJob in parallel
 *         Parallel parallel = new Parallel(this, "All jobs").branch(new MyJob(this, "Quick", new MyJobProps().jobFlavor("quick")).prefixStates()).branch(new MyJob(this, "Medium", new MyJobProps().jobFlavor("medium")).prefixStates()).branch(new MyJob(this, "Slow", new MyJobProps().jobFlavor("slow")).prefixStates());
 *         StateMachine.Builder.create(this, "MyStateMachine")
 *                 .definitionBody(DefinitionBody.fromChainable(parallel))
 *                 .build();
 *     }
 * }
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:26.254Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions.Parallel")
public class Parallel extends software.amazon.awscdk.services.stepfunctions.State implements software.amazon.awscdk.services.stepfunctions.INextable {

    protected Parallel(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Parallel(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Parallel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ParallelProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Parallel(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Define a Parallel state using JSONata in the state machine.
     * <p>
     * A Parallel state can be used to run one or more state machines at the same
     * time.
     * <p>
     * The Result of a Parallel state is an array of the results of its substatemachines.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel jsonata(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ParallelJsonataProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Parallel.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Define a Parallel state using JSONata in the state machine.
     * <p>
     * A Parallel state can be used to run one or more state machines at the same
     * time.
     * <p>
     * The Result of a Parallel state is an array of the results of its substatemachines.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel jsonata(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Parallel.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Define a Parallel state using JSONPath in the state machine.
     * <p>
     * A Parallel state can be used to run one or more state machines at the same
     * time.
     * <p>
     * The Result of a Parallel state is an array of the results of its substatemachines.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel jsonPath(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ParallelJsonPathProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Parallel.class, "jsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Define a Parallel state using JSONPath in the state machine.
     * <p>
     * A Parallel state can be used to run one or more state machines at the same
     * time.
     * <p>
     * The Result of a Parallel state is an array of the results of its substatemachines.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel jsonPath(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Parallel.class, "jsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CatchProps props) {
        return software.amazon.jsii.Kernel.call(this, "addCatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), props });
    }

    /**
     * Add a recovery handler for this state.
     * <p>
     * When a particular error occurs, execution will continue at the error
     * handler instead of failing the state machine execution.
     * <p>
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel addCatch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable handler) {
        return software.amazon.jsii.Kernel.call(this, "addCatch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel addRetry(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.RetryProps props) {
        return software.amazon.jsii.Kernel.call(this, "addRetry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), new Object[] { props });
    }

    /**
     * Add retry configuration for this state.
     * <p>
     * This controls if and how the execution will be retried if a particular
     * error occurs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel addRetry() {
        return software.amazon.jsii.Kernel.call(this, "addRetry", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class));
    }

    /**
     * Overwrites State.bindToGraph. Adds branches to the Parallel state here so that any necessary prefixes are appended first.
     * <p>
     * @param graph This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bindToGraph(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.StateGraph graph) {
        software.amazon.jsii.Kernel.call(this, "bindToGraph", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(graph, "graph is required") });
    }

    /**
     * Define one or more branches to run in parallel.
     * <p>
     * @param branches This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel branch(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable... branches) {
        return software.amazon.jsii.Kernel.call(this, "branch", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Parallel.class), java.util.Arrays.<Object>stream(branches).toArray(Object[]::new));
    }

    /**
     * Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.Kernel.call(this, "next", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Chain.class), new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return the Amazon States Language object for this state.
     * <p>
     * @param topLevelQueryLanguage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.QueryLanguage topLevelQueryLanguage) {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class), new Object[] { topLevelQueryLanguage });
    }

    /**
     * Return the Amazon States Language object for this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull com.fasterxml.jackson.databind.node.ObjectNode toStateJson() {
        return software.amazon.jsii.Kernel.call(this, "toStateJson", software.amazon.jsii.NativeType.forClass(com.fasterxml.jackson.databind.node.ObjectNode.class));
    }

    /**
     * Validate this state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validateState() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.call(this, "validateState", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * Continuable states of this Chainable.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.Parallel}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.Parallel> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.stepfunctions.ParallelProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A comment describing this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment A comment describing this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * The name of the query language used by the state.
         * <p>
         * If the state does not contain a <code>queryLanguage</code> field,
         * then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * <p>
         * Default: - JSONPath
         * <p>
         * @return {@code this}
         * @param queryLanguage The name of the query language used by the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.props().queryLanguage(queryLanguage);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props().stateName(stateName);
            return this;
        }

        /**
         * Workflow variables to store in this step.
         * <p>
         * Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * <p>
         * Default: - Not assign variables
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/step-functions/latest/dg/workflow-variables.html</a>
         * @param assign Workflow variables to store in this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assign(final java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.props().assign(assign);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props().inputPath(inputPath);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props().outputPath(outputPath);
            return this;
        }

        /**
         * Used to specify and transform output from the state.
         * <p>
         * When specified, the value overrides the state output default.
         * The output field accepts any JSON value (object, array, string, number, boolean, null).
         * Any string value, including those inside objects or arrays,
         * will be evaluated as JSONata if surrounded by {% %} characters.
         * Output also accepts a JSONata expression directly.
         * <p>
         * Default: - $states.result or $states.errorOutput
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html</a>
         * @param outputs Used to specify and transform output from the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.lang.Object outputs) {
            this.props().outputs(outputs);
            return this;
        }

        /**
         * Parameters pass a collection of key-value pairs, either static values or JSONata expressions that select from the input.
         * <p>
         * Default: No arguments
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/transforming-data.html">https://docs.aws.amazon.com/step-functions/latest/dg/transforming-data.html</a>
         * @param arguments Parameters pass a collection of key-value pairs, either static values or JSONata expressions that select from the input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder arguments(final java.util.Map<java.lang.String, ? extends java.lang.Object> arguments) {
            this.props().arguments(arguments);
            return this;
        }

        /**
         * Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input.
         * <p>
         * Default: No parameters
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-parameters</a>
         * @param parameters Parameters pass a collection of key-value pairs, either static values or JSONPath expressions that select from the input. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props().resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props().resultSelector(resultSelector);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.Parallel}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.Parallel build() {
            return new software.amazon.awscdk.services.stepfunctions.Parallel(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.stepfunctions.ParallelProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.stepfunctions.ParallelProps.Builder();
            }
            return this.props;
        }
    }
}
