package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for invoking a Bedrock Model.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.bedrock.*;
 * import software.amazon.awscdk.services.kms.*;
 * IBucket outputBucket;
 * IBucket trainingBucket;
 * IBucket validationBucket;
 * IKey kmsKey;
 * IVpc vpc;
 * FoundationModel model = FoundationModel.fromFoundationModelId(this, "Model", FoundationModelIdentifier.AMAZON_TITAN_TEXT_G1_EXPRESS_V1);
 * BedrockCreateModelCustomizationJob task = BedrockCreateModelCustomizationJob.Builder.create(this, "CreateModelCustomizationJob")
 *         .baseModel(model)
 *         .clientRequestToken("MyToken")
 *         .customizationType(CustomizationType.FINE_TUNING)
 *         .customModelKmsKey(kmsKey)
 *         .customModelName("MyCustomModel") // required
 *         .customModelTags(List.of(CustomModelTag.builder().key("key1").value("value1").build()))
 *         .hyperParameters(Map.of(
 *                 "batchSize", "10"))
 *         .jobName("MyCustomizationJob") // required
 *         .jobTags(List.of(CustomModelTag.builder().key("key2").value("value2").build()))
 *         .outputData(OutputBucketConfiguration.builder()
 *                 .bucket(outputBucket) // required
 *                 .path("output-data/")
 *                 .build())
 *         .trainingData(TrainingBucketConfiguration.builder()
 *                 .bucket(trainingBucket)
 *                 .path("training-data/data.json")
 *                 .build()) // required
 *         // If you don't provide validation data, you have to specify `Evaluation percentage` hyperparameter.
 *         .validationData(List.of(ValidationBucketConfiguration.builder()
 *                 .bucket(validationBucket)
 *                 .path("validation-data/data.json")
 *                 .build()))
 *         .vpcConfig(Map.of(
 *                 "securityGroups", List.of(SecurityGroup.Builder.create(this, "SecurityGroup").vpc(vpc).build()),
 *                 "subnets", vpc.getPrivateSubnets()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:26.393Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.BedrockCreateModelCustomizationJobProps")
@software.amazon.jsii.Jsii.Proxy(BedrockCreateModelCustomizationJobProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface BedrockCreateModelCustomizationJobProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps {

    /**
     * The base model.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.IModel getBaseModel();

    /**
     * A name for the resulting custom model.
     * <p>
     * The maximum length is 63 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getCustomModelName();

    /**
     * A name for the fine-tuning job.
     * <p>
     * The maximum length is 63 characters.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getJobName();

    /**
     * The S3 bucket configuration where the output data is stored.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_OutputDataConfig.html">https://docs.aws.amazon.com/bedrock/latest/APIReference/API_OutputDataConfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.OutputBucketConfiguration getOutputData();

    /**
     * The S3 bucket configuration where the training data is stored.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_TrainingDataConfig.html">https://docs.aws.amazon.com/bedrock/latest/APIReference/API_TrainingDataConfig.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.TrainingBucketConfiguration getTrainingData();

    /**
     * A unique, case-sensitive identifier to ensure that the API request completes no more than one time.
     * <p>
     * If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
     * <p>
     * The maximum length is 256 characters.
     * <p>
     * Default: - no client request token
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html">https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClientRequestToken() {
        return null;
    }

    /**
     * The customization type.
     * <p>
     * Default: FINE_TUNING
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.CustomizationType getCustomizationType() {
        return null;
    }

    /**
     * The custom model is encrypted at rest using this key.
     * <p>
     * Default: - encrypted with the AWS owned key
     * <p>
     * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-custom-job.html">https://docs.aws.amazon.com/bedrock/latest/userguide/encryption-custom-job.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.kms.IKey getCustomModelKmsKey() {
        return null;
    }

    /**
     * Tags to attach to the resulting custom model.
     * <p>
     * The maximum number of tags is 200.
     * <p>
     * Default: - no tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> getCustomModelTags() {
        return null;
    }

    /**
     * Parameters related to tuning the model.
     * <p>
     * Default: - use default hyperparameters
     * <p>
     * @see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html">https://docs.aws.amazon.com/bedrock/latest/userguide/custom-models-hp.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getHyperParameters() {
        return null;
    }

    /**
     * Tags to attach to the job.
     * <p>
     * The maximum number of tags is 200.
     * <p>
     * Default: - no tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> getJobTags() {
        return null;
    }

    /**
     * The IAM role that Amazon Bedrock can assume to perform tasks on your behalf.
     * <p>
     * For example, during model training, Amazon Bedrock needs your permission to read input data from an S3 bucket,
     * write model artifacts to an S3 bucket.
     * To pass this role to Amazon Bedrock, the caller of this API must have the iam:PassRole permission.
     * <p>
     * Default: - use auto generated role
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The S3 bucket configuration where the validation data is stored.
     * <p>
     * If you don't provide a validation dataset, specify the evaluation percentage by the <code>Evaluation percentage</code> hyperparameter.
     * <p>
     * The maximum number is 10.
     * <p>
     * Default: undefined - validate using a subset of the training data
     * <p>
     * @see <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_Validator.html">https://docs.aws.amazon.com/bedrock/latest/APIReference/API_Validator.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration> getValidationData() {
        return null;
    }

    /**
     * The VPC configuration.
     * <p>
     * Default: - no VPC configuration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.IBedrockCreateModelCustomizationJobVpcConfig getVpcConfig() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link BedrockCreateModelCustomizationJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link BedrockCreateModelCustomizationJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<BedrockCreateModelCustomizationJobProps> {
        software.amazon.awscdk.services.bedrock.IModel baseModel;
        java.lang.String customModelName;
        java.lang.String jobName;
        software.amazon.awscdk.services.stepfunctions.tasks.OutputBucketConfiguration outputData;
        software.amazon.awscdk.services.stepfunctions.tasks.TrainingBucketConfiguration trainingData;
        java.lang.String clientRequestToken;
        software.amazon.awscdk.services.stepfunctions.tasks.CustomizationType customizationType;
        software.amazon.awscdk.services.kms.IKey customModelKmsKey;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> customModelTags;
        java.util.Map<java.lang.String, java.lang.String> hyperParameters;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> jobTags;
        software.amazon.awscdk.services.iam.IRole role;
        java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration> validationData;
        software.amazon.awscdk.services.stepfunctions.tasks.IBedrockCreateModelCustomizationJobVpcConfig vpcConfig;
        java.lang.String resultPath;
        java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.String inputPath;
        java.lang.String outputPath;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getBaseModel}
         * @param baseModel The base model. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder baseModel(software.amazon.awscdk.services.bedrock.IModel baseModel) {
            this.baseModel = baseModel;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getCustomModelName}
         * @param customModelName A name for the resulting custom model. This parameter is required.
         *                        The maximum length is 63 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customModelName(java.lang.String customModelName) {
            this.customModelName = customModelName;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getJobName}
         * @param jobName A name for the fine-tuning job. This parameter is required.
         *                The maximum length is 63 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobName(java.lang.String jobName) {
            this.jobName = jobName;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getOutputData}
         * @param outputData The S3 bucket configuration where the output data is stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputData(software.amazon.awscdk.services.stepfunctions.tasks.OutputBucketConfiguration outputData) {
            this.outputData = outputData;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getTrainingData}
         * @param trainingData The S3 bucket configuration where the training data is stored. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trainingData(software.amazon.awscdk.services.stepfunctions.tasks.TrainingBucketConfiguration trainingData) {
            this.trainingData = trainingData;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getClientRequestToken}
         * @param clientRequestToken A unique, case-sensitive identifier to ensure that the API request completes no more than one time.
         *                           If this token matches a previous request, Amazon Bedrock ignores the request, but does not return an error.
         *                           <p>
         *                           The maximum length is 256 characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientRequestToken(java.lang.String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getCustomizationType}
         * @param customizationType The customization type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customizationType(software.amazon.awscdk.services.stepfunctions.tasks.CustomizationType customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getCustomModelKmsKey}
         * @param customModelKmsKey The custom model is encrypted at rest using this key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customModelKmsKey(software.amazon.awscdk.services.kms.IKey customModelKmsKey) {
            this.customModelKmsKey = customModelKmsKey;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getCustomModelTags}
         * @param customModelTags Tags to attach to the resulting custom model.
         *                        The maximum number of tags is 200.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder customModelTags(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> customModelTags) {
            this.customModelTags = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag>)customModelTags;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getHyperParameters}
         * @param hyperParameters Parameters related to tuning the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hyperParameters(java.util.Map<java.lang.String, java.lang.String> hyperParameters) {
            this.hyperParameters = hyperParameters;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getJobTags}
         * @param jobTags Tags to attach to the job.
         *                The maximum number of tags is 200.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder jobTags(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> jobTags) {
            this.jobTags = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag>)jobTags;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getRole}
         * @param role The IAM role that Amazon Bedrock can assume to perform tasks on your behalf.
         *             For example, during model training, Amazon Bedrock needs your permission to read input data from an S3 bucket,
         *             write model artifacts to an S3 bucket.
         *             To pass this role to Amazon Bedrock, the caller of this API must have the iam:PassRole permission.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getValidationData}
         * @param validationData The S3 bucket configuration where the validation data is stored.
         *                       If you don't provide a validation dataset, specify the evaluation percentage by the <code>Evaluation percentage</code> hyperparameter.
         *                       <p>
         *                       The maximum number is 10.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder validationData(java.util.List<? extends software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration> validationData) {
            this.validationData = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration>)validationData;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getVpcConfig}
         * @param vpcConfig The VPC configuration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcConfig(software.amazon.awscdk.services.stepfunctions.tasks.IBedrockCreateModelCustomizationJobVpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getResultSelector}
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         *                       You can use ResultSelector to create a payload with values that are static
         *                       or selected from the state's raw result.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder resultSelector(java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)resultSelector;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link BedrockCreateModelCustomizationJobProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link BedrockCreateModelCustomizationJobProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public BedrockCreateModelCustomizationJobProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link BedrockCreateModelCustomizationJobProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements BedrockCreateModelCustomizationJobProps {
        private final software.amazon.awscdk.services.bedrock.IModel baseModel;
        private final java.lang.String customModelName;
        private final java.lang.String jobName;
        private final software.amazon.awscdk.services.stepfunctions.tasks.OutputBucketConfiguration outputData;
        private final software.amazon.awscdk.services.stepfunctions.tasks.TrainingBucketConfiguration trainingData;
        private final java.lang.String clientRequestToken;
        private final software.amazon.awscdk.services.stepfunctions.tasks.CustomizationType customizationType;
        private final software.amazon.awscdk.services.kms.IKey customModelKmsKey;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> customModelTags;
        private final java.util.Map<java.lang.String, java.lang.String> hyperParameters;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> jobTags;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration> validationData;
        private final software.amazon.awscdk.services.stepfunctions.tasks.IBedrockCreateModelCustomizationJobVpcConfig vpcConfig;
        private final java.lang.String resultPath;
        private final java.util.Map<java.lang.String, java.lang.Object> resultSelector;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.baseModel = software.amazon.jsii.Kernel.get(this, "baseModel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.bedrock.IModel.class));
            this.customModelName = software.amazon.jsii.Kernel.get(this, "customModelName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.jobName = software.amazon.jsii.Kernel.get(this, "jobName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputData = software.amazon.jsii.Kernel.get(this, "outputData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.OutputBucketConfiguration.class));
            this.trainingData = software.amazon.jsii.Kernel.get(this, "trainingData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.TrainingBucketConfiguration.class));
            this.clientRequestToken = software.amazon.jsii.Kernel.get(this, "clientRequestToken", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.customizationType = software.amazon.jsii.Kernel.get(this, "customizationType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.CustomizationType.class));
            this.customModelKmsKey = software.amazon.jsii.Kernel.get(this, "customModelKmsKey", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.kms.IKey.class));
            this.customModelTags = software.amazon.jsii.Kernel.get(this, "customModelTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag.class)));
            this.hyperParameters = software.amazon.jsii.Kernel.get(this, "hyperParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.jobTags = software.amazon.jsii.Kernel.get(this, "jobTags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag.class)));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.validationData = software.amazon.jsii.Kernel.get(this, "validationData", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration.class)));
            this.vpcConfig = software.amazon.jsii.Kernel.get(this, "vpcConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.IBedrockCreateModelCustomizationJobVpcConfig.class));
            this.resultPath = software.amazon.jsii.Kernel.get(this, "resultPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultSelector = software.amazon.jsii.Kernel.get(this, "resultSelector", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.inputPath = software.amazon.jsii.Kernel.get(this, "inputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputPath = software.amazon.jsii.Kernel.get(this, "outputPath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.baseModel = java.util.Objects.requireNonNull(builder.baseModel, "baseModel is required");
            this.customModelName = java.util.Objects.requireNonNull(builder.customModelName, "customModelName is required");
            this.jobName = java.util.Objects.requireNonNull(builder.jobName, "jobName is required");
            this.outputData = java.util.Objects.requireNonNull(builder.outputData, "outputData is required");
            this.trainingData = java.util.Objects.requireNonNull(builder.trainingData, "trainingData is required");
            this.clientRequestToken = builder.clientRequestToken;
            this.customizationType = builder.customizationType;
            this.customModelKmsKey = builder.customModelKmsKey;
            this.customModelTags = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag>)builder.customModelTags;
            this.hyperParameters = builder.hyperParameters;
            this.jobTags = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag>)builder.jobTags;
            this.role = builder.role;
            this.validationData = (java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration>)builder.validationData;
            this.vpcConfig = builder.vpcConfig;
            this.resultPath = builder.resultPath;
            this.resultSelector = (java.util.Map<java.lang.String, java.lang.Object>)builder.resultSelector;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.inputPath = builder.inputPath;
            this.outputPath = builder.outputPath;
            this.outputs = builder.outputs;
        }

        @Override
        public final software.amazon.awscdk.services.bedrock.IModel getBaseModel() {
            return this.baseModel;
        }

        @Override
        public final java.lang.String getCustomModelName() {
            return this.customModelName;
        }

        @Override
        public final java.lang.String getJobName() {
            return this.jobName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.OutputBucketConfiguration getOutputData() {
            return this.outputData;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.TrainingBucketConfiguration getTrainingData() {
            return this.trainingData;
        }

        @Override
        public final java.lang.String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.CustomizationType getCustomizationType() {
            return this.customizationType;
        }

        @Override
        public final software.amazon.awscdk.services.kms.IKey getCustomModelKmsKey() {
            return this.customModelKmsKey;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> getCustomModelTags() {
            return this.customModelTags;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getHyperParameters() {
            return this.hyperParameters;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.CustomModelTag> getJobTags() {
            return this.jobTags;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.stepfunctions.tasks.ValidationBucketConfiguration> getValidationData() {
            return this.validationData;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.IBedrockCreateModelCustomizationJobVpcConfig getVpcConfig() {
            return this.vpcConfig;
        }

        @Override
        public final java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getResultSelector() {
            return this.resultSelector;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("baseModel", om.valueToTree(this.getBaseModel()));
            data.set("customModelName", om.valueToTree(this.getCustomModelName()));
            data.set("jobName", om.valueToTree(this.getJobName()));
            data.set("outputData", om.valueToTree(this.getOutputData()));
            data.set("trainingData", om.valueToTree(this.getTrainingData()));
            if (this.getClientRequestToken() != null) {
                data.set("clientRequestToken", om.valueToTree(this.getClientRequestToken()));
            }
            if (this.getCustomizationType() != null) {
                data.set("customizationType", om.valueToTree(this.getCustomizationType()));
            }
            if (this.getCustomModelKmsKey() != null) {
                data.set("customModelKmsKey", om.valueToTree(this.getCustomModelKmsKey()));
            }
            if (this.getCustomModelTags() != null) {
                data.set("customModelTags", om.valueToTree(this.getCustomModelTags()));
            }
            if (this.getHyperParameters() != null) {
                data.set("hyperParameters", om.valueToTree(this.getHyperParameters()));
            }
            if (this.getJobTags() != null) {
                data.set("jobTags", om.valueToTree(this.getJobTags()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getValidationData() != null) {
                data.set("validationData", om.valueToTree(this.getValidationData()));
            }
            if (this.getVpcConfig() != null) {
                data.set("vpcConfig", om.valueToTree(this.getVpcConfig()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }
            if (this.getResultSelector() != null) {
                data.set("resultSelector", om.valueToTree(this.getResultSelector()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.BedrockCreateModelCustomizationJobProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            BedrockCreateModelCustomizationJobProps.Jsii$Proxy that = (BedrockCreateModelCustomizationJobProps.Jsii$Proxy) o;

            if (!baseModel.equals(that.baseModel)) return false;
            if (!customModelName.equals(that.customModelName)) return false;
            if (!jobName.equals(that.jobName)) return false;
            if (!outputData.equals(that.outputData)) return false;
            if (!trainingData.equals(that.trainingData)) return false;
            if (this.clientRequestToken != null ? !this.clientRequestToken.equals(that.clientRequestToken) : that.clientRequestToken != null) return false;
            if (this.customizationType != null ? !this.customizationType.equals(that.customizationType) : that.customizationType != null) return false;
            if (this.customModelKmsKey != null ? !this.customModelKmsKey.equals(that.customModelKmsKey) : that.customModelKmsKey != null) return false;
            if (this.customModelTags != null ? !this.customModelTags.equals(that.customModelTags) : that.customModelTags != null) return false;
            if (this.hyperParameters != null ? !this.hyperParameters.equals(that.hyperParameters) : that.hyperParameters != null) return false;
            if (this.jobTags != null ? !this.jobTags.equals(that.jobTags) : that.jobTags != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.validationData != null ? !this.validationData.equals(that.validationData) : that.validationData != null) return false;
            if (this.vpcConfig != null ? !this.vpcConfig.equals(that.vpcConfig) : that.vpcConfig != null) return false;
            if (this.resultPath != null ? !this.resultPath.equals(that.resultPath) : that.resultPath != null) return false;
            if (this.resultSelector != null ? !this.resultSelector.equals(that.resultSelector) : that.resultSelector != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.baseModel.hashCode();
            result = 31 * result + (this.customModelName.hashCode());
            result = 31 * result + (this.jobName.hashCode());
            result = 31 * result + (this.outputData.hashCode());
            result = 31 * result + (this.trainingData.hashCode());
            result = 31 * result + (this.clientRequestToken != null ? this.clientRequestToken.hashCode() : 0);
            result = 31 * result + (this.customizationType != null ? this.customizationType.hashCode() : 0);
            result = 31 * result + (this.customModelKmsKey != null ? this.customModelKmsKey.hashCode() : 0);
            result = 31 * result + (this.customModelTags != null ? this.customModelTags.hashCode() : 0);
            result = 31 * result + (this.hyperParameters != null ? this.hyperParameters.hashCode() : 0);
            result = 31 * result + (this.jobTags != null ? this.jobTags.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.validationData != null ? this.validationData.hashCode() : 0);
            result = 31 * result + (this.vpcConfig != null ? this.vpcConfig.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            result = 31 * result + (this.resultSelector != null ? this.resultSelector.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
