package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Encryption Options of the S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AthenaStartQueryExecution startQueryExecutionJob = AthenaStartQueryExecution.Builder.create(this, "Start Athena Query")
 *         .queryString(JsonPath.stringAt("$.queryString"))
 *         .queryExecutionContext(QueryExecutionContext.builder()
 *                 .databaseName("mydatabase")
 *                 .build())
 *         .resultConfiguration(ResultConfiguration.builder()
 *                 .encryptionConfiguration(EncryptionConfiguration.builder()
 *                         .encryptionOption(EncryptionOption.S3_MANAGED)
 *                         .build())
 *                 .outputLocation(Location.builder()
 *                         .bucketName("amzn-s3-demo-bucket")
 *                         .objectKey("folder")
 *                         .build())
 *                 .build())
 *         .executionParameters(List.of("param1", "param2"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption">https://docs.aws.amazon.com/athena/latest/APIReference/API_EncryptionConfiguration.html#athena-Type-EncryptionConfiguration-EncryptionOption</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.112.0 (build de1bc80)", date = "2025-06-20T13:49:26.666Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EncryptionOption")
public enum EncryptionOption {
    /**
     * Server side encryption (SSE) with an Amazon S3-managed key.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingServerSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    S3_MANAGED,
    /**
     * Server-side encryption (SSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingKMSEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    KMS,
    /**
     * Client-side encryption (CSE) with an AWS KMS key managed by the account owner.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html">https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingClientSideEncryption.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLIENT_SIDE_KMS,
}
